/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public class LinkedSections {
    private Map<Offering, Map<Subpart, Set<Section>>> iSections = new HashMap<Offering, Map<Subpart, Set<Section>>>();
    private boolean iMustBeUsed;

    public LinkedSections(Section ... sections) {
        for (Section section : sections) {
            this.addSection(section);
        }
    }

    public LinkedSections(Collection<Section> sections) {
        for (Section section : sections) {
            this.addSection(section);
        }
    }

    private void addSection(Section section) {
        Set<Section> sections;
        Map<Subpart, Set<Section>> subparts = this.iSections.get(section.getSubpart().getConfig().getOffering());
        if (subparts == null) {
            subparts = new HashMap<Subpart, Set<Section>>();
            this.iSections.put(section.getSubpart().getConfig().getOffering(), subparts);
        }
        if ((sections = subparts.get(section.getSubpart())) == null) {
            sections = new HashSet<Section>();
            subparts.put(section.getSubpart(), sections);
        }
        sections.add(section);
    }

    public Set<Offering> getOfferings() {
        return this.iSections.keySet();
    }

    public Set<Subpart> getSubparts(Offering offering) {
        return this.iSections.get(offering).keySet();
    }

    public Set<Section> getSections(Subpart subpart) {
        return this.iSections.get(subpart.getConfig().getOffering()).get(subpart);
    }

    private LinkedSectionsConstraint createConstraint(Student student) {
        ArrayList<Request> requests = new ArrayList<Request>();
        int nrOfferings = 0;
        block0: for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)request).getCourses()) {
                Map<Subpart, Set<Section>> subpartsThisOffering = this.iSections.get(course.getOffering());
                if (subpartsThisOffering == null) continue;
                requests.add(request);
                ++nrOfferings;
                continue block0;
            }
        }
        if (nrOfferings <= 1) {
            return null;
        }
        LinkedSectionsConstraint constraint = new LinkedSectionsConstraint(student, requests);
        student.getRequests().get(0).getModel().addConstraint(constraint);
        return constraint;
    }

    public void createConstraints() {
        HashSet<Student> students = new HashSet<Student>();
        for (Offering offering : this.iSections.keySet()) {
            for (Course course : offering.getCourses()) {
                for (Request request : course.getRequests()) {
                    if (!students.add(request.getStudent()) || this.createConstraint(request.getStudent()) == null) continue;
                    request.getStudent().getLinkedSections().add(this);
                }
            }
        }
    }

    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, ConflictHandler conflicts) {
        this.computeConflicts(enrollment, new CurrentAssignment(assignment), conflicts);
    }

    public void computeConflicts(Enrollment enrollment, EnrollmentAssignment assignment, ConflictHandler conflicts) {
        Enrollment otherEnrollment;
        Request request;
        boolean full;
        if (enrollment == null || enrollment.getCourse() == null) {
            return;
        }
        Map<Subpart, Set<Section>> subparts = this.iSections.get(enrollment.getCourse().getOffering());
        if (subparts == null || subparts.isEmpty()) {
            return;
        }
        boolean match = false;
        boolean partial = false;
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = subparts.get(section.getSubpart());
            if (sections == null) continue;
            if (sections.contains(section)) {
                match = true;
                continue;
            }
            partial = true;
        }
        boolean bl = full = match && !partial;
        if (this.isMustBeUsed() && !full) {
            boolean hasOtherMatch = false;
            for (LinkedSections other : enrollment.getStudent().getLinkedSections()) {
                if (!other.hasFullMatch(enrollment) || this.nrSharedOfferings(other) <= 1) continue;
                hasOtherMatch = true;
                break;
            }
            if (!hasOtherMatch && !conflicts.onConflict(enrollment)) {
                return;
            }
        }
        if (full) {
            for (int i = 0; i < enrollment.getStudent().getRequests().size(); ++i) {
                boolean otherFull;
                Map<Subpart, Set<Section>> otherSubparts;
                request = enrollment.getStudent().getRequests().get(i);
                if (request.equals(enrollment.getRequest()) || (otherEnrollment = assignment.getEnrollment(request, i)) == null || otherEnrollment.getCourse() == null || (otherSubparts = this.iSections.get(otherEnrollment.getCourse().getOffering())) == null || otherSubparts.isEmpty()) continue;
                boolean otherMatch = false;
                boolean otherPartial = false;
                for (Section section : otherEnrollment.getSections()) {
                    Set<Section> otherSections = otherSubparts.get(section.getSubpart());
                    if (otherSections == null) continue;
                    if (otherSections.contains(section)) {
                        otherMatch = true;
                        continue;
                    }
                    otherPartial = true;
                }
                boolean bl2 = otherFull = otherMatch && !otherPartial;
                if (otherFull || conflicts.onConflict(otherEnrollment)) continue;
                return;
            }
        } else {
            for (int i = 0; i < enrollment.getStudent().getRequests().size(); ++i) {
                boolean otherFull;
                Map<Subpart, Set<Section>> otherSubparts;
                request = enrollment.getStudent().getRequests().get(i);
                if (request.equals(enrollment.getRequest()) || (otherEnrollment = assignment.getEnrollment(request, i)) == null || otherEnrollment.getCourse() == null || (otherSubparts = this.iSections.get(otherEnrollment.getCourse().getOffering())) == null || otherSubparts.isEmpty()) continue;
                boolean otherMatch = false;
                boolean otherPartial = false;
                for (Section section : otherEnrollment.getSections()) {
                    Set<Section> otherSections = otherSubparts.get(section.getSubpart());
                    if (otherSections == null) continue;
                    if (otherSections.contains(section)) {
                        otherMatch = true;
                        continue;
                    }
                    otherPartial = true;
                }
                boolean bl3 = otherFull = otherMatch && !otherPartial;
                if (!otherFull || conflicts.onConflict(otherEnrollment)) continue;
                return;
            }
        }
    }

    protected boolean hasFullMatch(Enrollment enrollment) {
        if (enrollment == null || enrollment.getCourse() == null) {
            return false;
        }
        Map<Subpart, Set<Section>> subparts = this.iSections.get(enrollment.getCourse().getOffering());
        if (subparts == null || subparts.isEmpty()) {
            return false;
        }
        boolean match = false;
        boolean partial = false;
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = subparts.get(section.getSubpart());
            if (sections == null) continue;
            if (sections.contains(section)) {
                match = true;
                continue;
            }
            partial = true;
        }
        return match && !partial;
    }

    protected int nrSharedOfferings(LinkedSections other) {
        int shared = 0;
        for (Offering offering : other.getOfferings()) {
            if (!this.iSections.containsKey(offering)) continue;
            ++shared;
        }
        return shared;
    }

    public Enrollment inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        return this.inConflict(enrollment, new CurrentAssignment(assignment));
    }

    public Enrollment inConflict(Enrollment enrollment, EnrollmentAssignment assignment) {
        final Toggle<Object> ret = new Toggle<Object>(null);
        this.computeConflicts(enrollment, assignment, new ConflictHandler(){

            @Override
            public boolean onConflict(Enrollment conflict) {
                ret.set(conflict);
                return false;
            }
        });
        return ret.get();
    }

    public boolean isMustBeUsed() {
        return this.iMustBeUsed;
    }

    public void setMustBeUsed(boolean mustBeUsed) {
        this.iMustBeUsed = mustBeUsed;
    }

    public String toString() {
        return "LinkedSections" + this.iSections.keySet();
    }

    public class LinkedSectionsConstraint
    extends Constraint<Request, Enrollment> {
        private Student iStudent;

        protected LinkedSectionsConstraint(Student student, Collection<Request> requests) {
            this.iStudent = student;
            for (Request request : requests) {
                this.addVariable(request);
            }
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public LinkedSections getLinkedSections() {
            return LinkedSections.this;
        }

        @Override
        public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment value, final Set<Enrollment> conflicts) {
            this.getLinkedSections().computeConflicts(assignment, value, new ConflictHandler(){

                @Override
                public boolean onConflict(Enrollment conflict) {
                    conflicts.add(conflict);
                    return true;
                }
            });
        }

        @Override
        public boolean isConsistent(Enrollment enrollment, final Enrollment other) {
            return this.getLinkedSections().inConflict(enrollment, new EnrollmentAssignment(){

                @Override
                public Enrollment getEnrollment(Request request, int indext) {
                    return request.equals(other.getRequest()) ? other : null;
                }
            }) == null;
        }

        @Override
        public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment value) {
            return this.getLinkedSections().inConflict(assignment, value) != null;
        }

        public String toString() {
            return this.getLinkedSections().toString();
        }
    }

    private static class Toggle<T> {
        private T iValue;

        Toggle(T value) {
            this.set(value);
        }

        void set(T value) {
            this.iValue = value;
        }

        T get() {
            return this.iValue;
        }
    }

    public static class CurrentAssignment
    implements EnrollmentAssignment {
        protected Assignment<Request, Enrollment> iAssignment;

        public CurrentAssignment(Assignment<Request, Enrollment> assignment) {
            this.iAssignment = assignment;
        }

        @Override
        public Enrollment getEnrollment(Request request, int index) {
            return this.iAssignment.getValue(request);
        }
    }

    public static interface ConflictHandler {
        public boolean onConflict(Enrollment var1);
    }

    public static interface EnrollmentAssignment {
        public Enrollment getEnrollment(Request var1, int var2);
    }
}

