/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.OptimisticInheritedAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ModelWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ConstraintListener;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.constraint.CancelledSections;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.constraint.CourseLimit;
import org.cpsolver.studentsct.constraint.DisabledSections;
import org.cpsolver.studentsct.constraint.FixInitialAssignments;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.constraint.RequiredReservation;
import org.cpsolver.studentsct.constraint.ReservationLimit;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.constraint.StudentConflict;
import org.cpsolver.studentsct.constraint.StudentNotAvailable;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.weights.PriorityStudentWeights;
import org.cpsolver.studentsct.weights.StudentWeights;

public class StudentSectioningModel
extends ModelWithContext<Request, Enrollment, StudentSectioningModelContext> {
    private static Logger sLog = Logger.getLogger(StudentSectioningModel.class);
    protected static DecimalFormat sDecimalFormat = new DecimalFormat("0.00");
    private List<Student> iStudents = new ArrayList<Student>();
    private List<Offering> iOfferings = new ArrayList<Offering>();
    private List<LinkedSections> iLinkedSections = new ArrayList<LinkedSections>();
    private DataProperties iProperties;
    private DistanceConflict iDistanceConflict = null;
    private TimeOverlapsCounter iTimeOverlaps = null;
    private int iNrDummyStudents = 0;
    private int iNrDummyRequests = 0;
    private double iTotalDummyWeight = 0.0;
    private double iTotalCRWeight = 0.0;
    private double iTotalDummyCRWeight = 0.0;
    private double iTotalMPPCRWeight = 0.0;
    private double iTotalSelCRWeight = 0.0;
    private double iBestAssignedCourseRequestWeight = 0.0;
    private StudentWeights iStudentWeights = null;
    private boolean iReservationCanAssignOverTheLimit;
    private boolean iMPP;
    private boolean iKeepInitials;
    protected double iProjectedStudentWeight = 0.01;
    private int iMaxDomainSize = -1;

    public StudentSectioningModel(DataProperties properties) {
        this.iReservationCanAssignOverTheLimit = properties.getPropertyBoolean("Reservation.CanAssignOverTheLimit", false);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iKeepInitials = properties.getPropertyBoolean("Sectioning.KeepInitialAssignments", false);
        this.iStudentWeights = new PriorityStudentWeights(properties);
        this.iMaxDomainSize = properties.getPropertyInt("Sectioning.MaxDomainSize", this.iMaxDomainSize);
        if (properties.getPropertyBoolean("Sectioning.SectionLimit", true)) {
            SectionLimit sectionLimit = new SectionLimit(properties);
            this.addGlobalConstraint(sectionLimit);
            if (properties.getPropertyBoolean("Sectioning.SectionLimit.Debug", false)) {
                sectionLimit.addConstraintListener(new ConstraintListener<Request, Enrollment>(){

                    @Override
                    public void constraintBeforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Constraint<Request, Enrollment> constraint, Enrollment enrollment, Set<Enrollment> unassigned) {
                        if (enrollment.getStudent().isDummy()) {
                            for (Enrollment conflict : unassigned) {
                                if (conflict.getStudent().isDummy()) continue;
                                sLog.warn("Enrolment of a real student " + conflict.getStudent() + " is unassigned " + "\n  -- " + conflict + "\ndue to an enrollment of a dummy student " + enrollment.getStudent() + " " + "\n  -- " + enrollment);
                            }
                        }
                    }

                    @Override
                    public void constraintAfterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Constraint<Request, Enrollment> constraint, Enrollment assigned, Set<Enrollment> unassigned) {
                    }
                });
            }
        }
        if (properties.getPropertyBoolean("Sectioning.ConfigLimit", true)) {
            ConfigLimit configLimit = new ConfigLimit(properties);
            this.addGlobalConstraint(configLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.CourseLimit", true)) {
            CourseLimit courseLimit = new CourseLimit(properties);
            this.addGlobalConstraint(courseLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.ReservationLimit", true)) {
            ReservationLimit reservationLimit = new ReservationLimit(properties);
            this.addGlobalConstraint(reservationLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.RequiredReservations", true)) {
            RequiredReservation requiredReservation = new RequiredReservation();
            this.addGlobalConstraint(requiredReservation);
        }
        if (properties.getPropertyBoolean("Sectioning.CancelledSections", true)) {
            CancelledSections cancelledSections = new CancelledSections();
            this.addGlobalConstraint(cancelledSections);
        }
        if (properties.getPropertyBoolean("Sectioning.StudentNotAvailable", true)) {
            StudentNotAvailable studentNotAvailable = new StudentNotAvailable();
            this.addGlobalConstraint(studentNotAvailable);
        }
        if (properties.getPropertyBoolean("Sectioning.DisabledSections", true)) {
            DisabledSections disabledSections = new DisabledSections();
            this.addGlobalConstraint(disabledSections);
        }
        if (this.iMPP && this.iKeepInitials) {
            this.addGlobalConstraint(new FixInitialAssignments());
        }
        try {
            Class<?> studentWeightsClass = Class.forName(properties.getProperty("StudentWeights.Class", PriorityStudentWeights.class.getName()));
            this.iStudentWeights = (StudentWeights)studentWeightsClass.getConstructor(DataProperties.class).newInstance(properties);
        }
        catch (Exception e) {
            sLog.error("Unable to create custom student weighting model (" + e.getMessage() + "), using default.", e);
            this.iStudentWeights = new PriorityStudentWeights(properties);
        }
        this.iProjectedStudentWeight = properties.getPropertyDouble("StudentWeights.ProjectedStudentWeight", this.iProjectedStudentWeight);
        this.iProperties = properties;
    }

    public boolean getReservationCanAssignOverTheLimit() {
        return this.iReservationCanAssignOverTheLimit;
    }

    public boolean isMPP() {
        return this.iMPP;
    }

    public boolean getKeepInitialAssignments() {
        return this.iKeepInitials;
    }

    public StudentWeights getStudentWeights() {
        return this.iStudentWeights;
    }

    public void setStudentWeights(StudentWeights weights) {
        this.iStudentWeights = weights;
    }

    public List<Student> getStudents() {
        return this.iStudents;
    }

    public void addStudent(Student student) {
        this.iStudents.add(student);
        if (student.isDummy()) {
            ++this.iNrDummyStudents;
        }
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
        if (this.getProperties().getPropertyBoolean("Sectioning.StudentConflict", true)) {
            this.addConstraint(new StudentConflict(student));
        }
    }

    @Override
    public void addVariable(Request request) {
        super.addVariable(request);
        if (request instanceof CourseRequest && !request.isAlternative()) {
            this.iTotalCRWeight += request.getWeight();
        }
        if (request.getStudent().isDummy()) {
            ++this.iNrDummyRequests;
            this.iTotalDummyWeight += request.getWeight();
            if (request instanceof CourseRequest && !request.isAlternative()) {
                this.iTotalDummyCRWeight += request.getWeight();
            }
        }
        if (request.isMPP()) {
            this.iTotalMPPCRWeight += request.getWeight();
        }
        if (request.hasSelection()) {
            this.iTotalSelCRWeight += request.getWeight();
        }
    }

    public void requestWeightsChanged(Assignment<Request, Enrollment> assignment) {
        ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).requestWeightsChanged(assignment);
    }

    public void removeStudent(Student student) {
        this.iStudents.remove(student);
        if (student.isDummy()) {
            --this.iNrDummyStudents;
        }
        Constraint conflict = null;
        for (Request request : student.getRequests()) {
            for (Constraint c : request.constraints()) {
                if (!(c instanceof StudentConflict)) continue;
                conflict = (StudentConflict)c;
                break;
            }
            if (conflict != null) {
                conflict.removeVariable(request);
            }
            this.removeVariable(request);
        }
        if (conflict != null) {
            this.removeConstraint(conflict);
        }
    }

    @Override
    public void removeVariable(Request request) {
        super.removeVariable(request);
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            for (Course course : cr.getCourses()) {
                course.getRequests().remove(request);
            }
        }
        if (request.getStudent().isDummy()) {
            --this.iNrDummyRequests;
            this.iTotalDummyWeight -= request.getWeight();
            if (request instanceof CourseRequest && !request.isAlternative()) {
                this.iTotalDummyCRWeight -= request.getWeight();
            }
        }
        if (request.isMPP()) {
            this.iTotalMPPCRWeight -= request.getWeight();
        }
        if (request.hasSelection()) {
            this.iTotalSelCRWeight -= request.getWeight();
        }
        if (request instanceof CourseRequest && !request.isAlternative()) {
            this.iTotalCRWeight -= request.getWeight();
        }
    }

    public List<Offering> getOfferings() {
        return this.iOfferings;
    }

    public void addOffering(Offering offering) {
        this.iOfferings.add(offering);
        offering.setModel(this);
    }

    public void addLinkedSections(boolean mustBeUsed, Section ... sections) {
        LinkedSections constraint = new LinkedSections(sections);
        constraint.setMustBeUsed(mustBeUsed);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    @Deprecated
    public void addLinkedSections(Section ... sections) {
        this.addLinkedSections(false, sections);
    }

    public void addLinkedSections(boolean mustBeUsed, Collection<Section> sections) {
        LinkedSections constraint = new LinkedSections(sections);
        constraint.setMustBeUsed(mustBeUsed);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    @Deprecated
    public void addLinkedSections(Collection<Section> sections) {
        this.addLinkedSections(false, sections);
    }

    public List<LinkedSections> getLinkedSections() {
        return this.iLinkedSections;
    }

    @Override
    public Map<String, String> getInfo(Assignment<Request, Enrollment> assignment) {
        int nrLastLikeStudents;
        int confs;
        Map<String, String> info = super.getInfo(assignment);
        StudentSectioningModelContext context = (StudentSectioningModelContext)this.getContext((Assignment)assignment);
        if (!this.getStudents().isEmpty()) {
            info.put("Students with complete schedule", sDoubleFormat.format(100.0 * (double)context.nrComplete() / (double)this.getStudents().size()) + "% (" + context.nrComplete() + "/" + this.getStudents().size() + ")");
        }
        if (this.getDistanceConflict() != null && (confs = this.getDistanceConflict().getTotalNrConflicts(assignment)) > 0) {
            int shortConfs = this.getDistanceConflict().getTotalNrShortConflicts(assignment);
            info.put("Student distance conflicts", confs + (shortConfs == 0 ? "" : " (" + this.getDistanceConflict().getDistanceMetric().getShortDistanceAccommodationReference() + ": " + shortConfs + ")"));
        }
        if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts(assignment) != 0) {
            info.put("Time overlapping conflicts", sDoubleFormat.format((double)this.getTimeOverlaps().getTotalNrConflicts(assignment) / 12.0) + " hours");
        }
        if ((nrLastLikeStudents = this.getNrLastLikeStudents(false)) != 0 && nrLastLikeStudents != this.getStudents().size()) {
            int nrRealStudents = this.getStudents().size() - nrLastLikeStudents;
            int nrLastLikeCompleteStudents = this.getNrCompleteLastLikeStudents(assignment, false);
            int nrRealCompleteStudents = context.nrComplete() - nrLastLikeCompleteStudents;
            if (nrLastLikeStudents > 0) {
                info.put("Projected students with complete schedule", sDecimalFormat.format(100.0 * (double)nrLastLikeCompleteStudents / (double)nrLastLikeStudents) + "% (" + nrLastLikeCompleteStudents + "/" + nrLastLikeStudents + ")");
            }
            if (nrRealStudents > 0) {
                info.put("Real students with complete schedule", sDecimalFormat.format(100.0 * (double)nrRealCompleteStudents / (double)nrRealStudents) + "% (" + nrRealCompleteStudents + "/" + nrRealStudents + ")");
            }
            int nrLastLikeRequests = this.getNrLastLikeRequests(false);
            int nrRealRequests = this.variables().size() - nrLastLikeRequests;
            int nrLastLikeAssignedRequests = context.getNrAssignedLastLikeRequests();
            int nrRealAssignedRequests = assignment.nrAssignedVariables() - nrLastLikeAssignedRequests;
            if (nrLastLikeRequests > 0) {
                info.put("Projected assigned requests", sDecimalFormat.format(100.0 * (double)nrLastLikeAssignedRequests / (double)nrLastLikeRequests) + "% (" + nrLastLikeAssignedRequests + "/" + nrLastLikeRequests + ")");
            }
            if (nrRealRequests > 0) {
                info.put("Real assigned requests", sDecimalFormat.format(100.0 * (double)nrRealAssignedRequests / (double)nrRealRequests) + "% (" + nrRealAssignedRequests + "/" + nrRealRequests + ")");
            }
        }
        context.getInfo(assignment, info);
        double groupSpread = 0.0;
        double groupCount = 0.0;
        for (Offering offering : this.iOfferings) {
            for (Course course : offering.getCourses()) {
                for (RequestGroup group : course.getRequestGroups()) {
                    groupSpread += group.getAverageSpread(assignment) * group.getEnrollmentWeight(assignment, null);
                    groupCount += group.getEnrollmentWeight(assignment, null);
                }
            }
        }
        if (groupCount > 0.0) {
            info.put("Same group", sDecimalFormat.format(100.0 * groupSpread / groupCount) + "%");
        }
        return info;
    }

    public double getTotalValue(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (precise) {
            double total = 0.0;
            for (Request request : assignment.assignedVariables()) {
                total += request.getWeight() * this.iStudentWeights.getWeight(assignment, assignment.getValue(request));
            }
            if (this.iDistanceConflict != null) {
                for (DistanceConflict.Conflict conflict : this.iDistanceConflict.computeAllConflicts(assignment)) {
                    total -= this.avg(conflict.getR1().getWeight(), conflict.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(assignment, conflict);
                }
            }
            if (this.iTimeOverlaps != null) {
                for (TimeOverlapsCounter.Conflict conflict : ((TimeOverlapsCounter.TimeOverlapsCounterContext)this.iTimeOverlaps.getContext(assignment)).computeAllConflicts(assignment)) {
                    if (conflict.getR1() != null) {
                        total -= conflict.getR1Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, conflict.getE1(), conflict);
                    }
                    if (conflict.getR2() == null) continue;
                    total -= conflict.getR2Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, conflict.getE2(), conflict);
                }
            }
            return -total;
        }
        return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getTotalValue();
    }

    @Override
    public double getTotalValue(Assignment<Request, Enrollment> assignment) {
        return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getTotalValue();
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void clearOnlineSectioningInfos() {
        for (Offering offering : this.iOfferings) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        section.setSpaceExpected(0.0);
                        section.setSpaceHeld(0.0);
                    }
                }
            }
        }
    }

    public void computeOnlineSectioningInfos(Assignment<Request, Enrollment> assignment) {
        this.clearOnlineSectioningInfos();
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                Enrollment enrollment = assignment.getValue(courseRequest);
                if (enrollment != null) {
                    for (Section section : enrollment.getSections()) {
                        section.setSpaceHeld(courseRequest.getWeight() + section.getSpaceHeld());
                    }
                }
                ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
                int totalLimit = 0;
                for (Enrollment enrl : courseRequest.values(assignment)) {
                    boolean overlaps = false;
                    for (Request otherRequest : student.getRequests()) {
                        Enrollment otherErollment;
                        if (otherRequest.equals(courseRequest) || !(otherRequest instanceof CourseRequest) || (otherErollment = assignment.getValue(otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                        overlaps = true;
                        break;
                    }
                    if (overlaps) continue;
                    feasibleEnrollments.add(enrl);
                    if (totalLimit < 0) continue;
                    int limit = enrl.getLimit();
                    if (limit < 0) {
                        totalLimit = -1;
                        continue;
                    }
                    totalLimit += limit;
                }
                double increment = courseRequest.getWeight() / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
                for (Enrollment feasibleEnrollment : feasibleEnrollments) {
                    for (Section section : feasibleEnrollment.getSections()) {
                        if (totalLimit > 0) {
                            section.setSpaceExpected(section.getSpaceExpected() + increment * (double)feasibleEnrollment.getLimit());
                            continue;
                        }
                        section.setSpaceExpected(section.getSpaceExpected() + increment);
                    }
                }
            }
        }
    }

    public double getUnassignedRequestWeight(Assignment<Request, Enrollment> assignment) {
        double weight = 0.0;
        for (Request request : assignment.unassignedVariables(this)) {
            weight += request.getWeight();
        }
        return weight;
    }

    public double getTotalRequestWeight() {
        double weight = 0.0;
        for (Request request : this.variables()) {
            weight += request.getWeight();
        }
        return weight;
    }

    public void setDistanceConflict(DistanceConflict dc) {
        this.iDistanceConflict = dc;
    }

    public DistanceConflict getDistanceConflict() {
        return this.iDistanceConflict;
    }

    public void setTimeOverlaps(TimeOverlapsCounter toc) {
        this.iTimeOverlaps = toc;
    }

    public TimeOverlapsCounter getTimeOverlaps() {
        return this.iTimeOverlaps;
    }

    public double avgUnassignPriority(Assignment<Request, Enrollment> assignment) {
        double totalPriority = 0.0;
        for (Request request : assignment.unassignedVariables(this)) {
            if (request.isAlternative()) continue;
            totalPriority += (double)request.getPriority();
        }
        return 1.0 + totalPriority / (double)assignment.nrUnassignedVariables(this);
    }

    public double avgNrRequests() {
        double totalRequests = 0.0;
        int totalStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.nrRequests() == 0) continue;
            totalRequests += (double)student.nrRequests();
            ++totalStudents;
        }
        return totalRequests / (double)totalStudents;
    }

    public int getNrLastLikeStudents(boolean precise) {
        if (!precise) {
            return this.iNrDummyStudents;
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrRealStudents(boolean precise) {
        if (!precise) {
            return this.getStudents().size() - this.iNrDummyStudents;
        }
        int nrRealStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getNrCompleteLastLikeStudents(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrCompleteLastLikeStudents();
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isComplete(assignment) || !student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrCompleteRealStudents(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).nrComplete() - ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrCompleteLastLikeStudents();
        }
        int nrRealStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isComplete(assignment) || student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getNrLastLikeRequests(boolean precise) {
        if (!precise) {
            return this.iNrDummyRequests;
        }
        int nrLastLikeRequests = 0;
        for (Request request : this.variables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrRealRequests(boolean precise) {
        if (!precise) {
            return this.variables().size() - this.iNrDummyRequests;
        }
        int nrRealRequests = 0;
        for (Request request : this.variables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    public int getNrAssignedLastLikeRequests(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrAssignedLastLikeRequests();
        }
        int nrLastLikeRequests = 0;
        for (Request request : assignment.assignedVariables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrAssignedRealRequests(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return assignment.nrAssignedVariables() - ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrAssignedLastLikeRequests();
        }
        int nrRealRequests = 0;
        for (Request request : assignment.assignedVariables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    @Override
    public Map<String, String> getExtendedInfo(Assignment<Request, Enrollment> assignment) {
        Map<String, String> info = this.getInfo(assignment);
        double dc = 0.0;
        if (this.getDistanceConflict() != null && this.getDistanceConflict().getTotalNrConflicts(assignment) != 0) {
            Set<DistanceConflict.Conflict> conf = this.getDistanceConflict().getAllConflicts(assignment);
            int sdc = 0;
            for (DistanceConflict.Conflict c : conf) {
                dc += this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(assignment, c);
                if (!c.getStudent().isNeedShortDistances()) continue;
                ++sdc;
            }
            if (!conf.isEmpty()) {
                info.put("Student distance conflicts", conf.size() + (sdc > 0 ? " (" + this.getDistanceConflict().getDistanceMetric().getShortDistanceAccommodationReference() + ": " + sdc + ", weighted: " : " (weighted: ") + sDecimalFormat.format(dc) + ")");
            }
        }
        double toc = 0.0;
        if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts(assignment) != 0) {
            Set<TimeOverlapsCounter.Conflict> conf = ((TimeOverlapsCounter.TimeOverlapsCounterContext)this.getTimeOverlaps().getContext(assignment)).computeAllConflicts(assignment);
            int share = 0;
            int crShare = 0;
            for (TimeOverlapsCounter.Conflict c : conf) {
                if (c.getR1() != null) {
                    toc += c.getR1Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE1(), c);
                }
                if (c.getR2() != null) {
                    toc += c.getR2Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE2(), c);
                }
                share += c.getShare();
                if (!(c.getR1() instanceof CourseRequest) || !(c.getR2() instanceof CourseRequest)) continue;
                crShare += c.getShare();
            }
            if (toc != 0.0) {
                info.put("Time overlapping conflicts", sDoubleFormat.format((double)share / 12.0) + " hours (" + sDoubleFormat.format((double)crShare / 12.0) + " hours between courses, weighted: " + sDoubleFormat.format(toc) + ")");
            }
        }
        double disbWeight = 0.0;
        int disbSections = 0;
        int disb10Sections = 0;
        int disb10Limit = this.getProperties().getPropertyInt("Info.ListDisbalancedSections", 0);
        TreeSet<String> disb10SectionList = disb10Limit == 0 ? null : new TreeSet<String>();
        for (Offering offering : this.getOfferings()) {
            for (Config config : offering.getConfigs()) {
                double enrl = config.getEnrollmentTotalWeight(assignment, null);
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getSections().size() <= 1) continue;
                    if (subpart.getLimit() > 0) {
                        double ratio = enrl / (double)subpart.getLimit();
                        for (Section section : subpart.getSections()) {
                            double desired = ratio * (double)section.getLimit();
                            disbWeight += Math.abs(section.getEnrollmentTotalWeight(assignment, null) - desired);
                            ++disbSections;
                            if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                            ++disb10Sections;
                            if (disb10SectionList == null) continue;
                            disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                        }
                        continue;
                    }
                    for (Section section : subpart.getSections()) {
                        double desired = enrl / (double)subpart.getSections().size();
                        disbWeight += Math.abs(section.getEnrollmentTotalWeight(assignment, null) - desired);
                        ++disbSections;
                        if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, 0.1 * desired))) continue;
                        ++disb10Sections;
                        if (disb10SectionList == null) continue;
                        disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                    }
                }
            }
        }
        if (disbSections != 0) {
            double assignedCRWeight = ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCourseRequestWeight();
            info.put("Average disbalance", sDecimalFormat.format(disbWeight / (double)disbSections) + " (" + sDecimalFormat.format(assignedCRWeight == 0.0 ? 0.0 : 100.0 * disbWeight / assignedCRWeight) + "%)");
            String list = "";
            if (disb10SectionList != null) {
                int i = 0;
                for (String section : disb10SectionList) {
                    if (i == disb10Limit) {
                        list = list + "<br>...";
                        break;
                    }
                    list = list + "<br>" + section;
                    ++i;
                }
            }
            info.put("Sections disbalanced by 10% or more", disb10Sections + " (" + sDecimalFormat.format(disbSections == 0 ? 0.0 : 100.0 * (double)disb10Sections / (double)disbSections) + "%)" + list);
        }
        info.put("Overall solution value", sDoubleFormat.format(this.getTotalValue(assignment)) + " [precise: " + sDoubleFormat.format(this.getTotalValue(assignment, true)) + "]");
        return info;
    }

    @Override
    public void restoreBest(Assignment<Request, Enrollment> assignment) {
        this.restoreBest(assignment, new Comparator<Request>(){

            @Override
            public int compare(Request r1, Request r2) {
                Enrollment e1 = (Enrollment)r1.getBestAssignment();
                Enrollment e2 = (Enrollment)r2.getBestAssignment();
                if (e1.getReservation() != null && e2.getReservation() == null) {
                    return -1;
                }
                if (e1.getReservation() == null && e2.getReservation() != null) {
                    return 1;
                }
                if (r1.getBestAssignmentIteration() != r2.getBestAssignmentIteration()) {
                    return r1.getBestAssignmentIteration() < r2.getBestAssignmentIteration() ? -1 : 1;
                }
                return r1.compareTo(r2);
            }
        });
        this.recomputeTotalValue(assignment);
    }

    public void recomputeTotalValue(Assignment<Request, Enrollment> assignment) {
        ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iTotalValue = this.getTotalValue(assignment, true);
    }

    @Override
    public void saveBest(Assignment<Request, Enrollment> assignment) {
        this.recomputeTotalValue(assignment);
        this.iBestAssignedCourseRequestWeight = ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCourseRequestWeight();
        super.saveBest(assignment);
    }

    public double getBestAssignedCourseRequestWeight() {
        return this.iBestAssignedCourseRequestWeight;
    }

    @Override
    public String toString(Assignment<Request, Enrollment> assignment) {
        double groupSpread = 0.0;
        double groupCount = 0.0;
        for (Offering offering : this.iOfferings) {
            for (Course course : offering.getCourses()) {
                for (RequestGroup group : course.getRequestGroups()) {
                    groupSpread += group.getAverageSpread(assignment) * group.getEnrollmentWeight(assignment, null);
                    groupCount += group.getEnrollmentWeight(assignment, null);
                }
            }
        }
        return (this.getNrRealStudents(false) > 0 ? "RRq:" + this.getNrAssignedRealRequests(assignment, false) + "/" + this.getNrRealRequests(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DRq:" + this.getNrAssignedLastLikeRequests(assignment, false) + "/" + this.getNrLastLikeRequests(false) + ", " : "") + (this.getNrRealStudents(false) > 0 ? "RS:" + this.getNrCompleteRealStudents(assignment, false) + "/" + this.getNrRealStudents(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DS:" + this.getNrCompleteLastLikeStudents(assignment, false) + "/" + this.getNrLastLikeStudents(false) + ", " : "") + "V:" + sDecimalFormat.format(-this.getTotalValue(assignment)) + (this.getDistanceConflict() == null ? "" : ", DC:" + this.getDistanceConflict().getTotalNrConflicts(assignment)) + (this.getTimeOverlaps() == null ? "" : ", TOC:" + this.getTimeOverlaps().getTotalNrConflicts(assignment)) + (this.iMPP ? ", IS:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSameSectionWeight / this.iTotalMPPCRWeight) + "%" : "") + (this.iMPP ? ", IT:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSameTimeWeight / this.iTotalMPPCRWeight) + "%" : "") + ", %:" + sDecimalFormat.format(-100.0 * this.getTotalValue(assignment) / ((double)(this.getStudents().size() - this.iNrDummyStudents) + (this.iProjectedStudentWeight < 0.0 ? (double)this.iNrDummyStudents * (this.iTotalDummyWeight / (double)this.iNrDummyRequests) : this.iProjectedStudentWeight * this.iTotalDummyWeight))) + (groupCount > 0.0 ? ", SG:" + sDecimalFormat.format(100.0 * groupSpread / groupCount) + "%" : "");
    }

    public double avg(double w1, double w2) {
        return Math.sqrt(w1 * w2);
    }

    public int getMaxDomainSize() {
        return this.iMaxDomainSize;
    }

    public void setMaxDomainSize(int maxDomainSize) {
        this.iMaxDomainSize = maxDomainSize;
    }

    @Override
    public StudentSectioningModelContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new StudentSectioningModelContext(assignment);
    }

    @Override
    public InheritedAssignment<Request, Enrollment> createInheritedAssignment(Solution<Request, Enrollment> solution, int index) {
        return new OptimisticInheritedAssignment<Request, Enrollment>(solution, index);
    }

    public DistanceMetric getDistanceMetric() {
        return this.iDistanceConflict != null ? this.iDistanceConflict.getDistanceMetric() : null;
    }

    public class StudentSectioningModelContext
    implements AssignmentConstraintContext<Request, Enrollment>,
    InfoProvider<Request, Enrollment> {
        private Set<Student> iCompleteStudents = new HashSet<Student>();
        private double iTotalValue = 0.0;
        private int iNrAssignedDummyRequests = 0;
        private int iNrCompleteDummyStudents = 0;
        private double iAssignedCRWeight = 0.0;
        private double iAssignedDummyCRWeight = 0.0;
        private double iReservedSpace = 0.0;
        private double iTotalReservedSpace = 0.0;
        private double iAssignedSameSectionWeight = 0.0;
        private double iAssignedSameChoiceWeight = 0.0;
        private double iAssignedSameTimeWeight = 0.0;
        private double iAssignedSelectedSectionWeight = 0.0;
        private double iAssignedSelectedConfigWeight = 0.0;
        private double iAssignedNoTimeSectionWeight = 0.0;

        public StudentSectioningModelContext(Assignment<Request, Enrollment> assignment) {
            for (Request request : StudentSectioningModel.this.variables()) {
                Enrollment enrollment = assignment.getValue(request);
                if (enrollment == null) continue;
                this.assigned(assignment, enrollment);
            }
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            Student student = enrollment.getStudent();
            if (student.isComplete(assignment)) {
                this.iCompleteStudents.add(student);
            }
            double value = enrollment.getRequest().getWeight() * StudentSectioningModel.this.iStudentWeights.getWeight(assignment, enrollment);
            this.iTotalValue -= value;
            ((Request.RequestContext)((Request)enrollment.variable()).getContext(assignment)).setLastWeight(value);
            if (enrollment.isCourseRequest()) {
                this.iAssignedCRWeight += enrollment.getRequest().getWeight();
            }
            if (enrollment.getRequest().isMPP()) {
                this.iAssignedSameSectionWeight += enrollment.getRequest().getWeight() * enrollment.percentInitial();
                this.iAssignedSameChoiceWeight += enrollment.getRequest().getWeight() * enrollment.percentSelected();
                this.iAssignedSameTimeWeight += enrollment.getRequest().getWeight() * enrollment.percentSameTime();
            }
            if (enrollment.getRequest().hasSelection()) {
                this.iAssignedSelectedSectionWeight += enrollment.getRequest().getWeight() * enrollment.percentSelectedSameSection();
                this.iAssignedSelectedConfigWeight += enrollment.getRequest().getWeight() * enrollment.percentSelectedSameConfig();
            }
            if (enrollment.getReservation() != null) {
                this.iReservedSpace += enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
                this.iTotalReservedSpace += enrollment.getRequest().getWeight();
            }
            if (student.isDummy()) {
                ++this.iNrAssignedDummyRequests;
                if (enrollment.isCourseRequest()) {
                    this.iAssignedDummyCRWeight += enrollment.getRequest().getWeight();
                }
                if (student.isComplete(assignment)) {
                    ++this.iNrCompleteDummyStudents;
                }
            }
            if (enrollment.isCourseRequest()) {
                int noTime = 0;
                for (Section section : enrollment.getSections()) {
                    if (section.getTime() != null) continue;
                    ++noTime;
                }
                if (noTime > 0) {
                    this.iAssignedNoTimeSectionWeight += enrollment.getRequest().getWeight() * (double)noTime / (double)enrollment.getSections().size();
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            Request.RequestContext cx;
            Double value;
            Student student = enrollment.getStudent();
            if (this.iCompleteStudents.contains(student)) {
                this.iCompleteStudents.remove(student);
                if (student.isDummy()) {
                    --this.iNrCompleteDummyStudents;
                }
            }
            if ((value = (cx = (Request.RequestContext)((Request)enrollment.variable()).getContext(assignment)).getLastWeight()) == null) {
                value = enrollment.getRequest().getWeight() * StudentSectioningModel.this.iStudentWeights.getWeight(assignment, enrollment);
            }
            this.iTotalValue += value.doubleValue();
            cx.setLastWeight(null);
            if (enrollment.isCourseRequest()) {
                this.iAssignedCRWeight -= enrollment.getRequest().getWeight();
            }
            if (enrollment.getRequest().isMPP()) {
                this.iAssignedSameSectionWeight -= enrollment.getRequest().getWeight() * enrollment.percentInitial();
                this.iAssignedSameChoiceWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelected();
                this.iAssignedSameTimeWeight -= enrollment.getRequest().getWeight() * enrollment.percentSameTime();
            }
            if (enrollment.getRequest().hasSelection()) {
                this.iAssignedSelectedSectionWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelectedSameSection();
                this.iAssignedSelectedConfigWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelectedSameConfig();
            }
            if (enrollment.getReservation() != null) {
                this.iReservedSpace -= enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
                this.iTotalReservedSpace -= enrollment.getRequest().getWeight();
            }
            if (student.isDummy()) {
                --this.iNrAssignedDummyRequests;
                if (enrollment.isCourseRequest()) {
                    this.iAssignedDummyCRWeight -= enrollment.getRequest().getWeight();
                }
            }
            if (enrollment.isCourseRequest()) {
                int noTime = 0;
                for (Section section : enrollment.getSections()) {
                    if (section.getTime() != null) continue;
                    ++noTime;
                }
                if (noTime > 0) {
                    this.iAssignedNoTimeSectionWeight -= enrollment.getRequest().getWeight() * (double)noTime / (double)enrollment.getSections().size();
                }
            }
        }

        public void add(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
            this.iTotalValue += StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getDistanceConflictWeight(assignment, c);
        }

        public void remove(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
            this.iTotalValue -= StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getDistanceConflictWeight(assignment, c);
        }

        public void add(Assignment<Request, Enrollment> assignment, TimeOverlapsCounter.Conflict c) {
            if (c.getR1() != null) {
                this.iTotalValue += c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE1(), c);
            }
            if (c.getR2() != null) {
                this.iTotalValue += c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE2(), c);
            }
        }

        public void remove(Assignment<Request, Enrollment> assignment, TimeOverlapsCounter.Conflict c) {
            if (c.getR1() != null) {
                this.iTotalValue -= c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE1(), c);
            }
            if (c.getR2() != null) {
                this.iTotalValue -= c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE2(), c);
            }
        }

        public Set<Student> getCompleteStudents() {
            return this.iCompleteStudents;
        }

        public int nrComplete() {
            return this.getCompleteStudents().size();
        }

        public void requestWeightsChanged(Assignment<Request, Enrollment> assignment) {
            StudentSectioningModel.this.iTotalCRWeight = 0.0;
            StudentSectioningModel.this.iTotalDummyWeight = 0.0;
            StudentSectioningModel.this.iTotalDummyCRWeight = 0.0;
            this.iAssignedCRWeight = 0.0;
            this.iAssignedDummyCRWeight = 0.0;
            StudentSectioningModel.this.iNrDummyRequests = 0;
            this.iNrAssignedDummyRequests = 0;
            this.iTotalReservedSpace = 0.0;
            this.iReservedSpace = 0.0;
            StudentSectioningModel.this.iTotalMPPCRWeight = 0.0;
            StudentSectioningModel.this.iTotalSelCRWeight = 0.0;
            this.iAssignedNoTimeSectionWeight = 0.0;
            for (Request request : StudentSectioningModel.this.variables()) {
                Enrollment e;
                boolean cr = request instanceof CourseRequest;
                if (cr && !request.isAlternative()) {
                    StudentSectioningModel.this.iTotalCRWeight += request.getWeight();
                }
                if (request.getStudent().isDummy()) {
                    StudentSectioningModel.this.iTotalDummyWeight += request.getWeight();
                    StudentSectioningModel.this.iNrDummyRequests++;
                    if (cr && !request.isAlternative()) {
                        StudentSectioningModel.this.iTotalDummyCRWeight += request.getWeight();
                    }
                }
                if (request.isMPP()) {
                    StudentSectioningModel.this.iTotalMPPCRWeight += request.getWeight();
                }
                if (request.hasSelection()) {
                    StudentSectioningModel.this.iTotalSelCRWeight += request.getWeight();
                }
                if ((e = assignment.getValue(request)) == null) continue;
                if (cr) {
                    this.iAssignedCRWeight += request.getWeight();
                }
                if (request.isMPP()) {
                    this.iAssignedSameSectionWeight += request.getWeight() * e.percentInitial();
                    this.iAssignedSameChoiceWeight += request.getWeight() * e.percentSelected();
                    this.iAssignedSameTimeWeight += request.getWeight() * e.percentSameTime();
                }
                if (request.hasSelection()) {
                    this.iAssignedSelectedSectionWeight += request.getWeight() * e.percentSelectedSameSection();
                    this.iAssignedSelectedConfigWeight += request.getWeight() * e.percentSelectedSameConfig();
                }
                if (e.getReservation() != null) {
                    this.iReservedSpace += request.getWeight();
                }
                if (cr && ((CourseRequest)request).hasReservations()) {
                    this.iTotalReservedSpace += request.getWeight();
                }
                if (request.getStudent().isDummy()) {
                    ++this.iNrAssignedDummyRequests;
                    if (cr) {
                        this.iAssignedDummyCRWeight += request.getWeight();
                    }
                }
                if (!cr) continue;
                int noTime = 0;
                for (Section section : e.getSections()) {
                    if (section.getTime() != null) continue;
                    ++noTime;
                }
                if (noTime <= 0) continue;
                this.iAssignedNoTimeSectionWeight += request.getWeight() * (double)noTime / (double)e.getSections().size();
            }
        }

        public double getTotalValue() {
            return this.iTotalValue;
        }

        public int getNrCompleteLastLikeStudents() {
            return this.iNrCompleteDummyStudents;
        }

        public int getNrAssignedLastLikeRequests() {
            return this.iNrAssignedDummyRequests;
        }

        @Override
        public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
            if (StudentSectioningModel.this.iTotalCRWeight > 0.0) {
                info.put("Assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedCRWeight / StudentSectioningModel.this.iTotalCRWeight) + "% (" + (int)Math.round(this.iAssignedCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalCRWeight) + ")");
                if (StudentSectioningModel.this.iNrDummyStudents > 0 && StudentSectioningModel.this.iNrDummyStudents != StudentSectioningModel.this.getStudents().size() && StudentSectioningModel.this.iTotalCRWeight != StudentSectioningModel.this.iTotalDummyCRWeight) {
                    if (StudentSectioningModel.this.iTotalDummyCRWeight > 0.0) {
                        info.put("Projected assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedDummyCRWeight / StudentSectioningModel.this.iTotalDummyCRWeight) + "% (" + (int)Math.round(this.iAssignedDummyCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalDummyCRWeight) + ")");
                    }
                    info.put("Real assigned course requests", sDecimalFormat.format(100.0 * (this.iAssignedCRWeight - this.iAssignedDummyCRWeight) / (StudentSectioningModel.this.iTotalCRWeight - StudentSectioningModel.this.iTotalDummyCRWeight)) + "% (" + (int)Math.round(this.iAssignedCRWeight - this.iAssignedDummyCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalCRWeight - StudentSectioningModel.this.iTotalDummyCRWeight) + ")");
                }
                if (this.iAssignedNoTimeSectionWeight > 0.0) {
                    info.put("Using classes w/o time", sDecimalFormat.format(100.0 * this.iAssignedNoTimeSectionWeight / this.iAssignedCRWeight) + "% (" + sDecimalFormat.format(this.iAssignedNoTimeSectionWeight) + ")");
                }
            }
            if (this.iTotalReservedSpace > 0.0) {
                info.put("Reservations", sDoubleFormat.format(100.0 * this.iReservedSpace / this.iTotalReservedSpace) + "% (" + Math.round(this.iReservedSpace) + "/" + Math.round(this.iTotalReservedSpace) + ")");
            }
            if (StudentSectioningModel.this.iMPP && StudentSectioningModel.this.iTotalMPPCRWeight > 0.0) {
                info.put("Perturbations: same section", sDoubleFormat.format(100.0 * this.iAssignedSameSectionWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameSectionWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                if (this.iAssignedSameChoiceWeight > this.iAssignedSameSectionWeight) {
                    info.put("Perturbations: same choice", sDoubleFormat.format(100.0 * this.iAssignedSameChoiceWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameChoiceWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                }
                if (this.iAssignedSameTimeWeight > this.iAssignedSameChoiceWeight) {
                    info.put("Perturbations: same time", sDoubleFormat.format(100.0 * this.iAssignedSameTimeWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameTimeWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                }
            }
            if (StudentSectioningModel.this.iTotalSelCRWeight > 0.0) {
                info.put("Selection", sDoubleFormat.format(100.0 * (0.3 * this.iAssignedSelectedConfigWeight + 0.7 * this.iAssignedSelectedSectionWeight) / StudentSectioningModel.this.iTotalSelCRWeight) + "% (" + Math.round(0.3 * this.iAssignedSelectedSectionWeight + 0.7 * this.iAssignedSelectedSectionWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalSelCRWeight) + ")");
            }
        }

        @Override
        public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
        }

        public double getAssignedCourseRequestWeight() {
            return this.iAssignedCRWeight;
        }
    }
}

