/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.instructor.criteria.BackToBack;
import org.cpsolver.instructor.criteria.DifferentLecture;
import org.cpsolver.instructor.criteria.SameCommon;
import org.cpsolver.instructor.criteria.SameCourse;
import org.cpsolver.instructor.criteria.SameDays;
import org.cpsolver.instructor.criteria.SameRoom;
import org.cpsolver.instructor.criteria.TimeOverlaps;
import org.cpsolver.instructor.criteria.UnusedInstructorLoad;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class Instructor
extends AbstractClassWithContext<TeachingRequest.Variable, TeachingAssignment, Context>
implements CanInheritContext<TeachingRequest.Variable, TeachingAssignment, Context> {
    private List<Attribute> iAttributes = new ArrayList<Attribute>();
    private List<Preference<TimeLocation>> iTimePreferences = new ArrayList<Preference<TimeLocation>>();
    private List<Preference<Course>> iCoursePreferences = new ArrayList<Preference<Course>>();
    private InstructorSchedulingModel iModel;
    private long iInstructorId;
    private String iExternalId;
    private String iName;
    private int iPreference;
    private float iMaxLoad;
    private int iBackToBackPreference;
    private int iSameDaysPreference;
    private int iSameRoomPreference;

    public Instructor(long id, String externalId, String name, int preference, float maxLoad) {
        this.iInstructorId = id;
        this.iExternalId = externalId;
        this.iName = name;
        this.iPreference = preference;
        this.iMaxLoad = maxLoad;
    }

    public InstructorSchedulingModel getModel() {
        return this.iModel;
    }

    public void setModel(InstructorSchedulingModel model) {
        this.iModel = model;
    }

    public long getInstructorId() {
        return this.iInstructorId;
    }

    public boolean hasExternalId() {
        return this.iExternalId != null && !this.iExternalId.isEmpty();
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public boolean hasName() {
        return this.iName != null && !this.iName.isEmpty();
    }

    public String getName() {
        return this.iName != null ? this.iName : (this.iExternalId != null ? this.iExternalId : "I" + this.iInstructorId);
    }

    public void setBackToBackPreference(int backToBackPreference) {
        this.iBackToBackPreference = backToBackPreference;
    }

    public int getBackToBackPreference() {
        return this.iBackToBackPreference;
    }

    public boolean isBackToBackPreferred() {
        return this.iBackToBackPreference < 0;
    }

    public boolean isBackToBackDiscouraged() {
        return this.iBackToBackPreference > 0;
    }

    public void setSameDaysPreference(int sameDaysPreference) {
        this.iSameDaysPreference = sameDaysPreference;
    }

    public int getSameDaysPreference() {
        return this.iSameDaysPreference;
    }

    public boolean isSameDaysPreferred() {
        return this.iSameDaysPreference < 0;
    }

    public boolean isSameDaysDiscouraged() {
        return this.iSameDaysPreference > 0;
    }

    public void setSameRoomPreference(int sameRoomPreference) {
        this.iSameRoomPreference = sameRoomPreference;
    }

    public int getSameRoomPreference() {
        return this.iSameRoomPreference;
    }

    public boolean isSameRoomPreferred() {
        return this.iSameRoomPreference < 0;
    }

    public boolean isSameRoomDiscouraged() {
        return this.iSameRoomPreference > 0;
    }

    public String getAvailable() {
        if (this.iTimePreferences == null) {
            return "";
        }
        String ret = "";
        for (Preference<TimeLocation> tl : this.iTimePreferences) {
            if (!tl.isProhibited()) continue;
            if (!ret.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + tl.getTarget().getLongName(true).trim();
        }
        return ret.isEmpty() ? "" : ret;
    }

    public List<Attribute> getAttributes() {
        return this.iAttributes;
    }

    public void addAttribute(Attribute attribute) {
        this.iAttributes.add(attribute);
    }

    public Set<Attribute> getAttributes(Attribute.Type type) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (Attribute attribute : this.iAttributes) {
            if (type.equals(attribute.getType())) {
                attributes.add(attribute);
            }
            for (Attribute parent = attribute.getParentAttribute(); parent != null; parent = parent.getParentAttribute()) {
                if (!type.equals(parent.getType())) continue;
                attributes.add(parent);
            }
        }
        return attributes;
    }

    public List<Preference<TimeLocation>> getTimePreferences() {
        return this.iTimePreferences;
    }

    public void addTimePreference(Preference<TimeLocation> pref) {
        this.iTimePreferences.add(pref);
    }

    public PreferenceCombination getTimePreference(TimeLocation time) {
        if (this.iTimePreferences.isEmpty()) {
            return null;
        }
        MinMaxPreferenceCombination comb = new MinMaxPreferenceCombination();
        for (Preference<TimeLocation> pref : this.iTimePreferences) {
            if (!pref.getTarget().hasIntersection(time)) continue;
            ((PreferenceCombination)comb).addPreferenceInt(pref.getPreference());
        }
        return comb;
    }

    public PreferenceCombination getTimePreference(TeachingRequest request) {
        MinMaxPreferenceCombination comb = new MinMaxPreferenceCombination();
        for (Preference<TimeLocation> pref : this.iTimePreferences) {
            for (Section section : request.getSections()) {
                if (!section.hasTime() || !section.getTime().hasIntersection(pref.getTarget())) continue;
                if (section.isAllowOverlap() && pref.isProhibited()) {
                    ((PreferenceCombination)comb).addPreferenceInt(4);
                    continue;
                }
                ((PreferenceCombination)comb).addPreferenceInt(pref.getPreference());
            }
        }
        return comb;
    }

    public List<Preference<Course>> getCoursePreferences() {
        return this.iCoursePreferences;
    }

    public void addCoursePreference(Preference<Course> pref) {
        this.iCoursePreferences.add(pref);
    }

    public Preference<Course> getCoursePreference(Course course) {
        boolean hasRequired = false;
        for (Preference<Course> pref : this.iCoursePreferences) {
            if (!pref.isRequired()) continue;
            hasRequired = true;
            break;
        }
        for (Preference<Course> pref : this.iCoursePreferences) {
            if (!pref.getTarget().equals(course) || hasRequired && !pref.isRequired()) continue;
            return pref;
        }
        if (hasRequired) {
            return new Preference<Course>(course, 100);
        }
        return new Preference<Course>(course, 0);
    }

    public int getPreference() {
        return this.iPreference;
    }

    public void setPreference(int preference) {
        this.iPreference = preference;
    }

    public float getMaxLoad() {
        return this.iMaxLoad;
    }

    public boolean canTeach(TeachingRequest request) {
        if (request.getLoad() > this.getMaxLoad()) {
            return false;
        }
        if (this.getTimePreference(request).isProhibited()) {
            return false;
        }
        if (this.getCoursePreference(request.getCourse()).isProhibited()) {
            return false;
        }
        return !request.getInstructorPreference(this).isProhibited();
    }

    public int hashCode() {
        return new Long(this.iInstructorId).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Instructor)) {
            return false;
        }
        Instructor i = (Instructor)o;
        return this.getInstructorId() == i.getInstructorId();
    }

    public int share(TeachingRequest request) {
        int share = 0;
        for (Section section : request.getSections()) {
            if (!section.hasTime() || !section.isAllowOverlap()) continue;
            for (Preference<TimeLocation> pref : this.iTimePreferences) {
                if (!pref.isProhibited() || !section.getTime().shareWeeks(pref.getTarget())) continue;
                share += section.getTime().nrSharedDays(pref.getTarget()) * section.getTime().nrSharedHours(pref.getTarget());
            }
        }
        return share;
    }

    public int share(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
        int share = 0;
        if (value.getInstructor().equals(this)) {
            for (TeachingAssignment other : ((Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                if (((TeachingRequest.Variable)other.variable()).equals(value.variable())) continue;
                share += ((TeachingRequest.Variable)value.variable()).getRequest().share(((TeachingRequest.Variable)other.variable()).getRequest());
            }
            share += this.share(((TeachingRequest.Variable)value.variable()).getRequest());
        }
        return share;
    }

    public double differentLectures(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
        double same = 0.0;
        int count = 0;
        if (value.getInstructor().equals(this)) {
            for (TeachingAssignment other : ((Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                if (((TeachingRequest.Variable)other.variable()).equals(value.variable())) continue;
                same += ((TeachingRequest.Variable)value.variable()).getRequest().nrSameLectures(((TeachingRequest.Variable)other.variable()).getRequest());
                ++count;
            }
        }
        return count == 0 ? 0.0 : ((double)count - same) / (double)count;
    }

    public double countBackToBacks(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, double diffRoomWeight, double diffTypeWeight) {
        double b2b = 0.0;
        if (value.getInstructor().equals(this) && this.getBackToBackPreference() != 0) {
            for (TeachingAssignment other : ((Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                if (((TeachingRequest.Variable)other.variable()).equals(value.variable())) continue;
                if (this.getBackToBackPreference() < 0) {
                    b2b += (((TeachingRequest.Variable)value.variable()).getRequest().countBackToBacks(((TeachingRequest.Variable)other.variable()).getRequest(), diffRoomWeight, diffTypeWeight) - 1.0) * (double)this.getBackToBackPreference();
                    continue;
                }
                b2b += ((TeachingRequest.Variable)value.variable()).getRequest().countBackToBacks(((TeachingRequest.Variable)other.variable()).getRequest(), diffRoomWeight, diffTypeWeight) * (double)this.getBackToBackPreference();
            }
        }
        return b2b;
    }

    public double countSameDays(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, double diffRoomWeight, double diffTypeWeight) {
        double sd = 0.0;
        if (value.getInstructor().equals(this) && this.getSameDaysPreference() != 0) {
            for (TeachingAssignment other : ((Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                if (((TeachingRequest.Variable)other.variable()).equals(value.variable())) continue;
                if (this.getSameDaysPreference() < 0) {
                    sd += (((TeachingRequest.Variable)value.variable()).getRequest().countSameDays(((TeachingRequest.Variable)other.variable()).getRequest(), diffRoomWeight, diffTypeWeight) - 1.0) * (double)this.getSameDaysPreference();
                    continue;
                }
                sd += ((TeachingRequest.Variable)value.variable()).getRequest().countSameDays(((TeachingRequest.Variable)other.variable()).getRequest(), diffRoomWeight, diffTypeWeight) * (double)this.getSameDaysPreference();
            }
        }
        return sd;
    }

    public double countSameRooms(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, double diffTypeWeight) {
        double sd = 0.0;
        if (value.getInstructor().equals(this) && this.getSameRoomPreference() != 0) {
            for (TeachingAssignment other : ((Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                if (((TeachingRequest.Variable)other.variable()).equals(value.variable())) continue;
                if (this.getSameRoomPreference() < 0) {
                    sd += (((TeachingRequest.Variable)value.variable()).getRequest().countSameRooms(((TeachingRequest.Variable)other.variable()).getRequest(), diffTypeWeight) - 1.0) * (double)this.getSameRoomPreference();
                    continue;
                }
                sd += ((TeachingRequest.Variable)value.variable()).getRequest().countSameRooms(((TeachingRequest.Variable)other.variable()).getRequest(), diffTypeWeight) * (double)this.getSameRoomPreference();
            }
        }
        return sd;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Context createAssignmentContext(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        return new Context(assignment);
    }

    @Override
    public Context inheritAssignmentContext(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Context parentContext) {
        return new Context(assignment, parentContext);
    }

    public class Context
    implements AssignmentConstraintContext<TeachingRequest.Variable, TeachingAssignment> {
        private HashSet<TeachingAssignment> iAssignments = new HashSet();
        private int iTimeOverlaps;
        private double iBackToBacks;
        private double iSameDays;
        private double iSameRooms;
        private double iDifferentLectures;
        private double iUnusedLoad;
        private double iSameCoursePenalty;
        private double iSameCommonPenalty;

        public Context(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            for (TeachingRequest.Variable request : Instructor.this.getModel().variables()) {
                TeachingAssignment value = assignment.getValue(request);
                if (value == null || !value.getInstructor().equals(this.getInstructor())) continue;
                this.iAssignments.add(value);
            }
            if (!this.iAssignments.isEmpty()) {
                this.updateCriteria(assignment);
            }
        }

        public Context(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Context parentContext) {
            this.iAssignments = new HashSet<TeachingAssignment>(parentContext.getAssignments());
            if (!this.iAssignments.isEmpty()) {
                this.updateCriteria(assignment);
            }
        }

        public Instructor getInstructor() {
            return Instructor.this;
        }

        @Override
        public void assigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            if (value.getInstructor().equals(this.getInstructor())) {
                this.iAssignments.add(value);
                this.updateCriteria(assignment);
            }
        }

        @Override
        public void unassigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            if (value.getInstructor().equals(this.getInstructor())) {
                this.iAssignments.remove(value);
                this.updateCriteria(assignment);
            }
        }

        private void updateCriteria(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            Criterion<TeachingRequest.Variable, TeachingAssignment> sameCommon;
            Criterion<TeachingRequest.Variable, TeachingAssignment> sameCourse;
            Criterion<TeachingRequest.Variable, TeachingAssignment> unused;
            Criterion<TeachingRequest.Variable, TeachingAssignment> diff;
            Criterion<TeachingRequest.Variable, TeachingAssignment> overlaps;
            SameRoom sr;
            SameDays sd;
            BackToBack b2b = (BackToBack)Instructor.this.getModel().getCriterion(BackToBack.class);
            if (b2b != null) {
                b2b.inc(assignment, -this.iBackToBacks);
                this.iBackToBacks = this.countBackToBackPreference(b2b.getDifferentRoomWeight(), b2b.getDifferentTypeWeight());
                b2b.inc(assignment, this.iBackToBacks);
            }
            if ((sd = (SameDays)Instructor.this.getModel().getCriterion(SameDays.class)) != null) {
                sd.inc(assignment, -this.iSameDays);
                this.iSameDays = this.countSameDaysPreference(sd.getDifferentRoomWeight(), sd.getDifferentTypeWeight());
                sd.inc(assignment, this.iSameDays);
            }
            if ((sr = (SameRoom)Instructor.this.getModel().getCriterion(SameRoom.class)) != null) {
                sr.inc(assignment, -this.iSameRooms);
                this.iSameRooms = this.countSameRoomPreference(sd.getDifferentTypeWeight());
                sr.inc(assignment, this.iSameRooms);
            }
            if ((overlaps = Instructor.this.getModel().getCriterion(TimeOverlaps.class)) != null) {
                overlaps.inc(assignment, -this.iTimeOverlaps);
                this.iTimeOverlaps = this.countTimeOverlaps();
                overlaps.inc(assignment, this.iTimeOverlaps);
            }
            if ((diff = Instructor.this.getModel().getCriterion(DifferentLecture.class)) != null) {
                diff.inc(assignment, -this.iDifferentLectures);
                this.iDifferentLectures = this.countDifferentLectures();
                diff.inc(assignment, this.iDifferentLectures);
            }
            if ((unused = Instructor.this.getModel().getCriterion(UnusedInstructorLoad.class)) != null) {
                unused.inc(assignment, -this.iUnusedLoad);
                this.iUnusedLoad = this.getUnusedLoad();
                unused.inc(assignment, this.iUnusedLoad);
            }
            if ((sameCourse = Instructor.this.getModel().getCriterion(SameCourse.class)) != null) {
                sameCourse.inc(assignment, -this.iSameCoursePenalty);
                this.iSameCoursePenalty = this.countSameCoursePenalty();
                sameCourse.inc(assignment, this.iSameCoursePenalty);
            }
            if ((sameCommon = Instructor.this.getModel().getCriterion(SameCommon.class)) != null) {
                sameCommon.inc(assignment, -this.iSameCommonPenalty);
                this.iSameCommonPenalty = this.countSameCommonPenalty();
                sameCommon.inc(assignment, this.iSameCommonPenalty);
            }
        }

        public Set<TeachingAssignment> getAssignments() {
            return this.iAssignments;
        }

        public float getLoad() {
            float load = 0.0f;
            for (TeachingAssignment assignment : this.iAssignments) {
                load += ((TeachingRequest.Variable)assignment.variable()).getRequest().getLoad();
            }
            return load;
        }

        public float getUnusedLoad() {
            return this.iAssignments.isEmpty() ? 0.0f : this.getInstructor().getMaxLoad() - this.getLoad();
        }

        public int countTimeOverlaps() {
            int share = 0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    share += ((TeachingRequest.Variable)a1.variable()).getRequest().share(((TeachingRequest.Variable)a2.variable()).getRequest());
                }
                share += this.getInstructor().share(((TeachingRequest.Variable)a1.variable()).getRequest());
            }
            return share;
        }

        public int countAssignmentsWithTime() {
            int ret = 0;
            block0: for (TeachingAssignment a1 : this.iAssignments) {
                for (Section s1 : ((TeachingRequest.Variable)a1.variable()).getSections()) {
                    if (!s1.hasTime()) continue;
                    ++ret;
                    continue block0;
                }
            }
            return ret;
        }

        public double countDifferentLectures() {
            double same = 0.0;
            int pairs = 0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    same += ((TeachingRequest.Variable)a1.variable()).getRequest().nrSameLectures(((TeachingRequest.Variable)a2.variable()).getRequest());
                    ++pairs;
                }
            }
            return pairs == 0 ? 0.0 : ((double)pairs - same) / (double)pairs;
        }

        public double countBackToBackPreference(double diffRoomWeight, double diffTypeWeight) {
            double b2b = 0.0;
            if (this.getInstructor().isBackToBackPreferred() || this.getInstructor().isBackToBackDiscouraged()) {
                for (TeachingAssignment a1 : this.iAssignments) {
                    for (TeachingAssignment a2 : this.iAssignments) {
                        if (a1.getId() >= a2.getId()) continue;
                        if (this.getInstructor().getBackToBackPreference() < 0) {
                            b2b += (((TeachingRequest.Variable)a1.variable()).getRequest().countBackToBacks(((TeachingRequest.Variable)a2.variable()).getRequest(), diffRoomWeight, diffTypeWeight) - 1.0) * (double)this.getInstructor().getBackToBackPreference();
                            continue;
                        }
                        b2b += ((TeachingRequest.Variable)a1.variable()).getRequest().countBackToBacks(((TeachingRequest.Variable)a2.variable()).getRequest(), diffRoomWeight, diffTypeWeight) * (double)this.getInstructor().getBackToBackPreference();
                    }
                }
            }
            return b2b;
        }

        public double countBackToBackPercentage() {
            BackToBack c = (BackToBack)Instructor.this.getModel().getCriterion(BackToBack.class);
            if (c == null) {
                return 0.0;
            }
            double b2b = 0.0;
            int pairs = 0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    b2b += ((TeachingRequest.Variable)a1.variable()).getRequest().countBackToBacks(((TeachingRequest.Variable)a2.variable()).getRequest(), c.getDifferentRoomWeight(), c.getDifferentTypeWeight());
                    ++pairs;
                }
            }
            return pairs == 0 ? 0.0 : b2b / (double)pairs;
        }

        public double countSameDaysPreference(double diffRoomWeight, double diffTypeWeight) {
            double sd = 0.0;
            if (this.getInstructor().isSameDaysPreferred() || this.getInstructor().isSameDaysDiscouraged()) {
                for (TeachingAssignment a1 : this.iAssignments) {
                    for (TeachingAssignment a2 : this.iAssignments) {
                        if (a1.getId() >= a2.getId()) continue;
                        if (this.getInstructor().getSameDaysPreference() < 0) {
                            sd += (((TeachingRequest.Variable)a1.variable()).getRequest().countSameDays(((TeachingRequest.Variable)a2.variable()).getRequest(), diffRoomWeight, diffTypeWeight) - 1.0) * (double)this.getInstructor().getSameDaysPreference();
                            continue;
                        }
                        sd += ((TeachingRequest.Variable)a1.variable()).getRequest().countSameDays(((TeachingRequest.Variable)a2.variable()).getRequest(), diffRoomWeight, diffTypeWeight) * (double)this.getInstructor().getSameDaysPreference();
                    }
                }
            }
            return sd;
        }

        public double countSameDaysPercentage() {
            SameDays c = (SameDays)Instructor.this.getModel().getCriterion(SameDays.class);
            if (c == null) {
                return 0.0;
            }
            double sd = 0.0;
            int pairs = 0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    sd += ((TeachingRequest.Variable)a1.variable()).getRequest().countSameDays(((TeachingRequest.Variable)a2.variable()).getRequest(), c.getDifferentRoomWeight(), c.getDifferentTypeWeight());
                    ++pairs;
                }
            }
            return pairs == 0 ? 0.0 : sd / (double)pairs;
        }

        public double countSameRoomPreference(double diffTypeWeight) {
            double sd = 0.0;
            if (this.getInstructor().isSameRoomPreferred() || this.getInstructor().isSameRoomDiscouraged()) {
                for (TeachingAssignment a1 : this.iAssignments) {
                    for (TeachingAssignment a2 : this.iAssignments) {
                        if (a1.getId() >= a2.getId()) continue;
                        if (this.getInstructor().getSameRoomPreference() < 0) {
                            sd += (((TeachingRequest.Variable)a1.variable()).getRequest().countSameRooms(((TeachingRequest.Variable)a2.variable()).getRequest(), diffTypeWeight) - 1.0) * (double)this.getInstructor().getSameRoomPreference();
                            continue;
                        }
                        sd += ((TeachingRequest.Variable)a1.variable()).getRequest().countSameRooms(((TeachingRequest.Variable)a2.variable()).getRequest(), diffTypeWeight) * (double)this.getInstructor().getSameRoomPreference();
                    }
                }
            }
            return sd;
        }

        public double countSameRoomPercentage() {
            SameRoom c = (SameRoom)Instructor.this.getModel().getCriterion(SameDays.class);
            if (c == null) {
                return 0.0;
            }
            double sr = 0.0;
            int pairs = 0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    sr += ((TeachingRequest.Variable)a1.variable()).getRequest().countSameRooms(((TeachingRequest.Variable)a2.variable()).getRequest(), c.getDifferentTypeWeight());
                    ++pairs;
                }
            }
            return pairs == 0 ? 0.0 : sr / (double)pairs;
        }

        public double countSameCoursePenalty() {
            if (this.iAssignments.size() <= 1) {
                return 0.0;
            }
            double penalty = 0.0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    penalty += ((TeachingRequest.Variable)a1.variable()).getRequest().getSameCoursePenalty(((TeachingRequest.Variable)a2.variable()).getRequest());
                }
            }
            return penalty / (double)(this.iAssignments.size() - 1);
        }

        public double countSameCommonPenalty() {
            if (this.iAssignments.size() <= 1) {
                return 0.0;
            }
            double penalty = 0.0;
            for (TeachingAssignment a1 : this.iAssignments) {
                for (TeachingAssignment a2 : this.iAssignments) {
                    if (a1.getId() >= a2.getId()) continue;
                    penalty += ((TeachingRequest.Variable)a1.variable()).getRequest().getSameCommonPenalty(((TeachingRequest.Variable)a2.variable()).getRequest());
                }
            }
            return penalty / (double)(this.iAssignments.size() - 1);
        }
    }
}

