/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class ExamConstruction
extends NeighbourSelectionWithContext<Exam, ExamPlacement, Context> {
    private boolean iCheckLocalOptimality = false;
    private Progress iProgress = null;
    private boolean iActive = false;

    public ExamConstruction(DataProperties properties) {
        this.iCheckLocalOptimality = properties.getPropertyBoolean("ExamConstruction.CheckLocalOptimality", this.iCheckLocalOptimality);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        super.init(solver);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iActive = false;
    }

    public Neighbour<Exam, ExamPlacement> checkLocalOptimality(Assignment<Exam, ExamPlacement> assignment, ExamModel model) {
        if (this.iCheckLocalOptimality) {
            Context context = (Context)this.getContext(assignment);
            for (Exam exam : assignment.assignedVariables()) {
                ExamPlacement current = assignment.getValue(exam);
                if (current.getTimeCost(assignment) <= 0.0) continue;
                ExamPlacement best = null;
                for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                    Set<ExamRoomPlacement> rooms;
                    if (exam.countStudentConflicts(assignment, period) > 0 && context.assignments().contains(exam.getId() + ":" + period.getIndex()) || !exam.checkDistributionConstraints(assignment, period)) continue;
                    ExamPlacement placement = new ExamPlacement(exam, period, null);
                    if (best != null && !(best.getTimeCost(assignment) > placement.getTimeCost(assignment)) || (rooms = exam.findBestAvailableRooms(assignment, period)) == null) continue;
                    best = new ExamPlacement(exam, period, rooms);
                }
                if (best == null || !(best.getTimeCost(assignment) < current.getTimeCost(assignment))) continue;
                return new ExamSimpleNeighbour(assignment, best);
            }
        }
        this.iActive = false;
        return null;
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        Context context = (Context)this.getContext(assignment);
        if (!this.iActive) {
            this.iActive = true;
            this.iProgress.info("[" + Thread.currentThread().getName() + "] Construction ...");
        }
        if (model.variables().size() - assignment.nrAssignedVariables() <= context.skip().size()) {
            return this.checkLocalOptimality(assignment, model);
        }
        Exam bestExam = null;
        for (Exam exam : model.variables()) {
            if (assignment.getValue(exam) != null || context.skip().contains(exam) || bestExam != null && exam.compareTo(bestExam) >= 0) continue;
            bestExam = exam;
        }
        ExamPlacement best = null;
        for (ExamPeriodPlacement period : bestExam.getPeriodPlacements()) {
            Set<ExamRoomPlacement> rooms;
            if (bestExam.countStudentConflicts(assignment, period) > 0 && context.assignments().contains(bestExam.getId() + ":" + period.getIndex()) || !bestExam.checkDistributionConstraints(assignment, period)) continue;
            ExamPlacement placement = new ExamPlacement(bestExam, period, null);
            if (best != null && !(best.getTimeCost(assignment) > placement.getTimeCost(assignment)) || (rooms = bestExam.findBestAvailableRooms(assignment, period)) == null) continue;
            best = new ExamPlacement(bestExam, period, rooms);
        }
        if (best != null) {
            context.assignments().add(bestExam.getId() + ":" + best.getPeriod().getIndex());
            return new ExamSimpleNeighbour(assignment, best);
        }
        if (!context.skip().contains(bestExam)) {
            context.skip().add(bestExam);
            return this.selectNeighbour(solution);
        }
        return this.checkLocalOptimality(assignment, model);
    }

    @Override
    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context();
    }

    public class Context
    implements AssignmentContext {
        private Set<String> iAssignments = Collections.synchronizedSet(new HashSet());
        private Set<Exam> iSkip = Collections.synchronizedSet(new HashSet());

        public Set<Exam> skip() {
            return this.iSkip;
        }

        public Set<String> assignments() {
            return this.iAssignments;
        }
    }
}

