/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.Daylight;
import biweekly.util.ICalDate;
import biweekly.util.UtcOffset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaylightScribe
extends ICalPropertyScribe<Daylight> {
    public DaylightScribe() {
        super(Daylight.class, "DAYLIGHT");
    }

    @Override
    protected String _writeText(Daylight property, WriteContext context) {
        if (!property.isDaylight()) {
            return "FALSE";
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add("TRUE");
        UtcOffset offset = property.getOffset();
        values.add(offset == null ? "" : offset.toString());
        ICalDate start = property.getStart();
        values.add(start == null || start.getRawComponents() == null ? "" : start.getRawComponents().toString(true, false));
        ICalDate end = property.getEnd();
        values.add(end == null || end.getRawComponents() == null ? "" : end.getRawComponents().toString(true, false));
        String standardName = property.getStandardName();
        values.add(standardName == null ? "" : standardName);
        String daylightName = property.getDaylightName();
        values.add(daylightName == null ? "" : daylightName);
        return DaylightScribe.structured(values.toArray());
    }

    @Override
    protected Daylight _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        ICalPropertyScribe.StructuredIterator it = DaylightScribe.structured(value);
        String next = it.nextString();
        boolean flag = next == null ? false : Boolean.parseBoolean(next);
        UtcOffset offset = null;
        next = it.nextString();
        if (next != null) {
            try {
                offset = UtcOffset.parse(next);
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(33, next);
            }
        }
        ICalDate start = null;
        next = it.nextString();
        if (next != null) {
            try {
                start = DaylightScribe.date(next).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(34, next);
            }
        }
        ICalDate end = null;
        next = it.nextString();
        if (next != null) {
            try {
                end = DaylightScribe.date(next).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(35, next);
            }
        }
        String standardName = it.nextString();
        String daylightName = it.nextString();
        return new Daylight(flag, offset, start, end, standardName, daylightName);
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V1_0);
    }
}

