/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.List;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.comparators.ClassComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnassignedClassRow
implements Serializable,
Comparable<UnassignedClassRow> {
    private static final long serialVersionUID = 1L;
    private Long iId = null;
    private String iName = null;
    private List<String> iInstructors = null;
    private int iNrStudents = 0;
    private String iInitial = null;
    private int iOrd = -1;
    private transient Class_ iClazz = null;

    public UnassignedClassRow(Long id, String name, List<String> instructors, int nrStudents, String initial, int ord) {
        this.iId = id;
        this.iName = name;
        this.iNrStudents = nrStudents;
        this.iInstructors = instructors;
        this.iInitial = initial;
        this.iOrd = ord;
    }

    public UnassignedClassRow(Long id, String name, List<String> instructors, int nrStudents, String initial, Class_ clazz) {
        this.iId = id;
        this.iName = name;
        this.iNrStudents = nrStudents;
        this.iInstructors = instructors;
        this.iInitial = initial;
        this.iClazz = clazz;
    }

    public Long getId() {
        return this.iId;
    }

    public String getOnClick() {
        return this.iId == null ? null : "showGwtDialog('Suggestions', 'suggestions.do?id=" + this.iId + "&op=Reset','900','90%');";
    }

    public String getName() {
        return this.iName;
    }

    public String getInstructor() {
        String instructors = "";
        if (this.iInstructors != null) {
            for (String instructor : this.iInstructors) {
                instructors = instructors + (instructors.isEmpty() ? "" : ", ") + instructor;
            }
        }
        return instructors;
    }

    public List<String> getInstructors() {
        return this.iInstructors;
    }

    public int getNrStudents() {
        return this.iNrStudents;
    }

    public String getInitial() {
        return this.iInitial;
    }

    @Override
    public int compareTo(UnassignedClassRow ucr) {
        int cmp;
        if (this.iOrd >= 0 && ucr.iOrd >= 0) {
            int cmp2 = Double.compare(this.iOrd, ucr.iOrd);
            if (cmp2 != 0) {
                return cmp2;
            }
        } else if (this.iClazz != null && ucr.iClazz != null && (cmp = new ClassComparator(5).compare(this.iClazz, ucr.iClazz)) != 0) {
            return cmp;
        }
        return this.getName().compareTo(ucr.getName());
    }
}

