/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLLoader;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.report.SectionConflictTable;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.dom4j.Document;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.solver.AbstractSolver;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseLoader;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseSaver;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.MemoryCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSolver
extends AbstractSolver<Request, Enrollment, StudentSectioningModel>
implements StudentSolverProxy {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private transient Map<Long, XCourse> iCourseInfoCache = null;
    private Map<String, Object> iOnlineProperties = new HashMap<String, Object>();
    private AcademicSessionInfo iSession = null;
    private DistanceMetric iDistanceMetric = null;

    public StudentSolver(DataProperties properties, SolverDisposeListener disposeListener) {
        super(properties, disposeListener);
    }

    @Override
    protected ProblemSaver<Request, Enrollment, StudentSectioningModel> getDatabaseSaver(Solver<Request, Enrollment> solver) {
        return new StudentSectioningDatabaseSaver(solver);
    }

    @Override
    protected ProblemLoader<Request, Enrollment, StudentSectioningModel> getDatabaseLoader(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        return new StudentSectioningDatabaseLoader(model, assignment);
    }

    @Override
    protected StudentSectioningModel createModel(DataProperties properties) {
        return new StudentSectioningModel(properties);
    }

    public void setInitalSolution(Model<Request, Enrollment> model) {
        this.setInitalSolution(new Solution(model, (Assignment)new DefaultSingleAssignment()));
    }

    @Override
    protected Document createCurrentSolutionBackup(boolean anonymize, boolean idconv) {
        this.getProperties().setProperty("Xml.SaveBest", "true");
        this.getProperties().setProperty("Xml.SaveInitial", "true");
        this.getProperties().setProperty("Xml.SaveCurrent", "true");
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
            this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
            this.getProperties().setProperty("Xml.SaveStudentInfo", "false");
            this.getProperties().setProperty("Xml.ShowNames", "false");
        }
        Document document = new StudentSectioningXMLSaver((Solver)this).saveDocument();
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", "false");
            this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
            this.getProperties().setProperty("Xml.SaveStudentInfo", "true");
            this.getProperties().setProperty("Xml.ShowNames", "true");
        }
        return document;
    }

    @Override
    protected void restureCurrentSolutionFromBackup(Document document) {
        this.getProperties().setProperty("Xml.LoadBest", "true");
        this.getProperties().setProperty("Xml.LoadInitial", "true");
        this.getProperties().setProperty("Xml.LoadCurrent", "true");
        new StudentSectioningXMLLoader((StudentSectioningModel)this.currentSolution().getModel(), this.currentSolution().getAssignment()).load(document);
    }

    @Override
    protected void disposeNoInherit(boolean unregister) {
        super.disposeNoInherit(unregister);
        this.clearCourseInfoTable();
    }

    @Override
    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcademicSessionInfo getAcademicSession() {
        if (this.iSession == null) {
            org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
            try {
                this.iSession = new AcademicSessionInfo((Session)SessionDAO.getInstance().get(this.getSessionId(), hibSession));
                this.iSession.setSectioningEnabled(false);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        return this.iSession;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        if (this.iDistanceMetric == null) {
            this.iDistanceMetric = new DistanceMetric(this.getProperties());
            TravelTime.populateTravelTimes(this.iDistanceMetric);
        }
        return this.iDistanceMetric;
    }

    @Override
    public DataProperties getConfig() {
        return this.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, XCourse> getCourseInfoTable() {
        if (this.iCourseInfoCache == null) {
            org.hibernate.Session hibSession = CourseOfferingDAO.getInstance().createNewSession();
            try {
                this.iCourseInfoCache = new Hashtable<Long, XCourse>();
                for (CourseOffering course : hibSession.createQuery("from CourseOffering x where x.subjectArea.session.uniqueId = :sessionId and x.instructionalOffering.notOffered = false").setLong("sessionId", this.getSessionId().longValue()).setCacheable(true).list()) {
                    this.iCourseInfoCache.put(course.getUniqueId(), new XCourse(course));
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        return this.iCourseInfoCache;
    }

    private void clearCourseInfoTable() {
        this.iCourseInfoCache = null;
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>(limit == null || limit < 0 ? 100 : limit);
        String queryInLowerCase = query.toLowerCase();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (c.matchCourseName(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                ret.add(c);
            }
            if (limit == null || limit <= 0 || ret.size() < limit) continue;
            return ret;
        }
        if (queryInLowerCase.length() > 2) {
            for (XCourse c : this.getCourseInfoTable().values()) {
                if (c.matchTitle(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                    ret.add(c);
                }
                if (limit == null || limit <= 0 || ret.size() < limit) continue;
                return ret;
            }
        }
        return ret;
    }

    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (!matcher.match(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public Collection<XStudentId> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XStudentId> ret = new ArrayList<XStudentId>();
        for (Student student : ((StudentSectioningModel)this.currentSolution().getModel()).getStudents()) {
            if (student.isDummy()) continue;
            XStudentId s = new XStudentId(student);
            if (student.isDummy() || !matcher.match(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    @Override
    public XCourse getCourse(Long courseId) {
        return this.getCourseInfoTable().get(courseId);
    }

    @Override
    public XCourse getCourse(String courseName) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            for (Course course : offering.getCourses()) {
                if (!course.getName().equalsIgnoreCase(courseName)) continue;
                return this.getCourse(course.getId());
            }
        }
        return null;
    }

    @Override
    public XStudent getStudent(Long studentId) {
        for (Student student : ((StudentSectioningModel)this.currentSolution().getModel()).getStudents()) {
            if (student.isDummy() || student.getId() != studentId.longValue()) continue;
            return new XStudent(student, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
        }
        return null;
    }

    @Override
    public XOffering getOffering(Long offeringId) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            return new XOffering(offering, ((StudentSectioningModel)this.currentSolution().getModel()).getLinkedSections());
        }
        return null;
    }

    @Override
    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        try {
            return (X)((OnlineSectioningAction)clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        E e;
        OnlineSectioningHelper h;
        block18: {
            long c0 = OnlineSectioningHelper.getCpuTime();
            h = new OnlineSectioningHelper(user);
            try {
                h.addMessageHandler(new OnlineSectioningHelper.DefaultMessageLogger(LogFactory.getLog((String)(action.getClass().getName() + "." + action.name() + "[" + this.getAcademicSession().toCompactString() + "]"))));
                h.addAction(action, this.getAcademicSession());
                E ret = action.execute(this, h);
                if (h.getAction() != null && !h.getAction().hasResult()) {
                    if (ret == null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    } else if (ret instanceof Boolean) {
                        h.getAction().setResult((Boolean)ret != false ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                    } else {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.SUCCESS);
                    }
                }
                e = ret;
                Object var9_8 = null;
                if (h.getAction() == null) break block18;
                h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            }
            catch (Exception e2) {
                try {
                    if (e2 instanceof SectioningException) {
                        if (e2.getCause() == null) {
                            h.info("Execution failed: " + e2.getMessage());
                        } else {
                            h.warn("Execution failed: " + e2.getMessage(), e2.getCause());
                        }
                    } else {
                        h.error("Execution failed: " + e2.getMessage(), e2);
                    }
                    if (h.getAction() != null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e2.getCause() != null && e2 instanceof SectioningException) {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getCause().getClass().getName() + ": " + e2.getCause().getMessage()));
                        } else {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getMessage() == null ? "null" : e2.getMessage()));
                        }
                    }
                    if (e2 instanceof SectioningException) {
                        throw (SectioningException)e2;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e2.getMessage()), e2);
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (h.getAction() != null) {
                        h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    }
                    this.sLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
                    throw throwable;
                }
            }
        }
        this.sLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
        return e;
    }

    @Override
    public <E> void execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user, OnlineSectioningServer.ServerCallback<E> callback) throws SectioningException {
        try {
            callback.onSuccess(this.execute(action, user));
        }
        catch (Throwable t) {
            callback.onFailure(t);
        }
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clearAllStudents() {
    }

    @Override
    public OnlineSectioningServer.Lock readLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        return new NoLock();
    }

    @Override
    public boolean isOfferingLocked(Long offeringId) {
        return false;
    }

    @Override
    public void lockOffering(Long offeringId) {
    }

    @Override
    public void unlockOffering(Long offeringId) {
    }

    @Override
    public Collection<Long> getLockedOfferings() {
        return null;
    }

    @Override
    public void releaseAllOfferingLocks() {
    }

    @Override
    public void persistExpectedSpaces(Long offeringId) {
    }

    @Override
    public List<Long> getOfferingsToPersistExpectedSpaces(long minimalAge) {
        return null;
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean needPersistExpectedSpaces(Long offeringId) {
        return false;
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    @Override
    public void releaseMasterLockIfHeld() {
    }

    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        ArrayList<XCourseRequest> ret = new ArrayList<XCourseRequest>();
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            for (Course course : offering.getCourses()) {
                for (CourseRequest req : course.getRequests()) {
                    if (req.getStudent().isDummy()) continue;
                    ret.add(new XCourseRequest(req, (Enrollment)this.currentSolution().getAssignment().getValue((Variable)req)));
                }
            }
        }
        return ret;
    }

    @Override
    public XEnrollments getEnrollments(Long offeringId) {
        return new XEnrollments(offeringId, this.getRequests(offeringId));
    }

    @Override
    public XExpectations getExpectations(Long offeringId) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            return new XExpectations(offering);
        }
        return null;
    }

    @Override
    public void update(XExpectations expectations) {
    }

    @Override
    public void remove(XStudent student) {
    }

    @Override
    public void update(XStudent student, boolean updateRequests) {
    }

    @Override
    public void remove(XOffering offering) {
    }

    @Override
    public void update(XOffering offering) {
    }

    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        return request;
    }

    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        return request;
    }

    @Override
    public boolean checkDeadline(Long courseId, XTime sectionTime, OnlineSectioningServer.Deadline type) {
        return true;
    }

    @Override
    public String getCourseDetails(Long courseId, CourseDetailsProvider provider) {
        XCourse course = this.getCourse(courseId);
        return course == null ? null : course.getDetails(this.getAcademicSession(), provider);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public long getMemUsage() {
        return new MemoryCounter().estimate(this);
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iOnlineProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        if (value == null) {
            this.iOnlineProperties.remove(name);
        } else {
            this.iOnlineProperties.put(name, value);
        }
    }

    @Override
    public CSVFile getReport(DataProperties parameters) {
        try {
            String name = parameters.getProperty("report", SectionConflictTable.class.getName());
            Class<?> clazz = Class.forName(name);
            StudentSectioningReport report = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(this.currentSolution().getModel());
            return report.create(this.currentSolution().getAssignment(), parameters);
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public OverExpectedCriterion getOverExpectedCriterion() {
        return new NeverOverExpected(this.getConfig());
    }

    @Override
    public SolverParameterGroup.SolverType getType() {
        return SolverParameterGroup.SolverType.STUDENT;
    }

    @Override
    public XCourseId getCourse(Long courseId, String courseName) {
        if (courseId != null) {
            return this.getCourse(courseId);
        }
        if (courseName != null) {
            return this.getCourse(courseName);
        }
        return null;
    }

    @Override
    public Collection<Long> getInstructedOfferings(String instructorExternalId) {
        ArrayList<Long> ret = new ArrayList<Long>();
        HashSet<Long> sections = new HashSet<Long>();
        for (Student student : ((StudentSectioningModel)this.currentSolution().getModel()).getStudents()) {
            if (!instructorExternalId.equals(student.getExternalId())) continue;
            for (Unavailability unavailability : student.getUnavailabilities()) {
                sections.add(unavailability.getId());
            }
        }
        block2: for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        if (sections.contains(section.getId())) {
                            ret.add(offering.getId());
                            continue block2;
                        }
                        if (!section.hasInstructors()) continue;
                        for (Instructor instructor : section.getInstructors()) {
                            if (!instructorExternalId.equals(instructor.getExternalId())) continue;
                            ret.add(offering.getId());
                            continue block2;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static class NoLock
    implements OnlineSectioningServer.Lock {
        public void release() {
        }
    }

    public class ReloadingDoneCallback
    implements Callback {
        Map<Long, Map<Long, Enrollment>> iCurrentAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iBestAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iInitialAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = StudentSolver.this.getProperties().getProperty("General.SolutionId");
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                Map<Long, Enrollment> assignments;
                Enrollment enrollment = (Enrollment)StudentSolver.this.currentSolution().getAssignment().getValue((Variable)request);
                if (enrollment != null) {
                    assignments = this.iCurrentAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iCurrentAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), enrollment);
                }
                if (request.getBestAssignment() != null) {
                    assignments = this.iBestAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iBestAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), (Enrollment)request.getBestAssignment());
                }
                if (request.getInitialAssignment() == null) continue;
                assignments = this.iInitialAssignmentTable.get(request.getStudent().getId());
                if (assignments == null) {
                    assignments = new Hashtable<Long, Enrollment>();
                    this.iInitialAssignmentTable.put(request.getStudent().getId(), assignments);
                }
                assignments.put(request.getId(), (Enrollment)request.getInitialAssignment());
            }
        }

        private Enrollment getEnrollment(Request request, Enrollment enrollment) {
            if (request instanceof FreeTimeRequest) {
                return ((FreeTimeRequest)request).createEnrollment();
            }
            CourseRequest cr = (CourseRequest)request;
            HashSet<Section> sections = new HashSet<Section>();
            for (Section s : enrollment.getSections()) {
                Section section = cr.getSection(s.getId());
                if (section == null) {
                    this.iProgress.warn("WARNING: Section " + s.getName() + " is not available for " + cr.getName());
                    return null;
                }
                sections.add(section);
            }
            return cr.createEnrollment(StudentSolver.this.currentSolution().getAssignment(), sections);
        }

        private void assign(Enrollment enrollment) {
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                this.iProgress.warn("Unable to assign " + ((Request)enrollment.variable()).getName() + " := " + enrollment.getName() + " (student not available)");
                return;
            }
            Map conflictConstraints = StudentSolver.this.currentSolution().getModel().conflictConstraints(StudentSolver.this.currentSolution().getAssignment(), (Value)enrollment);
            if (conflictConstraints.isEmpty()) {
                StudentSolver.this.currentSolution().getAssignment().assign(0L, (Value)enrollment);
            } else {
                this.iProgress.warn("Unable to assign " + ((Request)enrollment.variable()).getName() + " := " + enrollment.getName());
                this.iProgress.warn("&nbsp;&nbsp;Reason:");
                for (Constraint c : conflictConstraints.keySet()) {
                    Set vals = (Set)conflictConstraints.get(c);
                    for (Enrollment enrl : vals) {
                        this.iProgress.warn("&nbsp;&nbsp;&nbsp;&nbsp;" + enrl.getRequest().getName() + " = " + enrl.getName());
                    }
                    this.iProgress.debug("&nbsp;&nbsp;&nbsp;&nbsp;in constraint " + c);
                }
            }
        }

        private void unassignAll() {
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                StudentSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)request);
            }
        }

        public void execute() {
            Enrollment enrollment;
            Request request;
            Map r;
            this.iProgress = Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel());
            Hashtable<Long, Hashtable<Long, Request>> requests = new Hashtable<Long, Hashtable<Long, Request>>();
            for (Request request2 : StudentSolver.this.currentSolution().getModel().variables()) {
                r = (Hashtable<Long, Request>)requests.get(request2.getStudent().getId());
                if (r == null) {
                    r = new Hashtable<Long, Request>();
                    requests.put(request2.getStudent().getId(), (Hashtable<Long, Request>)r);
                }
                r.put(request2.getId(), request2);
            }
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating best assignment ...", (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment);
                    }
                }
                StudentSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating initial assignment ...", (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        request.setInitialAssignment((Value)enrollment);
                    }
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating current assignment ...", (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment);
                    }
                }
            }
            this.iCurrentAssignmentTable.clear();
            this.iBestAssignmentTable.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                StudentSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            StudentSolver.this.iLoadedDate = new Date();
            StudentSolver.this.iWorking = false;
            StudentSolver.this.afterLoad();
            Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }
}

