/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jgroups.Address;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.RoomAvailability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSolverServer
implements SolverServer {
    protected static Log sLog = LogFactory.getLog(AbstractSolverServer.class);
    protected int iUsageBase = 0;
    protected Date iStartTime = new Date();
    protected boolean iActive = false;

    @Override
    public void start() {
        this.iActive = true;
        sLog.info((Object)"Solver server is up and running.");
    }

    @Override
    public void stop() {
        sLog.info((Object)"Solver server is going down...");
        this.iActive = false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isCoordinator() {
        return true;
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public Address getLocalAddress() {
        return this.getAddress();
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public int getUsage() {
        int ret = this.iUsageBase;
        if (this.isLocal()) {
            ret += 500;
        }
        return ret;
    }

    @Override
    public void setUsageBase(int base) {
        this.iUsageBase = base;
    }

    @Override
    public long getAvailableMemory() {
        return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public long getMemoryLimit() {
        return 0x100000L * Long.parseLong(ApplicationProperties.getProperty(ApplicationProperty.SolverMemoryLimit));
    }

    @Override
    public String getVersion() {
        return Constants.getVersion();
    }

    @Override
    public Date getStartTime() {
        return this.iStartTime;
    }

    @Override
    public boolean isActive() {
        return this.iActive;
    }

    @Override
    public boolean isAvailable() {
        if (!this.isActive()) {
            return false;
        }
        if (this.getMemoryLimit() > this.getAvailableMemory()) {
            System.gc();
        }
        return this.getMemoryLimit() <= this.getAvailableMemory();
    }

    @Override
    public RoomAvailabilityInterface getRoomAvailability() {
        return RoomAvailability.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCourseSolution(Long ... solutionIds) {
        try {
            for (Long solutionId : solutionIds) {
                Solution.refreshSolution(solutionId);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshExamSolution(Long sessionId, Long examTypeId) {
        try {
            ExamType.refreshSolution(sessionId, examTypeId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshInstructorSolution(Collection<Long> solverGroupIds) {
        Session hibSession = new _RootDAO().createNewSession();
        try {
            SessionFactory hibSessionFactory = hibSession.getSessionFactory();
            List classIds = hibSession.createQuery("select distinct c.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false").setParameterList("solverGroupId", solverGroupIds).list();
            for (Object classId : classIds) {
                hibSessionFactory.getCache().evictEntity(Class_.class, (Serializable)classId);
                hibSessionFactory.getCache().evictCollection(Class_.class.getName() + ".classInstructors", (Serializable)classId);
            }
            List instructorIds = hibSession.createQuery("select i.uniqueId from DepartmentalInstructor i, SolverGroup g inner join g.departments d where g.uniqueId in :solverGroupId and i.department = d").setParameterList("solverGroupId", solverGroupIds).list();
            for (Object instructorId : instructorIds) {
                hibSessionFactory.getCache().evictEntity(DepartmentalInstructor.class, (Serializable)instructorId);
                hibSessionFactory.getCache().evictCollection(DepartmentalInstructor.class.getName() + ".classes", (Serializable)instructorId);
            }
            List requestIds = hibSession.createQuery("select distinct r.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false").setParameterList("solverGroupId", solverGroupIds).list();
            for (Long requestId : requestIds) {
                hibSessionFactory.getCache().evictEntity(TeachingRequest.class, (Serializable)requestId);
                hibSessionFactory.getCache().evictCollection(TeachingRequest.class.getName() + ".assignedInstructors", (Serializable)requestId);
            }
            List offeringIds = hibSession.createQuery("select distinct c.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false").setParameterList("solverGroupId", solverGroupIds).list();
            for (Long offeringId : offeringIds) {
                hibSessionFactory.getCache().evictEntity(InstructionalOffering.class, (Serializable)offeringId);
                hibSessionFactory.getCache().evictCollection(InstructionalOffering.class.getName() + ".offeringCoordinators", (Serializable)offeringId);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }

    @Override
    public void setApplicationProperty(Long sessionId, String key, String value) {
        Properties properties;
        sLog.info((Object)("Set " + key + " to " + value + (sessionId == null ? "" : " (for session " + sessionId + ")")));
        Properties properties2 = properties = sessionId == null ? ApplicationProperties.getConfigProperties() : ApplicationProperties.getSessionProperties(sessionId);
        if (properties == null) {
            return;
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    @Override
    public void setLoggingLevel(String name, Integer level) {
        Logger logger;
        sLog.info((Object)("Set logging level for " + (name == null ? "root" : name) + " to " + (level == null ? "null" : Level.toLevel((int)level))));
        Logger logger2 = logger = name == null ? Logger.getRootLogger() : Logger.getLogger((String)name);
        if (level == null) {
            logger.setLevel(null);
        } else {
            logger.setLevel(Level.toLevel((int)level));
        }
    }

    @Override
    public void reset() {
    }
}

