/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.instructor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.solver.instructor.InstructorSchedulingSolver;

public class InstructorSchedulingSuggestions {
    private InstructorSchedulingSolver iSolver;
    private InstructorSchedulingModel iModel;
    private Assignment<TeachingRequest.Variable, TeachingAssignment> iAssignment;
    private List<TeachingRequest.Variable> iInitialUnassignments = new ArrayList<TeachingRequest.Variable>();
    private Map<TeachingRequest.Variable, TeachingAssignment> iInitialAssignments = new HashMap<TeachingRequest.Variable, TeachingAssignment>();
    private double iValue;
    private Map<String, Double> iValues = new HashMap<String, Double>();
    private int iDepth = 2;
    private int iLimit = 20;
    private int iNrSolutions = 0;
    private int iNrCombinationsConsidered = 0;
    private int iNrDomainValues = 0;
    private long iTimeOut = 5000L;
    private long iStartTime = 0L;
    private boolean iTimeoutReached = false;
    private String iFilter = null;
    private TeachingRequest.Variable iRequest = null;
    private TreeSet<InstructorInterface.SuggestionInfo> iSuggestions = null;
    private List<TeachingRequest.Variable> iResolvedRequests = null;
    private Map<TeachingRequest.Variable, TeachingAssignment> iConflictsToResolve = null;
    private Map<TeachingRequest, InstructorInterface.TeachingRequestInfo> iRequestInfos = null;
    private Instructor iInstructor = null;

    public InstructorSchedulingSuggestions(InstructorSchedulingSolver solver) {
        this.iSolver = solver;
        this.iModel = (InstructorSchedulingModel)solver.currentSolution().getModel();
        this.iAssignment = solver.currentSolution().getAssignment();
        for (TeachingRequest.Variable variable : this.iModel.variables()) {
            TeachingAssignment value = (TeachingAssignment)this.iAssignment.getValue((Variable)variable);
            if (value == null) {
                this.iInitialUnassignments.add(variable);
                continue;
            }
            this.iInitialAssignments.put(variable, value);
        }
        this.iValue = this.iModel.getTotalValue(this.iAssignment);
        for (Criterion c : this.iModel.getCriteria()) {
            this.iValues.put(c.getName(), c.getValue(this.iAssignment));
        }
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public long getTimeOut() {
        return this.iTimeOut;
    }

    public void setTimeOut(long timeOut) {
        this.iTimeOut = timeOut;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public int getNrSolutions() {
        return this.iNrSolutions;
    }

    public int getNrCombinationsConsidered() {
        return this.iNrCombinationsConsidered;
    }

    public boolean wasTimeoutReached() {
        return this.iTimeoutReached;
    }

    public boolean match(String name) {
        if (this.iFilter == null || this.iFilter.trim().isEmpty()) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(this.iFilter.toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public synchronized InstructorInterface.SuggestionsResponse computeSuggestions(InstructorInterface.ComputeSuggestionsRequest request) {
        InstructorInterface.SuggestionsResponse response = new InstructorInterface.SuggestionsResponse();
        this.iSuggestions = new TreeSet();
        this.iResolvedRequests = new ArrayList<TeachingRequest.Variable>();
        this.iConflictsToResolve = new HashMap<TeachingRequest.Variable, TeachingAssignment>();
        this.iRequestInfos = new HashMap<TeachingRequest, InstructorInterface.TeachingRequestInfo>();
        this.iNrSolutions = -1;
        this.iNrCombinationsConsidered = 0;
        this.iNrDomainValues = 0;
        this.iTimeoutReached = false;
        this.iRequest = null;
        this.iDepth = request.getMaxDept();
        this.iTimeOut = request.getTimeout();
        this.iLimit = request.getMaxResults();
        if (request.getSelectedInstructorId() != null) {
            for (Instructor instructor : this.iModel.getInstructors()) {
                if (instructor.getInstructorId() != request.getSelectedInstructorId().longValue()) continue;
                this.iInstructor = instructor;
                break;
            }
        }
        TeachingAssignment requestedAssignment = null;
        ArrayList<TeachingAssignment> givenAssignments = new ArrayList<TeachingAssignment>();
        if (request.getSelectedRequestId() != null) {
            for (TeachingRequest teachingRequest : this.iModel.getRequests()) {
                if (teachingRequest.getRequestId() != request.getSelectedRequestId().longValue()) continue;
                this.iRequest = teachingRequest.getVariable(request.getSelectedIndex());
            }
        }
        for (InstructorInterface.AssignmentInfo assignmentInfo : request.getAssignments()) {
            block3: for (TeachingRequest teachingRequest : this.iModel.getRequests()) {
                if (teachingRequest.getRequestId() != assignmentInfo.getRequest().getRequestId().longValue()) continue;
                TeachingRequest.Variable var = teachingRequest.getVariable(assignmentInfo.getIndex());
                TeachingRequest.Variable[] original = (TeachingRequest.Variable[])this.iAssignment.getValue((Variable)var);
                if (assignmentInfo.getInstructor() == null) continue;
                for (TeachingAssignment val : var.values(this.iAssignment)) {
                    if (val.getInstructor().getInstructorId() != assignmentInfo.getInstructor().getInstructorId().longValue()) continue;
                    if (var.equals((Object)this.iRequest)) {
                        requestedAssignment = val;
                        continue block3;
                    }
                    if (original != null && original.equals((Object)val)) continue block3;
                    givenAssignments.add(val);
                    continue block3;
                }
            }
        }
        if (this.iRequest != null) {
            this.iAssignment.unassign(0L, (Variable)this.iRequest);
        }
        for (TeachingAssignment teachingAssignment : givenAssignments) {
            this.iAssignment.unassign(0L, teachingAssignment.variable());
        }
        for (TeachingAssignment teachingAssignment : givenAssignments) {
            for (TeachingAssignment teachingAssignment2 : this.iModel.conflictValues(this.iAssignment, (Value)teachingAssignment)) {
                this.iConflictsToResolve.put((TeachingRequest.Variable)teachingAssignment2.variable(), teachingAssignment2);
                this.iAssignment.unassign(0L, teachingAssignment2.variable());
            }
            this.iResolvedRequests.add((TeachingRequest.Variable)teachingAssignment.variable());
            this.iAssignment.assign(0L, (Value)teachingAssignment);
        }
        if (request.isComputeDomain()) {
            int domainSize = 0;
            TreeSet<InstructorInterface.SuggestionInfo> treeSet = new TreeSet<InstructorInterface.SuggestionInfo>();
            if (this.iInstructor != null) {
                for (TeachingRequest teachingRequest : this.iModel.getRequests()) {
                    PreferenceCombination attributePref;
                    if (!this.iInstructor.canTeach(teachingRequest) || (attributePref = teachingRequest.getAttributePreference(this.iInstructor)).isProhibited()) continue;
                    for (TeachingRequest.Variable var : teachingRequest.getVariables()) {
                        if (this.iResolvedRequests.contains(var)) continue;
                        ++domainSize;
                        InstructorInterface.SuggestionInfo suggestion = this.tryAssignment(new TeachingAssignment(var, this.iInstructor, attributePref.getPreferenceInt()));
                        if (suggestion == null || suggestion.getAssignments().isEmpty()) continue;
                        if (request.getMaxDomain() > 0 && treeSet.size() == request.getMaxDomain()) {
                            if (suggestion.compareTo((InstructorInterface.SuggestionInfo)treeSet.last()) >= 0) continue;
                            treeSet.add(suggestion);
                            treeSet.remove(treeSet.last());
                            continue;
                        }
                        treeSet.add(suggestion);
                    }
                }
            } else if (this.iInstructor == null) {
                for (TeachingAssignment teachingAssignment : this.iRequest.values(this.iAssignment)) {
                    InstructorInterface.SuggestionInfo suggestion = this.tryAssignment(teachingAssignment);
                    if (suggestion == null || suggestion.getAssignments().isEmpty()) continue;
                    ++domainSize;
                    if (request.getMaxDomain() > 0 && treeSet.size() == request.getMaxDomain()) {
                        if (suggestion.compareTo((InstructorInterface.SuggestionInfo)treeSet.last()) >= 0) continue;
                        treeSet.add(suggestion);
                        treeSet.remove(treeSet.last());
                        continue;
                    }
                    treeSet.add(suggestion);
                }
            }
            response.setDomainSize(domainSize);
            for (InstructorInterface.SuggestionInfo suggestionInfo : treeSet) {
                response.addDomainValue(suggestionInfo);
            }
        }
        if (request.isComputeSuggestions()) {
            if (requestedAssignment != null) {
                for (TeachingAssignment teachingAssignment : this.iModel.conflictValues(this.iAssignment, requestedAssignment)) {
                    this.iConflictsToResolve.put((TeachingRequest.Variable)teachingAssignment.variable(), teachingAssignment);
                    this.iAssignment.unassign(0L, teachingAssignment.variable());
                }
                if (!this.iConflictsToResolve.isEmpty()) {
                    this.iResolvedRequests.add((TeachingRequest.Variable)requestedAssignment.variable());
                }
                this.iAssignment.assign(0L, requestedAssignment);
            }
            if (this.iRequest == null && !this.iResolvedRequests.isEmpty() && this.iConflictsToResolve.isEmpty()) {
                for (TeachingAssignment teachingAssignment : givenAssignments) {
                    if (!teachingAssignment.getInstructor().equals((Object)this.iInstructor)) continue;
                    this.iRequest = (TeachingRequest.Variable)teachingAssignment.variable();
                    this.iResolvedRequests.remove(this.iRequest);
                    break;
                }
                if (this.iRequest == null && !this.iResolvedRequests.isEmpty()) {
                    this.iRequest = this.iResolvedRequests.get(0);
                    this.iResolvedRequests.remove(this.iRequest);
                }
            }
            response.setCurrentAssignment(this.createSuggestion(this.iModel.getTotalValue(this.iAssignment) - this.iValue));
            this.iStartTime = System.currentTimeMillis();
            if (this.iInstructor != null && this.iResolvedRequests.isEmpty()) {
                this.instructorBacktrack();
            } else {
                this.backtrack(this.iDepth);
            }
            for (InstructorInterface.SuggestionInfo suggestionInfo : this.iSuggestions) {
                response.addSuggestion(suggestionInfo);
            }
            response.setTimeoutReached(this.wasTimeoutReached());
            response.setNrCombinationsConsidered(this.getNrCombinationsConsidered());
            response.setNrSolutions(this.getNrSolutions());
        }
        for (TeachingRequest.Variable variable : this.iInitialUnassignments) {
            if (this.iAssignment.getValue((Variable)variable) == null) continue;
            this.iAssignment.unassign(0L, (Variable)variable);
        }
        ArrayList<TeachingAssignment> changes = new ArrayList<TeachingAssignment>();
        for (Map.Entry<TeachingRequest.Variable, TeachingAssignment> entry : this.iInitialAssignments.entrySet()) {
            TeachingRequest.Variable variable = entry.getKey();
            TeachingAssignment current = (TeachingAssignment)this.iAssignment.getValue((Variable)variable);
            TeachingAssignment initial = entry.getValue();
            if (initial.equals((Object)current)) continue;
            if (current != null) {
                this.iAssignment.unassign(0L, (Variable)variable);
            }
            changes.add(initial);
        }
        for (TeachingAssignment teachingAssignment : changes) {
            this.iAssignment.assign(0L, (Value)teachingAssignment);
        }
        for (Map.Entry<TeachingRequest, InstructorInterface.TeachingRequestInfo> entry : this.iRequestInfos.entrySet()) {
            InstructorInterface.TeachingRequestInfo teachingRequestInfo = entry.getValue();
            for (TeachingRequest.Variable var : entry.getKey().getVariables()) {
                TeachingAssignment initial = this.iInitialAssignments.get(var);
                if (initial == null) continue;
                teachingRequestInfo.addInstructor(this.toInstructorInfo(initial));
            }
        }
        return response;
    }

    protected InstructorInterface.InstructorInfo toInstructorInfo(TeachingAssignment assignment) {
        return this.iSolver.toInstructorInfo(assignment);
    }

    protected InstructorInterface.TeachingRequestInfo toRequestInfo(TeachingRequest request) {
        InstructorInterface.TeachingRequestInfo info = this.iRequestInfos.get(request);
        if (info == null) {
            info = this.iSolver.toRequestInfo(request);
            this.iRequestInfos.put(request, info);
        }
        return info;
    }

    protected InstructorInterface.AssignmentInfo toAssignmentInfo(TeachingRequest.Variable request) {
        InstructorInterface.AssignmentInfo info = new InstructorInterface.AssignmentInfo();
        info.setRequest(this.toRequestInfo(request.getRequest()));
        info.setIndex(request.getInstructorIndex());
        TeachingAssignment current = (TeachingAssignment)this.iAssignment.getValue((Variable)request);
        if (current != null) {
            info.setInstructor(this.toInstructorInfo(current));
        } else {
            TeachingAssignment initial = this.iInitialAssignments.get(request);
            if (initial != null) {
                for (Constraint c : this.iModel.constraints()) {
                    if (!c.inConflict(this.iAssignment, (Value)initial)) continue;
                    info.addConflict(c.getName());
                }
                for (Constraint c : this.iModel.globalConstraints()) {
                    if (!c.inConflict(this.iAssignment, (Value)initial)) continue;
                    info.addConflict(c.getName());
                }
            }
        }
        return info;
    }

    protected InstructorInterface.SuggestionInfo tryAssignment(TeachingAssignment assignment) {
        TeachingAssignment original = (TeachingAssignment)this.iAssignment.getValue(assignment.variable());
        Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)assignment);
        if (conflicts.contains(assignment)) {
            return null;
        }
        for (TeachingAssignment conflict : conflicts) {
            this.iAssignment.unassign(0L, conflict.variable());
        }
        this.iAssignment.assign(0L, (Value)assignment);
        InstructorInterface.SuggestionInfo suggestion = new InstructorInterface.SuggestionInfo();
        suggestion.setValue(this.iModel.getTotalValue(this.iAssignment) - this.iValue);
        suggestion.setId(new Long(this.iNrDomainValues++));
        for (Criterion c : this.iModel.getCriteria()) {
            double v = c.getValue(this.iAssignment);
            Double base = this.iValues.get(c.getName());
            suggestion.addValue(c.getName(), base == null ? v : v - base);
        }
        suggestion.addAssignment(this.toAssignmentInfo((TeachingRequest.Variable)assignment.variable()));
        for (TeachingRequest.Variable var : this.iResolvedRequests) {
            if (var.equals((Object)this.iRequest) || var.equals((Object)assignment.variable())) continue;
            suggestion.addAssignment(this.toAssignmentInfo(var));
        }
        for (TeachingAssignment conflict : conflicts) {
            if (((TeachingRequest.Variable)conflict.variable()).equals((Object)this.iRequest) || this.iConflictsToResolve.containsKey(conflict.variable()) || this.iResolvedRequests.contains(conflict.variable())) continue;
            suggestion.addAssignment(this.toAssignmentInfo((TeachingRequest.Variable)conflict.variable()));
        }
        this.iAssignment.unassign(0L, assignment.variable());
        for (TeachingAssignment conflict : conflicts) {
            this.iAssignment.assign(0L, (Value)conflict);
        }
        if (original != null) {
            this.iAssignment.assign(0L, (Value)original);
        }
        return suggestion;
    }

    protected InstructorInterface.SuggestionInfo createSuggestion(double value) {
        InstructorInterface.SuggestionInfo suggestion = new InstructorInterface.SuggestionInfo();
        suggestion.setValue(value);
        suggestion.setId(new Long(this.iNrSolutions++));
        for (Criterion c : this.iModel.getCriteria()) {
            double v = c.getValue(this.iAssignment);
            Double base = this.iValues.get(c.getName());
            suggestion.addValue(c.getName(), base == null ? v : v - base);
        }
        if (this.iRequest != null) {
            suggestion.addAssignment(this.toAssignmentInfo(this.iRequest));
        }
        for (TeachingRequest.Variable var : this.iResolvedRequests) {
            if (var.equals((Object)this.iRequest)) continue;
            suggestion.addAssignment(this.toAssignmentInfo(var));
        }
        for (TeachingRequest.Variable var : this.iConflictsToResolve.keySet()) {
            if (var.equals((Object)this.iRequest)) continue;
            suggestion.addAssignment(this.toAssignmentInfo(var));
        }
        for (TeachingRequest.Variable var : this.iModel.assignedVariables(this.iAssignment)) {
            if (this.iResolvedRequests.contains(var) || var.equals((Object)this.iRequest) || ((TeachingAssignment)this.iAssignment.getValue((Variable)var)).equals((Object)this.iInitialAssignments.get(var)) || this.iConflictsToResolve.containsKey(var)) continue;
            suggestion.addAssignment(this.toAssignmentInfo(var));
        }
        return suggestion;
    }

    private void instructorBacktrack() {
        for (TeachingRequest tr : this.iModel.getRequests()) {
            PreferenceCombination attributePref;
            if (!this.iInstructor.canTeach(tr) || (attributePref = tr.getAttributePreference(this.iInstructor)).isProhibited()) continue;
            block1: for (TeachingRequest.Variable var : tr.getVariables()) {
                Object c2;
                TeachingAssignment assignment;
                if (this.iResolvedRequests.contains(var) || (assignment = new TeachingAssignment(var, this.iInstructor, attributePref.getPreferenceInt())).equals((Object)this.iAssignment.getValue((Variable)var)) || var.equals((Object)this.iRequest) && !this.match(assignment.getInstructor().getExternalId() + " " + assignment.getInstructor().getName())) continue;
                Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)assignment);
                ++this.iNrCombinationsConsidered;
                if (this.iConflictsToResolve.size() + conflicts.size() > this.iDepth) continue;
                for (Object c2 : conflicts) {
                    if (!this.iResolvedRequests.contains(c2.variable()) || !var.equals((Object)c2.variable())) continue;
                    continue block1;
                }
                TeachingAssignment cur = (TeachingAssignment)this.iAssignment.getValue((Variable)var);
                c2 = conflicts.iterator();
                while (c2.hasNext()) {
                    TeachingAssignment c3 = (TeachingAssignment)c2.next();
                    this.iAssignment.unassign(0L, c3.variable());
                    this.iConflictsToResolve.put((TeachingRequest.Variable)c3.variable(), c3);
                }
                this.iAssignment.assign(0L, (Value)assignment);
                TeachingAssignment resolvedConf = this.iConflictsToResolve.remove(var);
                this.iResolvedRequests.add(var);
                this.backtrack(this.iDepth - 1);
                this.iResolvedRequests.remove(var);
                if (cur == null) {
                    this.iAssignment.unassign(0L, (Variable)var);
                } else {
                    this.iAssignment.assign(0L, (Value)cur);
                }
                for (TeachingAssignment c4 : conflicts) {
                    this.iAssignment.assign(0L, (Value)c4);
                    this.iConflictsToResolve.remove(c4.variable());
                }
                if (resolvedConf == null) continue;
                this.iConflictsToResolve.put(var, resolvedConf);
            }
        }
    }

    private void backtrack(int depth) {
        TeachingRequest.Variable var;
        if (this.iDepth > depth && this.iConflictsToResolve.isEmpty()) {
            double value = this.iModel.getTotalValue(this.iAssignment) - this.iValue;
            if (this.iSuggestions.size() == this.iLimit && (this.iSuggestions.last().getValue() < value || this.iSuggestions.last().getValue() == value && this.iSuggestions.last().getAssignments().size() <= this.iResolvedRequests.size())) {
                return;
            }
            this.iSuggestions.add(this.createSuggestion(value));
            if (this.iSuggestions.size() > this.iLimit) {
                this.iSuggestions.remove(this.iSuggestions.last());
            }
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (this.iTimeOut > 0L && System.currentTimeMillis() - this.iStartTime > this.iTimeOut) {
            this.iTimeoutReached = true;
            return;
        }
        TeachingRequest.Variable variable = var = this.iDepth == depth && this.iRequest != null && !this.iResolvedRequests.contains(this.iRequest) ? this.iRequest : this.iConflictsToResolve.keySet().iterator().next();
        if (this.iResolvedRequests.contains(var)) {
            return;
        }
        this.iResolvedRequests.add(var);
        block0: for (TeachingAssignment assignment : var.values(this.iAssignment)) {
            Object c2;
            if (assignment.equals((Object)this.iInitialAssignments.get(var)) || var.equals((Object)this.iRequest) && !this.match(assignment.getInstructor().getExternalId() + " " + assignment.getInstructor().getName())) continue;
            Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)assignment);
            ++this.iNrCombinationsConsidered;
            if (this.iConflictsToResolve.size() + conflicts.size() > depth) continue;
            for (Object c2 : conflicts) {
                if (!this.iResolvedRequests.contains(c2.variable())) continue;
                continue block0;
            }
            TeachingAssignment cur = (TeachingAssignment)this.iAssignment.getValue((Variable)var);
            c2 = conflicts.iterator();
            while (c2.hasNext()) {
                TeachingAssignment c3 = (TeachingAssignment)c2.next();
                this.iAssignment.unassign(0L, c3.variable());
                this.iConflictsToResolve.put((TeachingRequest.Variable)c3.variable(), c3);
            }
            this.iAssignment.assign(0L, (Value)assignment);
            TeachingAssignment resolvedConf = this.iConflictsToResolve.remove(var);
            this.backtrack(depth - 1);
            if (cur == null) {
                this.iAssignment.unassign(0L, (Variable)var);
            } else {
                this.iAssignment.assign(0L, (Value)cur);
            }
            for (TeachingAssignment c4 : conflicts) {
                this.iAssignment.assign(0L, (Value)c4);
                this.iConflictsToResolve.remove(c4.variable());
            }
            if (resolvedConf == null) continue;
            this.iConflictsToResolve.put(var, resolvedConf);
        }
        this.iResolvedRequests.remove(var);
    }
}

