/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.solver.course.ui.ClassAssignment;
import org.unitime.timetable.solver.course.ui.ClassDateInfo;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAssignmentInfo
extends ClassAssignment
implements Serializable {
    private static final long serialVersionUID = -4277344877497509285L;
    private TreeSet<StudentConflict> iStudentConflicts = new TreeSet();

    public ClassAssignmentInfo(Assignment assignment) {
        super(assignment);
        this.findStudentConflicts(null);
    }

    public ClassAssignmentInfo(Class_ clazz, ClassTimeInfo time, ClassDateInfo date, Collection<ClassRoomInfo> rooms) {
        super(clazz, time, date, rooms);
        this.findStudentConflicts(null);
    }

    public ClassAssignmentInfo(Class_ clazz, ClassTimeInfo time, ClassDateInfo date, Collection<ClassRoomInfo> rooms, Hashtable<Long, ClassAssignment> assignmentTable) {
        super(clazz, time, date, rooms);
        this.findStudentConflicts(assignmentTable);
    }

    private void findStudentConflicts(Hashtable<Long, ClassAssignment> assignmentTable) {
        if (!this.hasTime()) {
            return;
        }
        Hashtable<Long, Set<Long>> conflicts = Student.findConflictingStudents(this.getClassId(), this.getTime().getStartSlot(), this.getTime().getLength(), this.getTime().getDates());
        for (Map.Entry<Long, Set<Long>> entry : conflicts.entrySet()) {
            Class_ clazz;
            if (this.getClassId().equals(entry.getKey()) || assignmentTable != null && assignmentTable.containsKey(entry.getKey()) || (clazz = (Class_)Class_DAO.getInstance().get((Serializable)entry.getKey())).getCommittedAssignment() == null) continue;
            this.iStudentConflicts.add(new StudentConflict(new ClassAssignment(clazz.getCommittedAssignment()), entry.getValue()));
        }
        if (assignmentTable != null) {
            for (Map.Entry<Long, Object> entry : assignmentTable.entrySet()) {
                Set<Long> conf;
                if (this.getClassId().equals(entry.getKey()) || !((ClassAssignment)entry.getValue()).hasTime() || !this.getTime().overlaps(((ClassAssignment)entry.getValue()).getTime()) || (conf = ClassAssignmentInfo.merge(this.getStudents(), ((ClassAssignment)entry.getValue()).getStudents())).isEmpty()) continue;
                this.iStudentConflicts.add(new StudentConflict((ClassAssignment)entry.getValue(), conf));
            }
        }
    }

    public Set<StudentConflict> getStudentConflicts() {
        return this.iStudentConflicts;
    }

    public int getNrStudentCounflicts() {
        HashSet<Long> all = new HashSet<Long>();
        for (StudentConflict c : this.iStudentConflicts) {
            all.addAll(c.getConflictingStudents());
        }
        return all.size();
    }

    public String getConflictTable() {
        return this.getConflictTable(true);
    }

    public String getConflictTable(boolean header) {
        String ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        if (header) {
            ret = ret + "<tr>";
            ret = ret + "<td><i>Students</i></td>";
            ret = ret + "<td><i>Class</i></td>";
            ret = ret + "<td><i>Date</i></td>";
            ret = ret + "<td><i>Time</i></td>";
            ret = ret + "<td><i>Room</i></td>";
            ret = ret + "</tr>";
        }
        for (StudentConflict conf : this.getStudentConflicts()) {
            ret = ret + conf.toHtml();
        }
        ret = ret + "</table>";
        return ret;
    }

    public static Set<Long> merge(Set<Long> a, Set<Long> b) {
        HashSet<Long> ret = new HashSet<Long>();
        for (Long x : a) {
            if (!b.contains(x)) continue;
            ret.add(x);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StudentConflict
    implements Serializable,
    Comparable<StudentConflict> {
        private static final long serialVersionUID = -4480647127446582658L;
        private ClassAssignment iOtherClass = null;
        private Set<Long> iConflictingStudents = null;

        public StudentConflict(ClassAssignment other, Set<Long> students) {
            this.iOtherClass = other;
            this.iConflictingStudents = students;
        }

        public ClassAssignment getOtherClass() {
            return this.iOtherClass;
        }

        public Set<Long> getConflictingStudents() {
            return this.iConflictingStudents;
        }

        public int hashCode() {
            return ClassAssignmentInfo.this.getClassId().hashCode() ^ this.getOtherClass().getClassId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StudentConflict)) {
                return false;
            }
            return this.getOtherClass().equals(((StudentConflict)o).getOtherClass());
        }

        @Override
        public int compareTo(StudentConflict c) {
            int cmp = c.getConflictingStudents().size() - this.getConflictingStudents().size();
            if (cmp != 0) {
                return cmp;
            }
            return this.getOtherClass().compareTo(c.getOtherClass());
        }

        public String toHtml() {
            String ret = "";
            ret = ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='transparent';\" onclick=\"document.location='classInfo.do?classId=" + this.getOtherClass().getClassId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">";
            ret = ret + "<td style='font-weight:bold;color:" + PreferenceLevel.prolog2color("P") + ";'>";
            ret = ret + String.valueOf(this.getConflictingStudents().size());
            ret = ret + "<td>" + this.getOtherClass().getClassNameHtml() + "</td>";
            ret = ret + "<td>" + this.getOtherClass().getDate().toHtml() + "</td>";
            ret = ret + "<td>" + this.getOtherClass().getTime().getLongNameHtml() + "</td>";
            ret = ret + "<td>" + this.getOtherClass().getRoomNamesHtml(", ") + "</td>";
            ret = ret + "</tr>";
            return ret;
        }

        public String toHtml2() {
            String ret = "";
            ret = ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='transparent';\" onclick=\"document.location='classInfo.do?classId=" + this.getOtherClass().getClassId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">";
            ret = ret + "<td nowrap style='font-weight:bold;color:" + PreferenceLevel.prolog2color("P") + ";'>";
            ret = ret + String.valueOf(this.getConflictingStudents().size()) + "<br>";
            ret = ret + "<td nowrap>" + ClassAssignmentInfo.this.getClassNameHtml() + "<br>" + this.getOtherClass().getClassNameHtml() + "</td>";
            ret = ret + "<td nowrap>" + ClassAssignmentInfo.this.getDate().toHtml() + "<br>" + this.getOtherClass().getDate().toHtml() + "</td>";
            ret = ret + "<td nowrap>" + ClassAssignmentInfo.this.getTime().getLongNameHtml() + "<br>" + this.getOtherClass().getTime().getLongNameHtml() + "</td>";
            ret = ret + "<td nowrap>" + ClassAssignmentInfo.this.getRoomNamesHtml(", ") + "<br>" + this.getOtherClass().getRoomNamesHtml(", ") + "</td>";
            ret = ret + "</tr>";
            return ret;
        }
    }
}

