/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.server.instructor.TeachingRequestsFilterBackend;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.TeachingRequestsPageRequest.class)
public class TeachingRequestsPageBackend
extends InstructorSchedulingBackendHelper
implements GwtRpcImplementation<InstructorInterface.TeachingRequestsPageRequest, GwtRpcResponseList<InstructorInterface.TeachingRequestInfo>> {
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public GwtRpcResponseList<InstructorInterface.TeachingRequestInfo> execute(InstructorInterface.TeachingRequestsPageRequest request, SessionContext context) {
        InstructorSchedulingProxy solver;
        if (this.instructorSchedulingSolverService == null) {
            this.instructorSchedulingSolverService = (SolverService)SpringApplicationContextHolder.getBean("instructorSchedulingSolverService");
        }
        context.checkPermission(Right.InstructorScheduling);
        if (!request.getFilter().hasOption("offeringId")) {
            SubjectArea subject;
            String subjectId = null;
            if (request.getFilter().hasOption("subjectId")) {
                subjectId = request.getFilter().getOption("subjectId");
            } else if (request.getFilter().hasOption("subject") && (subject = SubjectArea.findByAbbv(context.getUser().getCurrentAcademicSessionId(), request.getFilter().getOption("subject"))) != null) {
                subjectId = subject.getUniqueId().toString();
                request.getFilter().setOption("subjectId", subjectId);
            }
            context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(subjectId == null ? "-1" : subjectId));
        }
        if (!request.getFilter().hasSessionId()) {
            request.getFilter().setSessionId(context.getUser().getCurrentAcademicSessionId());
        }
        if ((solver = this.instructorSchedulingSolverService.getSolver()) != null && !request.getFilter().hasOption("offeringId")) {
            return new GwtRpcResponseList<InstructorInterface.TeachingRequestInfo>((Collection<InstructorInterface.TeachingRequestInfo>)solver.getTeachingRequests(request.getFilter()));
        }
        InstructorSchedulingBackendHelper.Context cx = new InstructorSchedulingBackendHelper.Context(context, solver);
        Query q = TeachingRequestsFilterBackend.toQuery(request.getFilter());
        GwtRpcResponseList<InstructorInterface.TeachingRequestInfo> ret = new GwtRpcResponseList<InstructorInterface.TeachingRequestInfo>();
        List requests = TeachingRequestsFilterBackend.getRequestQuery(request.getFilter(), context.getUser()).select("r").query(DepartmentalInstructorDAO.getInstance().getSession()).list();
        for (TeachingRequest tr : requests) {
            InstructorInterface.TeachingRequestInfo info;
            if (tr.isCancelled() || (info = this.getRequest(tr, cx, true)) == null || !q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, (EventInterface.FilterRpcRequest)request.getFilter()))) continue;
            if (info.hasInstructors()) {
                for (InstructorInterface.InstructorInfo ii : info.getInstructors()) {
                    ii.setMatchingFilter(q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, ii, request.getFilter())));
                }
            }
            ret.add(info);
        }
        Collections.sort(ret);
        return ret;
    }
}

