/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StandardEventNote;
import org.unitime.timetable.model.StandardEventNoteDepartment;
import org.unitime.timetable.model.StandardEventNoteGlobal;
import org.unitime.timetable.model.StandardEventNoteSession;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StandardEventNoteDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=stdEvtNote]")
public class StandardEventNotes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStandardEventNote(), MESSAGES.pageStandardEventNotes());
    }

    @PreAuthorize(value="checkPermission('StandardEventNotes')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        ArrayList<SimpleEditInterface.ListItem> appliesTo = new ArrayList<SimpleEditInterface.ListItem>();
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 150, 20, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldNote(), SimpleEditInterface.FieldType.textarea, 50, 3, 1000, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAppliesTo(), SimpleEditInterface.FieldType.list, 300, appliesTo, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(2, 0, 1);
        boolean editGlobal = context.hasPermission(Right.StandardEventNotesGlobalEdit);
        if (editGlobal) {
            appliesTo.add(new SimpleEditInterface.ListItem("_global", MESSAGES.levelGlobal()));
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteGlobal order by reference").setCacheable(true).list()) {
            SimpleEditInterface.Record r = data.addRecord(note.getUniqueId());
            r.setField(0, note.getReference(), editGlobal);
            r.setField(1, note.getNote(), editGlobal);
            r.setField(2, editGlobal ? "_global" : MESSAGES.levelGlobal(), false);
            r.setDeletable(editGlobal);
        }
        data.setSessionId(sessionId);
        data.setSessionName(((Session)SessionDAO.getInstance().get(sessionId)).getLabel());
        boolean editSession = context.hasPermission(sessionId, "Session", Right.StandardEventNotesSessionEdit);
        if (editSession) {
            appliesTo.add(new SimpleEditInterface.ListItem("_session", data.getSessionName()));
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId order by reference").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            SimpleEditInterface.Record r = data.addRecord(note.getUniqueId());
            r.setField(0, note.getReference(), editSession);
            r.setField(1, note.getNote(), editSession);
            r.setField(2, editSession ? "_session" : data.getSessionName(), false);
            r.setDeletable(editSession);
        }
        data.setEditable(editGlobal || editSession);
        for (Department department : Department.getUserDepartments(context.getUser())) {
            if (!department.isAllowEvents().booleanValue()) continue;
            boolean editDept = context.hasPermission(department, Right.StandardEventNotesDepartmentEdit);
            if (editDept) {
                appliesTo.add(new SimpleEditInterface.ListItem(department.getDeptCode(), department.getDeptCode() + " - " + department.getName()));
                data.setEditable(true);
            }
            for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.uniqueId = :deptId order by reference").setLong("deptId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                SimpleEditInterface.Record r = data.addRecord(note.getUniqueId());
                r.setField(0, note.getReference(), editDept);
                r.setField(1, note.getNote(), editDept);
                r.setField(2, editDept ? department.getDeptCode() : department.getDeptCode() + " - " + department.getName(), false);
                r.setDeletable(editDept);
            }
        }
        return data;
    }

    @PreAuthorize(value="checkPermission('StandardEventNotes')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface.Record r;
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        if (context.hasPermission(Right.StandardEventNotesGlobalEdit)) {
            for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteGlobal").setCacheable(true).list()) {
                r = data.getRecord(note.getUniqueId());
                if (r == null) {
                    this.delete(note, context, hibSession);
                    continue;
                }
                this.update(note, r, context, hibSession);
            }
        }
        if (context.hasPermission(sessionId, "Session", Right.StandardEventNotesSessionEdit)) {
            for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                r = data.getRecord(note.getUniqueId());
                if (r == null) {
                    this.delete(note, context, hibSession);
                    continue;
                }
                this.update(note, r, context, hibSession);
            }
        }
        for (Department department : Department.getUserDepartments(context.getUser())) {
            if (!department.isAllowEvents().booleanValue() || !context.hasPermission(department, Right.StandardEventNotesDepartmentEdit)) continue;
            for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.uniqueId = :deptId").setLong("deptId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                SimpleEditInterface.Record r2 = data.getRecord(note.getUniqueId());
                if (r2 == null) {
                    this.delete(note, context, hibSession);
                    continue;
                }
                this.update(note, r2, context, hibSession);
            }
        }
        for (SimpleEditInterface.Record r3 : data.getNewRecords()) {
            this.save(r3, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('StandardEventNotes')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        StandardEventNote note = null;
        if ("_global".equals(record.getField(2))) {
            note = new StandardEventNoteGlobal();
            context.checkPermission(Right.StandardEventNotesGlobalEdit);
        } else if ("_session".equals(record.getField(2))) {
            note = new StandardEventNoteSession();
            ((StandardEventNoteSession)note).setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            context.checkPermission(((StandardEventNoteSession)note).getSession(), Right.StandardEventNotesSessionEdit);
        } else {
            note = new StandardEventNoteDepartment();
            ((StandardEventNoteDepartment)note).setDepartment(Department.findByDeptCode(record.getField(2), context.getUser().getCurrentAcademicSessionId()));
            context.checkPermission(((StandardEventNoteDepartment)note).getDepartment(), Right.StandardEventNotesDepartmentEdit);
        }
        note.setReference(record.getField(0));
        note.setNote(record.getField(1));
        record.setUniqueId((Long)hibSession.save((Object)note));
        ChangeLog.addChange(hibSession, context, note, note.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StandardEventNote note, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (note == null) {
            return;
        }
        if (ToolBox.equals((Object)note.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)note.getNote(), (Object)record.getField(1))) {
            return;
        }
        note.setReference(record.getField(0));
        note.setNote(record.getField(1));
        hibSession.saveOrUpdate((Object)note);
        ChangeLog.addChange(hibSession, context, note, note.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, note instanceof StandardEventNoteDepartment ? ((StandardEventNoteDepartment)note).getDepartment() : null);
    }

    @PreAuthorize(value="checkPermission('StandardEventNotes')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        StandardEventNote note = (StandardEventNote)StandardEventNoteDAO.getInstance().get(record.getUniqueId());
        if (note == null) {
            return;
        }
        if (note instanceof StandardEventNoteGlobal) {
            context.checkPermission(Right.StandardEventNotesGlobalEdit);
            this.update(note, record, context, hibSession);
        } else if (note instanceof StandardEventNoteSession) {
            context.checkPermission(((StandardEventNoteSession)note).getSession(), Right.StandardEventNotesSessionEdit);
            this.update(note, record, context, hibSession);
        } else if (note instanceof StandardEventNoteDepartment) {
            context.checkPermission(((StandardEventNoteDepartment)note).getDepartment(), Right.StandardEventNotesDepartmentEdit);
            this.update(note, record, context, hibSession);
        }
    }

    protected void delete(StandardEventNote note, SessionContext context, org.hibernate.Session hibSession) {
        if (note == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, note, note.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, note instanceof StandardEventNoteDepartment ? ((StandardEventNoteDepartment)note).getDepartment() : null);
        hibSession.delete((Object)note);
    }

    @PreAuthorize(value="checkPermission('StandardEventNotes')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        StandardEventNote note = (StandardEventNote)StandardEventNoteDAO.getInstance().get(record.getUniqueId());
        if (note == null) {
            return;
        }
        if (note instanceof StandardEventNoteGlobal) {
            context.checkPermission(Right.StandardEventNotesGlobalEdit);
            this.delete(note, context, hibSession);
        } else if (note instanceof StandardEventNoteSession) {
            context.checkPermission(((StandardEventNoteSession)note).getSession(), Right.StandardEventNotesSessionEdit);
            this.delete(note, context, hibSession);
        } else if (note instanceof StandardEventNoteDepartment) {
            context.checkPermission(((StandardEventNoteDepartment)note).getDepartment(), Right.StandardEventNotesDepartmentEdit);
            this.delete(note, context, hibSession);
        }
    }
}

