/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedReservations
implements StudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private StudentSectioningModel iModel = null;

    public UnusedReservations(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    protected String type(Reservation reservation) {
        if (reservation instanceof GroupReservation) {
            return "group";
        }
        if (reservation instanceof ReservationOverride) {
            return "override";
        }
        if (reservation instanceof IndividualReservation) {
            return "individual";
        }
        if (reservation instanceof CurriculumReservation) {
            return "curriculum";
        }
        if (reservation instanceof CourseReservation) {
            return "course";
        }
        if (reservation instanceof DummyReservation) {
            return "dummy";
        }
        return "other";
    }

    protected String name(Reservation reservation) {
        if (reservation instanceof GroupReservation) {
            return "group";
        }
        if (reservation instanceof ReservationOverride) {
            return "override";
        }
        if (reservation instanceof IndividualReservation) {
            return "individual";
        }
        if (reservation instanceof CurriculumReservation) {
            return "curriculum";
        }
        if (reservation instanceof CourseReservation) {
            return "course";
        }
        if (reservation instanceof DummyReservation) {
            return "dummy";
        }
        return "other";
    }

    protected String curriculum(Student student) {
        String curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = curriculum + (curriculum.isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        String group = "";
        for (AcademicAreaCode aac : student.getMinors()) {
            if ("A".equals(aac.getArea())) continue;
            group = group + (group.isEmpty() ? "" : ", ") + aac.getCode();
        }
        return group;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean includeLastLikeStudents = properties.getPropertyBoolean("lastlike", false);
        boolean includeRealStudents = properties.getPropertyBoolean("real", true);
        HashSet<String> types = new HashSet<String>();
        for (String type : properties.getProperty("type", "group").split("\\,")) {
            types.add(type);
        }
        HashMap<Long, ArrayList<Reservation>> unused = new HashMap<Long, ArrayList<Reservation>>();
        for (Offering offering : this.getModel().getOfferings()) {
            for (Reservation reservation : offering.getReservations()) {
                if (!types.contains(this.type(reservation))) continue;
                HashSet<Long> studentIds = null;
                if (reservation instanceof IndividualReservation) {
                    studentIds = new HashSet<Long>(((IndividualReservation)reservation).getStudentIds());
                } else if (reservation instanceof CourseReservation) {
                    studentIds = new HashSet();
                    for (CourseRequest cr : ((CourseReservation)reservation).getCourse().getRequests()) {
                        studentIds.add(cr.getStudent().getId());
                    }
                } else {
                    studentIds = new HashSet();
                    for (Course course : reservation.getOffering().getCourses()) {
                        for (CourseRequest cr : course.getRequests()) {
                            if (!reservation.isApplicable(cr.getStudent())) continue;
                            studentIds.add(cr.getStudent().getId());
                        }
                    }
                }
                if (studentIds == null || studentIds.isEmpty()) continue;
                for (Enrollment e : reservation.getEnrollments(assignment)) {
                    studentIds.remove(e.getStudent().getId());
                }
                for (Long studentId : studentIds) {
                    ArrayList<Reservation> studentReservations = (ArrayList<Reservation>)unused.get(studentId);
                    if (studentReservations == null) {
                        studentReservations = new ArrayList<Reservation>();
                        unused.put(studentId, studentReservations);
                    }
                    studentReservations.add(reservation);
                }
            }
        }
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportRequestedCourse()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict())});
        if (unused.isEmpty()) {
            return csv;
        }
        for (Student student : this.getModel().getStudents()) {
            List studentReservations = (List)unused.get(student.getId());
            if (studentReservations == null || studentReservations.isEmpty()) continue;
            for (Reservation reservation : studentReservations) {
                if (student.isDummy() && !includeLastLikeStudents || !student.isDummy() && !includeRealStudents) continue;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (dbStudent != null) {
                    line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                } else {
                    line.add(new CSVFile.CSVField((Object)""));
                }
                line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                line.add(new CSVFile.CSVField((Object)this.group(student)));
                CourseRequest courseRequest = null;
                Course course = null;
                block10: for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest cr = (CourseRequest)r;
                    for (Course c : cr.getCourses()) {
                        if (!reservation.getOffering().equals((Object)c.getOffering())) continue;
                        courseRequest = cr;
                        course = c;
                        break block10;
                    }
                }
                if (course == null) {
                    line.add(new CSVFile.CSVField((Object)(reservation instanceof CourseReservation ? ((CourseReservation)reservation).getCourse().getName() : reservation.getOffering().getName())));
                    line.add(new CSVFile.CSVField((Object)MSG.courseNotRequested()));
                } else {
                    line.add(new CSVFile.CSVField((Object)course.getName()));
                    Enrollment enrollment = (Enrollment)courseRequest.getAssignment(assignment);
                    if (enrollment != null && reservation.isIncluded(enrollment)) continue;
                    TreeSet<Enrollment> overlaps = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                        @Override
                        public int compare(Enrollment o1, Enrollment o2) {
                            return o1.getRequest().compareTo(o2.getRequest());
                        }
                    });
                    Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                    List av = courseRequest.getAvaiableEnrollmentsSkipSameTime(assignment);
                    if (av.isEmpty() || av.size() == 1 && ((Enrollment)av.get(0)).equals((Object)courseRequest.getInitialAssignment()) && this.getModel().inConflict(assignment, (Value)av.get(0))) {
                        if (((Course)courseRequest.getCourses().get(0)).getLimit() >= 0) {
                            line.add(new CSVFile.CSVField((Object)MSG.courseIsFull()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)MSG.classNotAvailable()));
                        }
                    } else {
                        for (Object enrl : av) {
                            for (Request q : enrl.getStudent().getRequests()) {
                                Enrollment x;
                                if (q.equals((Object)courseRequest) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                for (SctAssignment a : x.getAssignments()) {
                                    if (!a.isOverlapping(enrl.getAssignments())) continue;
                                    overlaps.add(x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    CourseRequest cr = (CourseRequest)x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a);
                                }
                            }
                        }
                        if (!overlaps.isEmpty()) {
                            Object enrl;
                            TreeSet<String> ts = new TreeSet<String>();
                            enrl = overlaps.iterator();
                            while (enrl.hasNext()) {
                                Enrollment q = (Enrollment)enrl.next();
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    ts.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = ov + ",";
                                    }
                                }
                                ts.add(ov);
                            }
                            String message = "";
                            Iterator i = ts.iterator();
                            while (i.hasNext()) {
                                String x = (String)i.next();
                                if (message.isEmpty()) {
                                    message = message + MSG.conflictWithFirst(x);
                                    continue;
                                }
                                if (!i.hasNext()) {
                                    message = message + MSG.conflictWithLast(x);
                                    continue;
                                }
                                message = message + MSG.conflictWithMiddle(x);
                            }
                            line.add(new CSVFile.CSVField((Object)message));
                        } else if (courseRequest.getAssignment(assignment) == null) {
                            line.add(new CSVFile.CSVField((Object)MSG.courseNotAssigned()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)MSG.reservationNotUsed()));
                        }
                    }
                }
                csv.addLine(line);
            }
        }
        return csv;
    }
}

