/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamScheduleByPeriodReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ExamScheduleByPeriodReport.class);

    public ExamScheduleByPeriodReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY PERIOD", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        String[] stringArray = new String[2];
        stringArray[0] = "Date And Time                  Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section     Meeting Times                         Enrl" + (this.iDispRooms ? "  Room         Cap ExCap" : "");
        stringArray[1] = "------------------------------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- -------------------------------------- -----" + (this.iDispRooms ? " ----------- ----- -----" : "");
        this.setHeader(stringArray);
        this.printHeader();
        sLog.debug((Object)"  Sorting exams...");
        TreeSet<ExamAssignmentInfo> exams = new TreeSet<ExamAssignmentInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            exams.add(exam);
        }
        sLog.debug((Object)"  Printing report...");
        Iterator<ExamPeriod> p = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()).iterator();
        while (p.hasNext()) {
            ExamPeriod period = p.next();
            this.iPeriodPrinted = false;
            this.setPageName(this.formatPeriod(period));
            this.setCont(this.formatPeriod(period));
            for (ExamAssignmentInfo exam : exams) {
                if (!period.equals(exam.getPeriod())) continue;
                if (this.iPeriodPrinted && !this.iNewPage) {
                    this.println("");
                }
                ExamInfo.ExamSectionInfo lastSection = null;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (!this.hasSubjectArea(section)) continue;
                    this.iStudentPrinted = false;
                    this.iCoursePrinted = false;
                    this.iSubjectPrinted = false;
                    if (lastSection != null && section.getSubject().equals(lastSection.getSubject())) {
                        this.iSubjectPrinted = true;
                        if (section.getCourseNbr().equals(lastSection.getCourseNbr())) {
                            this.iCoursePrinted = true;
                            if (section.getItype().equals(lastSection.getItype())) {
                                this.iStudentPrinted = true;
                            }
                        }
                    }
                    lastSection = section;
                    if (!this.iDispRooms) {
                        this.println(this.rpad(this.iPeriodPrinted ? "" : this.formatPeriod(period), 30) + " " + this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iStudentPrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 38) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iPeriodPrinted = !this.iNewPage;
                        continue;
                    }
                    if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                        this.println(this.rpad(this.iPeriodPrinted ? "" : this.formatPeriod(period), 30) + " " + this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iStudentPrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 38) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5) + " " + this.iNoRoom);
                        this.iPeriodPrinted = !this.iNewPage;
                        continue;
                    }
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.iNrLines) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iPeriodPrinted ? "" : this.formatPeriod(period), 30) + " " + this.rpad(!firstRoom || this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(!firstRoom || this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(!firstRoom || this.iStudentPrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(!firstRoom ? "" : section.getSection(), 9) + " " + this.rpad(!firstRoom ? "" : this.getMeetingTime(section), 38) + " " + this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5) + " " + this.formatRoom(room) + " " + this.lpad("" + room.getCapacity(), 5) + " " + this.lpad("" + room.getExamCapacity(), 5));
                        firstRoom = false;
                    }
                    this.iPeriodPrinted = !this.iNewPage;
                }
            }
            this.setCont(null);
            if (!this.iPeriodPrinted || !p.hasNext()) continue;
            this.newPage();
        }
        if (this.iPeriodPrinted) {
            this.lastPage();
        }
    }
}

