/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.CalendarExport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class StudentEmail
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private static GwtMessages GWT = Localization.create(GwtMessages.class);
    private Date iTimeStamp = new Date();
    private static Formats.Format<Date> sTimeStampFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private static Formats.Format<Date> sConsentApprovalDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
    private String iSubject = MSG.emailDeafultSubject();
    private String iSubjectExt = null;
    private String iMessage = null;
    private String iCC = null;
    private static Hashtable<Long, String> sLastMessage = new Hashtable();
    private byte[] iTimetableImage = null;
    private Long iStudentId;
    private XOffering iOldOffering;
    private XCourseId iOldCourseId;
    private XEnrollment iOldEnrollment;
    private XStudent iOldStudent;
    private XStudent iStudent;
    private CourseUrlProvider iCourseUrlProvider = null;
    private static String[] sColor1 = new String[]{"2952A3", "B1365F", "7A367A", "5229A3", "29527A", "1B887A", "28754E", "0D7813", "528800", "88880E", "AB8B00", "BE6D00", "B1440E", "865A5A", "705770", "4E5D6C", "5A6986", "4A716C", "6E6E41", "8D6F47"};
    private static String[] sColor2 = new String[]{"668CD9", "E67399", "B373B3", "8C66D9", "668CB3", "59BFB3", "65AD89", "4CB052", "8CBF40", "BFBF4D", "E0C240", "F2A640", "E6804D", "BE9494", "A992A9", "8997A5", "94A2bE", "85AAA5", "A7A77D", "C4A883"};

    public StudentEmail forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public StudentEmail oldEnrollment(XOffering oldOffering, XCourseId oldCourseId, XEnrollment oldEnrollment) {
        this.iOldOffering = oldOffering;
        this.iOldCourseId = oldCourseId;
        this.iOldEnrollment = oldEnrollment;
        return this;
    }

    public StudentEmail oldStudent(XStudent oldStudent) {
        this.iOldStudent = oldStudent;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    private String getSubject() {
        return this.iSubject;
    }

    private void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getEmailSubject() {
        return this.iSubjectExt;
    }

    public void setEmailSubject(String subject) {
        this.iSubjectExt = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getCC() {
        return this.iCC;
    }

    public void setCC(String cc) {
        this.iCC = cc;
    }

    public XEnrollment getOldEnrollment() {
        return this.iOldEnrollment;
    }

    public XOffering getOldOffering() {
        return this.iOldOffering;
    }

    public XCourse getOldCourse() {
        return this.iOldOffering == null || this.iOldCourseId == null ? null : this.iOldOffering.getCourse(this.iOldCourseId);
    }

    public XStudent getOldStudent() {
        return this.iOldStudent;
    }

    public XStudent getStudent() {
        return this.iStudent;
    }

    public void setStudent(XStudent student) {
        this.iStudent = student;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student;
        OnlineSectioningLog.Action.Builder action;
        OnlineSectioningServer.Lock lock;
        block42: {
            OnlineSectioningLog.Enrollment.Builder enrollment;
            try {
                String providerClass = ApplicationProperty.CustomizationCourseLink.value();
                if (providerClass != null) {
                    this.iCourseUrlProvider = (CourseUrlProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            lock = server.lockStudent(this.getStudentId(), null, this.name());
            action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            if (this.getOldEnrollment() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XSection xSection : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(xSection, this.getOldEnrollment()));
                }
                action.addEnrollment(enrollment);
            } else if (this.getOldStudent() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest xRequest : this.getOldStudent().getRequests()) {
                    XEnrollment e = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                    if (e == null) continue;
                    for (XSection xSection : server.getOffering(e.getOfferingId()).getSections(e)) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(xSection, e));
                    }
                }
                action.addEnrollment(enrollment);
            }
            student = server.getStudent(this.getStudentId());
            if (student != null) break block42;
            Iterator<XRequest> iterator = false;
            Object var21_25 = null;
            lock.release();
            return iterator;
        }
        try {
            boolean bl;
            this.setStudent(student);
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
            for (XRequest r : student.getRequests()) {
                action.addRequest(OnlineSectioningHelper.toProto(r));
                XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                if (e == null) continue;
                for (XSection section : server.getOffering(e.getOfferingId()).getSections(e)) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(section, e));
                }
            }
            action.addEnrollment(enrollment);
            boolean bl2 = false;
            Student dbStudent = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (dbStudent != null && dbStudent.getEmail() != null && !dbStudent.getEmail().isEmpty()) {
                void var10_24;
                action.getStudentBuilder().setName(dbStudent.getEmail());
                boolean emailEnabled = true;
                StudentSectioningStatus studentSectioningStatus = dbStudent.getSectioningStatus();
                if (studentSectioningStatus == null) {
                    StudentSectioningStatus studentSectioningStatus2 = dbStudent.getSession().getDefaultSectioningStatus();
                }
                if (var10_24 != null && !var10_24.hasOption(StudentSectioningStatus.Option.email)) {
                    emailEnabled = false;
                }
                if (emailEnabled) {
                    final String html = this.generateMessage(dbStudent, server, helper);
                    if (html != null) {
                        String lastMessageId;
                        String additionalCC;
                        TimetableManager manager;
                        Email email = Email.createEmail();
                        email.addRecipient(dbStudent.getEmail(), helper.getStudentNameFormat().format(dbStudent));
                        if (this.getCC() != null && !this.getCC().isEmpty()) {
                            helper.logOption("cc", this.getCC());
                            StringTokenizer s = new StringTokenizer(this.getCC(), ",;");
                            while (s.hasMoreTokens()) {
                                email.addRecipientCC(s.nextToken(), null);
                            }
                        }
                        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
                            email.setSubject(this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                            helper.logOption("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                        } else {
                            email.setSubject(this.getSubject().replace("%session%", server.getAcademicSession().toString()));
                        }
                        if (this.getMessage() != null && !this.getMessage().isEmpty()) {
                            helper.logOption("message", this.getMessage());
                        }
                        if (helper.getUser() != null && this.getOldEnrollment() == null && this.getOldStudent() == null && (manager = (TimetableManager)helper.getHibSession().createQuery("from TimetableManager where externalUniqueId = :id").setString("id", helper.getUser().getExternalId()).uniqueResult()) != null && manager.getEmailAddress() != null) {
                            email.setReplyTo(manager.getEmailAddress(), manager.getName());
                            helper.logOption("reply-to", manager.getName() + " <" + manager.getEmailAddress() + ">");
                        }
                        if ((additionalCC = ApplicationProperty.OnlineSchedulingEmailCarbonCopy.value()) != null) {
                            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                            for (String address : additionalCC.split("[\n,]")) {
                                String cc = address.trim();
                                if (cc.isEmpty()) continue;
                                if (suffix != null && cc.indexOf(64) < 0) {
                                    cc = cc + suffix;
                                }
                                email.addRecipientCC(cc, null);
                            }
                        }
                        final StringWriter buffer = new StringWriter();
                        if (ApplicationProperty.OnlineSchedulingEmailIncludeMessage.isTrue()) {
                            PrintWriter out = new PrintWriter(buffer);
                            this.generateTimetable(out, server, helper);
                            out.flush();
                            out.close();
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "message.html";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(html.replace("<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>", buffer.toString()).getBytes("UTF-8"));
                                }

                                public String getContentType() {
                                    return "text/html; charset=UTF-8";
                                }
                            });
                        }
                        if (this.iTimetableImage != null) {
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "timetable.png";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(StudentEmail.this.iTimetableImage);
                                }

                                public String getContentType() {
                                    return "image/png";
                                }
                            });
                        }
                        if (ApplicationProperty.OnlineSchedulingEmailICalendar.isTrue()) {
                            try {
                                final String calendar = CalendarExport.getCalendar(server, student);
                                if (calendar != null) {
                                    email.addAttachment(new DataSource(){

                                        public OutputStream getOutputStream() throws IOException {
                                            throw new IOException("No output stream.");
                                        }

                                        public String getName() {
                                            return "timetable.ics";
                                        }

                                        public InputStream getInputStream() throws IOException {
                                            return new ByteArrayInputStream(calendar.getBytes("UTF-8"));
                                        }

                                        public String getContentType() {
                                            return "text/calendar; charset=UTF-8";
                                        }
                                    });
                                }
                            }
                            catch (IOException e) {
                                helper.warn("Unable to create calendar for student " + student.getStudentId() + ":" + e.getMessage());
                            }
                        }
                        if ((lastMessageId = sLastMessage.get(student.getStudentId())) != null) {
                            email.setInReplyTo(lastMessageId);
                        }
                        email.setHTML(html);
                        helper.logOption("email", html.replace("<img src='cid:timetable.png' border='0' alt='Timetable Image'/>", buffer.toString()));
                        email.send();
                        String messageId = email.getMessageId();
                        if (messageId != null) {
                            sLastMessage.put(student.getStudentId(), messageId);
                        }
                        Date ts = new Date();
                        dbStudent.setScheduleEmailedDate(ts);
                        student.setEmailTimeStamp(ts);
                        helper.getHibSession().saveOrUpdate((Object)dbStudent);
                        helper.getHibSession().flush();
                        server.update(student, false);
                        bl = true;
                    } else {
                        helper.debug("Email notification failed to generate for student " + student.getName() + ".");
                    }
                } else {
                    helper.debug("Email notification is disabled for student " + student.getName() + ".");
                }
            } else {
                helper.debug("Student " + student.getName() + " has no email address on file.");
            }
            Boolean bl3 = bl;
            Object var21_26 = null;
            lock.release();
            return bl3;
        }
        catch (Exception e) {
            try {
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                lock.release();
                throw throwable;
            }
        }
    }

    @Override
    public String name() {
        return "student-email";
    }

    protected URL getCourseUrl(AcademicSessionInfo session, XCourse course) {
        if (this.iCourseUrlProvider == null) {
            return null;
        }
        return this.iCourseUrlProvider.getCourseUrl(session, course.getSubjectArea(), course.getCourseNumber());
    }

    private String generateMessage(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setClassForTemplateLoading(StudentEmail.class, "/");
        cfg.setLocale(Localization.getJavaLocale());
        cfg.setOutputEncoding("utf-8");
        Template template = cfg.getTemplate(ApplicationProperty.OnlineSchedulingEmailTemplate.value());
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("msg", MSG);
        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
            input.put("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
        }
        input.put("student", this.getStudent());
        input.put("name", helper.getStudentNameFormat().format(student));
        input.put("server", server);
        input.put("helper", helper);
        input.put("message", this.getMessage());
        input.put("dfConsentApproval", sConsentApprovalDateFormat);
        Table classes = this.generateListOfClasses(student, server, helper);
        input.put("classes", classes);
        float totalCredit = 0.0f;
        Pattern pattern = Pattern.compile("\\d+\\.?\\d*");
        for (TableLine line : classes) {
            Matcher m;
            String credit = line.getCredit();
            if (credit == null || !(m = pattern.matcher(credit)).find()) continue;
            totalCredit += Float.parseFloat(m.group());
        }
        input.put("credit", new DecimalFormat("0.#").format(totalCredit));
        if (!this.getStudent().getRequests().isEmpty() && ApplicationProperty.OnlineSchedulingEmailIncludeImage.isTrue()) {
            try {
                this.iTimetableImage = this.generateTimetableImage(server);
            }
            catch (Exception e) {
                helper.error("Unable to create timetable image: " + e.getMessage(), e);
                StringWriter buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                this.generateTimetable(out, server, helper);
                out.flush();
                out.close();
                input.put("timetable", buffer.toString());
            }
            if (this.iTimetableImage != null) {
                input.put("timetable", "<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>");
            }
        }
        AcademicSessionInfo session = server.getAcademicSession();
        if (this.getOldOffering() != null) {
            Table listOfChanges = new Table();
            Object newRequest = null;
            XOffering newOffering = null;
            XCourse course = this.getOldEnrollment() != null ? this.getOldOffering().getCourse(this.getOldEnrollment().getCourseId()) : this.getOldCourse();
            for (XRequest r : this.getStudent().getRequests()) {
                if (!(r instanceof XCourseRequest) || (this.getOldCourse() != null || ((XCourseRequest)r).getCourseIdByOfferingId(this.getOldOffering().getOfferingId()) == null) && (this.getOldCourse() == null || !((XCourseRequest)r).hasCourse(this.getOldCourse().getCourseId()))) continue;
                newRequest = (XCourseRequest)r;
                newOffering = server.getOffering(this.getOldOffering().getOfferingId());
                if (((XCourseRequest)newRequest).getEnrollment() == null) break;
                course = newOffering.getCourse(((XCourseRequest)newRequest).getEnrollment().getCourseId());
                break;
            }
            input.put("changedCourse", course);
            if (this.getOldEnrollment() == null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                this.setSubject(MSG.emailEnrollmentNew(course.getSubjectArea(), course.getCourseNumber()));
                XEnrollment enrollment = ((XCourseRequest)newRequest).getEnrollment();
                Iterator<XSection> consent = this.consent(server, enrollment);
                for (XSection section : newOffering.getSections(enrollment)) {
                    XSection parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart = newOffering.getSubpart(section.getSubpartId());
                    Object requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    } else {
                        requires = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, section, (String)requires, this.getCourseUrl(session, course)));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                String requires;
                this.setSubject(MSG.emailEnrollmentChanged(course.getSubjectArea(), course.getCourseNumber()));
                String consent = this.consent(server, ((XCourseRequest)newRequest).getEnrollment());
                block5: for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                    XSection parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart = newOffering.getSubpart(section.getSubpartId());
                    for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        String requires2 = null;
                        if (parent != null) {
                            requires2 = parent.getName(course.getCourseId());
                        }
                        XSubpart oldSubpart = this.getOldOffering().getSubpart(old.getSubpartId());
                        XSection oldParent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                        String oldRequires = null;
                        if (oldParent != null) {
                            oldRequires = oldParent.getName(course.getCourseId());
                        }
                        if (oldRequires == null && requires2 == null) {
                            requires2 = consent;
                            oldRequires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionModifiedLine((XCourseRequest)newRequest, course, oldSubpart, subpart, old, section, oldRequires, requires2, this.getCourseUrl(session, course)));
                        continue block5;
                    }
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    } else {
                        requires = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, section, requires, this.getCourseUrl(session, course)));
                }
                block7: for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        continue block7;
                    }
                    XSubpart subpart = this.getOldOffering().getSubpart(old.getSubpartId());
                    XSection parent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(course.getCourseId());
                    }
                    listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, course, subpart, old, requires, this.getCourseUrl(session, course)));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && (newRequest == null || ((XCourseRequest)newRequest).getEnrollment() == null)) {
                this.setSubject(newRequest == null ? MSG.emailCourseDropReject(course.getSubjectArea(), course.getCourseNumber()) : MSG.emailCourseDropChange(course.getSubjectArea(), course.getCourseNumber()));
                if (newRequest != null && this.getStudent().canAssign((XCourseRequest)newRequest)) {
                    input.put("changeMessage", ((XRequest)newRequest).isAlternative() ? (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListedAlternative() : MSG.emailCourseNotEnrolledAlternative()) : (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListed() : MSG.emailCourseNotEnrolled()));
                } else if (newRequest == null && course.getConsentLabel() != null) {
                    input.put("changeMessage", MSG.emailConsentRejected(course.getConsentLabel().toLowerCase()));
                }
            }
        } else if (this.getOldStudent() != null && !this.getOldStudent().getRequests().isEmpty()) {
            boolean somethingWasAssigned = false;
            for (XRequest or : this.getOldStudent().getRequests()) {
                if (!(or instanceof XCourseRequest) || ((XCourseRequest)or).getEnrollment() == null) continue;
                somethingWasAssigned = true;
                break;
            }
            if (somethingWasAssigned) {
                XCourse course;
                Table listOfChanges = new Table();
                block10: for (XRequest nr : this.getStudent().getRequests()) {
                    if (nr instanceof XFreeTimeRequest) continue;
                    XCourseRequest ncr = (XCourseRequest)nr;
                    for (XRequest or : this.getOldStudent().getRequests()) {
                        String requires;
                        XSection parent;
                        Object subpart;
                        Object course2;
                        if (or instanceof XFreeTimeRequest) continue;
                        XCourseRequest ocr = (XCourseRequest)or;
                        if (!or.getRequestId().equals(nr.getRequestId())) continue;
                        if (ocr.getEnrollment() == null) {
                            if (ncr.getEnrollment() == null) continue;
                            String consent = this.consent(server, ncr.getEnrollment());
                            XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                            course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                XSubpart subpart2 = no.getSubpart(section.getSubpartId());
                                XSection parent2 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires3 = null;
                                if (parent2 != null) {
                                    requires3 = parent2.getName(((XCourseId)course2).getCourseId());
                                } else {
                                    requires3 = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionLine(ncr, (XCourse)course2, subpart2, section, requires3, this.getCourseUrl(session, (XCourse)course2)));
                            }
                            continue block10;
                        }
                        if (ncr.getEnrollment() == null) {
                            XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                            XCourse course3 = oo.getCourse(ocr.getEnrollment().getCourseId());
                            for (XSection section : oo.getSections(ocr.getEnrollment())) {
                                Iterator<XSection> subpart3 = oo.getSubpart(section.getSubpartId());
                                XSection parent3 = section.getParentId() == null ? null : oo.getSection(section.getParentId());
                                Object requires4 = null;
                                if (parent3 != null) {
                                    requires4 = parent3.getName(course3.getCourseId());
                                }
                                listOfChanges.add(new TableSectionDeletedLine(ncr, course3, (XSubpart)((Object)subpart3), section, (String)requires4, this.getCourseUrl(session, course3)));
                            }
                            continue block10;
                        }
                        XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                        XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                        course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                        String consent = this.consent(server, ncr.getEnrollment());
                        block14: for (XSection section : no.getSections(ncr.getEnrollment())) {
                            for (XSection old : oo.getSections(ocr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                if (StudentEmail.equals(section, old)) continue block14;
                                XSubpart subpart4 = no.getSubpart(section.getSubpartId());
                                XSection parent4 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires5 = null;
                                if (parent4 != null) {
                                    requires5 = parent4.getName(((XCourseId)course2).getCourseId());
                                }
                                XSubpart oldSubpart = oo.getSubpart(old.getSubpartId());
                                XSection oldParent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                                String oldRequires = null;
                                if (oldParent != null) {
                                    oldRequires = oldParent.getName(((XCourseId)course2).getCourseId());
                                }
                                if (oldRequires == null && requires5 == null) {
                                    requires5 = consent;
                                    oldRequires = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionModifiedLine(ncr, (XCourse)course2, oldSubpart, subpart4, old, section, oldRequires, requires5, this.getCourseUrl(session, (XCourse)course2)));
                                continue block14;
                            }
                            subpart = no.getSubpart(section.getSubpartId());
                            parent = section.getParentId() == null ? null : no.getSection(section.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(((XCourseId)course2).getCourseId());
                            } else {
                                requires = consent;
                                consent = null;
                            }
                            listOfChanges.add(new TableSectionLine(ncr, (XCourse)course2, (XSubpart)subpart, section, requires, this.getCourseUrl(session, (XCourse)course2)));
                        }
                        course2 = oo.getCourse(ocr.getEnrollment().getCourseId());
                        block16: for (XSection old : oo.getSections(ocr.getEnrollment())) {
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                continue block16;
                            }
                            subpart = oo.getSubpart(old.getSubpartId());
                            parent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(((XCourseId)course2).getCourseId());
                            }
                            listOfChanges.add(new TableSectionDeletedLine(ocr, (XCourse)course2, (XSubpart)subpart, old, requires, this.getCourseUrl(session, (XCourse)course2)));
                        }
                        continue block10;
                    }
                    if (ncr.getEnrollment() == null) continue;
                    XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                    course = no.getCourse(ncr.getEnrollment().getCourseId());
                    String consent = this.consent(server, ncr.getEnrollment());
                    for (XSection section : no.getSections(ncr.getEnrollment())) {
                        XSubpart subpart = no.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : no.getSection(section.getParentId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionLine(ncr, course, subpart, section, requires, this.getCourseUrl(session, course)));
                    }
                }
                block19: for (XRequest or : this.getOldStudent().getRequests()) {
                    if (or instanceof XFreeTimeRequest || ((XCourseRequest)or).getEnrollment() == null) continue;
                    for (XRequest nr : this.getStudent().getRequests()) {
                        if (or instanceof XFreeTimeRequest || !or.getRequestId().equals(nr.getRequestId())) continue;
                        continue block19;
                    }
                    XCourseRequest ocr = (XCourseRequest)or;
                    XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                    course = oo.getCourse(ocr.getEnrollment().getCourseId());
                    for (XSection section : oo.getSections(((XCourseRequest)or).getEnrollment())) {
                        XSubpart subpart = oo.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : oo.getSection(section.getParentId());
                        Object requires2 = null;
                        if (parent != null) {
                            requires2 = parent.getName(course.getCourseId());
                        }
                        listOfChanges.add(new TableSectionDeletedLine(ocr, course, subpart, section, (String)requires2, this.getCourseUrl(session, course)));
                    }
                }
                input.put("changes", listOfChanges);
            } else {
                this.setSubject(MSG.emailSubjectNotification());
            }
        } else {
            this.setSubject(MSG.emailSubjectNotification());
        }
        input.put("manager", helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER);
        input.put("changed", this.getOldEnrollment() != null || this.getOldStudent() != null);
        input.put("version", GWT.pageVersion(Constants.getVersion(), Constants.getReleaseDate()));
        input.put("copyright", GWT.pageCopyright());
        input.put("ts", sTimeStampFormat.format(this.getTimeStamp()));
        input.put("link", ApplicationProperty.UniTimeUrl.value());
        StringWriter s = new StringWriter();
        template.process(input, (Writer)new PrintWriter(s));
        s.flush();
        s.close();
        return s.toString();
    }

    Table generateListOfClasses(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Table listOfClasses = new Table();
        AcademicSessionInfo session = server.getAcademicSession();
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)request;
                XEnrollment enrollment = cr.getEnrollment();
                if (enrollment == null) {
                    if (!this.getStudent().canAssign(cr)) continue;
                    XCourse course = server.getCourse(cr.getCourseIds().get(0).getCourseId());
                    listOfClasses.add(new TableCourseLine(cr, course, this.getCourseUrl(session, course)));
                } else {
                    XOffering offering = server.getOffering(enrollment.getOfferingId());
                    XCourse course = offering.getCourse(enrollment.getCourseId());
                    String consent = this.consent(server, enrollment);
                    for (XSection section : offering.getSections(enrollment)) {
                        XSection parent = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                        XSubpart subpart = offering.getSubpart(section.getSubpartId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfClasses.add(new TableSectionLine(cr, course, subpart, section, requires, this.getCourseUrl(session, course)));
                    }
                }
            }
            if (!(request instanceof XFreeTimeRequest)) continue;
            listOfClasses.add(new TableLineFreeTime((XFreeTimeRequest)request));
        }
        return listOfClasses;
    }

    public static boolean equals(XSection a, XSection b) {
        return ToolBox.equals((Object)a.getName(), (Object)b.getName()) && ToolBox.equals((Object)a.getTime(), (Object)b.getTime()) && ToolBox.equals(a.getRooms(), b.getRooms()) && ToolBox.equals(a.getInstructors(), b.getInstructors()) && ToolBox.equals((Object)a.getParentId(), (Object)b.getParentId());
    }

    private static String startTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot());
    }

    private static String endTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot() + time.getLength(), time.getBreakTime());
    }

    private String consent(OnlineSectioningServer server, XEnrollment enrollment) {
        if (enrollment == null || enrollment.getCourseId() == null) {
            return null;
        }
        XCourse info = server.getCourse(enrollment.getCourseId());
        if (info == null || info.getConsentLabel() == null) {
            return null;
        }
        if (enrollment.getApproval() == null) {
            return MSG.consentWaiting(info.getConsentLabel().toLowerCase());
        }
        return MSG.consentApproved(sConsentApprovalDateFormat.format(enrollment.getApproval().getTimeStamp()));
    }

    public void generateTimetable(PrintWriter out, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Enumeration<Integer> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        out.println("<table cellspacing='0' cellpadding='0'>");
        out.println("<tr><td align='left' style='vertical-align: top;'><table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 30px;'></div></td>");
        for (int i = 0; i < nrDays; ++i) {
            out.println("<td align='center' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 180px; '>" + DayCode.values()[i].getName() + "</div></td>");
        }
        out.println("</tr></table></td></tr>");
        out.println("<tr><td align='left' style='vertical-align: top;'><div style='width: " + (35 + 180 * nrDays) + "px; '>");
        out.println("<table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top; '><div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 30px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px; white-space: nowrap; position: absolute; left: 0px; top: " + top + "px;'>" + (CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h)) + "</div>");
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px;position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        out.println("</div></td>");
        out.println("<td align='left' style='vertical-align: top; '>");
        out.println("<div style='border-bottom: 1px solid #DDDDDD; position: relative; overflow-x: hidden; overflow-y: hidden; width: " + (5 + 180 * nrDays) + "px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        out.println("<div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 100%; height: 100%; '>");
        out.println("<div style='background: #FFFDDD; width: " + (2 + 180 * nrDays) + "px; height: 500px; position: absolute; left: 0px; top: " + (25 + 50 * (7 - firstHour)) + "px;'></div>");
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                if (dow.getIndex() >= nrDays || fr.getTime().getSlot() + fr.getTime().getLength() < 12 * firstHour || fr.getTime().getSlot() > 12 * lastHour) continue;
                out.println("<div style='background: #FFE1DD; width: 100%; color: #BA5353; font-size: x-small; text-align: left; white-space: nowrap; overflow: hidden;width: 183px; height: " + 125 * fr.getTime().getLength() / 30 + "px; " + "position: absolute; left: " + 180 * dow.getIndex() + "px;" + "top: " + (125 * fr.getTime().getSlot() / 30 - 50 * firstHour) + "px; '>");
                out.println("<div style='padding-left: 5px; white-space: nowrap; '>Free " + DayCode.toString(fr.getTime().getDays()) + " " + StudentEmail.startTime(fr.getTime()) + " - " + StudentEmail.endTime(fr.getTime()) + "</div>");
                out.println("</div>");
            }
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='display: block; border-top: 1px solid #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + top + "px; '></div>");
            out.println("<div style='display: block; border-top: 1px dotted #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        for (int i = 0; i <= nrDays; ++i) {
            int left = 180 * i;
            out.println("<div style='height: 100%; position: absolute; top: 0px; left: 0%; border-left: 1px solid #DDDDDD; border-right: 1px solid #DDDDDD; width: 2px; position: absolute; left: " + left + "px; top: 0px; '></div>");
        }
        out.println("</div>");
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 174 / col + (index + 1 != col && col > 1 ? -3 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 3;
                    int l = 4 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 1 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    out.println("<div style='overflow-x: hidden; overflow-y: hidden; width: " + w + "px; height: " + h + "px; position: absolute; left: " + l + "px; top: " + t + "px; " + "position: absolute; font-size: x-small; font-family: arial; overflow: hidden; -webkit-border-radius: 6px; -moz-border-radius: 6px; color: #FFFFFF; " + "border: 1px solid #" + sColor1[color] + "; background: #" + sColor2[color] + ";'>");
                    out.println("<table cellspacing='0' cellpadding='0' style='padding-left: 4px; padding-right: 4px; padding-bottom: 2px; padding-top: 2px; width: 100%; -webkit-border-top-left-radius: 5px; -webkit-border-top-right-radius: 5px; -moz-border-radius-topleft: 5px; -moz-border-radius-topright: 5px;background: #" + sColor1[color] + ";'><tr><td align='left' style='vertical-align: top; '>");
                    out.println("<div style='padding-left: 2px; width: 100%; font-size: x-small; white-space: nowrap; overflow: hidden; color: #FFFFFF;'>" + MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName() + "</div></td></tr></tbody></table>");
                    out.println("<div style='font-size: x-small; padding-left: 4px; white-space: wrap; -webkit-border-bottom-left-radius: 5px; -webkit-border-bottom-right-radius: 5px; -moz-border-radius-bottomleft: 5px; -moz-border-radius-bottomright: 5px;'>");
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            out.println("<span style='white-space: nowrap'>" + room.getName() + ",</span>");
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        out.println("<span style='white-space: nowrap'>" + instructor.getName() + ",</span>");
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        out.println("<span style='white-space: nowrap'>" + section.getTime().getDatePatternName() + "</span>");
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        out.println("<br>" + course.getNote().replace("\n", "<br>"));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        out.println("<br>" + section.getNote().replace("\n", "<br>"));
                    }
                    out.println("</div></div>");
                }
            }
            color = (1 + color) % sColor1.length;
        }
        out.println("</div></td></tr></table></div></td></tr>");
        out.println("</table>");
    }

    public byte[] generateTimetableImage(OnlineSectioningServer server) throws IOException {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Iterator<DayCode> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        BufferedImage image = new BufferedImage(39 + 180 * nrDays, 21 + 50 * (lastHour - firstHour), 1);
        Graphics2D g = image.createGraphics();
        g.setFont(new Font("Sans Serif", 0, 11));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(255, 255, 255));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int fh = g.getFontMetrics().getHeight();
        g.setColor(new Color(105, 145, 206));
        for (int i = 0; i < nrDays; ++i) {
            g.drawString(DayCode.values()[i].getName(), 40 + i * 180, 17);
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.drawString(CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h), 2, top + fh);
        }
        g.setColor(new Color(255, 253, 221));
        g.fillRect(35, 45 + 50 * (7 - firstHour), 5 + 180 * nrDays, 501);
        Stroke noStroke = g.getStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
        g.setColor(new Color(221, 221, 221));
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.setStroke(noStroke);
            g.drawLine(35, top, 39 + 180 * nrDays, top);
            g.setStroke(dotted);
            g.drawLine(35, top + 25, 39 + 180 * nrDays, top + 25);
        }
        g.setStroke(noStroke);
        g.drawLine(35, 20 + 50 * (lastHour - firstHour), 39 + 180 * nrDays, 20 + 50 * (lastHour - firstHour));
        g.setColor(new Color(255, 225, 221));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.fillRect(36 + 180 * dow.getIndex(), 21 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour, 182, 125 * fr.getTime().getLength() / 30 - 1);
            }
        }
        g.setColor(new Color(221, 221, 221));
        for (int i = 0; i <= nrDays; ++i) {
            g.drawLine(35 + 180 * i, 20, 35 + 180 * i, 20 + 50 * (lastHour - firstHour));
            g.drawLine(38 + 180 * i, 20, 38 + 180 * i, 20 + 50 * (lastHour - firstHour));
        }
        g.setColor(new Color(186, 83, 83));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.drawString(OnlineSectioningHelper.toString(fr), 42 + 180 * dow.getIndex(), 20 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour + fh);
            }
        }
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                block13: for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 176 / col + (index + 1 < col ? -2 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 1;
                    int l = 39 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 21 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    g.setColor(new Color(Integer.valueOf(sColor2[color], 16)));
                    g.fillRoundRect(l, t, w, h, 6, 6);
                    g.setColor(new Color(Integer.valueOf(sColor1[color], 16)));
                    g.drawRoundRect(l, t, w, h, 6, 6);
                    g.fillRoundRect(l, t, w, 2 + fh, 6, 6);
                    g.fillRect(l, t + fh - 2, w, 4);
                    g.setColor(new Color(255, 255, 255));
                    String text = MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName();
                    while (g.getFontMetrics().stringWidth(text) > w - 10) {
                        text = text.substring(0, text.length() - 1);
                    }
                    g.drawString(text, l + 5, t + fh - 2);
                    ArrayList<String> texts = new ArrayList<String>();
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            texts.add(room.getName());
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        texts.add(instructor.getName());
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        texts.add(section.getTime().getDatePatternName());
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        texts.add(course.getNote().replace("\n", "; "));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        texts.add(section.getNote().replace("\n", "; "));
                    }
                    int tt = t + fh;
                    String next = "";
                    int idx = 0;
                    while (idx < texts.size() || !next.isEmpty()) {
                        if (idx < texts.size()) {
                            next = next + (String)texts.get(idx++);
                            if (idx < texts.size()) {
                                next = next + ", ";
                            }
                        }
                        while (g.getFontMetrics().stringWidth(next.trim()) < w - 10 && idx < texts.size() && g.getFontMetrics().stringWidth(next + (String)texts.get(idx) + ",") < w - 10) {
                            next = next + (String)texts.get(idx++);
                            if (idx >= texts.size()) continue;
                            next = next + ", ";
                        }
                        text = next;
                        next = "";
                        while (g.getFontMetrics().stringWidth(text.trim()) > w - 10) {
                            int sp = text.lastIndexOf(32);
                            if (sp >= 0 && g.getFontMetrics().stringWidth(text.substring(sp)) < w - 10) {
                                next = text.substring(sp);
                                text = text.substring(0, sp);
                                continue;
                            }
                            next = text.substring(text.length() - 1, text.length()) + next;
                            text = text.substring(0, text.length() - 1);
                        }
                        if (tt + fh - 2 > t + h) continue block13;
                        g.drawString(text.trim(), l + 5, tt + fh - 2);
                        tt += fh;
                    }
                }
            }
            color = (1 + color) % sColor1.length;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.flush();
        out.close();
        return out.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Table
    extends ArrayList<TableLine> {
        private static final long serialVersionUID = 1L;

        public boolean sameCourse(TableLine a, TableLine b) {
            if (a instanceof TableCourseLine && b instanceof TableCourseLine) {
                return ((TableCourseLine)a).getCourse().equals(((TableCourseLine)b).getCourse());
            }
            return false;
        }

        public boolean isFirst(TableLine line) {
            int index = this.indexOf(line);
            return index <= 0 || !this.sameCourse(line, (TableLine)this.get(index - 1));
        }

        public boolean isLast(TableLine line) {
            int index = this.indexOf(line);
            return index + 1 >= this.size() || !this.sameCourse(line, (TableLine)this.get(index + 1));
        }

        @Override
        public boolean add(TableLine line) {
            line.setTable(this);
            return super.add(line);
        }
    }

    public static class TableSectionModifiedLine
    extends TableSectionLine {
        private XSubpart iOldSubpart;
        private XSection iOldSection;
        private String iOldRequires;

        public TableSectionModifiedLine(XCourseRequest request, XCourse course, XSubpart oldSubpart, XSubpart subpart, XSection oldSection, XSection section, String oldRequires, String requires, URL url) {
            super(request, course, subpart, section, requires, url);
            this.iOldSection = oldSection;
            this.iOldSubpart = oldSubpart;
            this.iOldRequires = oldRequires;
        }

        public XSubpart getOldSubpart() {
            return this.iOldSubpart;
        }

        public XSection getOldSection() {
            return this.iOldSection;
        }

        public XTime getOldTime() {
            return this.iOldSection.getTime();
        }

        public String getName() {
            return this.diff(this.iOldSection.getName(this.iCourse.getCourseId()), this.iSection.getName(this.iCourse.getCourseId()));
        }

        public String diff(String a, String b) {
            if (a == null || a.isEmpty()) {
                return b == null || b.isEmpty() ? "<span style='text-decoration: none;'>&nbsp;</span>" : b;
            }
            if (b == null || b.isEmpty()) {
                return "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
            }
            if (a.equals(b)) {
                return a;
            }
            return b + "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
        }

        public String getRequires() {
            return this.diff(this.iOldRequires, this.iRequires);
        }

        public String getInstructors() {
            String oldInstructors = "";
            if (!this.iOldSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iOldSection.getInstructors()) {
                    if (!oldInstructors.isEmpty()) {
                        oldInstructors = oldInstructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        oldInstructors = oldInstructors + instructor.getName();
                        continue;
                    }
                    oldInstructors = oldInstructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            String instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!instructors.isEmpty()) {
                        instructors = instructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        instructors = instructors + instructor.getName();
                        continue;
                    }
                    instructors = instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            return this.diff(oldInstructors, instructors);
        }

        public String getRooms() {
            String oldRooms = "";
            if (this.iOldSection.getRooms() != null && !this.iOldSection.getRooms().isEmpty()) {
                for (XRoom room : this.iOldSection.getRooms()) {
                    if (!oldRooms.isEmpty()) {
                        oldRooms = oldRooms + ", ";
                    }
                    oldRooms = oldRooms + room.getName();
                }
            }
            String rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!rooms.isEmpty()) {
                        rooms = rooms + ", ";
                    }
                    rooms = rooms + room.getName();
                }
            }
            return this.diff(oldRooms, rooms);
        }

        public String getNote() {
            return this.diff(this.iOldSection.getNote(), this.iSection.getNote());
        }

        public String getCourseNote() {
            return null;
        }

        public String getArrangeHours() {
            return this.diff(this.getOldTime() == null ? MSG.emailArrangeHours() : DayCode.toString(this.getOldTime().getDays()) + " " + StudentEmail.startTime(this.getOldTime()), MSG.emailArrangeHours());
        }

        public String getDays() {
            return this.diff(this.getOldTime() == null ? null : DayCode.toString(this.getOldTime().getDays()), DayCode.toString(this.getTime().getDays()));
        }

        public String getStart() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.startTime(this.getOldTime()), StudentEmail.startTime(this.getTime()));
        }

        public String getEnd() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.endTime(this.getOldTime()), StudentEmail.endTime(this.getTime()));
        }

        public String getDate() {
            return this.diff(this.getOldTime() == null ? null : this.getOldTime().getDatePatternName(), this.getTime().getDatePatternName());
        }
    }

    public static class TableSectionDeletedLine
    extends TableSectionLine {
        public TableSectionDeletedLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(request, course, subpart, section, requires, url);
        }

        public String getCourseNote() {
            return null;
        }
    }

    public static class TableLineFreeTime
    implements TableLine {
        private XFreeTimeRequest iRequest;

        public TableLineFreeTime(XFreeTimeRequest request) {
            this.iRequest = request;
        }

        public XRequest getRequest() {
            return this.iRequest;
        }

        public String getSubject() {
            return MSG.freeTimeCourse();
        }

        public String getCourseNumber() {
            return MSG.freeTimeSubject();
        }

        public String getCourseTitle() {
            return null;
        }

        public String getType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public XTime getTime() {
            return this.iRequest.getTime();
        }

        public boolean isAssigned() {
            return true;
        }

        public String getCredit() {
            return null;
        }

        public String getNote() {
            return null;
        }

        public String getCourseNote() {
            return null;
        }

        public String getRequires() {
            return null;
        }

        public String getRooms() {
            return "";
        }

        public String getInstructors() {
            return "";
        }

        public boolean isFreeTime() {
            return true;
        }

        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        public String getDate() {
            return this.getTime().getDatePatternName();
        }

        public void setTable(Table table) {
        }

        public boolean isLast() {
            return true;
        }

        public boolean isFirst() {
            return true;
        }

        public String getUrl() {
            return null;
        }
    }

    public static class TableSectionLine
    extends TableCourseLine {
        protected XSection iSection;
        protected XSubpart iSubpart;
        protected String iRequires;

        public TableSectionLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(request, course, url);
            this.iCourse = course;
            this.iSubpart = subpart;
            this.iSection = section;
            this.iRequires = requires;
        }

        public String getType() {
            return this.iSection.getSubpartName();
        }

        public String getName() {
            return this.iSection.getName(this.iCourse.getCourseId());
        }

        public XSection getSection() {
            return this.iSection;
        }

        public XSubpart getSubpart() {
            return this.iSubpart;
        }

        public String getRequires() {
            return this.iRequires;
        }

        public String getNote() {
            return this.iSection.getNote();
        }

        public String getCourseNote() {
            return this.iCourse.getNote();
        }

        public String getCredit() {
            return this.iSubpart == null ? null : this.iSubpart.getCreditAbbv(this.iCourse.getCourseId());
        }

        public XTime getTime() {
            return this.iSection.getTime();
        }

        public boolean isAssigned() {
            return true;
        }

        public String getRooms() {
            String rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!rooms.isEmpty()) {
                        rooms = rooms + ", ";
                    }
                    rooms = rooms + room.getName();
                }
            }
            return rooms;
        }

        public String getInstructors() {
            String instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!instructors.isEmpty()) {
                        instructors = instructors + ", ";
                    }
                    if (instructor.getEmail() == null) {
                        instructors = instructors + "<span style='white-space: nowrap;'>" + instructor.getName() + "</span>";
                        continue;
                    }
                    instructors = instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none; white-space: nowrap;\">" + instructor.getName() + "</a>";
                }
            }
            return instructors;
        }

        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        public String getDate() {
            return this.getTime().getDatePatternName();
        }
    }

    public static class TableCourseLine
    implements TableLine {
        protected XCourseRequest iRequest;
        protected XCourse iCourse;
        protected Table iTable;
        protected String iUrl;

        public TableCourseLine(XCourseRequest request, XCourse course, URL url) {
            this.iRequest = request;
            this.iCourse = course;
            this.iUrl = url == null ? null : url.toString();
        }

        public XRequest getRequest() {
            return this.iRequest;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public String getSubject() {
            return this.getCourse().getSubjectArea();
        }

        public String getCourseNumber() {
            return this.getCourse().getCourseNumber();
        }

        public String getCourseTitle() {
            return this.getCourse().getTitle();
        }

        public String getType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public XTime getTime() {
            return null;
        }

        public boolean isAssigned() {
            return false;
        }

        public String getCredit() {
            return null;
        }

        public String getNote() {
            if (this.iRequest.isAlternative()) {
                return this.iRequest.isWaitlist() ? MSG.emailWaitListedAlternativeRequest() : MSG.emailNotEnrolledAlternativeRequest();
            }
            return this.iRequest.isWaitlist() ? MSG.emailWaitListedRequest() : MSG.emailNotEnrolledRequest();
        }

        public String getCourseNote() {
            return null;
        }

        public String getRequires() {
            return null;
        }

        public String getRooms() {
            return null;
        }

        public String getInstructors() {
            return null;
        }

        public boolean isFreeTime() {
            return false;
        }

        public String getArrangeHours() {
            return null;
        }

        public String getDays() {
            return null;
        }

        public String getStart() {
            return null;
        }

        public String getEnd() {
            return null;
        }

        public String getDate() {
            return null;
        }

        public void setTable(Table table) {
            this.iTable = table;
        }

        public boolean isLast() {
            return this.iTable.isLast(this);
        }

        public boolean isFirst() {
            return this.iTable.isFirst(this);
        }

        public String getUrl() {
            return this.iUrl;
        }
    }

    public static interface TableLine {
        public XRequest getRequest();

        public String getSubject();

        public String getCourseNumber();

        public String getCourseTitle();

        public String getType();

        public String getName();

        public String getUrl();

        public XTime getTime();

        public String getRooms();

        public String getInstructors();

        public boolean isAssigned();

        public boolean isFreeTime();

        public String getArrangeHours();

        public String getDays();

        public String getStart();

        public String getEnd();

        public String getDate();

        public String getCredit();

        public String getNote();

        public String getCourseNote();

        public String getRequires();

        public void setTable(Table var1);

        public boolean isLast();

        public boolean isFirst();
    }
}

