/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEnrollments
implements OnlineSectioningAction<List<ClassAssignmentInterface.Enrollment>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iOfferingId;
    private Long iSectionId;
    private boolean iCanShowExtIds = false;
    private boolean iCanRegister = false;
    private boolean iCanUseAssistant = false;

    public ListEnrollments forOffering(Long offeringId) {
        this.iOfferingId = offeringId;
        return this;
    }

    public ListEnrollments withSection(Long sectionId) {
        this.iSectionId = sectionId;
        return this;
    }

    public ListEnrollments canShowExternalIds(boolean canShowExtIds) {
        this.iCanShowExtIds = canShowExtIds;
        return this;
    }

    public ListEnrollments canRegister(boolean canRegister) {
        this.iCanRegister = canRegister;
        return this;
    }

    public ListEnrollments canUseAssistant(boolean canUseAssistant) {
        this.iCanUseAssistant = canUseAssistant;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassAssignmentInterface.Enrollment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            ArrayList<ClassAssignmentInterface.Enrollment> enrollments = new ArrayList<ClassAssignmentInterface.Enrollment>();
            XOffering offering = server.getOffering(this.iOfferingId);
            DistanceMetric m = server.getDistanceMetric();
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
            XExpectations expectations = server.getExpectations(this.iOfferingId);
            XEnrollments requests = server.getEnrollments(this.iOfferingId);
            for (XCourseRequest request : requests.getRequests()) {
                XEnrollment enrollment = request.getEnrollment();
                if (this.iSectionId != null && (enrollment == null || !enrollment.getSectionIds().contains(this.iSectionId))) continue;
                for (XCourse course : offering.getCourses()) {
                    if (!request.getCourseIds().contains(course) || enrollment != null && !course.getCourseId().equals(enrollment.getCourseId())) continue;
                    XStudent student = server.getStudent(request.getStudentId());
                    if (enrollment == null && !student.canAssign(request)) continue;
                    ClassAssignmentInterface.Enrollment e = new ClassAssignmentInterface.Enrollment();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    st.setId(student.getStudentId());
                    st.setSessionId(server.getAcademicSession().getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setCanRegister(this.iCanRegister);
                    st.setCanUseAssistant(this.iCanUseAssistant);
                    st.setName(student.getName());
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        st.addArea(acm.getArea());
                        st.addClassification(acm.getClassification());
                        st.addMajor(acm.getMajor());
                    }
                    for (String ac : student.getAccomodations()) {
                        st.addAccommodation(ac);
                    }
                    for (String gr : student.getGroups()) {
                        st.addGroup(gr);
                    }
                    e.setStudent(st);
                    e.setPriority(1 + request.getPriority());
                    ClassAssignmentInterface.CourseAssignment c = new ClassAssignmentInterface.CourseAssignment();
                    c.setCourseId(course.getCourseId());
                    c.setSubject(course.getSubjectArea());
                    c.setCourseNbr(course.getCourseNumber());
                    c.setTitle(course.getTitle());
                    c.setHasCrossList(offering.hasCrossList());
                    e.setCourse(c);
                    e.setWaitList(request.isWaitlist());
                    if (!request.getCourseIds().get(0).equals(course)) {
                        e.setAlternative(request.getCourseIds().get(0).getCourseName());
                    }
                    if (request.isAlternative()) {
                        for (XRequest r : student.getRequests()) {
                            if (!(r instanceof XCourseRequest) || r.isAlternative() || ((XCourseRequest)r).getEnrollment() != null) continue;
                            e.setAlternative(((XCourseRequest)r).getCourseIds().get(0).getCourseName());
                        }
                    }
                    if (request.getTimeStamp() != null) {
                        e.setRequestedDate(request.getTimeStamp());
                    }
                    if (enrollment == null) {
                        e.setEnrollmentMessage(request.getEnrollmentMessage());
                    }
                    if (enrollment != null) {
                        if (enrollment.getReservation() != null) {
                            switch (enrollment.getReservation().getType()) {
                                case Course: {
                                    e.setReservation(MSG.reservationCourse());
                                    break;
                                }
                                case Curriculum: {
                                    e.setReservation(MSG.reservationCurriculum());
                                    break;
                                }
                                case Group: {
                                    e.setReservation(MSG.reservationGroup());
                                    break;
                                }
                                case Individual: {
                                    e.setReservation(MSG.reservationIndividual());
                                }
                            }
                        }
                        e.setEnrolledDate(request.getEnrollment().getTimeStamp());
                        if (request.getEnrollment().getApproval() != null) {
                            e.setApprovedDate(request.getEnrollment().getApproval().getTimeStamp());
                            e.setApprovedBy(request.getEnrollment().getApproval().getName());
                        }
                        for (Long sectionId : request.getEnrollment().getSectionIds()) {
                            String consent;
                            XSection section = offering.getSection(sectionId);
                            ClassAssignmentInterface.ClassAssignment a = e.getCourse().addClassAssignment();
                            a.setAlternative(request.isAlternative());
                            a.setClassId(section.getSectionId());
                            XSubpart subpart = offering.getSubpart(section.getSubpartId());
                            a.setSubpart(subpart.getName());
                            a.setSection(section.getName(course.getCourseId()));
                            a.setClassNumber(section.getName(-1L));
                            a.setCancelled(section.isCancelled());
                            a.setLimit(new int[]{requests.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                            if (section.getTime() != null) {
                                for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                    a.addDay(d.getIndex());
                                }
                                a.setStart(section.getTime().getSlot());
                                a.setLength(section.getTime().getLength());
                                a.setBreakTime(section.getTime().getBreakTime());
                                a.setDatePattern(section.getTime().getDatePatternName());
                            }
                            for (XRoom rm : section.getRooms()) {
                                a.addRoom(rm.getUniqueId(), rm.getName());
                            }
                            for (XInstructor instructor : section.getInstructors()) {
                                a.addInstructor(instructor.getName());
                                a.addInstructor(instructor.getEmail() == null ? "" : instructor.getEmail());
                            }
                            if (section.getParentId() != null) {
                                a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                            }
                            a.setSubpartId(section.getSubpartId());
                            a.addNote(course.getNote());
                            a.addNote(section.getNote());
                            a.setCredit(subpart.getCredit(course.getCourseId()));
                            int dist = 0;
                            String from = null;
                            TreeSet<String> overlap = new TreeSet<String>();
                            for (XRequest q : student.getRequests()) {
                                XEnrollment otherEnrollment;
                                if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                                XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                    if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                    int d = otherSection.getDistanceInMinutes(section, m);
                                    if (d > dist) {
                                        dist = d;
                                        from = "";
                                        Iterator<XRoom> k = otherSection.getRooms().iterator();
                                        while (k.hasNext()) {
                                            from = from + k.next().getName() + (k.hasNext() ? ", " : "");
                                        }
                                    }
                                    if (d > otherSection.getTime().getBreakTime()) {
                                        a.setDistanceConflict(true);
                                    }
                                    if (section.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                                    XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                    XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                    overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                                }
                            }
                            if (!overlap.isEmpty()) {
                                String note = null;
                                Iterator j = overlap.iterator();
                                while (j.hasNext()) {
                                    String n = (String)j.next();
                                    if (note == null) {
                                        note = MSG.noteAllowedOverlapFirst(n);
                                        continue;
                                    }
                                    if (j.hasNext()) {
                                        note = note + MSG.noteAllowedOverlapMiddle(n);
                                        continue;
                                    }
                                    note = note + MSG.noteAllowedOverlapLast(n);
                                }
                                a.setOverlapNote(note);
                            }
                            a.setBackToBackDistance(dist);
                            a.setBackToBackRooms(from);
                            a.setSaved(true);
                            if (a.getParentSection() == null && (consent = server.getCourse(course.getCourseId()).getConsentLabel()) != null) {
                                if (request.getEnrollment().getApproval() != null) {
                                    a.setParentSection(MSG.consentApproved(df.format(request.getEnrollment().getApproval().getTimeStamp())));
                                } else {
                                    a.setParentSection(MSG.consentWaiting(consent.toLowerCase()));
                                }
                            }
                            a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                        }
                    }
                    enrollments.add(e);
                }
            }
            ArrayList<ClassAssignmentInterface.Enrollment> arrayList = enrollments;
            Object var38_38 = null;
            lock.release();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var38_39 = null;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public String name() {
        return "list-enrollments";
    }
}

