/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAssignment
implements OnlineSectioningAction<ClassAssignmentInterface> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private Long iStudentId;
    private List<StudentEnrollmentProvider.EnrollmentFailure> iMessages;
    private boolean iIncludeRequest = false;

    public GetAssignment forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public GetAssignment withMessages(List<StudentEnrollmentProvider.EnrollmentFailure> messages) {
        this.iMessages = messages;
        return this;
    }

    public GetAssignment withRequest(boolean includeRequest) {
        this.iIncludeRequest = includeRequest;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student;
        OnlineSectioningLog.Action.Builder action;
        OverExpectedCriterion overExp;
        DistanceMetric m;
        Formats.Format<Date> df;
        OnlineSectioningServer.Lock lock;
        block82: {
            lock = server.readLock();
            df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
            m = server.getDistanceMetric();
            overExp = server.getOverExpectedCriterion();
            action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
            student = server.getStudent(this.iStudentId);
            if (student != null) break block82;
            ClassAssignmentInterface classAssignmentInterface = null;
            Object var44_11 = null;
            lock.release();
            return classAssignmentInterface;
        }
        try {
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
            ClassAssignmentInterface ret = new ClassAssignmentInterface();
            int nrUnassignedCourses = 0;
            int nrAssignedAlt = 0;
            OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
            stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
            boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
            if (!setReadOnly && helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
                setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
            }
            List<CourseSection> unavailabilities = GetAssignment.fillUnavailabilitiesIn(ret, student, server, helper, stored);
            for (XRequest xRequest : student.getRequests()) {
                XRequest r;
                action.addRequest(OnlineSectioningHelper.toProto(xRequest));
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                if (xRequest instanceof XCourseRequest) {
                    r = (XCourseRequest)xRequest;
                    XEnrollment enrollment = ((XCourseRequest)r).getEnrollment();
                    XEnrollment xEnrollment = enrollment == null ? ((XCourseRequest)r).getCourseIds().get(0) : enrollment;
                    XOffering offering = server.getOffering(xEnrollment.getOfferingId());
                    XExpectations expectations = server.getExpectations(xEnrollment.getOfferingId());
                    Iterator<DayCode> course = offering.getCourse(xEnrollment);
                    if (xRequest.isAlternative() && nrAssignedAlt >= nrUnassignedCourses && enrollment == null) continue;
                    if (xRequest.isAlternative() && enrollment != null) {
                        ++nrAssignedAlt;
                    }
                    if (server.isOfferingLocked(((XCourseId)((Object)course)).getOfferingId())) {
                        ca.setLocked(true);
                    }
                    ca.setAssigned(enrollment != null);
                    ca.setCourseId(((XCourseId)((Object)course)).getCourseId());
                    ca.setSubject(((XCourse)((Object)course)).getSubjectArea());
                    ca.setWaitListed(((XCourseRequest)r).isWaitlist());
                    ca.setCourseNbr(((XCourse)((Object)course)).getCourseNumber());
                    ca.setTitle(((XCourseId)((Object)course)).getTitle());
                    ca.setEnrollmentMessage(((XCourseRequest)r).getEnrollmentMessage());
                    ca.setRequestedDate(((XCourseRequest)r).getTimeStamp());
                    ca.setHasCrossList(offering.hasCrossList());
                    if (enrollment == null) {
                        TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                            @Override
                            public int compare(Enrollment o1, Enrollment o2) {
                                return o1.getRequest().compareTo(o2.getRequest());
                            }
                        });
                        Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                        AssignmentMap assignment = new AssignmentMap();
                        List list = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, (XCourseRequest)r, server).getAvaiableEnrollmentsSkipSameTime((Assignment)assignment);
                        for (Enrollment enrl2 : list) {
                            for (Request q : enrl2.getStudent().getRequests()) {
                                Enrollment x;
                                if (q.equals((Object)xRequest) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                for (SctAssignment a : x.getAssignments()) {
                                    if (!a.isOverlapping(enrl2.getAssignments())) continue;
                                    overlap.add(x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    CourseRequest cr = (CourseRequest)x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a);
                                }
                            }
                        }
                        for (Enrollment q : overlap) {
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = ov + ",";
                                }
                            }
                            ca.addOverlap(ov);
                        }
                        if (list.isEmpty()) {
                            ca.setNotAvailable(true);
                            if (((XCourse)((Object)course)).getLimit() >= 0) {
                                Collection<XCourseRequest> requests = server.getRequests(((XCourseId)((Object)course)).getOfferingId());
                                int enrl3 = 0;
                                if (requests != null) {
                                    for (XCourseRequest x : requests) {
                                        if (x.getEnrollment() == null || !x.getEnrollment().getCourseId().equals(((XCourseId)((Object)course)).getCourseId())) continue;
                                        ++enrl3;
                                    }
                                }
                                ca.setFull(enrl3 >= ((XCourse)((Object)course)).getLimit());
                            }
                        }
                        if (!((XCourseRequest)r).isWaitlist()) {
                            // empty if block
                        }
                        int alt = ++nrUnassignedCourses;
                        for (XRequest q : student.getRequests()) {
                            XEnrollment otherEnrollment;
                            if (!(q instanceof XCourseRequest) || q.equals(xRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null || !q.isAlternative() || --alt != 0) continue;
                            XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                            XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                            ca.setInstead(MSG.course(otherCourse.getSubjectArea(), otherCourse.getCourseNumber()));
                            break;
                        }
                    } else {
                        List<XSection> sections = offering.getSections(enrollment);
                        boolean hasAlt = false;
                        if (((XCourseRequest)r).getCourseIds().size() > 1) {
                            hasAlt = true;
                        } else if (offering.getConfigs().size() > 1) {
                            hasAlt = true;
                        } else {
                            for (XSubpart xSubpart : offering.getConfigs().get(0).getSubparts()) {
                                if (xSubpart.getSections().size() <= 1) continue;
                                hasAlt = true;
                                break;
                            }
                        }
                        XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                        for (XSection section : sections) {
                            String consent;
                            stored.addSection(OnlineSectioningHelper.toProto(section, enrollment));
                            ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                            a.setAlternative(r.isAlternative());
                            a.setClassId(section.getSectionId());
                            XSubpart subpart3 = offering.getSubpart(section.getSubpartId());
                            a.setSubpart(subpart3.getName());
                            a.setClassNumber(section.getName(-1L));
                            a.setSection(section.getName(((XCourseId)((Object)course)).getCourseId()));
                            a.setCancelled(section.isCancelled());
                            a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                            if (section.getTime() != null) {
                                for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                    a.addDay(d.getIndex());
                                }
                                a.setStart(section.getTime().getSlot());
                                a.setLength(section.getTime().getLength());
                                a.setBreakTime(section.getTime().getBreakTime());
                                a.setDatePattern(section.getTime().getDatePatternName());
                            }
                            if (section.getRooms() != null) {
                                for (XRoom room : section.getRooms()) {
                                    a.addRoom(room.getUniqueId(), room.getName());
                                }
                            }
                            for (XInstructor instructor : section.getInstructors()) {
                                a.addInstructor(instructor.getName());
                                a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                            }
                            if (section.getParentId() != null) {
                                a.setParentSection(offering.getSection(section.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                            }
                            a.setSubpartId(section.getSubpartId());
                            a.setHasAlternatives(hasAlt);
                            a.addNote(((XCourse)((Object)course)).getNote());
                            a.addNote(section.getNote());
                            a.setCredit(subpart3.getCredit(((XCourseId)((Object)course)).getCourseId()));
                            a.setEnrolledDate(enrollment.getTimeStamp());
                            int dist = 0;
                            String from = null;
                            TreeSet<String> overlap = new TreeSet<String>();
                            for (XRequest q : student.getRequests()) {
                                XEnrollment otherEnrollment;
                                if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                                XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                    if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                    int d = otherSection.getDistanceInMinutes(section, m);
                                    if (d > dist) {
                                        dist = d;
                                        from = "";
                                        Iterator<XRoom> k = otherSection.getRooms().iterator();
                                        while (k.hasNext()) {
                                            from = from + k.next().getName() + (k.hasNext() ? ", " : "");
                                        }
                                    }
                                    if (d > otherSection.getTime().getBreakTime()) {
                                        a.setDistanceConflict(true);
                                    }
                                    if (section.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                                    XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                    XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                    overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                                }
                            }
                            if (unavailabilities != null) {
                                for (CourseSection cs : unavailabilities) {
                                    if (section.getTime() == null || !section.getTime().hasIntersection(cs.getSection().getTime())) continue;
                                    overlap.add(MSG.teachingAssignment(MSG.clazz(cs.getCourse().getSubjectArea(), cs.getCourse().getCourseNumber(), cs.getSection().getSubpartName(), cs.getSection().getName(cs.getCourse().getCourseId()))));
                                }
                            }
                            if (!overlap.isEmpty()) {
                                String note = null;
                                Iterator j = overlap.iterator();
                                while (j.hasNext()) {
                                    String n = (String)j.next();
                                    if (note == null) {
                                        note = MSG.noteAllowedOverlapFirst(n);
                                        continue;
                                    }
                                    if (j.hasNext()) {
                                        note = note + MSG.noteAllowedOverlapMiddle(n);
                                        continue;
                                    }
                                    note = note + MSG.noteAllowedOverlapLast(n);
                                }
                                a.setOverlapNote(note);
                            }
                            a.setBackToBackDistance(dist);
                            a.setBackToBackRooms(from);
                            a.setSaved(true);
                            if (a.getParentSection() == null && (consent = server.getCourse(((XCourseId)((Object)course)).getCourseId()).getConsentLabel()) != null) {
                                if (enrollment.getApproval() != null) {
                                    a.setParentSection(MSG.consentApproved(df.format(enrollment.getApproval().getTimeStamp())));
                                } else {
                                    a.setParentSection(MSG.consentWaiting(consent.toLowerCase()));
                                }
                            }
                            a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                        }
                    }
                    if (this.iMessages != null) {
                        XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                        block21: for (StudentEnrollmentProvider.EnrollmentFailure f : this.iMessages) {
                            XSection xSection = f.getSection();
                            if (!f.getCourse().getCourseId().equals(ca.getCourseId())) continue;
                            for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                                if (!f.getSection().getSectionId().equals(a.getClassId())) continue;
                                a.setError(f.getMessage());
                                continue block21;
                            }
                            ca.setAssigned(true);
                            ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                            a.setAlternative(r.isAlternative());
                            a.setClassId(xSection.getSectionId());
                            XSubpart subpart = offering.getSubpart(xSection.getSubpartId());
                            a.setSubpart(subpart.getName());
                            a.setClassNumber(xSection.getName(-1L));
                            a.setSection(xSection.getName(((XCourseId)((Object)course)).getCourseId()));
                            a.setCancelled(xSection.isCancelled());
                            a.setLimit(new int[]{enrollments.countEnrollmentsForSection(xSection.getSectionId()), xSection.getLimit()});
                            if (xSection.getTime() != null) {
                                for (DayCode d : DayCode.toDayCodes(xSection.getTime().getDays())) {
                                    a.addDay(d.getIndex());
                                }
                                a.setStart(xSection.getTime().getSlot());
                                a.setLength(xSection.getTime().getLength());
                                a.setBreakTime(xSection.getTime().getBreakTime());
                                a.setDatePattern(xSection.getTime().getDatePatternName());
                            }
                            if (xSection.getRooms() != null) {
                                for (XRoom room : xSection.getRooms()) {
                                    a.addRoom(room.getUniqueId(), room.getName());
                                }
                            }
                            for (XInstructor instructor : xSection.getInstructors()) {
                                a.addInstructor(instructor.getName());
                                a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                            }
                            if (xSection.getParentId() != null) {
                                a.setParentSection(offering.getSection(xSection.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                            }
                            a.setSubpartId(xSection.getSubpartId());
                            a.addNote(((XCourse)((Object)course)).getNote());
                            a.addNote(xSection.getNote());
                            a.setCredit(subpart.getCredit(((XCourseId)((Object)course)).getCourseId()));
                            int dist = 0;
                            String from = null;
                            a.setBackToBackDistance(dist);
                            a.setBackToBackRooms(from);
                            a.setSaved(false);
                            a.setDummy(true);
                            a.setError(f.getMessage());
                            a.setExpected(overExp.getExpected(xSection.getLimit(), expectations.getExpectedSpace(xSection.getSectionId()).doubleValue()));
                        }
                    }
                } else if (xRequest instanceof XFreeTimeRequest) {
                    r = (XFreeTimeRequest)xRequest;
                    ca.setCourseId(null);
                    for (XRequest xRequest2 : student.getRequests()) {
                        XEnrollment otherEnrollment;
                        if (!(xRequest2 instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)xRequest2).getEnrollment()) == null) continue;
                        XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                        for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                            if (otherSection.getTime() == null || !otherSection.getTime().hasIntersection(((XFreeTimeRequest)r).getTime())) continue;
                            XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                            XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                            ca.addOverlap(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                        }
                    }
                    ca.setAssigned(ca.getOverlaps() == null);
                    ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                    a.setAlternative(r.isAlternative());
                    for (DayCode d : DayCode.toDayCodes(((XFreeTimeRequest)r).getTime().getDays())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(((XFreeTimeRequest)r).getTime().getSlot());
                    a.setLength(((XFreeTimeRequest)r).getTime().getLength());
                }
                ret.add(ca);
            }
            action.addEnrollment(stored);
            if (this.iMessages != null) {
                HashSet<String> added = new HashSet<String>();
                for (StudentEnrollmentProvider.EnrollmentFailure f : this.iMessages) {
                    for (String fm : f.getMessage().split("\n")) {
                        String message = MSG.clazz(f.getCourse().getSubjectArea(), f.getCourse().getCourseNumber(), f.getSection().getSubpartName(), f.getSection().getName(f.getCourse().getCourseId())) + ": " + (String)fm;
                        if (!added.add(message)) continue;
                        ret.addMessage(message);
                    }
                }
            }
            if (this.iIncludeRequest) {
                CourseRequestInterface request = new CourseRequestInterface();
                request.setStudentId(this.iStudentId);
                request.setSaved(true);
                request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
                Object var16_23 = null;
                int lastRequestPriority = -1;
                for (XRequest cd : student.getRequests()) {
                    Object var20_40 = null;
                    if (cd instanceof XFreeTimeRequest) {
                        void var16_24;
                        XFreeTimeRequest ftr = (XFreeTimeRequest)cd;
                        CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                        ft.setStart(ftr.getTime().getSlot());
                        ft.setLength(ftr.getTime().getLength());
                        for (DayCode day : DayCode.toDayCodes(ftr.getTime().getDays())) {
                            ft.addDay(day.getIndex());
                        }
                        if (var16_24 != null && lastRequestPriority == cd.getPriority() && var16_24.hasRequestedCourse() && var16_24.getRequestedCourse(0).isFreeTime()) {
                            var16_24.getRequestedCourse(0).addFreeTime(ft);
                        } else {
                            CourseRequestInterface.Request request2 = new CourseRequestInterface.Request();
                            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                            request2.addRequestedCourse(rc);
                            rc.addFreeTime(ft);
                            if (cd.isAlternative()) {
                                request.getAlternatives().add(request2);
                            } else {
                                request.getCourses().add(request2);
                            }
                            CourseRequestInterface.Request request3 = request2;
                            lastRequestPriority = cd.getPriority();
                        }
                    } else if (cd instanceof XCourseRequest) {
                        CourseRequestInterface.Request request4 = new CourseRequestInterface.Request();
                        for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                            XCourse c = server.getCourse(courseId.getCourseId());
                            if (c == null) continue;
                            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                            rc.setCourseId(c.getCourseId());
                            rc.setCourseName(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                            if (setReadOnly && ((XCourseRequest)cd).getEnrollment() != null && c.getCourseId().equals(((XCourseRequest)cd).getEnrollment().getCourseId())) {
                                rc.setReadOnly(true);
                            }
                            OnlineSectioningHelper.fillPreferencesIn(rc, ((XCourseRequest)cd).getPreferences(courseId));
                            request4.addRequestedCourse(rc);
                        }
                        request4.setWaitList(((XCourseRequest)cd).isWaitlist());
                        if (request4.hasRequestedCourse()) {
                            if (cd.isAlternative()) {
                                request.getAlternatives().add(request4);
                            } else {
                                request.getCourses().add(request4);
                            }
                        }
                        CourseRequestInterface.Request request5 = request4;
                        lastRequestPriority = cd.getPriority();
                    }
                    action.addRequest(OnlineSectioningHelper.toProto(cd));
                }
                ret.setRequest(request);
            }
            ClassAssignmentInterface classAssignmentInterface = ret;
            Object var44_12 = null;
            lock.release();
            return classAssignmentInterface;
        }
        catch (Throwable throwable) {
            Object var44_13 = null;
            lock.release();
            throw throwable;
        }
    }

    public static List<CourseSection> fillUnavailabilitiesIn(ClassAssignmentInterface ret, XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningLog.Enrollment.Builder eb) {
        if (student.getExternalId() == null || student.getExternalId().isEmpty()) {
            return null;
        }
        ArrayList<CourseSection> sections = new ArrayList<CourseSection>();
        Collection<Long> offeringIds = server.getInstructedOfferings(student.getExternalId());
        if (offeringIds != null && !offeringIds.isEmpty()) {
            TreeSet<XOffering> offerings = new TreeSet<XOffering>(new Comparator<XOffering>(){

                @Override
                public int compare(XOffering o1, XOffering o2) {
                    int cmp = o1.getName().compareTo(o2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return o1.getOfferingId().compareTo(o2.getOfferingId());
                }
            });
            for (Long offeringId : offeringIds) {
                XOffering offering = server.getOffering(offeringId);
                if (offering == null) continue;
                offerings.add(offering);
            }
            for (XOffering offering : offerings) {
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                XCourse course = offering.getControllingCourse();
                XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                if (server.isOfferingLocked(course.getOfferingId())) {
                    ca.setLocked(true);
                }
                ca.setAssigned(true);
                ca.setCourseId(course.getCourseId());
                ca.setSubject(course.getSubjectArea());
                ca.setWaitListed(false);
                ca.setCourseNbr(course.getCourseNumber());
                ca.setTitle(course.getTitle());
                ca.setTeachingAssignment(true);
                ca.setHasCrossList(offering.hasCrossList());
                HashSet<Long> added = new HashSet<Long>();
                for (XConfig config : offering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            if (section.isCancelled()) continue;
                            for (XInstructor instructor : section.getAllInstructors()) {
                                if (!student.getExternalId().equals(instructor.getExternalId()) || !added.add(section.getSectionId())) continue;
                                if (eb != null) {
                                    eb.addSection(OnlineSectioningHelper.toProto(section, null));
                                }
                                ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                                a.setAlternative(false);
                                a.setClassId(section.getSectionId());
                                a.setSubpart(subpart.getName());
                                a.setClassNumber(section.getName(-1L));
                                a.setSection(section.getName(course.getCourseId()));
                                a.setCancelled(section.isCancelled());
                                a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                                if (section.getTime() != null) {
                                    for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                        a.addDay(d.getIndex());
                                    }
                                    a.setStart(section.getTime().getSlot());
                                    a.setLength(section.getTime().getLength());
                                    a.setBreakTime(section.getTime().getBreakTime());
                                    a.setDatePattern(section.getTime().getDatePatternName());
                                }
                                if (section.getRooms() != null) {
                                    for (XRoom room : section.getRooms()) {
                                        a.addRoom(room.getUniqueId(), room.getName());
                                    }
                                }
                                for (XInstructor instr : section.getInstructors()) {
                                    a.addInstructor(instr.getName());
                                    a.addInstructoEmail(instr.getEmail() == null ? "" : instr.getEmail());
                                }
                                if (section.getParentId() != null) {
                                    a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                                }
                                a.setSubpartId(section.getSubpartId());
                                a.setHasAlternatives(false);
                                a.addNote(course.getNote());
                                a.addNote(section.getNote());
                                a.setCredit(subpart.getCredit(course.getCourseId()));
                                a.setTeachingAssignment(true);
                                a.setInstructing(instructor.isInstructing());
                                sections.add(new CourseSection(course, section));
                            }
                        }
                    }
                }
                ret.add(ca);
            }
        }
        return sections;
    }

    @Override
    public String name() {
        return "get-assignment";
    }

    public static class CourseSection {
        XCourse iCourse;
        XSection iSection;

        CourseSection(XCourse course, XSection section) {
            this.iCourse = course;
            this.iSection = section;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public XSection getSection() {
            return this.iSection;
        }
    }
}

