/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLock {
    private Log iLog = LogFactory.getLog(MultiLock.class);
    private Lock iLock = new ReentrantLock();
    private Condition iAllLocked = null;
    private Map<Long, Condition> iIndividualLocks = new HashMap<Long, Condition>();

    public MultiLock() {
        this.iLog = LogFactory.getLog((String)(MultiLock.class.getName() + ".lock"));
    }

    public MultiLock(AcademicSessionInfo session) {
        this.iLog = LogFactory.getLog((String)(MultiLock.class.getName() + ".lock[" + session.toCompactString() + "]"));
    }

    private Condition hasLock(Collection<Long> ids) {
        if (this.iAllLocked != null) {
            return this.iAllLocked;
        }
        for (Long id : ids) {
            Condition c = this.iIndividualLocks.get(id);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Unlock lock(Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.lock(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnlockAll lockAll() {
        this.iLock.lock();
        try {
            this.iLog.debug((Object)"Locking all ...");
            while (this.iAllLocked != null) {
                this.iAllLocked.awaitUninterruptibly();
            }
            this.iAllLocked = this.iLock.newCondition();
            while (!this.iIndividualLocks.isEmpty()) {
                Condition otherCondition = this.iIndividualLocks.values().iterator().next();
                otherCondition.awaitUninterruptibly();
            }
            this.iLog.debug((Object)"Locked: all");
            UnlockAll unlockAll = new UnlockAll();
            Object var3_2 = null;
            this.iLock.unlock();
            return unlockAll;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() {
        this.iLock.lock();
        try {
            this.iLog.debug((Object)"Unlocking all ...");
            Condition allLocked = this.iAllLocked;
            this.iAllLocked = null;
            allLocked.signalAll();
            this.iLog.debug((Object)"Unlocked: all");
            Object var3_2 = null;
            this.iLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unlock lock(Collection<Long> ids) {
        block5: {
            this.iLock.lock();
            if (ids != null && !ids.isEmpty()) break block5;
            Unlock unlock = new Unlock(ids);
            Object var7_4 = null;
            this.iLock.unlock();
            return unlock;
        }
        try {
            this.iLog.debug((Object)("Locking " + ids + " ..."));
            Condition otherCondition = null;
            while ((otherCondition = this.hasLock(ids)) != null) {
                otherCondition.awaitUninterruptibly();
            }
            Condition myCondition = this.iLock.newCondition();
            for (Long id : ids) {
                this.iIndividualLocks.put(id, myCondition);
            }
            this.iLog.debug((Object)("Locked: " + ids));
            Unlock unlock = new Unlock(ids);
            Object var7_5 = null;
            this.iLock.unlock();
            return unlock;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Collection<Long> ids) {
        this.iLock.lock();
        try {
            block8: {
                block7: {
                    if (ids == null) break block7;
                    if (!ids.isEmpty()) break block8;
                }
                Object var6_2 = null;
                this.iLock.unlock();
                return;
            }
            this.iLog.debug((Object)("Unlocking " + ids + " ..."));
            Condition myCondition = null;
            for (Long id : ids) {
                myCondition = this.iIndividualLocks.remove(id);
            }
            if (myCondition != null) {
                myCondition.signalAll();
            }
            this.iLog.debug((Object)("Unlocked: " + ids));
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.iLock.unlock();
            throw throwable;
        }
        Object var6_3 = null;
        this.iLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> locked() {
        this.iLock.lock();
        try {
            TreeSet<Long> treeSet = new TreeSet<Long>(this.iIndividualLocks.keySet());
            Object var3_2 = null;
            this.iLock.unlock();
            return treeSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(Long id) {
        this.iLock.lock();
        try {
            boolean bl = this.iIndividualLocks.containsKey(id);
            Object var4_3 = null;
            this.iLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            Thread t;
            int i;
            final MultiLock lock = new MultiLock();
            for (i = 1; i <= 1000; ++i) {
                t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                int nrCourses = 2 + ToolBox.random((int)9);
                                HashSet<Long> courses = new HashSet<Long>();
                                String s = "";
                                for (int i = 0; i < nrCourses; ++i) {
                                    long courseId;
                                    while (!courses.add(courseId = (long)ToolBox.random((int)10000))) {
                                    }
                                    s = s + (i > 0 ? ", " : "") + courseId;
                                }
                                System.out.println(Thread.currentThread().getName() + "Locking: [" + s + "]");
                                Unlock l = lock.lock(courses);
                                System.out.println(Thread.currentThread().getName() + "Locked: [" + s + "]");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Unlocking: [" + s + "]");
                                l.release();
                                System.out.println(Thread.currentThread().getName() + "Unlocked: [" + s + "]");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                t.setName("[T" + i + "]: ");
                t.start();
            }
            for (i = 1; i <= 3; ++i) {
                t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                try {
                                    Thread.sleep(ToolBox.random((int)5000));
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Locking all...");
                                lock.lockAll();
                                System.out.println(Thread.currentThread().getName() + "All locked.");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Unlocking all.");
                                lock.unlockAll();
                                System.out.println(Thread.currentThread().getName() + "All unlocked.");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                t.setName("[A" + i + "]: ");
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class UnlockAll
    implements OnlineSectioningServer.Lock {
        private UnlockAll() {
        }

        public void release() {
            MultiLock.this.unlockAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Unlock
    implements OnlineSectioningServer.Lock {
        private Collection<Long> iIds;

        private Unlock(Collection<Long> ids) {
            this.iIds = ids;
        }

        @Override
        public void release() {
            MultiLock.this.unlock(this.iIds);
        }
    }
}

