/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSession
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iAcademicInitiative;
    private String iAcademicYear;
    private String iAcademicTerm;
    private Date iSessionBeginDateTime;
    private Date iClassesEndDateTime;
    private Date iSessionEndDateTime;
    private Date iExamBeginDate;
    private Date iEventBeginDate;
    private Date iEventEndDate;
    private String iHolidays;
    private Integer iLastWeekToEnroll;
    private Integer iLastWeekToChange;
    private Integer iLastWeekToDrop;
    private DepartmentStatusType iStatusType;
    private DatePattern iDefaultDatePattern;
    private StudentSectioningStatus iDefaultSectioningStatus;
    private ClassDurationType iDefaultClassDurationType;
    private Set<SubjectArea> iSubjectAreas;
    private Set<Building> iBuildings;
    private Set<Department> iDepartments;
    private Set<Location> iRooms;
    private Set<InstructionalOffering> iInstructionalOfferings;
    public static String PROP_ACADEMIC_INITIATIVE = "academicInitiative";
    public static String PROP_ACADEMIC_YEAR = "academicYear";
    public static String PROP_ACADEMIC_TERM = "academicTerm";
    public static String PROP_SESSION_BEGIN_DATE_TIME = "sessionBeginDateTime";
    public static String PROP_CLASSES_END_DATE_TIME = "classesEndDateTime";
    public static String PROP_SESSION_END_DATE_TIME = "sessionEndDateTime";
    public static String PROP_EXAM_BEGIN_DATE = "examBeginDate";
    public static String PROP_EVENT_BEGIN_DATE = "eventBeginDate";
    public static String PROP_EVENT_END_DATE = "eventEndDate";
    public static String PROP_HOLIDAYS = "holidays";
    public static String PROP_WK_ENROLL = "lastWeekToEnroll";
    public static String PROP_WK_CHANGE = "lastWeekToChange";
    public static String PROP_WK_DROP = "lastWeekToDrop";

    public BaseSession() {
        this.initialize();
    }

    public BaseSession(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getAcademicInitiative() {
        return this.iAcademicInitiative;
    }

    public void setAcademicInitiative(String academicInitiative) {
        this.iAcademicInitiative = academicInitiative;
    }

    public String getAcademicYear() {
        return this.iAcademicYear;
    }

    public void setAcademicYear(String academicYear) {
        this.iAcademicYear = academicYear;
    }

    public String getAcademicTerm() {
        return this.iAcademicTerm;
    }

    public void setAcademicTerm(String academicTerm) {
        this.iAcademicTerm = academicTerm;
    }

    public Date getSessionBeginDateTime() {
        return this.iSessionBeginDateTime;
    }

    public void setSessionBeginDateTime(Date sessionBeginDateTime) {
        this.iSessionBeginDateTime = sessionBeginDateTime;
    }

    public Date getClassesEndDateTime() {
        return this.iClassesEndDateTime;
    }

    public void setClassesEndDateTime(Date classesEndDateTime) {
        this.iClassesEndDateTime = classesEndDateTime;
    }

    public Date getSessionEndDateTime() {
        return this.iSessionEndDateTime;
    }

    public void setSessionEndDateTime(Date sessionEndDateTime) {
        this.iSessionEndDateTime = sessionEndDateTime;
    }

    public Date getExamBeginDate() {
        return this.iExamBeginDate;
    }

    public void setExamBeginDate(Date examBeginDate) {
        this.iExamBeginDate = examBeginDate;
    }

    public Date getEventBeginDate() {
        return this.iEventBeginDate;
    }

    public void setEventBeginDate(Date eventBeginDate) {
        this.iEventBeginDate = eventBeginDate;
    }

    public Date getEventEndDate() {
        return this.iEventEndDate;
    }

    public void setEventEndDate(Date eventEndDate) {
        this.iEventEndDate = eventEndDate;
    }

    public String getHolidays() {
        return this.iHolidays;
    }

    public void setHolidays(String holidays) {
        this.iHolidays = holidays;
    }

    public Integer getLastWeekToEnroll() {
        return this.iLastWeekToEnroll;
    }

    public void setLastWeekToEnroll(Integer lastWeekToEnroll) {
        this.iLastWeekToEnroll = lastWeekToEnroll;
    }

    public Integer getLastWeekToChange() {
        return this.iLastWeekToChange;
    }

    public void setLastWeekToChange(Integer lastWeekToChange) {
        this.iLastWeekToChange = lastWeekToChange;
    }

    public Integer getLastWeekToDrop() {
        return this.iLastWeekToDrop;
    }

    public void setLastWeekToDrop(Integer lastWeekToDrop) {
        this.iLastWeekToDrop = lastWeekToDrop;
    }

    public DepartmentStatusType getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(DepartmentStatusType statusType) {
        this.iStatusType = statusType;
    }

    public DatePattern getDefaultDatePattern() {
        return this.iDefaultDatePattern;
    }

    public void setDefaultDatePattern(DatePattern defaultDatePattern) {
        this.iDefaultDatePattern = defaultDatePattern;
    }

    public StudentSectioningStatus getDefaultSectioningStatus() {
        return this.iDefaultSectioningStatus;
    }

    public void setDefaultSectioningStatus(StudentSectioningStatus defaultSectioningStatus) {
        this.iDefaultSectioningStatus = defaultSectioningStatus;
    }

    public ClassDurationType getDefaultClassDurationType() {
        return this.iDefaultClassDurationType;
    }

    public void setDefaultClassDurationType(ClassDurationType defaultClassDurationType) {
        this.iDefaultClassDurationType = defaultClassDurationType;
    }

    public Set<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Set<SubjectArea> subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void addTosubjectAreas(SubjectArea subjectArea) {
        if (this.iSubjectAreas == null) {
            this.iSubjectAreas = new HashSet<SubjectArea>();
        }
        this.iSubjectAreas.add(subjectArea);
    }

    public Set<Building> getBuildings() {
        return this.iBuildings;
    }

    public void setBuildings(Set<Building> buildings) {
        this.iBuildings = buildings;
    }

    public void addTobuildings(Building building) {
        if (this.iBuildings == null) {
            this.iBuildings = new HashSet<Building>();
        }
        this.iBuildings.add(building);
    }

    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addTodepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addTorooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    public Set<InstructionalOffering> getInstructionalOfferings() {
        return this.iInstructionalOfferings;
    }

    public void setInstructionalOfferings(Set<InstructionalOffering> instructionalOfferings) {
        this.iInstructionalOfferings = instructionalOfferings;
    }

    public void addToinstructionalOfferings(InstructionalOffering instructionalOffering) {
        if (this.iInstructionalOfferings == null) {
            this.iInstructionalOfferings = new HashSet<InstructionalOffering>();
        }
        this.iInstructionalOfferings.add(instructionalOffering);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Session)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Session)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Session)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Session[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "Session[\n\tAcademicInitiative: " + this.getAcademicInitiative() + "\n\tAcademicTerm: " + this.getAcademicTerm() + "\n\tAcademicYear: " + this.getAcademicYear() + "\n\tClassesEndDateTime: " + this.getClassesEndDateTime() + "\n\tDefaultClassDurationType: " + this.getDefaultClassDurationType() + "\n\tDefaultDatePattern: " + this.getDefaultDatePattern() + "\n\tDefaultSectioningStatus: " + this.getDefaultSectioningStatus() + "\n\tEventBeginDate: " + this.getEventBeginDate() + "\n\tEventEndDate: " + this.getEventEndDate() + "\n\tExamBeginDate: " + this.getExamBeginDate() + "\n\tHolidays: " + this.getHolidays() + "\n\tLastWeekToChange: " + this.getLastWeekToChange() + "\n\tLastWeekToDrop: " + this.getLastWeekToDrop() + "\n\tLastWeekToEnroll: " + this.getLastWeekToEnroll() + "\n\tSessionBeginDateTime: " + this.getSessionBeginDateTime() + "\n\tSessionEndDateTime: " + this.getSessionEndDateTime() + "\n\tStatusType: " + this.getStatusType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

