/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.PeriodPreferencesWidget;
import org.unitime.timetable.gwt.client.rooms.RoomNoteChanges;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomDetail
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private RoomInterface.RoomDetailInterface iRoom = null;
    private RoomInterface.RoomsPageMode iMode = null;
    private int iLastScrollLeft;
    private int iLastScrollTop;

    public RoomDetail(RoomInterface.RoomsPageMode mode) {
        this.iMode = mode;
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("edit", MESSAGES.buttonEditRoom(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomDetail.this.edit();
            }
        });
        this.iHeader.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomInterface.RoomDetailInterface prev = RoomDetail.this.getPrevious(RoomDetail.this.getRoom().getUniqueId());
                if (prev != null) {
                    RoomDetail.this.previous(prev);
                }
            }
        });
        this.iHeader.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomInterface.RoomDetailInterface next = RoomDetail.this.getNext(RoomDetail.this.getRoom().getUniqueId());
                if (next != null) {
                    RoomDetail.this.next(next);
                }
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if ("1".equals(Window.Location.getParameter((String)"back"))) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "back.do");
                } else {
                    RoomDetail.this.hide();
                }
            }
        });
        this.iForm = new SimpleForm(3);
        this.iForm.addStyleName("unitime-RoomDetail");
        this.iFooter = this.iHeader.clonePanel();
        this.initWidget((Widget)this.iForm);
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRoomDetail());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public void show(String message) {
        this.show();
        if (message != null) {
            this.iHeader.setErrorMessage(message);
        } else {
            this.iHeader.clearMessage();
        }
    }

    public void hide() {
        this.setVisible(false);
        this.onHide();
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide() {
    }

    protected void onShow() {
    }

    protected void edit() {
    }

    protected RoomInterface.RoomDetailInterface getNext(Long roomId) {
        return null;
    }

    protected void next(RoomInterface.RoomDetailInterface event) {
    }

    protected RoomInterface.RoomDetailInterface getPrevious(Long roomId) {
        return null;
    }

    protected void previous(RoomInterface.RoomDetailInterface previous) {
    }

    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        this.iProperties = properties;
    }

    public RoomInterface.RoomDetailInterface getRoom() {
        return this.iRoom;
    }

    public void setRoom(RoomInterface.RoomDetailInterface room) {
        Object sharing;
        UniTimeHeaderPanel header;
        List<RoomInterface.FeatureInterface> features;
        List<RoomInterface.GroupInterface> departmentalGroups;
        List<RoomInterface.GroupInterface> globalGroups;
        this.iRoom = room;
        this.iForm.clear();
        this.iHeader.clearMessage();
        this.iHeader.setHeaderTitle(this.iRoom.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : this.iRoom.getLabel());
        this.iHeader.setEnabled("edit", this.iRoom.isCanEdit());
        this.iHeader.setEnabled("previous", this.getPrevious(this.iRoom.getUniqueId()) != null);
        this.iHeader.setEnabled("next", this.getNext(this.iRoom.getUniqueId()) != null);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        boolean courses = this.iProperties != null && this.iProperties.isCanSeeCourses();
        boolean exams = this.iProperties != null && this.iProperties.isCanSeeExams();
        boolean events = this.iProperties != null && this.iProperties.isCanSeeEvents();
        int firstRow = this.iForm.getRowCount();
        if (this.iMode.hasSessionSelection()) {
            this.iForm.addRow(MESSAGES.propAcademicSession(), (Widget)new Label(this.iRoom.hasSessionName() ? this.iRoom.getSessionName() : this.iProperties.getAcademicSessionName()), 1);
        }
        this.iForm.addRow(MESSAGES.propType(), (Widget)new Label(this.iRoom.getRoomType().getLabel()), 1);
        if (this.iRoom.hasExternalId()) {
            this.iForm.addRow(MESSAGES.propExternalId(), (Widget)new Label(this.iRoom.getExternalId()), 1);
        }
        if (this.iRoom.getCapacity() != null) {
            this.iForm.addRow(MESSAGES.propCapacity(), (Widget)new Label(this.iRoom.getCapacity().toString()), 1);
        }
        if (exams && (this.iRoom.getExamCapacity() != null || this.iRoom.hasExamTypes())) {
            this.iForm.addRow(MESSAGES.propExamCapacity(), (Widget)new ExamSeatingCapacityLabel(this.iRoom), 1);
        }
        if (courses && this.iRoom.getControlDepartment() != null) {
            this.iForm.addRow(MESSAGES.propControllingDepartment(), (Widget)new Label(RoomDetail.toString(this.iRoom.getControlDepartment())), 1);
        }
        if (this.iRoom.hasCoordinates()) {
            if (this.iProperties != null && this.iProperties.hasEllipsoid()) {
                this.iForm.addRow(MESSAGES.propCoordinates(), (Widget)new HTML(MESSAGES.coordinatesWithEllipsoid(this.iRoom.getX(), this.iRoom.getY(), this.iProperties.getEllipsoid())), 1);
            } else {
                this.iForm.addRow(MESSAGES.propCoordinates(), (Widget)new HTML(MESSAGES.coordinates(this.iRoom.getX(), this.iRoom.getY())), 1);
            }
        }
        if (this.iRoom.getArea() != null) {
            this.iForm.addRow(MESSAGES.propRoomArea(), (Widget)new HTML(MESSAGES.roomArea(this.iRoom.getArea()) + " " + (this.iProperties != null && this.iProperties.isRoomAreaInMetricUnits() ? CONSTANTS.roomAreaMetricUnitsShort() : CONSTANTS.roomAreaUnitsShort())), 1);
        }
        if (courses) {
            this.iForm.addRow(MESSAGES.propDistanceCheck(), (Widget)new Check(!room.isIgnoreTooFar(), MESSAGES.infoDistanceCheckOn(), MESSAGES.infoDistanceCheckOff()));
            this.iForm.addRow(MESSAGES.propRoomCheck(), (Widget)new Check(!room.isIgnoreRoomCheck(), MESSAGES.infoRoomCheckOn(), MESSAGES.infoRoomCheckOff()));
        } else if (events) {
            this.iForm.addRow(MESSAGES.propRoomCheck(), (Widget)new Check(!room.isIgnoreRoomCheck(), MESSAGES.infoRoomCheckOn(), MESSAGES.infoRoomCheckOff()));
        }
        if (events && this.iRoom.getEventDepartment() != null) {
            this.iForm.addRow(MESSAGES.propEventDepartment(), (Widget)new Label(RoomDetail.toString(this.iRoom.getEventDepartment(), true)), 1);
        }
        if (events && (this.iRoom.getEventStatus() != null || this.iRoom.getDefaultEventStatus() != null)) {
            Label status = new Label(CONSTANTS.eventStatusName()[this.iRoom.getEventStatus() == null ? this.iRoom.getDefaultEventStatus() : this.iRoom.getEventStatus()]);
            if (this.iRoom.getEventStatus() == null) {
                status.addStyleName("default");
            }
            this.iForm.addRow(MESSAGES.propEventStatus(), (Widget)status, 1);
        }
        if (events && (this.iRoom.hasEventNote() || this.iRoom.hasDefaultEventNote())) {
            HTML note = new HTML(this.iRoom.hasEventNote() ? this.iRoom.getEventNote() : this.iRoom.getDefaultEventNote());
            note.addStyleName("note");
            if (!this.iRoom.hasEventNote()) {
                note.addStyleName("default");
            }
            this.iForm.addRow(MESSAGES.propEventNote(), (Widget)note, 1);
        }
        if (events && (this.iRoom.getBreakTime() != null || this.iRoom.getDefaultBreakTime() != null)) {
            Label bt = new Label((this.iRoom.getBreakTime() == null ? this.iRoom.getDefaultBreakTime() : this.iRoom.getBreakTime()).toString());
            if (this.iRoom.getBreakTime() == null) {
                bt.addStyleName("default");
            }
            this.iForm.addRow(MESSAGES.propBreakTime(), (Widget)bt, 1);
        }
        if (events && this.iRoom.hasServices()) {
            this.iForm.addRow(MESSAGES.propAvailableServices(), (Widget)new ServicesCell(this.iRoom.getServices(), this.iRoom.getEventDepartment()));
        }
        if (courses && this.iRoom.hasPreference()) {
            this.iForm.addRow(MESSAGES.propPreference(), (Widget)new PreferenceCell(this.iRoom.getDepartments()), 1);
        }
        if (!(globalGroups = this.iRoom.getGlobalGroups()).isEmpty()) {
            this.iForm.addRow(MESSAGES.propGlobalGroups(), (Widget)new GroupsCell(globalGroups), 1);
        }
        if (!(departmentalGroups = this.iRoom.getDepartmentalGroups(null)).isEmpty()) {
            this.iForm.addRow(MESSAGES.propDepartmenalGroups(), (Widget)new GroupsCell(departmentalGroups), 1);
        }
        if (!(features = this.iRoom.getFeatures((Long)null)).isEmpty()) {
            this.iForm.addRow(MESSAGES.propFeatures(), (Widget)new FeaturesCell(features), 1);
        }
        if (this.iProperties != null) {
            for (RoomInterface.FeatureTypeInterface type : this.iProperties.getFeatureTypes()) {
                List<RoomInterface.FeatureInterface> featuresOfType = this.iRoom.getFeatures(type);
                if (featuresOfType.isEmpty()) continue;
                this.iForm.addRow(type.getLabel() + ":", (Widget)new FeaturesCell(featuresOfType), 1);
            }
        }
        if (this.iRoom.hasLastChange()) {
            this.iForm.addRow(MESSAGES.propLastChange(), (Widget)new Label(this.iRoom.getLastChange()), 1);
        }
        if (this.iRoom.hasMapUrl()) {
            Image image = new Image(this.iRoom.getMapUrl());
            image.setStyleName("map");
            if (Window.getClientWidth() <= 800) {
                this.iForm.addRow((Widget)image);
            } else {
                this.iForm.setWidget(firstRow, 2, (Widget)image);
                this.iForm.getFlexCellFormatter().setRowSpan(firstRow, 2, this.iForm.getRowCount() - firstRow);
            }
        }
        if (courses && this.iRoom.isCanSeeAvailability()) {
            header = new UniTimeHeaderPanel(MESSAGES.headerRoomSharing());
            header.showLoading();
            this.iForm.addHeaderRow((Widget)header);
            sharing = new RoomSharingWidget(false);
            sharing.setVisible(false);
            this.iForm.addRow((Widget)sharing);
            RPC.execute(RoomInterface.RoomSharingRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), false), new AsyncCallback<RoomInterface.RoomSharingModel>((RoomSharingWidget)sharing){
                final /* synthetic */ RoomSharingWidget val$sharing;
                {
                    this.val$sharing = roomSharingWidget;
                }

                public void onFailure(Throwable caught) {
                    header.setErrorMessage(MESSAGES.failedToLoadRoomAvailability(caught.getMessage()));
                }

                public void onSuccess(RoomInterface.RoomSharingModel result) {
                    header.clearMessage();
                    this.val$sharing.setModel(result);
                    this.val$sharing.setVisible(true);
                }
            });
        }
        if (exams && this.iRoom.isCanSeePeriodPreferences() && this.iRoom.hasExamTypes()) {
            header = new UniTimeHeaderPanel(MESSAGES.headerExaminationPeriodPreferences());
            header.showLoading();
            this.iForm.addHeaderRow((Widget)header);
            for (RoomInterface.ExamTypeInterface type : this.iRoom.getExamTypes()) {
                final PeriodPreferencesWidget pref = new PeriodPreferencesWidget(false);
                final int row = this.iForm.addRow(MESSAGES.propExaminationPreferences(type.getLabel()), (Widget)pref);
                this.iForm.getRowFormatter().setVisible(row, false);
                RPC.execute(RoomInterface.PeriodPreferenceRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), type.getId()), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

                    public void onFailure(Throwable caught) {
                        header.setErrorMessage(MESSAGES.failedToLoadPeriodPreferences(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.PeriodPreferenceModel result) {
                        header.clearMessage();
                        pref.setModel(result);
                        if (!result.getPeriods().isEmpty()) {
                            RoomDetail.this.iForm.getRowFormatter().setVisible(row, true);
                        }
                    }
                });
            }
        }
        if (events && this.iRoom.isCanSeeEventAvailability()) {
            header = new UniTimeHeaderPanel(MESSAGES.headerEventAvailability());
            header.showLoading();
            this.iForm.addHeaderRow((Widget)header);
            sharing = new RoomSharingWidget(false);
            sharing.setVisible(false);
            this.iForm.addRow((Widget)sharing);
            RPC.execute(RoomInterface.RoomSharingRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), true), new AsyncCallback<RoomInterface.RoomSharingModel>((RoomSharingWidget)sharing){
                final /* synthetic */ RoomSharingWidget val$sharing;
                {
                    this.val$sharing = roomSharingWidget;
                }

                public void onFailure(Throwable caught) {
                    header.setErrorMessage(MESSAGES.failedToLoadRoomAvailability(caught.getMessage()));
                }

                public void onSuccess(RoomInterface.RoomSharingModel result) {
                    header.clearMessage();
                    this.val$sharing.setModel(result);
                    this.val$sharing.setVisible(true);
                }
            });
        }
        if (this.iRoom.hasPictures()) {
            header = new UniTimeHeaderPanel(MESSAGES.headerRoomPictures());
            this.iForm.addHeaderRow((Widget)header);
            this.iForm.addRow((Widget)new PicturesCell(this.iRoom));
        }
        if (this.iRoom.isCanShowDetail()) {
            RoomNoteChanges noteChanges = new RoomNoteChanges();
            noteChanges.load(this.iRoom.getUniqueId());
            this.iForm.addRow((Widget)noteChanges);
        }
        this.iForm.addNotPrintableBottomRow((Widget)this.iFooter);
    }

    static String toString(RoomInterface.DepartmentInterface department, boolean events) {
        if (events) {
            return department.getDeptCode() + " - " + department.getLabel();
        }
        return department.getExtAbbreviationOrCode() + " - " + department.getExtLabelWhenExist();
    }

    static String toString(RoomInterface.DepartmentInterface department) {
        return RoomDetail.toString(department, false);
    }

    static class Check
    extends P {
        Check(boolean value, String onMessage, String offMessage) {
            super(new String[0]);
            Image image = new Image(value ? RESOURCES.on() : RESOURCES.off());
            image.addStyleName("image");
            this.add((Widget)image);
            InlineHTML text = new InlineHTML(value ? onMessage : offMessage);
            text.addStyleName("message");
            this.add((Widget)text);
            if (value) {
                this.addStyleName("check-enabled");
            } else {
                this.addStyleName("check-disabled");
            }
        }
    }

    static class LinkCell
    extends ImageLink {
        LinkCell(RoomInterface.RoomPictureInterface picture) {
            super(new Image(RESOURCES.download()), GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            this.setStyleName("link");
            this.setTitle(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getLabel() + ")"));
            this.setText(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getAbbreviation() + ")"));
        }
    }

    static class PictureCell
    extends Image {
        private P iPopupWidget;
        private RoomInterface.RoomPictureInterface iPicture;

        PictureCell(RoomInterface.RoomPictureInterface picture) {
            this.iPicture = picture;
            this.setStyleName("picture");
            this.setUrl(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            this.setAltText(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getAbbreviation() + ")"));
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    GwtHint.showHint((Element)PictureCell.this.getElement(), (Widget)PictureCell.this.getPopupWidget());
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    GwtHint.hideHint();
                }
            });
        }

        protected P getPopupWidget() {
            if (this.iPopupWidget == null) {
                this.iPopupWidget = new P("unitime-RoomPictureHint");
                Image image = new Image(GWT.getHostPageBaseURL() + "picture?id=" + this.iPicture.getUniqueId());
                image.setStyleName("picture");
                this.iPopupWidget.add((Widget)image);
                P caption = new P("caption");
                caption.setText(this.iPicture.getName() + (this.iPicture.getPictureType() == null ? "" : " (" + this.iPicture.getPictureType().getAbbreviation() + ")"));
                this.iPopupWidget.add((Widget)caption);
            }
            return this.iPopupWidget;
        }
    }

    static class PicturesCell
    extends P {
        PicturesCell(RoomInterface.RoomDetailInterface room) {
            super("pictures");
            if (room.hasPictures()) {
                for (RoomInterface.RoomPictureInterface picture : room.getPictures()) {
                    this.add((Widget)(picture.getPictureType() == null || picture.getPictureType().isImage() ? new PictureCell(picture) : new LinkCell(picture)));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PreferenceCell
    extends RoomsTable.DepartmentCell {
        PreferenceCell(List<RoomInterface.DepartmentInterface> departments) {
            super(true, new RoomInterface.DepartmentInterface[0]);
            for (RoomInterface.DepartmentInterface department : departments) {
                if (department.getPreference() == null) continue;
                P p = new P("department");
                p.setText(MESSAGES.roomPreference(RoomDetail.toString(department), department.getPreference().getName()));
                p.setTitle(department.getPreference().getName() + " " + department.getExtLabelWhenExist());
                p.getElement().getStyle().setColor(department.getPreference().getColor());
                this.iP.put(department, p);
                this.add((Widget)p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServicesCell
    extends P {
        ServicesCell(Set<? extends EventInterface.EventServiceProviderInterface> services) {
            this(services, null);
        }

        ServicesCell(Set<? extends EventInterface.EventServiceProviderInterface> services, RoomInterface.DepartmentInterface department) {
            super(new String[0]);
            this.setStyleName("services");
            for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : services) {
                P p = new P("service");
                p.setText(eventServiceProviderInterface.getLabel());
                if (eventServiceProviderInterface.hasMessage()) {
                    p.setTitle(eventServiceProviderInterface.getMessage());
                }
                if (eventServiceProviderInterface.getDepartmentId() != null && department != null) {
                    p.setText(eventServiceProviderInterface.getLabel() + " (" + RoomDetail.toString(department) + ")");
                }
                this.add((Widget)p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FeaturesCell
    extends P {
        FeaturesCell(List<? extends RoomInterface.FeatureInterface> features) {
            super(new String[0]);
            this.setStyleName("features");
            for (RoomInterface.FeatureInterface featureInterface : features) {
                P p = new P("feature");
                p.setText(featureInterface.getLabel());
                if (featureInterface.getTitle() != null) {
                    p.setTitle(featureInterface.getTitle());
                }
                if (featureInterface.getDepartment() != null) {
                    p.setText(featureInterface.getLabel() + " (" + RoomDetail.toString(featureInterface.getDepartment()) + ")");
                }
                this.add((Widget)p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GroupsCell
    extends P {
        GroupsCell(List<? extends RoomInterface.GroupInterface> groups) {
            this(groups, true);
        }

        GroupsCell(List<? extends RoomInterface.GroupInterface> groups, boolean department) {
            super(new String[0]);
            this.setStyleName("groups");
            for (RoomInterface.GroupInterface groupInterface : groups) {
                P p = new P("group");
                p.setText(groupInterface.getLabel());
                if (groupInterface.getTitle() != null) {
                    p.setTitle(groupInterface.getTitle());
                }
                if (groupInterface.getDepartment() != null && department) {
                    p.setText(groupInterface.getLabel() + " (" + RoomDetail.toString(groupInterface.getDepartment()) + ")");
                }
                this.add((Widget)p);
            }
        }
    }

    static class ExamSeatingCapacityLabel
    extends Label {
        ExamSeatingCapacityLabel(RoomInterface.RoomDetailInterface room) {
            if (room.hasExamTypes()) {
                String types = "";
                for (RoomInterface.ExamTypeInterface type : room.getExamTypes()) {
                    types = types + (types.isEmpty() ? "" : ", ") + type.getLabel();
                }
                if (room.getExamCapacity() != null) {
                    this.setText(room.getExamCapacity() + " (" + types + ")");
                } else {
                    this.setText("(" + types + ")");
                }
            } else if (room.getExamCapacity() != null) {
                this.setText(room.getExamCapacity().toString());
            }
        }
    }
}

