/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.client.events.AddMeetingsDialog;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventCookie;
import org.unitime.timetable.gwt.client.events.EventDetail;
import org.unitime.timetable.gwt.client.events.EventResourceTimetable;
import org.unitime.timetable.gwt.client.events.RoomFilterBox;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.events.StartEndTimeSelector;
import org.unitime.timetable.gwt.client.events.TimeGrid;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRoomAvailability
extends Composite
implements AcademicSessionSelectionBox.AcademicSessionFilter,
EventAdd.EventPropertiesProvider {
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormatShort());
    private EventResourceTimetable.HistoryToken iHistoryToken = new EventResourceTimetable.HistoryToken(EventResourceTimetable.PageType.Availability);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private SimpleForm iFilter = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeHeaderPanel iFilterHeader;
    private AcademicSessionSelectionBox iSession;
    private int iSessionRow;
    private StartEndTimeSelector iTimes;
    private SessionDatesSelector iDates;
    private RoomFilterBox iRooms;
    private VerticalPanel iTables;
    private EventInterface.EventPropertiesRpcResponse iProperties = null;
    private boolean iInitialized = false;
    private StartEndTimeSelector.StartEndTime iSelectedTimes = null;
    private List<Integer> iSelectedDates = null;
    private List<EventInterface.ResourceInterface> iSelectedRooms = null;
    private List<EventInterface> iData;
    private List<EventInterface.SessionMonth> iSessionMonths = null;
    private EventDetail iEventDetail;
    private EventAdd iEventAdd;
    private TimeGrid.MeetingClickHandler iMeetingClickHandler;

    public EventRoomAvailability() {
        this.iFilter.removeStyleName("unitime-NotPrintableBottomLine");
        this.iFilter.getColumnFormatter().setWidth(0, "120px");
        this.iFilterHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iFilterHeader.addButton("add", MESSAGES.buttonAddEvent(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventRoomAvailability.this.iEventAdd.setEvent(null);
                EventRoomAvailability.this.iEventAdd.show();
            }
        });
        this.iFilterHeader.setEnabled("add", false);
        this.iFilter.addHeaderRow((Widget)this.iFilterHeader);
        this.iFilterHeader.addButton("clear", MESSAGES.buttonClear(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventRoomAvailability.this.iDates.setValue(null);
                EventRoomAvailability.this.iTimes.setValue(null);
                EventRoomAvailability.this.iRooms.setValue(EventRoomAvailability.this.iHistoryToken.getDefaultParameter("rooms", ""), true);
                EventRoomAvailability.this.hideResults();
                EventRoomAvailability.this.changeUrl();
            }
        });
        this.iFilterHeader.addButton("search", MESSAGES.buttonSearch(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventRoomAvailability.this.reload(true);
            }
        });
        this.iSession = new AcademicSessionSelectionBox(this.iHistoryToken.getParameter("term"), "Events"){

            @Override
            protected void onInitializationSuccess(List<AcademicSessionSelectionBox.AcademicSession> sessions) {
                EventRoomAvailability.this.iFilter.setVisible(sessions != null && !sessions.isEmpty());
                UniTimePageHeader.getInstance().getRight().setVisible(false);
                UniTimePageHeader.getInstance().getRight().setPreventDefault(true);
            }

            @Override
            protected void onInitializationFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedLoadSessions(caught.getMessage()), caught);
            }
        };
        this.iSession.setFilter(this);
        this.iSessionRow = this.iFilter.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSession);
        this.iDates = new SessionDatesSelector(this.iSession);
        this.iDates.setCanSelectPast(true);
        ToolBox.setMaxWidth(this.iDates.getElement().getStyle(), Math.round(0.9 * (double)ToolBox.getClientWidth() - 120.0) + "px");
        this.iFilter.addRow(MESSAGES.propDates(), (Widget)this.iDates);
        this.iTimes = new StartEndTimeSelector();
        this.iTimes.setDiff(12);
        this.iFilter.addRow(MESSAGES.propTimes(), (Widget)this.iTimes);
        this.iRooms = new RoomFilterBox(this.iSession);
        this.iFilter.addRow(MESSAGES.propLocations(), (Widget)this.iRooms);
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("add", MESSAGES.buttonAddEvent(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventRoomAvailability.this.iEventAdd.setEvent(null);
                EventRoomAvailability.this.iEventAdd.show();
            }
        });
        this.iHeader.setEnabled("add", false);
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                HashMap<Long, String> colors = new HashMap<Long, String>();
                ArrayList<ToolBox.Page> pages = new ArrayList<ToolBox.Page>();
                if (EventRoomAvailability.this.iSelectedDates.size() == 1) {
                    final Date date = EventRoomAvailability.this.iDates.getDate((Integer)EventRoomAvailability.this.iSelectedDates.get(0));
                    int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
                    int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
                    int dow = (SingleDateSelector.firstDayOfWeek(year, month) + Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1) % 7;
                    int[] days = new int[]{dow};
                    EventInterface.WeekInterface week = new EventInterface.WeekInterface();
                    week.setDayOfYear((Integer)EventRoomAvailability.this.iSelectedDates.get(0) - dow);
                    for (int i = 0; i < 7; ++i) {
                        week.addDayName(new EventInterface.DateInterface(sDateFormat.format(EventRoomAvailability.this.iDates.getDate(week.getDayOfYear() + i)), month, week.getDayOfYear() + i));
                    }
                    ArrayList<EventInterface.WeekInterface> weeks = new ArrayList<EventInterface.WeekInterface>();
                    weeks.add(week);
                    boolean past = !EventRoomAvailability.this.iDates.isEnabled(date) || EventRoomAvailability.this.iDates.hasFlag(date, EventInterface.SessionMonth.Flag.PAST);
                    for (int i = 0; i < EventRoomAvailability.this.iSelectedDates.size(); ++i) {
                        int startHour = CONSTANTS.eventStartDefault() / 12;
                        if (EventRoomAvailability.this.iSelectedTimes.getStart() != null) {
                            startHour = Math.max(0, (EventRoomAvailability.this.iSelectedTimes.getStart() - 6) / 12);
                        }
                        int endHour = (11 + CONSTANTS.eventStopDefault()) / 12;
                        if (EventRoomAvailability.this.iSelectedTimes.getEnd() != null) {
                            endHour = Math.min(24, (17 + EventRoomAvailability.this.iSelectedTimes.getEnd()) / 12);
                        }
                        final TimeGrid grid = new TimeGrid(colors, days, 1000 / days.length, 55, true, false, startHour, endHour, EventRoomAvailability.this);
                        grid.setResourceType(EventInterface.ResourceType.ROOM);
                        grid.setSelectedWeeks(weeks);
                        ArrayList<EventInterface.ResourceInterface> rooms = new ArrayList<EventInterface.ResourceInterface>(EventRoomAvailability.this.iSelectedRooms);
                        grid.setRoomResources(rooms);
                        grid.setMode(TimeGrid.Mode.OVERLAP);
                        for (EventInterface event : EventRoomAvailability.this.sortedEvents()) {
                            ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                                if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || ((Integer)EventRoomAvailability.this.iSelectedDates.get(i)).intValue() != meeting.getDayOfYear() || !meeting.hasLocation()) continue;
                                meetings.add(meeting);
                            }
                            if (meetings.isEmpty()) continue;
                            grid.addEvent(event, meetings);
                        }
                        grid.labelDays(week, null);
                        grid.yellow(EventRoomAvailability.this.iSelectedTimes.getStart() == null ? CONSTANTS.eventStartDefault() : EventRoomAvailability.this.iSelectedTimes.getStart().intValue(), EventRoomAvailability.this.iSelectedTimes.getEnd() == null ? CONSTANTS.eventStopDefault() : EventRoomAvailability.this.iSelectedTimes.getEnd().intValue());
                        if (past) {
                            grid.gray(0, 1);
                        }
                        grid.showVerticalSplit();
                        grid.addMeetingClickHandler(EventRoomAvailability.this.iMeetingClickHandler);
                        pages.add(new ToolBox.Page(){

                            public String getName() {
                                return DateTimeFormat.getFormat((String)CONSTANTS.meetingDateFormat()).format(date);
                            }

                            public String getUser() {
                                return "";
                            }

                            public String getSession() {
                                return "";
                            }

                            public Element getBody() {
                                return grid.getElement();
                            }
                        });
                    }
                } else {
                    int[] days = new int[EventRoomAvailability.this.iSelectedDates.size()];
                    EventInterface.WeekInterface week = new EventInterface.WeekInterface();
                    week.setDayOfYear((Integer)EventRoomAvailability.this.iSelectedDates.get(0));
                    ArrayList<String> dows = new ArrayList<String>();
                    int lastPast = -1;
                    for (int i = 0; i < EventRoomAvailability.this.iSelectedDates.size(); ++i) {
                        Date date = EventRoomAvailability.this.iDates.getDate((Integer)EventRoomAvailability.this.iSelectedDates.get(i));
                        int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
                        int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
                        int dow = (SingleDateSelector.firstDayOfWeek(year, month) + Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1) % 7;
                        days[i] = i;
                        week.addDayName(new EventInterface.DateInterface(sDateFormat.format(date), month, (Integer)EventRoomAvailability.this.iSelectedDates.get(i)));
                        dows.add(CONSTANTS.days()[dow]);
                        if (EventRoomAvailability.this.iDates.isEnabled(date) && !EventRoomAvailability.this.iDates.hasFlag(date, EventInterface.SessionMonth.Flag.PAST)) continue;
                        lastPast = i;
                    }
                    ArrayList<EventInterface.WeekInterface> weeks = new ArrayList<EventInterface.WeekInterface>();
                    weeks.add(week);
                    for (final EventInterface.ResourceInterface room : EventRoomAvailability.this.iSelectedRooms) {
                        int startHour = CONSTANTS.eventStartDefault() / 12;
                        if (EventRoomAvailability.this.iSelectedTimes.getStart() != null) {
                            startHour = Math.max(0, (EventRoomAvailability.this.iSelectedTimes.getStart() - 6) / 12);
                        }
                        int endHour = (11 + CONSTANTS.eventStopDefault()) / 12;
                        if (EventRoomAvailability.this.iSelectedTimes.getEnd() != null) {
                            endHour = Math.min(24, (17 + EventRoomAvailability.this.iSelectedTimes.getEnd()) / 12);
                        }
                        final TimeGrid grid = new TimeGrid(colors, days, 1000 / days.length, 55, true, false, startHour, endHour, EventRoomAvailability.this);
                        grid.setResourceType(EventInterface.ResourceType.ROOM);
                        grid.setSelectedWeeks(weeks);
                        ArrayList<EventInterface.ResourceInterface> rooms = new ArrayList<EventInterface.ResourceInterface>();
                        rooms.add(room);
                        grid.setRoomResources(rooms);
                        grid.setMode(TimeGrid.Mode.OVERLAP);
                        for (EventInterface event : EventRoomAvailability.this.sortedEvents()) {
                            ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                                int idx;
                                if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || meeting.getMeetingDate() == null || !meeting.hasLocation() || !meeting.getLocation().getId().equals(room.getId()) || (idx = EventRoomAvailability.this.iSelectedDates.indexOf(meeting.getDayOfYear())) < 0) continue;
                                meeting.setGridIndex(idx);
                                meetings.add(meeting);
                            }
                            if (meetings.isEmpty()) continue;
                            grid.addEvent(event, meetings);
                        }
                        grid.labelDays(dows, week);
                        grid.yellow(EventRoomAvailability.this.iSelectedTimes.getStart() == null ? CONSTANTS.eventStartDefault() : EventRoomAvailability.this.iSelectedTimes.getStart().intValue(), EventRoomAvailability.this.iSelectedTimes.getEnd() == null ? CONSTANTS.eventStopDefault() : EventRoomAvailability.this.iSelectedTimes.getEnd().intValue());
                        if (lastPast >= 0) {
                            grid.gray(0, lastPast);
                        }
                        grid.addMeetingClickHandler(EventRoomAvailability.this.iMeetingClickHandler);
                        pages.add(new ToolBox.Page(){

                            public String getName() {
                                return room.getName();
                            }

                            public String getUser() {
                                return room.getRoomType();
                            }

                            public String getSession() {
                                return room.hasSize() ? MESSAGES.hintRoomCapacity(room.getSize().toString()) : "";
                            }

                            public Element getBody() {
                                return grid.getElement();
                            }
                        });
                    }
                }
                ToolBox.print(pages);
            }
        });
        this.iHeader.addButton("sort", MESSAGES.buttonSortBy(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                MenuBar menu = new MenuBar(true);
                for (final AddMeetingsDialog.SortRoomsBy sortBy : AddMeetingsDialog.SortRoomsBy.values()) {
                    if (sortBy == AddMeetingsDialog.SortRoomsBy.DISTANCE && !EventRoomAvailability.this.iRooms.hasChip(new FilterBox.Chip("flag", "Nearby"))) continue;
                    MenuItem item = new MenuItem((sortBy.ordinal() == EventCookie.getInstance().getRoomsSortBy() ? "&uarr; " : (sortBy.ordinal() + AddMeetingsDialog.SortRoomsBy.values().length == EventCookie.getInstance().getRoomsSortBy() ? "&darr; " : "")) + AddMeetingsDialog.getSortRoomsByName(sortBy), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            if (sortBy.ordinal() == EventCookie.getInstance().getRoomsSortBy()) {
                                EventCookie.getInstance().setSortRoomsBy(AddMeetingsDialog.SortRoomsBy.values().length + sortBy.ordinal());
                            } else {
                                EventCookie.getInstance().setSortRoomsBy(sortBy.ordinal());
                            }
                            EventRoomAvailability.this.populate(EventRoomAvailability.this.iData, EventCookie.getInstance().getRoomsSortBy());
                        }
                    });
                    item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(item);
                }
                menu.setVisible(true);
                menu.setFocusOnHoverEnabled(true);
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                ((MenuBar)popup.getWidget()).focus();
            }
        });
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iTables = new VerticalPanel();
        this.iPanel.addRow((Widget)this.iTables);
        this.iFooter = this.iHeader.clonePanel();
        this.iPanel.addRow((Widget)this.iFooter);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.initWidget((Widget)this.iRootPanel);
        this.hideResults();
        this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                EventRoomAvailability.this.loadProperties((AsyncCallback<EventInterface.EventPropertiesRpcResponse>)((AsyncCallback)new AsyncCallback<EventInterface.EventPropertiesRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EventPropertiesRpcResponse result) {
                        if (!EventRoomAvailability.this.iInitialized) {
                            EventRoomAvailability.this.setup(true);
                        } else {
                            EventRoomAvailability.this.reload(false);
                        }
                    }
                }));
            }
        });
        this.iEventDetail = new EventDetail(this){

            protected void onHide() {
                EventRoomAvailability.this.iRootPanel.setWidget((Widget)EventRoomAvailability.this.iPanel);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEventRoomAvailability());
                if (!EventRoomAvailability.this.isShowingResults()) {
                    EventRoomAvailability.this.reload(true);
                }
                EventRoomAvailability.this.changeUrl();
            }

            protected void onShow() {
                EventRoomAvailability.this.iRootPanel.setWidget((Widget)EventRoomAvailability.this.iEventDetail);
                EventRoomAvailability.this.changeUrl();
            }

            protected void edit() {
                this.hide();
                EventRoomAvailability.this.iEventAdd.setEvent(this.getEvent());
                EventRoomAvailability.this.iEventAdd.show();
            }

            protected EventInterface getPrevious(Long eventId) {
                return null;
            }

            protected EventInterface getNext(Long eventId) {
                return null;
            }

            protected void previous(final EventInterface event) {
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventRoomAvailability.this.iSession.getAcademicSessionId(), event.getId()), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(event.getName(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        this.setEvent(result);
                        EventRoomAvailability.this.changeUrl();
                    }
                }, MESSAGES.waitLoading(event.getName()));
            }

            protected void next(EventInterface event) {
                this.previous(event);
            }

            public void hide() {
                super.hide();
            }

            protected void onApprovalOrReject(Long eventId, EventInterface event) {
                if (EventRoomAvailability.this.iData != null) {
                    EventRoomAvailability.this.populate(EventRoomAvailability.this.tinker(new GwtRpcResponseList(EventRoomAvailability.this.iData), eventId, event), null);
                }
            }
        };
        this.iEventAdd = new EventAdd(this.iSession, this){

            protected void onHide() {
                EventRoomAvailability.this.iSession.setFilter(EventRoomAvailability.this);
                EventRoomAvailability.this.iFilter.setWidget(EventRoomAvailability.this.iSessionRow, 1, (Widget)EventRoomAvailability.this.iSession);
                EventInterface modified = EventRoomAvailability.this.iEventAdd.getEvent();
                final EventInterface detail = EventRoomAvailability.this.iEventDetail.getEvent();
                EventInterface saved = EventRoomAvailability.this.iEventAdd.getSavedEvent();
                if (saved != null) {
                    if (EventRoomAvailability.this.iData != null) {
                        EventRoomAvailability.this.populate(EventRoomAvailability.this.tinker(new GwtRpcResponseList(EventRoomAvailability.this.iData), saved.getId() == null ? modified.getId() : saved.getId(), saved), null);
                    }
                    if (saved.getId() != null) {
                        EventRoomAvailability.this.iEventDetail.setEvent(saved);
                        EventRoomAvailability.this.iEventDetail.show();
                    } else {
                        EventRoomAvailability.this.iRootPanel.setWidget((Widget)EventRoomAvailability.this.iPanel);
                        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEventRoomAvailability());
                    }
                } else if (modified != null && detail != null && detail.getId().equals(modified.getId())) {
                    LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventRoomAvailability.this.iSession.getAcademicSessionId(), modified.getId()), new AsyncCallback<EventInterface>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoad(detail.getName(), caught.getMessage()), caught);
                        }

                        public void onSuccess(EventInterface result) {
                            LoadingWidget.getInstance().hide();
                            EventRoomAvailability.this.iEventDetail.setEvent(result);
                            EventRoomAvailability.this.iEventDetail.show();
                        }
                    }, MESSAGES.waitLoading(detail.getName()));
                } else {
                    EventRoomAvailability.this.iRootPanel.setWidget((Widget)EventRoomAvailability.this.iPanel);
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEventRoomAvailability());
                }
                EventRoomAvailability.this.changeUrl();
            }

            protected void onShow() {
                EventRoomAvailability.this.iRootPanel.setWidget((Widget)EventRoomAvailability.this.iEventAdd);
                EventRoomAvailability.this.changeUrl();
            }
        };
        this.iMeetingClickHandler = new TimeGrid.MeetingClickHandler(){

            public void onMeetingClick(final TimeGrid.MeetingClickEvent event) {
                if (!event.getEvent().isCanView()) {
                    return;
                }
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventRoomAvailability.this.iSession.getAcademicSessionId(), event.getEvent().getId()), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(event.getEvent().getName(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        EventRoomAvailability.this.iEventDetail.setEvent(result);
                        EventRoomAvailability.this.iEventDetail.show();
                    }
                }, MESSAGES.waitLoading(event.getEvent().getName()));
            }
        };
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (EventRoomAvailability.this.iInitialized) {
                    EventRoomAvailability.this.iHistoryToken.reset((String)event.getValue());
                    EventRoomAvailability.this.setup(false);
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                }
            }
        });
    }

    private Integer getOccupancy(EventInterface.ResourceInterface room) {
        int startSlot = this.iSelectedTimes.getStart() == null ? CONSTANTS.eventStartDefault() : this.iSelectedTimes.getStart().intValue();
        int endSlot = this.iSelectedTimes.getEnd() == null ? CONSTANTS.eventStopDefault() : this.iSelectedTimes.getEnd().intValue();
        int use = 0;
        for (EventInterface event : this.iData) {
            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                if (!room.equals(meeting.getLocation())) continue;
                int start = Math.max(startSlot, meeting.getStartSlot());
                int end = Math.min(endSlot, meeting.getEndSlot());
                use += Math.max(0, end - start);
            }
        }
        return use;
    }

    private Comparator<EventInterface.ResourceInterface> getSortRoomsComparator(AddMeetingsDialog.SortRoomsBy sortBy, final boolean preferSize) {
        switch (sortBy) {
            case CAPACITY: {
                return new Comparator<EventInterface.ResourceInterface>(){

                    @Override
                    public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                        int cmp = (r1.getSize() == null ? new Integer(0) : r1.getSize()).compareTo(r2.getSize() == null ? new Integer(0) : r2.getSize());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getId().compareTo(r2.getId()) : cmp;
                    }
                };
            }
            case NAME: {
                return new Comparator<EventInterface.ResourceInterface>(){

                    @Override
                    public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                        int cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getId().compareTo(r2.getId()) : cmp;
                    }
                };
            }
            case DISTANCE: {
                return new Comparator<EventInterface.ResourceInterface>(){

                    @Override
                    public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                        int cmp = (r1.getDistance() == null ? new Double(0.0) : r1.getDistance()).compareTo(r2.getDistance() == null ? new Double(0.0) : r2.getDistance());
                        if (cmp != 0) {
                            return cmp;
                        }
                        if (preferSize && (cmp = (r1.getSize() == null ? new Integer(0) : r1.getSize()).compareTo(r2.getSize() == null ? new Integer(0) : r2.getSize())) != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getId().compareTo(r2.getId()) : cmp;
                    }
                };
            }
            case AVAILABILITY: {
                return new Comparator<EventInterface.ResourceInterface>(){

                    @Override
                    public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                        int cmp = EventRoomAvailability.this.getOccupancy(r1).compareTo(EventRoomAvailability.this.getOccupancy(r2));
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = (r1.getDistance() == null ? new Double(0.0) : r1.getDistance()).compareTo(r2.getDistance() == null ? new Double(0.0) : r2.getDistance());
                        if (cmp != 0) {
                            return cmp;
                        }
                        if (preferSize && (cmp = (r1.getSize() == null ? new Integer(0) : r1.getSize()).compareTo(r2.getSize() == null ? new Integer(0) : r2.getSize())) != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getId().compareTo(r2.getId()) : cmp;
                    }
                };
            }
        }
        return null;
    }

    private Comparator<EventInterface.ResourceInterface> inverse(final Comparator<EventInterface.ResourceInterface> cmp) {
        return new Comparator<EventInterface.ResourceInterface>(){

            @Override
            public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                return -cmp.compare(r1, r2);
            }
        };
    }

    @Override
    public boolean accept(AcademicSessionSelectionBox.AcademicSession session) {
        return session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasEvents);
    }

    private void hideResults() {
        for (int i = 1; i < this.iPanel.getRowCount(); ++i) {
            this.iPanel.getRowFormatter().setVisible(i, false);
        }
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iHeader.setEnabled("operations", false);
    }

    private void showResults() {
        for (int i = 1; i < this.iPanel.getRowCount(); ++i) {
            this.iPanel.getRowFormatter().setVisible(i, true);
        }
        this.iHeader.setEnabled("print", true);
    }

    private boolean isShowingResults() {
        return ((Object)((Object)this.iPanel)).equals(this.iRootPanel.getWidget()) && this.iPanel.getRowFormatter().isVisible(1);
    }

    private void setup(boolean init) {
        if (init) {
            this.iInitialized = true;
        }
        boolean reload = init;
        boolean isDefault = true;
        if (this.iHistoryToken.isChanged("rooms", "flag:Event", this.iRooms.getValue())) {
            this.iRooms.setValue(this.iHistoryToken.getParameter("rooms", "flag:Event"), true);
            reload = true;
            if (!this.iRooms.getValue().equals("flag:Event")) {
                isDefault = false;
            }
        }
        if (this.iHistoryToken.isChanged("after", this.iTimes.getValue().getStart() == null ? "" : this.iTimes.getValue().getStart().toString()) || this.iHistoryToken.isChanged("before", this.iTimes.getValue().getEnd() == null ? "" : this.iTimes.getValue().getEnd().toString())) {
            String after = this.iHistoryToken.getParameter("after");
            String before = this.iHistoryToken.getParameter("before");
            this.iTimes.setValue(new StartEndTimeSelector.StartEndTime(after == null || after.isEmpty() ? null : Integer.valueOf(after), before == null || before.isEmpty() ? null : Integer.valueOf(before)));
            reload = true;
            if (this.iTimes.getValue().getStart() != null) {
                isDefault = false;
            }
        }
        String dates = "";
        for (Integer date : this.iDates.getSelectedDays()) {
            dates = dates + (dates.isEmpty() ? "" : ",") + date;
        }
        if (this.iHistoryToken.isChanged("dates", dates)) {
            dates = this.iHistoryToken.getParameter("dates");
            ArrayList<Date> val = new ArrayList<Date>();
            if (dates != null && !dates.isEmpty()) {
                for (String d : dates.split(",")) {
                    val.add(this.iDates.getDate(Integer.valueOf(d)));
                }
            }
            this.iDates.setValue(val);
            reload = true;
            if (this.iDates.getSelectedDaysCount() > 0) {
                isDefault = false;
            }
        }
        if (this.iHistoryToken.isChanged("term", this.iSession.getAcademicSessionAbbreviation()) && this.iHistoryToken.getParameter("term") != null) {
            this.iSession.selectSession(this.iHistoryToken.getParameter("term"), null);
        }
        if (this.iHistoryToken.hasParameter("event")) {
            if ("add".equals(this.iHistoryToken.getParameter("event"))) {
                this.iEventAdd.setEvent(null);
                this.iEventAdd.show();
            } else {
                Long eventId = Long.valueOf(this.iHistoryToken.getParameter("event"));
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(this.iSession.getAcademicSessionId(), eventId), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(MESSAGES.anEvent(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        EventRoomAvailability.this.iEventDetail.setEvent(result);
                        EventRoomAvailability.this.iEventDetail.show();
                    }
                }, MESSAGES.waitLoading(MESSAGES.anEvent()));
            }
        } else {
            this.iRootPanel.setWidget((Widget)this.iPanel);
            if (this.iHistoryToken.hasParameter("term") && this.iHistoryToken.isChanged("term", this.iSession.getAcademicSessionAbbreviation())) {
                this.iSession.selectSession(this.iHistoryToken.getParameter("term"), null);
            } else if (reload && this.iProperties != null) {
                this.reload(this.isShowingResults() || !isDefault && CONSTANTS.searchWhenPageIsLoaded());
            }
        }
    }

    private EventInterface.EventFilterRpcRequest getEventsRequest() {
        EventInterface.EventFilterRpcRequest request = new EventInterface.EventFilterRpcRequest();
        request.setSessionId(this.iSession.getAcademicSessionId());
        request.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
        this.iSelectedTimes = this.iTimes.getValue();
        if (this.iSelectedTimes.getStart() != null) {
            int startHour = Math.max(0, (this.iSelectedTimes.getStart() - 6) / 12);
            request.setOption("after", TimeSelector.TimeUtils.slot2time(12 * startHour));
        }
        if (this.iSelectedTimes.getEnd() != null) {
            int endHour = Math.min(24, (17 + this.iSelectedTimes.getEnd()) / 12);
            request.setOption("before", TimeSelector.TimeUtils.slot2time(12 * endHour));
        }
        this.iSelectedDates = this.iDates.getSelectedDays();
        for (Integer date : this.iSelectedDates) {
            request.addOption("dates", date.toString());
        }
        return request;
    }

    private void reload(boolean loadData) {
        if (loadData) {
            if (this.iSession.getAcademicSessionId() == null) {
                UniTimeNotifications.warn(MESSAGES.warnNoSession());
            } else if (this.iProperties == null) {
                UniTimeNotifications.warn(MESSAGES.warnNoEventProperties(this.iSession.getAcademicSessionName()));
            } else if (this.iDates.getSelectedDaysCount() <= 0) {
                UniTimeNotifications.warn(MESSAGES.errorNoDateSelected());
            } else {
                EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
                resource.setType(EventInterface.ResourceType.ROOM);
                resource.setName(this.iRooms.getValue());
                LoadingWidget.execute(this.iRooms.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(MESSAGES.resourceRoom().toLowerCase(), caught.getMessage()), caught);
                        EventRoomAvailability.this.hideResults();
                    }

                    public void onSuccess(EventInterface.FilterRpcResponse result) {
                        if (result == null) {
                            return;
                        }
                        EventRoomAvailability.this.iSelectedRooms = new ArrayList();
                        if (result.hasResults()) {
                            for (EventInterface.FilterRpcResponse.Entity room : result.getResults()) {
                                EventRoomAvailability.this.iSelectedRooms.add(new EventInterface.ResourceInterface(room));
                            }
                        }
                        if (EventRoomAvailability.this.iRooms.getChip("size") != null) {
                            Collections.sort(EventRoomAvailability.this.iSelectedRooms, new Comparator<EventInterface.ResourceInterface>(){

                                @Override
                                public int compare(EventInterface.ResourceInterface r1, EventInterface.ResourceInterface r2) {
                                    int cmp = (r1.getSize() == null ? new Integer(-1) : r1.getSize()).compareTo(r2.getSize() == null ? new Integer(-1) : r2.getSize());
                                    if (cmp != 0) {
                                        return cmp;
                                    }
                                    return r1.compareTo(r2);
                                }
                            });
                        } else {
                            Collections.sort(EventRoomAvailability.this.iSelectedRooms);
                        }
                        if (!result.hasResults() || result.getResults().isEmpty()) {
                            UniTimeNotifications.error(MESSAGES.errorNoMatchingRooms());
                            EventRoomAvailability.this.hideResults();
                            return;
                        }
                        LoadingWidget.execute(EventInterface.EventLookupRpcRequest.findEvents(EventRoomAvailability.this.iSession.getAcademicSessionId(), null, EventRoomAvailability.this.getEventsRequest(), (EventInterface.RoomFilterRpcRequest)EventRoomAvailability.this.iRooms.getElementsRequest(), CONSTANTS.maxMeetings()), new AsyncCallback<GwtRpcResponseList<EventInterface>>(){

                            public void onSuccess(GwtRpcResponseList<EventInterface> result) {
                                EventRoomAvailability.this.populate(result, EventCookie.getInstance().getRoomsSortBy());
                            }

                            public void onFailure(Throwable caught) {
                                UniTimeNotifications.error(MESSAGES.failedLoad(MESSAGES.resourceRoom().toLowerCase(), caught.getMessage()), caught);
                                EventRoomAvailability.this.hideResults();
                            }
                        }, MESSAGES.waitLoadingTimetable(MESSAGES.resourceRoom().toLowerCase(), EventRoomAvailability.this.iSession.getAcademicSessionName()));
                    }
                }, MESSAGES.waitLoadingTimetable(MESSAGES.resourceRoom().toLowerCase(), this.iSession.getAcademicSessionName()));
            }
        } else {
            this.iData = null;
            this.hideResults();
        }
    }

    private void loadProperties(final AsyncCallback<EventInterface.EventPropertiesRpcResponse> callback) {
        this.iProperties = null;
        this.iSessionMonths = null;
        this.iFilterHeader.setEnabled("add", false);
        this.iFooter.setEnabled("add", false);
        if (this.iSession.getAcademicSessionId() != null) {
            RPC.execute(EventInterface.EventPropertiesRpcRequest.requestEventProperties(this.iSession.getAcademicSessionId(), EventResourceTimetable.PageType.Availability.name()), new AsyncCallback<EventInterface.EventPropertiesRpcResponse>(){

                public void onFailure(Throwable caught) {
                    UniTimeNotifications.error(MESSAGES.failedLoad(EventRoomAvailability.this.iSession.getAcademicSessionName(), caught.getMessage()), caught);
                    if (callback != null) {
                        callback.onFailure(caught);
                    }
                }

                public void onSuccess(final EventInterface.EventPropertiesRpcResponse result) {
                    if (result.isCanSaveFilterDefaults()) {
                        EventRoomAvailability.this.iHistoryToken.setDefaultParameter("rooms", result.getFilterDefault("rooms"));
                        EventRoomAvailability.this.iRooms.setDefaultValueProvider(new TakesValue<String>(){

                            public void setValue(final String value) {
                                RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(EventResourceTimetable.PageType.Availability.name() + ".rooms", EventRoomAvailability.this.iRooms.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                    }

                                    public void onSuccess(GwtRpcResponse result) {
                                        EventRoomAvailability.this.iHistoryToken.setDefaultParameter("rooms", value);
                                    }
                                });
                            }

                            public String getValue() {
                                return EventRoomAvailability.this.iHistoryToken.getDefaultParameter("rooms", "");
                            }
                        });
                    }
                    RPC.execute(new EventInterface.RequestSessionDetails(EventRoomAvailability.this.iSession.getAcademicSessionId()), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoad(EventRoomAvailability.this.iSession.getAcademicSessionName(), caught.getMessage()), caught);
                            if (callback != null) {
                                callback.onFailure(caught);
                            }
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> months) {
                            EventRoomAvailability.this.iProperties = result;
                            EventRoomAvailability.this.iSessionMonths = months;
                            EventRoomAvailability.this.iFilterHeader.setEnabled("add", result.isCanAddEvent() && "true".equals(EventRoomAvailability.this.iHistoryToken.getParameter("addEvent", "true")));
                            EventRoomAvailability.this.iFooter.setEnabled("add", result.isCanAddEvent() && "true".equals(EventRoomAvailability.this.iHistoryToken.getParameter("addEvent", "true")));
                            EventRoomAvailability.this.iEventAdd.setup(result);
                            if (callback != null) {
                                callback.onSuccess((Object)result);
                            }
                        }
                    });
                }
            });
        }
    }

    private Collection<EventInterface> sortedEvents() {
        TreeSet<EventInterface> data = new TreeSet<EventInterface>(new Comparator<EventInterface>(){

            @Override
            public int compare(EventInterface e1, EventInterface e2) {
                int cmp = new Integer(e1.getMeetings().first().getDayOfYear()).compareTo(e2.getMeetings().first().getDayOfYear());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = new Integer(e1.getMeetings().first().getStartSlot()).compareTo(e2.getMeetings().first().getStartSlot());
                if (cmp != 0) {
                    return cmp;
                }
                return e1.compareTo(e2);
            }
        });
        data.addAll(this.iData);
        return data;
    }

    private void populate(List<EventInterface> result, Integer sortBy) {
        Comparator<EventInterface.ResourceInterface> comparator;
        for (int i = 0; i < this.iTables.getWidgetCount(); ++i) {
            Widget w = this.iTables.getWidget(i);
            if (!(w instanceof TimeGrid)) continue;
            ((TimeGrid)w).destroy();
        }
        this.iData = result;
        if (sortBy != null && sortBy >= 0 && sortBy < AddMeetingsDialog.SortRoomsBy.values().length) {
            Comparator<EventInterface.ResourceInterface> comparator2 = this.getSortRoomsComparator(AddMeetingsDialog.SortRoomsBy.values()[sortBy], this.iRooms.getChip("size") != null);
            if (comparator2 != null) {
                Collections.sort(this.iSelectedRooms, comparator2);
            }
        } else if (sortBy != null && sortBy >= AddMeetingsDialog.SortRoomsBy.values().length && sortBy < 2 * AddMeetingsDialog.SortRoomsBy.values().length && (comparator = this.getSortRoomsComparator(AddMeetingsDialog.SortRoomsBy.values()[sortBy - AddMeetingsDialog.SortRoomsBy.values().length], this.iRooms.getChip("size") != null)) != null) {
            Collections.sort(this.iSelectedRooms, this.inverse(comparator));
        }
        this.iTables.clear();
        HashMap<Long, String> colors = new HashMap<Long, String>();
        if (this.iSelectedDates.size() == 1) {
            Date date = this.iDates.getDate(this.iSelectedDates.get(0));
            int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
            int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
            int dow = (SingleDateSelector.firstDayOfWeek(year, month) + Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1) % 7;
            int[] days = new int[]{dow};
            EventInterface.WeekInterface week = new EventInterface.WeekInterface();
            week.setDayOfYear(this.iSelectedDates.get(0) - dow);
            for (int i = 0; i < 7; ++i) {
                week.addDayName(new EventInterface.DateInterface(sDateFormat.format(this.iDates.getDate(week.getDayOfYear() + i)), month, week.getDayOfYear() + i));
            }
            ArrayList<EventInterface.WeekInterface> weeks = new ArrayList<EventInterface.WeekInterface>();
            weeks.add(week);
            boolean past = !this.iDates.isEnabled(date) || this.iDates.hasFlag(date, EventInterface.SessionMonth.Flag.PAST);
            for (int i = 0; i < this.iSelectedDates.size(); ++i) {
                int startHour = CONSTANTS.eventStartDefault() / 12;
                if (this.iSelectedTimes.getStart() != null) {
                    startHour = Math.max(0, (this.iSelectedTimes.getStart() - 6) / 12);
                }
                int endHour = (11 + CONSTANTS.eventStopDefault()) / 12;
                if (this.iSelectedTimes.getEnd() != null) {
                    endHour = Math.min(24, (17 + this.iSelectedTimes.getEnd()) / 12);
                }
                TimeGrid grid = new TimeGrid(colors, days, (int)(0.9 * (double)ToolBox.getClientWidth() / (double)days.length), false, false, startHour, endHour, this);
                grid.setResourceType(EventInterface.ResourceType.ROOM);
                grid.setSelectedWeeks(weeks);
                ArrayList<EventInterface.ResourceInterface> rooms = new ArrayList<EventInterface.ResourceInterface>(this.iSelectedRooms);
                grid.setRoomResources(rooms);
                grid.setMode(TimeGrid.Mode.OVERLAP);
                for (EventInterface event : this.sortedEvents()) {
                    ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                    for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                        if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || this.iSelectedDates.get(i).intValue() != meeting.getDayOfYear() || !meeting.hasLocation()) continue;
                        meetings.add(meeting);
                    }
                    if (meetings.isEmpty()) continue;
                    grid.addEvent(event, meetings);
                }
                grid.labelDays(week, null);
                grid.yellow(this.iSelectedTimes.getStart() == null ? CONSTANTS.eventStartDefault() : this.iSelectedTimes.getStart().intValue(), this.iSelectedTimes.getEnd() == null ? CONSTANTS.eventStopDefault() : this.iSelectedTimes.getEnd().intValue());
                if (past) {
                    grid.gray(0, 1);
                }
                grid.showVerticalSplit();
                grid.addMeetingClickHandler(this.iMeetingClickHandler);
                this.iTables.add((Widget)grid);
            }
        } else {
            int[] days = new int[this.iSelectedDates.size()];
            EventInterface.WeekInterface week = new EventInterface.WeekInterface();
            week.setDayOfYear(this.iSelectedDates.get(0));
            ArrayList<String> dows = new ArrayList<String>();
            int lastPast = -1;
            for (int i = 0; i < this.iSelectedDates.size(); ++i) {
                Date date = this.iDates.getDate(this.iSelectedDates.get(i));
                int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
                int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
                int dow = (SingleDateSelector.firstDayOfWeek(year, month) + Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1) % 7;
                days[i] = i;
                week.addDayName(new EventInterface.DateInterface(sDateFormat.format(date), month, this.iSelectedDates.get(i)));
                dows.add(CONSTANTS.days()[dow]);
                if (this.iDates.isEnabled(date) && !this.iDates.hasFlag(date, EventInterface.SessionMonth.Flag.PAST)) continue;
                lastPast = i;
            }
            ArrayList<EventInterface.WeekInterface> weeks = new ArrayList<EventInterface.WeekInterface>();
            weeks.add(week);
            for (EventInterface.ResourceInterface room : this.iSelectedRooms) {
                P hp = new P("unitime-RoomAvailabilityHeader");
                HTML name = new HTML(room.getNameWithSizeAndHint(MESSAGES), false);
                name.setStyleName("name");
                hp.add((Widget)name);
                HTML type = new HTML(room.getRoomType(), false);
                type.setStyleName("type");
                hp.add((Widget)type);
                HTML warn = new HTML(room.hasMessage() && room.isShowMessageInGrid() ? room.getMessage() : "");
                warn.setStyleName("warning");
                hp.add((Widget)warn);
                if (this.iTables.getWidgetCount() > 0) {
                    hp.addStyleName("unitime-TopLineDash");
                }
                this.iTables.add((Widget)hp);
                int startHour = CONSTANTS.eventStartDefault() / 12;
                if (this.iSelectedTimes.getStart() != null) {
                    startHour = Math.max(0, (this.iSelectedTimes.getStart() - 6) / 12);
                }
                int endHour = (11 + CONSTANTS.eventStopDefault()) / 12;
                if (this.iSelectedTimes.getEnd() != null) {
                    endHour = Math.min(24, (17 + this.iSelectedTimes.getEnd()) / 12);
                }
                TimeGrid grid = new TimeGrid(colors, days, (int)(0.9 * (double)ToolBox.getClientWidth() / (double)days.length), false, false, startHour, endHour, this);
                grid.setResourceType(EventInterface.ResourceType.ROOM);
                grid.setSelectedWeeks(weeks);
                ArrayList<EventInterface.ResourceInterface> rooms = new ArrayList<EventInterface.ResourceInterface>();
                rooms.add(room);
                grid.setRoomResources(rooms);
                grid.setMode(TimeGrid.Mode.OVERLAP);
                for (EventInterface event : this.sortedEvents()) {
                    ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                    for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                        int idx;
                        if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || meeting.getMeetingDate() == null || !meeting.hasLocation() || !meeting.getLocation().getId().equals(room.getId()) || (idx = this.iSelectedDates.indexOf(meeting.getDayOfYear())) < 0) continue;
                        meeting.setGridIndex(idx);
                        meetings.add(meeting);
                    }
                    if (meetings.isEmpty()) continue;
                    grid.addEvent(event, meetings);
                }
                grid.labelDays(dows, week);
                grid.yellow(this.iSelectedTimes.getStart() == null ? CONSTANTS.eventStartDefault() : this.iSelectedTimes.getStart().intValue(), this.iSelectedTimes.getEnd() == null ? CONSTANTS.eventStopDefault() : this.iSelectedTimes.getEnd().intValue());
                if (lastPast >= 0) {
                    grid.gray(0, lastPast);
                }
                grid.addMeetingClickHandler(this.iMeetingClickHandler);
                this.iTables.add((Widget)grid);
            }
        }
        this.showResults();
        this.changeUrl();
    }

    @Override
    public Long getSessionId() {
        return this.iSession.getAcademicSessionId();
    }

    @Override
    public EventInterface.EventPropertiesRpcResponse getProperties() {
        return this.iProperties;
    }

    @Override
    public List<EventInterface.SelectionInterface> getSelection() {
        ArrayList<EventInterface.SelectionInterface> selection = new ArrayList<EventInterface.SelectionInterface>();
        for (int i = 0; i < this.iTables.getWidgetCount(); ++i) {
            Widget w = this.iTables.getWidget(i);
            if (!(w instanceof TimeGrid)) continue;
            for (EventInterface.SelectionInterface s : ((TimeGrid)w).getSelections()) {
                EventInterface.SelectionInterface x = new EventInterface.SelectionInterface();
                x.setLength(s.getLength());
                x.setStartSlot(s.getStartSlot());
                for (EventInterface.ResourceInterface r : s.getLocations()) {
                    x.addLocation(r);
                }
                for (Integer d : s.getDays()) {
                    x.addDay(this.iSelectedDates.get(d - this.iSelectedDates.get(0)));
                }
                selection.add(x);
            }
        }
        return selection;
    }

    @Override
    public String getRoomFilter() {
        return this.iRooms.getValue();
    }

    @Override
    public List<Date> getSelectedDates() {
        return this.iDates.getValue();
    }

    @Override
    public StartEndTimeSelector.StartEndTime getSelectedTime() {
        return this.iTimes.getValue();
    }

    @Override
    public EventInterface.ContactInterface getMainContact() {
        return this.iProperties == null ? null : this.iProperties.getMainContact();
    }

    @Override
    public boolean isTooEarly(int startSlot, int endSlot) {
        if (this.iProperties == null || !this.iProperties.hasTooEarlySlot()) {
            return false;
        }
        return startSlot > 0 && startSlot <= this.iProperties.getTooEarlySlot() || startSlot == 0 && endSlot <= this.iProperties.getTooEarlySlot();
    }

    @Override
    public EventInterface.SessionMonth.Flag getDateFlag(EventInterface.EventType type, Date date) {
        if (this.iSessionMonths == null || this.iSessionMonths.isEmpty()) {
            return null;
        }
        if (date == null) {
            return null;
        }
        int m = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
        for (EventInterface.SessionMonth month : this.iSessionMonths) {
            if (m != month.getMonth() + 1) continue;
            int d = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1;
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.FINALS) && type != EventInterface.EventType.FinalExam) {
                return EventInterface.SessionMonth.Flag.FINALS;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.BREAK)) {
                return EventInterface.SessionMonth.Flag.BREAK;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.WEEKEND)) {
                return EventInterface.SessionMonth.Flag.WEEKEND;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.HOLIDAY)) {
                return EventInterface.SessionMonth.Flag.HOLIDAY;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.MIDTERMS) && type != EventInterface.EventType.MidtermExam) {
                return EventInterface.SessionMonth.Flag.MIDTERMS;
            }
            return null;
        }
        return null;
    }

    protected void changeUrl() {
        this.iHistoryToken.reset(null);
        this.iHistoryToken.setParameter("term", this.iSession.getAcademicSessionAbbreviation());
        this.iHistoryToken.setParameter("rooms", this.iRooms.getValue().trim());
        if (((Object)((Object)this.iEventDetail)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("event", this.iEventDetail.getEvent().getId());
        } else if (this.iEventAdd.equals(this.iRootPanel.getWidget())) {
            Long id = this.iEventAdd.getEventId();
            this.iHistoryToken.setParameter("event", id == null ? "add" : id.toString());
        }
        this.iSelectedTimes = this.iTimes.getValue();
        if (this.iTimes.getValue().getStart() != null) {
            this.iHistoryToken.setParameter("after", this.iTimes.getValue().getStart().toString());
        }
        if (this.iTimes.getValue().getEnd() != null) {
            this.iHistoryToken.setParameter("before", this.iTimes.getValue().getEnd().toString());
        }
        this.iSelectedDates = this.iDates.getSelectedDays();
        String dates = "";
        for (Integer date : this.iDates.getSelectedDays()) {
            dates = dates + (dates.isEmpty() ? "" : ",") + date;
        }
        if (!dates.isEmpty()) {
            this.iHistoryToken.setParameter("dates", dates);
        }
        this.iHistoryToken.mark();
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    private GwtRpcResponseList<EventInterface> tinker(GwtRpcResponseList<EventInterface> data, Long oldEventId, EventInterface newEvent) {
        Iterator i = data.iterator();
        while (i.hasNext()) {
            EventInterface event = (EventInterface)i.next();
            if (event.getId().equals(oldEventId)) {
                i.remove();
                continue;
            }
            if (event.hasConflicts()) {
                Iterator<EventInterface> j = event.getConflicts().iterator();
                while (j.hasNext()) {
                    if (!j.next().getId().equals(oldEventId)) continue;
                    j.remove();
                }
            }
            if (newEvent == null || newEvent.getId() == null || !event.inConflict(newEvent)) continue;
            event.addConflict(event.createConflictingEvent(newEvent));
        }
        if (newEvent != null && newEvent.getId() != null) {
            data.add(newEvent);
        }
        return data;
    }
}

