/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.IntervalSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcademicSessionSelectionBox
extends IntervalSelector<AcademicSession>
implements AcademicSessionProvider {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private List<AcademicSession> iAllSessions = null;
    private AcademicSessionFilter iFilter = null;
    private List<AcademicSessionProvider.AcademicSessionChangeHandler> iChangeHandlers = new ArrayList<AcademicSessionProvider.AcademicSessionChangeHandler>();
    private Long iLastSessionId = null;

    public AcademicSessionSelectionBox(String term, String source) {
        super(false);
        this.setHint(MESSAGES.waitLoadingSessions());
        RPC.execute(new ListAcademicSessions(term, source), new AsyncCallback<GwtRpcResponseList<AcademicSession>>(){

            public void onFailure(Throwable caught) {
                AcademicSessionSelectionBox.this.setErrorHint(caught.getMessage());
                ToolBox.checkAccess(caught);
                AcademicSessionSelectionBox.this.onInitializationFailure(caught);
            }

            public void onSuccess(GwtRpcResponseList<AcademicSession> result) {
                AcademicSessionSelectionBox.this.clearHint();
                AcademicSessionSelectionBox.this.iAllSessions = result;
                AcademicSessionSelectionBox.this.setValues((List<AcademicSession>)result);
                AcademicSessionSelectionBox.this.onInitializationSuccess(result);
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<IntervalSelector.Interval>(){

            public void onValueChange(ValueChangeEvent<IntervalSelector.Interval> event) {
                AcademicSessionSelectionBox.this.fireAcademicSessionChanged();
                AcademicSessionSelectionBox.this.setAriaLabel(ARIA.academicSession(AcademicSessionSelectionBox.this.toAriaString()));
            }
        });
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                AcademicSessionSelectionBox.this.setAriaLabel(ARIA.academicSession(AcademicSessionSelectionBox.this.toAriaString()));
            }
        });
    }

    protected void onInitializationSuccess(List<AcademicSession> sessions) {
    }

    protected void onInitializationFailure(Throwable caught) {
    }

    @Override
    public Long getAcademicSessionId() {
        return this.getValue() == null ? null : (this.getValues().isEmpty() ? null : ((AcademicSession)this.getValue().getFirst()).getUniqueId());
    }

    @Override
    public String getAcademicSessionName() {
        return this.getValue() == null ? null : (this.getValues().isEmpty() ? null : ((AcademicSession)this.getValue().getFirst()).getName());
    }

    public String getAcademicSessionAbbreviation() {
        return this.getValue() == null ? null : (this.getValues().isEmpty() ? null : ((AcademicSession)this.getValue().getFirst()).getAbbv());
    }

    @Override
    public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
        this.iChangeHandlers.add(handler);
    }

    @Override
    public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
        if (sessionId != null && sessionId.equals(this.getAcademicSessionId())) {
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
            return;
        }
        if (sessionId == null && this.getAcademicSessionId() == null) {
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
            return;
        }
        if (sessionId == null) {
            this.setValue(null);
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
        } else {
            boolean found = false;
            if (this.getValues() != null) {
                for (AcademicSession session : this.getValues()) {
                    if (!session.getUniqueId().equals(sessionId)) continue;
                    this.setValue(new IntervalSelector.Interval(this, session));
                    if (callback != null) {
                        callback.onSuccess((Object)true);
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.setValue(null);
                if (callback != null) {
                    callback.onSuccess((Object)false);
                }
            }
        }
        this.fireAcademicSessionChanged();
    }

    public void selectSession(String sessionAbbreviation, AsyncCallback<Boolean> callback) {
        if (sessionAbbreviation != null && sessionAbbreviation.equals(this.getAcademicSessionAbbreviation())) {
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
            return;
        }
        if (sessionAbbreviation == null && this.getAcademicSessionAbbreviation() == null) {
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
            return;
        }
        if (sessionAbbreviation == null) {
            this.setValue(null);
            if (callback != null) {
                callback.onSuccess((Object)true);
            }
        } else {
            boolean found = false;
            if (this.getValues() != null) {
                for (AcademicSession session : this.getValues()) {
                    if (!sessionAbbreviation.equals(session.getAbbv())) continue;
                    this.setValue(new IntervalSelector.Interval(this, session));
                    if (callback != null) {
                        callback.onSuccess((Object)true);
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.setValue(null);
                if (callback != null) {
                    callback.onSuccess((Object)false);
                }
            }
        }
        this.fireAcademicSessionChanged();
    }

    public void fireAcademicSessionChanged() {
        final Long oldSession = this.iLastSessionId;
        this.iLastSessionId = this.getAcademicSessionId();
        AcademicSessionProvider.AcademicSessionChangeEvent event = new AcademicSessionProvider.AcademicSessionChangeEvent(){

            public boolean isChanged() {
                if (oldSession == null) {
                    return AcademicSessionSelectionBox.this.getAcademicSessionId() != null;
                }
                return !oldSession.equals(AcademicSessionSelectionBox.this.getAcademicSessionId());
            }

            public Long getOldAcademicSessionId() {
                return oldSession;
            }

            public Long getNewAcademicSessionId() {
                return AcademicSessionSelectionBox.this.getAcademicSessionId();
            }
        };
        for (AcademicSessionProvider.AcademicSessionChangeHandler handler : this.iChangeHandlers) {
            handler.onAcademicSessionChange(event);
        }
    }

    @Override
    public void setValue(IntervalSelector.Interval value, boolean fire) {
        if (value == null && this.getValues() != null) {
            for (AcademicSession session : this.getValues()) {
                if (!session.isSelected()) continue;
                value = new IntervalSelector.Interval(this, session);
                break;
            }
        }
        if (value != null && value.isOne()) {
            this.setHint(((AcademicSession)value.getFirst()).getHint());
        }
        super.setValue(value, fire);
    }

    protected AcademicSession session(Long id) {
        if (this.iAllSessions != null && id != null) {
            for (AcademicSession session : this.iAllSessions) {
                if (!session.getUniqueId().equals(id)) continue;
                return session;
            }
        }
        return null;
    }

    @Override
    protected IntervalSelector.Interval previous(IntervalSelector.Interval interval) {
        if (interval.isOne()) {
            AcademicSession prev = this.session(((AcademicSession)interval.getFirst()).getPreviousId());
            while (prev != null && this.iFilter != null && !this.iFilter.accept(prev)) {
                prev = this.session(prev.getPreviousId());
            }
            if (prev != null) {
                return new IntervalSelector.Interval(this, prev);
            }
        }
        return null;
    }

    @Override
    protected IntervalSelector.Interval next(IntervalSelector.Interval interval) {
        if (interval.isOne()) {
            AcademicSession next = this.session(((AcademicSession)interval.getFirst()).getNextId());
            while (next != null && this.iFilter != null && !this.iFilter.accept(next)) {
                next = this.session(next.getNextId());
            }
            if (next != null) {
                return new IntervalSelector.Interval(this, next);
            }
        }
        return null;
    }

    public void setFilter(AcademicSessionFilter filter) {
        this.iFilter = filter;
        if (this.iAllSessions != null) {
            this.setValues(this.iAllSessions);
            this.setValue(this.getValue(), false);
        }
    }

    public List<AcademicSession> getAllSessions() {
        return this.iAllSessions;
    }

    @Override
    public void setValues(List<AcademicSession> sessions) {
        ArrayList<AcademicSession> filtered = new ArrayList<AcademicSession>();
        AcademicSession selected = null;
        for (AcademicSession session : sessions) {
            if (this.iFilter != null && !this.iFilter.accept(session)) continue;
            filtered.add(session);
            if (!session.isSelected()) continue;
            selected = session;
        }
        if (selected == null) {
            selected = filtered.isEmpty() ? null : (AcademicSession)filtered.get(filtered.size() - 1);
        }
        this.setDefaultValue(new IntervalSelector.Interval(this, selected));
        super.setValues(filtered);
        if (filtered.isEmpty()) {
            this.setErrorHint(MESSAGES.noSessionAvailable());
            UniTimeNotifications.error(MESSAGES.noSessionAvailable());
        } else if (this.getValue() == null && this.getDefaultValue() != null) {
            this.setValue(this.getDefaultValue(), true);
        }
    }

    @Override
    public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
        return null;
    }

    public static interface AcademicSessionFilter {
        public boolean accept(AcademicSession var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAcademicSessions
    implements GwtRpcRequest<GwtRpcResponseList<AcademicSession>> {
        private String iTerm = null;
        private String iSource = null;

        public ListAcademicSessions() {
        }

        public ListAcademicSessions(String term, String source) {
            this.iTerm = term;
            this.iSource = source;
        }

        public boolean hasTerm() {
            return this.iTerm != null && !this.iTerm.isEmpty();
        }

        public String getTerm() {
            return this.iTerm;
        }

        public boolean hasSource() {
            return this.iSource != null && !this.iSource.isEmpty();
        }

        public String getSource() {
            return this.iSource;
        }

        @Override
        public String toString() {
            return this.hasTerm() ? this.getTerm() : "";
        }
    }

    public static class AcademicSession
    implements IsSerializable {
        private Long iUniqueId;
        private String iName;
        private String iAbbv;
        private String iHint;
        private boolean iSelected;
        private Long iPreviousId;
        private Long iNextId;
        private int iFlags = 0;

        public AcademicSession() {
        }

        public AcademicSession(Long uniqueId, String name, String abbv, String hint, boolean selected) {
            this.iUniqueId = uniqueId;
            this.iName = name;
            this.iAbbv = abbv;
            this.iHint = hint;
            this.iSelected = selected;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public String getName() {
            return this.iName;
        }

        public String getAbbv() {
            return this.iAbbv;
        }

        public String getHint() {
            return this.iHint;
        }

        public boolean isSelected() {
            return this.iSelected;
        }

        public Long getPreviousId() {
            return this.iPreviousId;
        }

        public void setPreviousId(Long id) {
            this.iPreviousId = id;
        }

        public Long getNextId() {
            return this.iNextId;
        }

        public void setNextId(Long id) {
            this.iNextId = id;
        }

        public boolean has(Flag f) {
            return f.in(this.iFlags);
        }

        public void set(Flag f) {
            this.iFlags = f.set(this.iFlags);
        }

        public void clear(Flag f) {
            this.iFlags = f.clear(this.iFlags);
        }

        public String toString() {
            return this.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flag {
            HasClasses,
            HasMidtermExams,
            HasFinalExams,
            HasEvents,
            CanAddEvents;


            public int flag() {
                return 1 << this.ordinal();
            }

            public boolean in(int flags) {
                return (flags & this.flag()) != 0;
            }

            public int set(int flags) {
                return this.in(flags) ? flags : flags + this.flag();
            }

            public int clear(int flags) {
                return this.in(flags) ? flags - this.flag() : flags;
            }
        }
    }
}

