/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.context.HttpSessionContext;

public class SubjectAreaEditForm
extends ActionForm {
    private static final long serialVersionUID = -8093172074512485680L;
    private Long uniqueId;
    private String op;
    private String abbv;
    private String title;
    private String externalId;
    private Long department;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.op.equals(rsc.getMessage("button.deleteSubjectArea"))) {
            SubjectArea sa = (SubjectArea)new SubjectAreaDAO().get(this.getUniqueId());
            if (sa.hasOfferedCourses()) {
                errors.add("uniqueid", new ActionMessage("errors.generic", (Object)"A subject area with offered classes cannot be deleted"));
            }
        } else {
            if (this.abbv == null || this.abbv.trim().length() == 0) {
                errors.add("abbv", new ActionMessage("errors.required", (Object)"Abbreviation"));
            }
            if (this.title == null || this.title.trim().length() == 0) {
                errors.add("title", new ActionMessage("errors.required", (Object)"Title"));
            }
            if (this.department == null || this.department <= 0L) {
                errors.add("department", new ActionMessage("errors.required", (Object)"Department"));
            }
            if (errors.size() == 0) {
                Long sessionId = HttpSessionContext.getSessionContext(request.getSession().getServletContext()).getUser().getCurrentAcademicSessionId();
                SubjectArea sa = SubjectArea.findByAbbv(sessionId, this.abbv);
                if (this.uniqueId == null && sa != null) {
                    errors.add("abbv", new ActionMessage("errors.generic", (Object)"A subject area with the abbreviation exists for the academic session"));
                }
                if (this.uniqueId != null && sa != null && !sa.getUniqueId().equals(this.uniqueId)) {
                    errors.add("abbv", new ActionMessage("errors.generic", (Object)"A subject area with the abbreviation exists for the academic session"));
                }
            }
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.uniqueId = null;
        this.op = null;
        this.abbv = null;
        this.title = null;
        this.externalId = null;
        this.department = null;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getAbbv() {
        return this.abbv;
    }

    public void setAbbv(String abbv) {
        this.abbv = abbv;
    }

    public Long getDepartment() {
        return this.department;
    }

    public void setDepartment(Long department) {
        this.department = department;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId != null && uniqueId <= 0L ? null : uniqueId;
    }
}

