/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class ClassesForm
extends ActionForm {
    private static final long serialVersionUID = -2473101585994845220L;
    private String iOp = null;
    private Long iSession = null;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private Collection iSubjectAreas = null;
    private Vector iSessions = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private String iMessage;
    private Boolean canRetrieveAllClassesForAllSubjects;
    private String iUser;
    private String iPassword;

    public Boolean getCanRetrieveAllClassesForAllSubjects() {
        return this.canRetrieveAllClassesForAllSubjects;
    }

    public void setCanRetrieveAllClassesForAllSubjects(Boolean canRetrieveAllClassesForAllSubjects) {
        this.canRetrieveAllClassesForAllSubjects = canRetrieveAllClassesForAllSubjects;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iSession = null;
        this.iUser = null;
        this.iPassword = null;
        this.iMessage = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.iCourseNumber = courseNumber;
    }

    public Long getSession() {
        return this.iSession;
    }

    public void setSession(Long session) {
        this.iSession = session;
    }

    public Collection getSessions() {
        return this.iSessions;
    }

    public Boolean canDisplayAllSubjectsAtOnce() {
        Boolean displayAll = new Boolean(false);
        if (this.iSession != null) {
            String queryStr = "select count(io) from InstructionalOffering io where io.session.uniqueId = :sessionId";
            int count = ((Number)SessionDAO.getInstance().getQuery(queryStr).setLong("sessionId", this.iSession.longValue()).setCacheable(true).uniqueResult()).intValue();
            if (count <= 300) {
                displayAll = new Boolean(true);
            }
        }
        return displayAll;
    }

    public void load(HttpSession session) {
        this.setSubjectArea(session.getAttribute("Classes.subjectArea") == null ? null : (String)session.getAttribute("Classes.subjectArea"));
        this.setCourseNumber(session.getAttribute("Classes.courseNumber") == null ? null : (String)session.getAttribute("Classes.courseNumber"));
        this.iSessions = new Vector();
        this.setSession((Long)(session.getAttribute("Classes.session") == null ? (this.iSessions.isEmpty() ? null : Long.valueOf(((ComboBoxLookup)this.iSessions.lastElement()).getValue())) : (Long)session.getAttribute("Classes.session")));
        boolean hasSession = false;
        for (Session s : Session.getAllSessions()) {
            if (s.getStatusType() == null || !s.getStatusType().canNoRoleReportClass() || !Solution.hasTimetable(s.getUniqueId())) continue;
            if (s.getUniqueId().equals(this.getSession())) {
                hasSession = true;
            }
            this.iSessions.add(new ComboBoxLookup(s.getLabel(), s.getUniqueId().toString()));
        }
        if (!hasSession) {
            this.setSession(null);
            this.setSubjectArea(null);
        }
        if (this.getSession() == null && !this.iSessions.isEmpty()) {
            this.setSession(Long.valueOf(((ComboBoxLookup)this.iSessions.lastElement()).getValue()));
        }
        this.iSubjectAreas = new TreeSet(new SubjectAreaDAO().getSession().createQuery("select distinct sa.subjectAreaAbbreviation from SubjectArea sa").setCacheable(true).list());
        this.setCanRetrieveAllClassesForAllSubjects(this.canDisplayAllSubjectsAtOnce());
    }

    public void save(HttpSession session) {
        if (this.getSubjectArea() == null) {
            session.removeAttribute("Classes.subjectArea");
        } else {
            session.setAttribute("Classes.subjectArea", (Object)this.getSubjectArea());
        }
        if (this.getCourseNumber() == null) {
            session.removeAttribute("Classes.courseNumber");
        } else {
            session.setAttribute("Classes.courseNumber", (Object)this.getCourseNumber());
        }
        if (this.getSession() == null) {
            session.removeAttribute("Classes.session");
        } else {
            session.setAttribute("Classes.session", (Object)this.getSession());
        }
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public String getUsername() {
        return this.iUser;
    }

    public void setUsername(String user) {
        this.iUser = user;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getSessionLabel() {
        if (this.iSessions == null) {
            return "";
        }
        Enumeration e = this.iSessions.elements();
        while (e.hasMoreElements()) {
            ComboBoxLookup s = (ComboBoxLookup)e.nextElement();
            if (!Long.valueOf(s.getValue()).equals(this.getSession())) continue;
            return s.getLabel();
        }
        return "";
    }
}

