/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:meetings.csv")
public class EventsExportMeetingsToCSV
extends EventsExporter {
    @Override
    public String reference() {
        return "meetings.csv";
    }

    @Override
    protected void print(ExportHelper helper, EventInterface.EventLookupRpcRequest request, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        CSVPrinter printer = new CSVPrinter(helper.getWriter(), false);
        helper.setup(printer.getContentType(), this.reference(), false);
        this.hideColumns(printer, events, eventCookieFlags);
        this.print(printer, this.meetings(events, sort, asc));
    }

    @Override
    protected void hideColumn(Exporter.Printer out, List<EventInterface> events, EventInterface.EventFlag flag) {
        switch (flag) {
            case SHOW_SECTION: {
                out.hideColumn(1);
                break;
            }
            case SHOW_TITLE: {
                out.hideColumn(3);
                break;
            }
            case SHOW_NOTE: {
                out.hideColumn(4);
                break;
            }
            case SHOW_PUBLISHED_TIME: {
                out.hideColumn(6);
                out.hideColumn(7);
                break;
            }
            case SHOW_ALLOCATED_TIME: {
                out.hideColumn(8);
                out.hideColumn(9);
                break;
            }
            case SHOW_SETUP_TIME: {
                out.hideColumn(10);
                break;
            }
            case SHOW_TEARDOWN_TIME: {
                out.hideColumn(11);
                break;
            }
            case SHOW_CAPACITY: {
                out.hideColumn(13);
                break;
            }
            case SHOW_MEETING_CONTACTS: {
                out.hideColumn(14);
                break;
            }
            case SHOW_ENROLLMENT: {
                out.hideColumn(15);
                break;
            }
            case SHOW_LIMIT: {
                out.hideColumn(16);
                break;
            }
            case SHOW_SPONSOR: {
                out.hideColumn(17);
                out.hideColumn(18);
                break;
            }
            case SHOW_REQUESTED_SERVICES: {
                out.hideColumn(19);
                break;
            }
            case SHOW_MAIN_CONTACT: {
                out.hideColumn(20);
                out.hideColumn(21);
                break;
            }
            case SHOW_APPROVAL: {
                out.hideColumn(22);
                break;
            }
            case SHOW_LAST_CHANGE: {
                out.hideColumn(23);
            }
        }
    }

    protected void print(Exporter.Printer out, Set<EventsExporter.EventMeeting> meetings) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colSection(), MESSAGES.colType(), MESSAGES.colTitle(), MESSAGES.colNote(), MESSAGES.colDate(), MESSAGES.colPublishedStartTime(), MESSAGES.colPublishedEndTime(), MESSAGES.colAllocatedStartTime(), MESSAGES.colAllocatedEndTime(), MESSAGES.colSetupTimeShort(), MESSAGES.colTeardownTimeShort(), MESSAGES.colLocation(), MESSAGES.colCapacity(), MESSAGES.colMeetingContacts(), MESSAGES.colEnrollment(), MESSAGES.colLimit(), MESSAGES.colSponsorOrInstructor(), MESSAGES.colEmail(), MESSAGES.colRequestedServices(), MESSAGES.colMainContact(), MESSAGES.colEmail(), MESSAGES.colApproval(), MESSAGES.colLastChange());
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        EventInterface last = null;
        for (EventsExporter.EventMeeting em : meetings) {
            EventInterface event = em.getEvent();
            EventInterface.MeetingInterface meeting = em.getMeeting();
            if (last == null || !last.equals(event)) {
                out.flush();
                last = event;
            }
            String[] stringArray = new String[24];
            stringArray[0] = this.getName(event);
            stringArray[1] = this.getSection(event);
            stringArray[2] = event.hasInstruction() ? event.getInstruction() : event.getType().getAbbreviation(CONSTANTS);
            stringArray[3] = this.getTitle(event);
            stringArray[4] = event.hasEventNote() ? event.getEventNote("\n").replace("<br>", "\n") : "";
            stringArray[5] = meeting.isArrangeHours() ? "" : df.format(meeting.getMeetingDate());
            stringArray[6] = meeting.isArrangeHours() ? "" : meeting.getStartTime(CONSTANTS, true);
            stringArray[7] = meeting.isArrangeHours() ? "" : meeting.getEndTime(CONSTANTS, true);
            stringArray[8] = meeting.isArrangeHours() ? "" : meeting.getStartTime(CONSTANTS, false);
            stringArray[9] = meeting.isArrangeHours() ? "" : meeting.getEndTime(CONSTANTS, false);
            stringArray[10] = meeting.isArrangeHours() ? "" : String.valueOf(meeting.getStartOffset());
            stringArray[11] = meeting.isArrangeHours() ? "" : String.valueOf(-meeting.getEndOffset());
            stringArray[12] = meeting.getLocationName(MESSAGES);
            stringArray[13] = meeting.hasLocation() && meeting.getLocation().hasSize() ? meeting.getLocation().getSize().toString() : null;
            stringArray[14] = meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES);
            stringArray[15] = event.hasMaxCapacity() ? event.getMaxCapacity().toString() : null;
            String string = stringArray[16] = event.hasEnrollment() ? event.getEnrollment().toString() : null;
            String string2 = event.hasInstructors() ? event.getInstructorNames("\n", MESSAGES) : (stringArray[17] = event.hasSponsor() ? event.getSponsor().getName() : null);
            stringArray[18] = event.hasInstructors() ? event.getInstructorEmails("\n") : (event.hasSponsor() ? event.getSponsor().getEmail() : null);
            stringArray[19] = event.hasRequestedServices() ? event.getRequestedServices("\n") : null;
            stringArray[20] = event.hasContact() ? event.getContact().getName(MESSAGES) : null;
            String string3 = stringArray[21] = event.hasContact() ? event.getContact().getEmail() : null;
            stringArray[22] = event.getType() == EventInterface.EventType.Unavailabile ? "" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? df.format(meeting.getApprovalDate()) : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? MESSAGES.approvalCancelled() : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? MESSAGES.approvalRejected() : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? MESSAGES.approvalDeleted() : (meeting.isPast() ? MESSAGES.approvalNotApprovedPast() : (event.getExpirationDate() != null ? MESSAGES.approvalExpire(df.format(event.getExpirationDate())) : MESSAGES.approvalNotApproved()))))));
            stringArray[23] = event.getLastNote() != null ? df.format(event.getLastNote().getDate()) + " " + event.getLastNote().getType().getName() : null;
            out.printLine(stringArray);
        }
        out.flush();
        out.close();
    }
}

