/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.SubjectAreaEditForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalCourseOfferingRemoveAction;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/subjectAreaEdit")
public class SubjectAreaEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        this.sessionContext.checkPermission(Right.SubjectAreas);
        SubjectAreaEditForm frm = (SubjectAreaEditForm)form;
        MessageResources rsc = this.getResources(request);
        ActionErrors errors = null;
        String string = op = frm.getOp() != null ? frm.getOp() : request.getParameter("op");
        if (op.equals(rsc.getMessage("button.addSubjectArea"))) {
            this.sessionContext.checkPermission(Right.SubjectAreaAdd);
            LookupTables.setupNonExternalDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return mapping.findForward("addSubjectArea");
        }
        if (op.equals(rsc.getMessage("op.edit"))) {
            this.doLoad(request, frm);
            LookupTables.setupNonExternalDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return mapping.findForward("editSubjectArea");
        }
        if ((op.equals(rsc.getMessage("button.updateSubjectArea")) || op.equals(rsc.getMessage("button.saveSubjectArea"))) && (errors = frm.validate(mapping, request)).size() == 0) {
            this.doUpdate(request, frm);
        }
        if (op.equals(rsc.getMessage("button.deleteSubjectArea")) && (errors = frm.validate(mapping, request)).size() == 0) {
            this.doDelete(request, frm);
        }
        if (frm.getUniqueId() != null) {
            request.setAttribute(Constants.JUMP_TO_ATTR_NAME, (Object)frm.getUniqueId().toString());
        }
        if (errors != null && errors.size() > 0) {
            this.saveErrors(request, (ActionMessages)errors);
            LookupTables.setupNonExternalDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            if (frm.getUniqueId() != null) {
                return mapping.findForward("editSubjectArea");
            }
            return mapping.findForward("addSubjectArea");
        }
        return mapping.findForward("back");
    }

    private void doLoad(HttpServletRequest request, SubjectAreaEditForm frm) throws Exception {
        Long id = null;
        try {
            id = Long.parseLong(request.getParameter("id"));
        }
        catch (Exception e) {
            throw new Exception("Invalid Subject Area IDencountered");
        }
        this.sessionContext.checkPermission(id, "SubjectArea", Right.SubjectAreaEdit);
        SubjectArea sa = (SubjectArea)new SubjectAreaDAO().get(id);
        frm.setUniqueId(id);
        frm.setAbbv(sa.getSubjectAreaAbbreviation() != null ? sa.getSubjectAreaAbbreviation() : "");
        frm.setDepartment(sa.getDepartment() != null ? sa.getDepartment().getUniqueId() : null);
        frm.setExternalId(sa.getExternalUniqueId() != null ? sa.getExternalUniqueId() : "");
        frm.setTitle(sa.getTitle() != null ? sa.getTitle() : "");
    }

    private void doDelete(HttpServletRequest request, SubjectAreaEditForm frm) throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        this.sessionContext.checkPermission(frm.getUniqueId(), "SubjectArea", Right.SubjectAreaDelete);
        try {
            SubjectAreaDAO sdao = new SubjectAreaDAO();
            hibSession = sdao.getSession();
            tx = hibSession.beginTransaction();
            SubjectArea sa = (SubjectArea)sdao.get(frm.getUniqueId());
            String className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
            if (className != null && className.trim().length() > 0) {
                ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).newInstance();
                for (CourseOffering co : sa.getCourseOfferings()) {
                    removeAction.performExternalCourseOfferingRemoveAction(co, hibSession);
                }
            }
            Set<InstructionalOffering> s = sa.getInstructionalOfferings();
            for (InstructionalOffering io : s) {
                io.deleteAllDistributionPreferences(hibSession);
                io.deleteAllClasses(hibSession);
                io.deleteAllCourses(hibSession);
                hibSession.delete((Object)io);
            }
            for (CourseOffering co : sa.getCourseOfferings()) {
                hibSession.delete((Object)co);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, sa, ChangeLog.Source.SUBJECT_AREA_EDIT, ChangeLog.Operation.DELETE, null, sa.getDepartment());
            hibSession.delete((Object)sa);
            tx.commit();
            hibSession.flush();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private void doUpdate(HttpServletRequest request, SubjectAreaEditForm frm) throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        if (frm.getUniqueId() == null) {
            this.sessionContext.checkPermission(Right.SubjectAreaAdd);
        } else {
            this.sessionContext.checkPermission(frm.getUniqueId(), "SubjectArea", Right.SubjectAreaEdit);
        }
        try {
            String className;
            SubjectAreaDAO sdao = new SubjectAreaDAO();
            DepartmentDAO ddao = new DepartmentDAO();
            SubjectArea sa = null;
            Department oldDept = null;
            hibSession = sdao.getSession();
            tx = hibSession.beginTransaction();
            sa = frm.getUniqueId() != null ? (SubjectArea)sdao.get(frm.getUniqueId()) : new SubjectArea();
            Department dept = (Department)ddao.get(frm.getDepartment());
            HashSet<Class_> updatedClasses = new HashSet<Class_>();
            sa.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession));
            sa.setSubjectAreaAbbreviation(frm.getAbbv());
            if (sa.getDepartment() != null && !dept.equals(sa.getDepartment())) {
                HashSet<Location> availableRooms = new HashSet<Location>();
                HashSet<Building> availableBuildings = new HashSet<Building>();
                for (RoomDept roomDept : dept.getRoomDepts()) {
                    availableRooms.add(roomDept.getRoom());
                    if (!(roomDept.getRoom() instanceof Room)) continue;
                    availableBuildings.add(((Room)roomDept.getRoom()).getBuilding());
                }
                for (CourseOffering co : sa.getCourseOfferings()) {
                    if (!co.getIsControl().booleanValue() || co.getInstructionalOffering() == null) continue;
                    for (InstrOfferingConfig ioc : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                            if (!ss.getManagingDept().isExternalManager().booleanValue()) {
                                Iterator<Serializable> l = ss.getPreferences().iterator();
                                while (l.hasNext()) {
                                    RoomGroupPref rgp;
                                    Preference p = (Preference)l.next();
                                    if (p instanceof TimePref) continue;
                                    if (p instanceof RoomPref) {
                                        RoomPref rp = (RoomPref)p;
                                        if (availableRooms.contains(rp.getRoom())) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (p instanceof BuildingPref) {
                                        BuildingPref bp = (BuildingPref)p;
                                        if (availableBuildings.contains(bp.getBuilding())) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (p instanceof RoomFeaturePref) {
                                        RoomFeaturePref rfp = (RoomFeaturePref)p;
                                        if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                    l.remove();
                                }
                                hibSession.saveOrUpdate((Object)ss);
                            }
                            for (Class_ c : ss.getClasses()) {
                                Iterator<Comparable> m;
                                if (!c.getManagingDept().isExternalManager().booleanValue()) {
                                    m = c.getPreferences().iterator();
                                    while (m.hasNext()) {
                                        RoomGroupPref rgp;
                                        Preference p = (Preference)m.next();
                                        if (p instanceof TimePref) continue;
                                        if (p instanceof RoomPref) {
                                            RoomPref rp = (RoomPref)p;
                                            if (availableRooms.contains(rp.getRoom())) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (p instanceof BuildingPref) {
                                            BuildingPref bp = (BuildingPref)p;
                                            if (availableBuildings.contains(bp.getBuilding())) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (p instanceof RoomFeaturePref) {
                                            RoomFeaturePref rfp = (RoomFeaturePref)p;
                                            if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                        m.remove();
                                    }
                                    c.setManagingDept(dept, this.sessionContext.getUser(), hibSession);
                                }
                                m = c.getClassInstructors().iterator();
                                while (m.hasNext()) {
                                    ClassInstructor ci = (ClassInstructor)m.next();
                                    DepartmentalInstructor newInstructor = null;
                                    if (ci.getInstructor().getExternalUniqueId() != null) {
                                        newInstructor = DepartmentalInstructor.findByPuidDepartmentId(ci.getInstructor().getExternalUniqueId(), dept.getUniqueId());
                                    }
                                    ci.getInstructor().getClasses().remove(ci);
                                    hibSession.saveOrUpdate((Object)ci.getInstructor());
                                    if (newInstructor != null) {
                                        ci.setInstructor(newInstructor);
                                        newInstructor.getClasses().add(ci);
                                        hibSession.saveOrUpdate((Object)newInstructor);
                                        continue;
                                    }
                                    m.remove();
                                    hibSession.delete((Object)ci);
                                }
                                hibSession.saveOrUpdate((Object)c);
                                updatedClasses.add(c);
                            }
                        }
                    }
                }
                for (Preference p : sa.getDepartment().getPreferences()) {
                    if (!(p instanceof DistributionPref)) continue;
                    DistributionPref dp = (DistributionPref)p;
                    boolean change = true;
                    for (DistributionObject dobj : dp.getOrderedSetOfDistributionObjects()) {
                        if (dobj.getPrefGroup() instanceof SchedulingSubpart) {
                            SchedulingSubpart ss = (SchedulingSubpart)dobj.getPrefGroup();
                            if (ss.getControllingCourseOffering().getSubjectArea().equals(sa)) break;
                            change = false;
                            break;
                        }
                        if (!(dobj.getPrefGroup() instanceof Class_)) continue;
                        Class_ c = (Class_)dobj.getPrefGroup();
                        if (c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().equals(sa)) break;
                        change = false;
                        break;
                    }
                    if (!change) continue;
                    dp.setOwner(dept);
                    hibSession.saveOrUpdate((Object)dp);
                }
                oldDept = sa.getDepartment();
                sa.setDepartment(dept);
            } else if (sa.getDepartment() == null) {
                sa.setDepartment(dept);
            }
            sa.setExternalUniqueId(frm.getExternalId());
            sa.setTitle(frm.getTitle());
            hibSession.saveOrUpdate((Object)sa);
            ChangeLog.addChange(hibSession, this.sessionContext, sa, ChangeLog.Source.SUBJECT_AREA_EDIT, frm.getUniqueId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, sa, dept);
            tx.commit();
            hibSession.refresh((Object)sa);
            hibSession.flush();
            hibSession.refresh((Object)sa.getSession());
            if (oldDept != null) {
                hibSession.refresh((Object)oldDept);
                hibSession.refresh((Object)sa.getDepartment());
            }
            if ((className = ApplicationProperty.ExternalActionClassEdit.value()) != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).newInstance();
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }
}

