/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.SolutionReportForm;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.DeptBalancingReport;
import org.unitime.timetable.solver.ui.DiscouragedInstructorBtbReport;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.solver.ui.PerturbationReport;
import org.unitime.timetable.solver.ui.RoomReport;
import org.unitime.timetable.solver.ui.SameSubpartBalancingReport;
import org.unitime.timetable.solver.ui.StudentConflictsReport;
import org.unitime.timetable.solver.ui.ViolatedDistrPreferencesReport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/solutionReport")
public class SolutionReportAction
extends Action {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolverProxy solver;
        DatePattern dp;
        SolutionReportForm myForm = (SolutionReportForm)form;
        this.sessionContext.checkPermission(Right.SolutionReports);
        String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        BitSet sessionDays = session.getDefaultDatePattern().getPatternBitSet();
        int startDayDayOfWeek = Constants.getDayOfWeek(session.getDefaultDatePattern().getStartDate());
        Float nrWeeks = null;
        if (ApplicationProperty.TimetableGridUtilizationSkipHolidays.isFalse() && (dp = session.getDefaultDatePatternNotNull()) != null) {
            nrWeeks = Float.valueOf(dp.getEffectiveNumberOfWeeks());
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) == null) {
            request.setAttribute("SolutionReport.message", (Object)"Neither a solver is started nor solution is loaded.");
        } else {
            try {
                PerturbationReport perturbationReport;
                SameSubpartBalancingReport sameSubpartBalancingReport;
                Object studentConflictsReport;
                DiscouragedInstructorBtbReport discouragedInstructorBtbReportReport;
                ViolatedDistrPreferencesReport violatedDistrPreferencesReport;
                DeptBalancingReport deptBalancingReport;
                PdfWebTable t;
                for (RoomType type : RoomType.findAll()) {
                    PdfWebTable t2;
                    RoomReport roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, type.getUniqueId(), nrWeeks);
                    if (roomReport == null || roomReport.getGroups().isEmpty() || (t2 = this.getRoomReportTable(request, roomReport, false, type.getUniqueId())) == null) continue;
                    request.setAttribute("SolutionReport.roomReportTable." + type.getReference(), (Object)t2.printTable(WebTable.getOrder(this.sessionContext, "solutionReports.roomReport.ord")));
                }
                RoomReport roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, null, nrWeeks);
                if (roomReport != null && !roomReport.getGroups().isEmpty() && (t = this.getRoomReportTable(request, roomReport, false, null)) != null) {
                    request.setAttribute("SolutionReport.roomReportTable.nonUniv", (Object)t.printTable(WebTable.getOrder(this.sessionContext, "solutionReports.roomReport.ord")));
                }
                if ((deptBalancingReport = solver.getDeptBalancingReport()) != null && !deptBalancingReport.getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.deptBalancingReportTable", (Object)this.getDeptBalancingReportTable(request, deptBalancingReport, false).printTable(WebTable.getOrder(this.sessionContext, "solutionReports.deptBalancingReport.ord")));
                }
                if ((violatedDistrPreferencesReport = solver.getViolatedDistrPreferencesReport()) != null && !violatedDistrPreferencesReport.getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.violatedDistrPreferencesReportTable", (Object)this.getViolatedDistrPreferencesReportTable(request, violatedDistrPreferencesReport, false).printTable(WebTable.getOrder(this.sessionContext, "solutionReports.violDistPrefReport.ord")));
                }
                if ((discouragedInstructorBtbReportReport = solver.getDiscouragedInstructorBtbReport()) != null && !discouragedInstructorBtbReportReport.getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.discouragedInstructorBtbReportReportTable", (Object)this.getDiscouragedInstructorBtbReportReportTable(request, discouragedInstructorBtbReportReport, false).printTable(WebTable.getOrder(this.sessionContext, "solutionReports.violInstBtb.ord")));
                }
                if ((studentConflictsReport = solver.getStudentConflictsReport()) != null && !((StudentConflictsReport)studentConflictsReport).getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.studentConflictsReportTable", (Object)this.getStudentConflictsReportTable(request, (StudentConflictsReport)studentConflictsReport, false).printTable(WebTable.getOrder(this.sessionContext, "solutionReports.studConf.ord")));
                }
                if ((sameSubpartBalancingReport = solver.getSameSubpartBalancingReport()) != null && !sameSubpartBalancingReport.getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.sameSubpartBalancingReportTable", (Object)this.getSameSubpartBalancingReportTable(request, sameSubpartBalancingReport, false).printTable(PdfWebTable.getOrder(this.sessionContext, "solutionReports.sectBalancingReport.ord")));
                }
                if ((perturbationReport = solver.getPerturbationReport()) != null && !perturbationReport.getGroups().isEmpty()) {
                    request.setAttribute("SolutionReport.perturbationReportTable", (Object)this.getPerturbationReportTable(request, perturbationReport, false).printTable(WebTable.getOrder(this.sessionContext, "solutionReports.pert.ord")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("Export PDF".equals(op)) {
            PerturbationReport perturbationReport;
            DeptBalancingReport deptBalancingReport;
            SameSubpartBalancingReport sameSubpartBalancingReport;
            StudentConflictsReport studentConflictsReport;
            ViolatedDistrPreferencesReport violatedDistrPreferencesReport;
            DiscouragedInstructorBtbReport discouragedInstructorBtbReportReport;
            PdfWebTable table;
            PdfPTable pdfTable;
            PdfWebTable table2;
            OutputStream out = ExportUtils.getPdfOutputStream(response, "report");
            Document doc = new Document(new Rectangle(60.0f + PageSize.LETTER.getHeight(), 60.0f + 0.75f * PageSize.LETTER.getHeight()), 30.0f, 30.0f, 30.0f, 30.0f);
            PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
            doc.open();
            boolean atLeastOneRoomReport = false;
            for (RoomType type : RoomType.findAll()) {
                RoomReport roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, type.getUniqueId(), nrWeeks);
                if (roomReport == null || roomReport.getGroups().isEmpty() || (table2 = this.getRoomReportTable(request, roomReport, true, type.getUniqueId())) == null) continue;
                pdfTable = table2.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.roomReport.ord"));
                if (!atLeastOneRoomReport) {
                    doc.setPageSize(new Rectangle(60.0f + table2.getWidth(), 60.0f + 0.75f * table2.getWidth()));
                    doc.newPage();
                }
                doc.add((Element)new Paragraph(table2.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable);
                atLeastOneRoomReport = true;
            }
            RoomReport roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, null, nrWeeks);
            if (roomReport != null && !roomReport.getGroups().isEmpty() && (table = this.getRoomReportTable(request, roomReport, true, null)) != null) {
                PdfPTable pdfTable2 = table.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.roomReport.ord"));
                if (!atLeastOneRoomReport) {
                    doc.setPageSize(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()));
                    doc.newPage();
                }
                doc.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable2);
                atLeastOneRoomReport = true;
            }
            if (atLeastOneRoomReport) {
                PdfPTable pdfTable3 = new PdfPTable(new float[]{10.0f, 100.0f});
                pdfTable3.setWidthPercentage(100.0f);
                pdfTable3.getDefaultCell().setPadding(3.0f);
                pdfTable3.getDefaultCell().setBorderWidth(0.0f);
                pdfTable3.setSplitRows(false);
                pdfTable3.addCell("Group");
                pdfTable3.addCell("group size <minimum, maximum)");
                pdfTable3.addCell("Size");
                pdfTable3.addCell("actual group size (size of the smallest and the biggest room in the group)");
                pdfTable3.addCell("NrRooms");
                pdfTable3.addCell("number of rooms in the group");
                pdfTable3.addCell("ClUse");
                pdfTable3.addCell("number of classes that are using a room from the group (actual solution)");
                pdfTable3.addCell("ClShould");
                pdfTable3.addCell("number of classes that \"should\" use a room of the group (smallest available room of a class is in this group)");
                pdfTable3.addCell("ClMust");
                pdfTable3.addCell("number of classes that must use a room of the group (all available rooms of a class are in this group)");
                pdfTable3.addCell("HrUse");
                pdfTable3.addCell("average hours a room of the group is used (actual solution)");
                pdfTable3.addCell("HrShould");
                pdfTable3.addCell("average hours a room of the group should be used (smallest available room of a class is in this group)");
                pdfTable3.addCell("HrMust");
                pdfTable3.addCell("average hours a room of this group must be used (all available rooms of a class are in this group)");
                pdfTable3.addCell("");
                pdfTable3.addCell("*) cumulative numbers (group minimum ... inf) are displayed in parentheses.");
                doc.add((Element)pdfTable3);
            }
            if ((discouragedInstructorBtbReportReport = solver.getDiscouragedInstructorBtbReport()) != null && !discouragedInstructorBtbReportReport.getGroups().isEmpty()) {
                PdfWebTable table3 = this.getDiscouragedInstructorBtbReportReportTable(request, discouragedInstructorBtbReportReport, true);
                PdfPTable pdfTable4 = table3.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.violInstBtb.ord"));
                doc.setPageSize(new Rectangle(60.0f + table3.getWidth(), 60.0f + 0.75f * table3.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table3.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable4);
            }
            if ((violatedDistrPreferencesReport = solver.getViolatedDistrPreferencesReport()) != null && !violatedDistrPreferencesReport.getGroups().isEmpty()) {
                table2 = this.getViolatedDistrPreferencesReportTable(request, violatedDistrPreferencesReport, true);
                pdfTable = table2.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.violDistPrefReport.ord"));
                doc.setPageSize(new Rectangle(60.0f + table2.getWidth(), 60.0f + 0.75f * table2.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table2.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable);
            }
            if ((studentConflictsReport = solver.getStudentConflictsReport()) != null && !studentConflictsReport.getGroups().isEmpty()) {
                PdfWebTable table4 = this.getStudentConflictsReportTable(request, studentConflictsReport, true);
                PdfPTable pdfTable5 = table4.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.studConf.ord"));
                doc.setPageSize(new Rectangle(60.0f + table4.getWidth(), 60.0f + 0.75f * table4.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table4.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable5);
            }
            if ((sameSubpartBalancingReport = solver.getSameSubpartBalancingReport()) != null && !sameSubpartBalancingReport.getGroups().isEmpty()) {
                PdfWebTable table5 = this.getSameSubpartBalancingReportTable(request, sameSubpartBalancingReport, true);
                PdfPTable pdfTable6 = table5.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.sectBalancingReport.ord"));
                doc.setPageSize(new Rectangle(60.0f + table5.getWidth(), 60.0f + 0.75f * table5.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table5.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable6);
            }
            if ((deptBalancingReport = solver.getDeptBalancingReport()) != null && !deptBalancingReport.getGroups().isEmpty()) {
                PdfWebTable table6 = this.getDeptBalancingReportTable(request, deptBalancingReport, true);
                PdfPTable pdfTable7 = table6.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.deptBalancingReport.ord"));
                doc.setPageSize(new Rectangle(60.0f + table6.getWidth(), 60.0f + 0.75f * table6.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table6.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable7);
            }
            if ((perturbationReport = solver.getPerturbationReport()) != null && !perturbationReport.getGroups().isEmpty()) {
                PdfWebTable table7 = this.getPerturbationReportTable(request, perturbationReport, true);
                PdfPTable pdfTable8 = table7.printPdfTable(WebTable.getOrder(this.sessionContext, "solutionReports.pert.ord"));
                doc.setPageSize(new Rectangle(60.0f + table7.getWidth(), 60.0f + 0.75f * table7.getWidth()));
                doc.newPage();
                doc.add((Element)new Paragraph(table7.getName(), PdfFont.getBigFont(true)));
                doc.add((Element)pdfTable8);
                pdfTable8 = new PdfPTable(new float[]{5.0f, 100.0f});
                pdfTable8.setWidthPercentage(100.0f);
                pdfTable8.getDefaultCell().setPadding(3.0f);
                pdfTable8.getDefaultCell().setBorderWidth(0.0f);
                pdfTable8.setSplitRows(false);
                pdfTable8.addCell("Class");
                pdfTable8.addCell("Class name");
                pdfTable8.addCell("Time");
                pdfTable8.addCell("Time (initial -> assigned)");
                pdfTable8.addCell("Room");
                pdfTable8.addCell("Room (initial -> assigned)");
                pdfTable8.addCell("Dist");
                pdfTable8.addCell("Distance between assignments (if different are used buildings)");
                pdfTable8.addCell("St");
                pdfTable8.addCell("Number of affected students");
                pdfTable8.addCell("StT");
                pdfTable8.addCell("Number of affected students by time change");
                pdfTable8.addCell("StR");
                pdfTable8.addCell("Number of affected students by room change");
                pdfTable8.addCell("StB");
                pdfTable8.addCell("Number of affected students by building change");
                pdfTable8.addCell("Ins");
                pdfTable8.addCell("Number of affected instructors");
                pdfTable8.addCell("InsT");
                pdfTable8.addCell("Number of affected instructors by time change");
                pdfTable8.addCell("InsR");
                pdfTable8.addCell("Number of affected instructors by room change");
                pdfTable8.addCell("InsB");
                pdfTable8.addCell("Number of affected instructors by building change");
                pdfTable8.addCell("Rm");
                pdfTable8.addCell("Number of rooms changed");
                pdfTable8.addCell("Bld");
                pdfTable8.addCell("Number of buildings changed");
                pdfTable8.addCell("Tm");
                pdfTable8.addCell("Number of times changed");
                pdfTable8.addCell("Day");
                pdfTable8.addCell("Number of days changed");
                pdfTable8.addCell("Hr");
                pdfTable8.addCell("Number of hours changed");
                pdfTable8.addCell("TFSt");
                pdfTable8.addCell("Assigned building too far for instructor (from the initial one)");
                pdfTable8.addCell("TFIns");
                pdfTable8.addCell("Assigned building too far for students (from the initial one)");
                pdfTable8.addCell("DStC");
                pdfTable8.addCell("Difference in student conflicts");
                pdfTable8.addCell("NStC");
                pdfTable8.addCell("Number of new student conflicts");
                pdfTable8.addCell("DTPr");
                pdfTable8.addCell("Difference in time preferences");
                pdfTable8.addCell("DRPr");
                pdfTable8.addCell("Difference in room preferences");
                pdfTable8.addCell("DInsB");
                pdfTable8.addCell("Difference in back-to-back instructor preferences");
                doc.add((Element)pdfTable8);
            }
            doc.close();
            out.flush();
            out.close();
            return null;
        }
        return mapping.findForward("showSolutionReport");
    }

    public PdfWebTable getRoomReportTable(HttpServletRequest request, RoomReport report, boolean noHtml, Long type) {
        WebTable.setOrder(this.sessionContext, "solutionReports.roomReport.ord", request.getParameter("room_ord"), -1);
        String name = "Room Allocation - " + (type == null ? "Non University Locations" : ((RoomType)RoomTypeDAO.getInstance().get(type)).getLabel());
        PdfWebTable webTable = new PdfWebTable(9, name, "solutionReport.do?room_ord=%%", new String[]{"Group", "Size", "NrRooms*", "ClUse", "ClShould", "ClMust*", "HrUse", "HrShould", "HrMust*"}, new String[]{"center", "center", "left", "left", "left", "left", "left", "left", "left"}, null);
        webTable.setRowStyle("white-space:nowrap");
        int nrLines = 0;
        try {
            int nrAllRooms = 0;
            int nrAllLectureUse = 0;
            int nrAllLectureShouldUse = 0;
            double allSlotsUse = 0.0;
            double allSlotsShouldUse = 0.0;
            TreeSet groups = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    RoomReport.RoomAllocationGroup g1 = (RoomReport.RoomAllocationGroup)o1;
                    RoomReport.RoomAllocationGroup g2 = (RoomReport.RoomAllocationGroup)o2;
                    return -Double.compare(g1.getMinRoomSize(), g2.getMinRoomSize());
                }
            });
            groups.addAll(report.getGroups());
            for (RoomReport.RoomAllocationGroup g : groups) {
                if (g.getNrRooms() == 0) continue;
                double factor = (double)Constants.SLOT_LENGTH_MIN / 60.0;
                nrAllRooms += g.getNrRooms();
                allSlotsUse += g.getSlotsUse();
                allSlotsShouldUse += g.getSlotsShouldUse();
                nrAllLectureUse += g.getLecturesUse();
                nrAllLectureShouldUse += g.getLecturesShouldUse();
                ++nrLines;
                String[] stringArray = new String[9];
                stringArray[0] = g.getMinRoomSize() + " ... " + (g.getMaxRoomSize() == Integer.MAX_VALUE ? (noHtml ? "inf" : "<i>inf</i>") : String.valueOf(g.getMaxRoomSize()));
                stringArray[1] = g.getActualMinRoomSize() + " ... " + g.getActualMaxRoomSize();
                stringArray[2] = g.getNrRooms() + " (" + g.getNrRoomsThisSizeOrBigger() + ")";
                stringArray[3] = "" + g.getLecturesUse() + " (" + nrAllLectureUse + ")";
                stringArray[4] = "" + g.getLecturesShouldUse() + " (" + nrAllLectureShouldUse + ")";
                stringArray[5] = g.getLecturesMustUse() + " (" + g.getLecturesMustUseThisSizeOrBigger() + ")";
                stringArray[6] = sDoubleFormat.format(factor * g.getSlotsUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * allSlotsUse / (double)nrAllRooms) + ")";
                stringArray[7] = sDoubleFormat.format(factor * g.getSlotsShouldUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * allSlotsShouldUse / (double)nrAllRooms) + ")";
                stringArray[8] = sDoubleFormat.format(factor * g.getSlotsMustUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * g.getSlotsMustUseThisSizeOrBigger() / (double)g.getNrRoomsThisSizeOrBigger()) + ")";
                webTable.addLine(null, stringArray, new Comparable[]{new Integer(g.getMinRoomSize()), new Integer(g.getActualMinRoomSize()), new Integer(g.getNrRooms()), new Integer(g.getLecturesUse()), new Integer(g.getLecturesShouldUse()), new Integer(g.getLecturesMustUse()), new Double(factor * g.getSlotsUse() / (double)g.getNrRooms()), new Double(factor * g.getSlotsShouldUse() / (double)g.getNrRooms()), new Double(factor * g.getSlotsMustUse() / (double)g.getNrRooms())});
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
            ++nrLines;
        }
        if (nrLines == 0) {
            return null;
        }
        return webTable;
    }

    public PdfWebTable getDeptBalancingReportTable(HttpServletRequest request, DeptBalancingReport deptBalancingReport, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.deptBalancingReport.ord", request.getParameter("dept_ord"), 1);
        String[] header = new String[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
        String[] pos = new String[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
        header[0] = "Department";
        pos[0] = "left";
        header[1] = "Penalty";
        pos[1] = "center";
        for (int i = 0; i < deptBalancingReport.getSlotsPerDayNoEvening() / 6; ++i) {
            header[i + 2] = Constants.slot2str(deptBalancingReport.getFirstDaySlot() + i * 6);
            pos[i + 2] = "center";
        }
        PdfWebTable webTable = new PdfWebTable(header.length, "Departmental Balancing", "solutionReport.do?dept_ord=%%", header, pos, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (DeptBalancingReport.DeptBalancingGroup g : deptBalancingReport.getGroups()) {
                String[] line = new String[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
                Comparable[] cmp = new Comparable[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
                line[0] = g.getDepartmentName();
                cmp[0] = g.getDepartmentName();
                int penalty = 0;
                for (int i = 0; i < deptBalancingReport.getSlotsPerDayNoEvening() / 6; ++i) {
                    int limit;
                    int slot = deptBalancingReport.getFirstDaySlot() + i * 6;
                    int usage = g.getUsage(slot);
                    if (usage > (limit = g.getLimit(slot))) {
                        penalty += g.getExcess(slot);
                    }
                    Vector classes = new Vector(g.getClasses(slot));
                    Collections.sort(classes);
                    StringBuffer sb = new StringBuffer();
                    StringBuffer toolTip = new StringBuffer();
                    int u = 0;
                    boolean over = false;
                    Enumeration e = classes.elements();
                    while (e.hasMoreElements()) {
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                        int nrMeetings = 0;
                        for (int j = deptBalancingReport.getFirstWorkDay(); j <= deptBalancingReport.getLastWorkDay(); ++j) {
                            if ((Constants.DAY_CODES[j] & ca.getTime().getDays()) == 0) continue;
                            ++nrMeetings;
                        }
                        if ((u += nrMeetings) > limit && !over) {
                            over = true;
                            sb.append("<hr>");
                        }
                        sb.append(noHtml ? ca.getClazz().getName() : ca.getClazz().toHtml(true, true));
                        if (e.hasMoreElements()) {
                            sb.append(noHtml ? "\n" : "<br>");
                        }
                        toolTip.append(ca.getClassName());
                        if (!e.hasMoreElements()) continue;
                        toolTip.append(", ");
                    }
                    if (noHtml) {
                        line[i + 2] = usage + " / " + limit;
                        int n = i + 2;
                        line[n] = line[n] + (classes.isEmpty() ? "" : "\n" + sb.toString());
                    } else {
                        line[i + 2] = "<a title='" + toolTip + "'>" + (limit == 0 ? "" : (usage > limit ? "<font color='red'>" : "") + usage + " / " + limit + (usage > limit ? "</font>" : "")) + "</a>";
                        int n = i + 2;
                        line[n] = line[n] + (classes.isEmpty() ? "" : "<br>" + sb.toString());
                    }
                    cmp[i + 2] = new Integer(usage * 1000 + limit);
                }
                line[1] = noHtml ? "" + penalty : (penalty == 0 ? "" : "<font color='red'>+" + penalty + "</font>");
                cmp[1] = new Integer(penalty);
                webTable.addLine(null, line, cmp);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    public PdfWebTable getViolatedDistrPreferencesReportTable(HttpServletRequest request, ViolatedDistrPreferencesReport report, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.violDistPrefReport.ord", request.getParameter("vdist_ord"), 1);
        PdfWebTable webTable = new PdfWebTable(6, "Violated Distribution Preferences", "solutionReport.do?vdist_ord=%%", new String[]{"Type", "Preference", "Violations", "Class", "Time", "Room"}, new String[]{"left", "left", "right", "left", "left", "left"}, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (ViolatedDistrPreferencesReport.ViolatedDistrPreference g : report.getGroups()) {
                StringBuffer cSB = new StringBuffer();
                MultiComparable ord = new MultiComparable();
                StringBuffer tSB = new StringBuffer();
                StringBuffer rSB = new StringBuffer();
                Enumeration e = g.getClasses().elements();
                while (e.hasMoreElements()) {
                    int j;
                    ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                    if (noHtml) {
                        cSB.append(ca.getClazz().getName());
                        tSB.append(ca.getTime().getDaysName() + " " + ca.getTime().getStartTime() + " - " + ca.getTime().getEndTime());
                        for (j = 0; j < ca.getRoom().length; ++j) {
                            rSB.append((j > 0 ? ", " : "") + ca.getRoom()[j].getName());
                        }
                    } else {
                        cSB.append(ca.getClazz().toHtml(true, true));
                        tSB.append(ca.getTime().toHtml(false, false, true, true));
                        for (j = 0; j < ca.getRoom().length; ++j) {
                            rSB.append((j > 0 ? ", " : "") + ca.getRoom()[j].toHtml(false, false, true));
                        }
                    }
                    ord.add(ca);
                    if (!e.hasMoreElements()) continue;
                    if (noHtml) {
                        cSB.append("\n");
                        tSB.append("\n");
                        rSB.append("\n");
                        continue;
                    }
                    cSB.append("<BR>");
                    tSB.append("<BR>");
                    rSB.append("<BR>");
                }
                webTable.addLine(null, new String[]{g.getName(), (noHtml ? "" : "<font color='" + PreferenceLevel.int2color(g.getPreference()) + "'>") + PreferenceLevel.getPreferenceLevel(PreferenceLevel.int2prolog(g.getPreference())).getPrefName() + (noHtml ? "" : "</font>"), String.valueOf(g.getNrViolations()), cSB.toString(), tSB.toString(), rSB.toString()}, new Comparable[]{g.getName(), new Integer(g.getPreference()), Integer.valueOf(g.getNrViolations()), ord, null, null});
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    public PdfWebTable getDiscouragedInstructorBtbReportReportTable(HttpServletRequest request, DiscouragedInstructorBtbReport report, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.violInstBtb.ord", request.getParameter("vinbtb_ord"), 1);
        PdfWebTable webTable = new PdfWebTable(7, "Instructor Back-to-Back Preferences", "solutionReport.do?vinbtb_ord=%%", new String[]{"Instructor", "Preference", "Distance", "Class", "Time", "Date", "Room"}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (DiscouragedInstructorBtbReport.DiscouragedBtb g : report.getGroups()) {
                int j;
                StringBuffer rSB = new StringBuffer();
                for (j = 0; j < g.getFirst().getRoom().length; ++j) {
                    rSB.append((j > 0 ? ", " : "") + (noHtml ? g.getFirst().getRoom()[j].getName() : g.getFirst().getRoom()[j].toHtml(false, false, true)));
                }
                rSB.append(noHtml ? "\n" : "<BR>");
                for (j = 0; j < g.getSecond().getRoom().length; ++j) {
                    rSB.append((j > 0 ? ", " : "") + (noHtml ? g.getSecond().getRoom()[j].getName() : g.getSecond().getRoom()[j].toHtml(false, false, true)));
                }
                webTable.addLine(null, new String[]{g.getInstructorName(), (noHtml ? "" : "<font color='" + PreferenceLevel.prolog2color(g.getPreference()) + "'>") + PreferenceLevel.getPreferenceLevel(g.getPreference()).getPrefName() + (noHtml ? "" : "</font>"), String.valueOf(Math.round(g.getDistance())) + "m", noHtml ? g.getFirst().getClazz().getName() + "\n" + g.getSecond().getClazz().getName() : g.getFirst().getClazz().toHtml(true, true) + "<BR>" + g.getSecond().getClazz().toHtml(true, true), noHtml ? g.getFirst().getTime().getName(true) + "\n" + g.getSecond().getTime().getName(true) : g.getFirst().getTime().toHtml(false, false, true, true) + "<BR>" + g.getSecond().getTime().toHtml(false, false, true, true), noHtml ? g.getFirst().getTime().getDatePatternName() + "\n" + g.getSecond().getTime().getDatePatternName() : g.getFirst().getTime().toDatesHtml(false, false, true) + "<BR>" + g.getSecond().getTime().toDatesHtml(false, false, true), rSB.toString()}, new Comparable[]{g.getInstructorName(), g.getPreference(), new Double(g.getDistance()), new DuoComparable(g.getFirst(), g.getSecond()), null, null, null});
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    public PdfWebTable getStudentConflictsReportTable(HttpServletRequest request, StudentConflictsReport report, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.studConf.ord", request.getParameter("studconf_ord"), -1);
        boolean hasImportant = false;
        boolean hasInstructor = false;
        for (JenrlInfo g : report.getGroups()) {
            if (g.isImportant()) {
                hasImportant = true;
            }
            if (!g.isInstructor()) continue;
            hasInstructor = true;
        }
        PdfWebTable webTable = null;
        webTable = hasImportant ? (hasInstructor ? new PdfWebTable(12, "Student Conflicts", "solutionReport.do?studconf_ord=%%", new String[]{"NrConflicts", "Class", "Date", "Time", "Room", "Hard", "Distance", "Fixed", "Commited", "Important", "Instructor", "Curriculum"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null) : new PdfWebTable(11, "Student Conflicts", "solutionReport.do?studconf_ord=%%", new String[]{"NrConflicts", "Class", "Date", "Time", "Room", "Hard", "Distance", "Fixed", "Commited", "Important", "Curriculum"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null)) : (hasInstructor ? new PdfWebTable(11, "Student Conflicts", "solutionReport.do?studconf_ord=%%", new String[]{"NrConflicts", "Class", "Date", "Time", "Room", "Hard", "Distance", "Fixed", "Commited", "Instructor", "Curriculum"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null) : new PdfWebTable(10, "Student Conflicts", "solutionReport.do?studconf_ord=%%", new String[]{"NrConflicts", "Class", "Date", "Time", "Room", "Hard", "Distance", "Fixed", "Commited", "Curriculum"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null));
        webTable.setRowStyle("white-space:nowrap");
        try {
            int[] total = new int[]{0, 0, 0, 0, 0, 0, 0};
            for (JenrlInfo g : report.getGroups()) {
                int j;
                if (Math.round(g.getJenrl()) <= 0L) continue;
                StringBuffer rSB = new StringBuffer();
                for (j = 0; j < g.getFirst().getRoom().length; ++j) {
                    rSB.append((j > 0 ? ", " : "") + (noHtml ? g.getFirst().getRoom()[j].getName() : g.getFirst().getRoom()[j].toHtml(false, false, true)));
                }
                rSB.append(noHtml ? "\n" : "<BR>");
                for (j = 0; j < g.getSecond().getRoom().length; ++j) {
                    rSB.append((j > 0 ? ", " : "") + (noHtml ? g.getSecond().getRoom()[j].getName() : g.getSecond().getRoom()[j].toHtml(false, false, true)));
                }
                String[] line = new String[hasImportant ? (hasInstructor ? 12 : 11) : (hasInstructor ? 11 : 10)];
                Comparable[] cmp = new Comparable[hasImportant ? (hasInstructor ? 12 : 11) : (hasInstructor ? 11 : 10)];
                int idx = 0;
                line[idx] = String.valueOf(Math.round(g.getJenrl()));
                cmp[idx++] = new Double(g.getJenrl());
                line[idx] = noHtml ? g.getFirst().getClazz().getName() + "\n" + g.getSecond().getClazz().getName() : g.getFirst().getClazz().toHtml(true, true) + "<BR>" + g.getSecond().getClazz().toHtml(true, true);
                cmp[idx++] = new DuoComparable(g.getFirst(), g.getSecond());
                line[idx] = g.getFirst().getDaysName() + (noHtml ? "\n" : "<BR>") + g.getSecond().getDaysName();
                cmp[idx++] = null;
                line[idx] = noHtml ? g.getFirst().getTime().getName(true) + "\n" + g.getSecond().getTime().getName(true) : g.getFirst().getTime().toHtml(false, false, true, true) + "<BR>" + g.getSecond().getTime().toHtml(false, false, true, true);
                cmp[idx++] = null;
                line[idx] = rSB.toString();
                cmp[idx++] = null;
                line[idx] = noHtml ? (g.isHard() ? "true" : "") : (g.isHard() ? "<img src='images/accept.png' border='0'/>" : "");
                cmp[idx++] = new Integer(g.isHard() ? 1 : 0);
                line[idx] = g.isDistance() ? String.valueOf(Math.round(g.getDistance())) + "m" : "";
                cmp[idx++] = new Double(g.getDistance());
                line[idx] = noHtml ? (g.isFixed() ? "true" : "") : (g.isFixed() ? "<img src='images/accept.png' border='0'/>" : "");
                cmp[idx++] = new Integer(g.isFixed() ? 1 : 0);
                line[idx] = noHtml ? (g.isCommited() ? "true" : "") : (g.isCommited() ? "<img src='images/accept.png' border='0'/>" : "");
                cmp[idx++] = new Integer(g.isCommited() ? 1 : 0);
                if (hasImportant) {
                    line[idx] = noHtml ? (g.isImportant() ? "true" : "") : (g.isImportant() ? "<img src='images/accept.png' border='0'/>" : "");
                    cmp[idx++] = new Integer(g.isImportant() ? 1 : 0);
                }
                if (hasInstructor) {
                    line[idx] = noHtml ? (g.isInstructor() ? "true" : "") : (g.isInstructor() ? "<img src='images/accept.png' border='0'/>" : "");
                    cmp[idx++] = new Integer(g.isInstructor() ? 1 : 0);
                }
                line[idx] = g.getCurriculumText();
                cmp[idx++] = null;
                webTable.addLine(null, line, cmp);
                total[0] = (int)((long)total[0] + Math.round(g.getJenrl()));
                if (g.isHard()) {
                    total[1] = (int)((long)total[1] + Math.round(g.getJenrl()));
                }
                if (g.isDistance()) {
                    total[2] = (int)((long)total[2] + Math.round(g.getJenrl()));
                }
                if (g.isFixed()) {
                    total[3] = (int)((long)total[3] + Math.round(g.getJenrl()));
                }
                if (g.isCommited()) {
                    total[4] = (int)((long)total[4] + Math.round(g.getJenrl()));
                }
                if (g.isImportant()) {
                    total[5] = (int)((long)total[5] + Math.round(g.getJenrl()));
                }
                if (!g.isInstructor()) continue;
                total[6] = total[6] + (g.isInstructor() ? 1 : 0);
            }
            String[] line = new String[hasImportant ? (hasInstructor ? 12 : 11) : (hasInstructor ? 11 : 10)];
            Comparable[] cmp = new Comparable[hasImportant ? (hasInstructor ? 12 : 11) : (hasInstructor ? 11 : 10)];
            int idx = 0;
            line[idx] = String.valueOf(total[0]);
            cmp[idx++] = new Double(total[0]);
            line[idx] = "<i>Total</i>";
            cmp[idx++] = new DuoComparable(null, null);
            line[idx] = "";
            cmp[idx++] = null;
            line[idx] = "";
            cmp[idx++] = null;
            line[idx] = "";
            cmp[idx++] = null;
            line[idx] = String.valueOf(total[1]);
            cmp[idx++] = new Integer(total[1]);
            line[idx] = String.valueOf(total[2]);
            cmp[idx++] = new Double(1000.0 * (double)total[2]);
            line[idx] = String.valueOf(total[3]);
            cmp[idx++] = new Integer(total[3]);
            line[idx] = String.valueOf(total[4]);
            cmp[idx++] = new Integer(total[4]);
            if (hasImportant) {
                line[idx] = String.valueOf(total[5]);
                cmp[idx++] = new Integer(total[5]);
            }
            if (hasInstructor) {
                line[idx] = String.valueOf(total[6]);
                cmp[idx++] = new Integer(total[6]);
            }
            line[idx] = "";
            cmp[idx++] = null;
            webTable.addLine(null, line, cmp);
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    public PdfWebTable getSameSubpartBalancingReportTable(HttpServletRequest request, SameSubpartBalancingReport report, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.sectBalancingReport.ord", request.getParameter("sect_ord"), 1);
        String[] header = new String[2 + report.getSlotsPerDayNoEvening() / 6];
        String[] pos = new String[2 + report.getSlotsPerDayNoEvening() / 6];
        header[0] = "Department";
        pos[0] = "left";
        header[1] = "Penalty";
        pos[1] = "center";
        for (int i = 0; i < report.getSlotsPerDayNoEvening() / 6; ++i) {
            header[i + 2] = Constants.slot2str(report.getFirstDaySlot() + i * 6);
            pos[i + 2] = "center";
        }
        PdfWebTable webTable = new PdfWebTable(header.length, "Section Balancing", "solutionReport.do?sect_ord=%%", header, pos, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (SameSubpartBalancingReport.SameSubpartBalancingGroup g : report.getGroups()) {
                String[] line = new String[2 + report.getSlotsPerDayNoEvening() / 6];
                Comparable[] cmp = new Comparable[2 + report.getSlotsPerDayNoEvening() / 6];
                line[0] = g.getName();
                cmp[0] = g.getName();
                int penalty = 0;
                for (int i = 0; i < report.getSlotsPerDayNoEvening() / 6; ++i) {
                    int limit;
                    int slot = report.getFirstDaySlot() + i * 6;
                    int usage = g.getUsage(slot);
                    if (usage > (limit = g.getLimit(slot))) {
                        penalty += g.getExcess(slot);
                    }
                    Vector classes = new Vector(g.getClasses(slot));
                    Collections.sort(classes);
                    StringBuffer sb = new StringBuffer();
                    StringBuffer toolTip = new StringBuffer();
                    int u = 0;
                    boolean over = false;
                    Enumeration e = classes.elements();
                    while (e.hasMoreElements()) {
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                        int nrMeetings = 0;
                        for (int j = report.getFirstWorkDay(); j <= report.getLastWorkDay(); ++j) {
                            if ((Constants.DAY_CODES[j] & ca.getTime().getDays()) == 0) continue;
                            ++nrMeetings;
                        }
                        if ((u += nrMeetings) > limit && !over) {
                            over = true;
                            sb.append(noHtml ? "\n" : "<hr>");
                        }
                        sb.append(noHtml ? ca.getClazz().getName() : ca.getClazz().toHtml(true, true));
                        if (e.hasMoreElements()) {
                            sb.append(noHtml ? "\n" : "<br>");
                        }
                        toolTip.append(ca.getClassName());
                        if (!e.hasMoreElements()) continue;
                        toolTip.append(", ");
                    }
                    if (noHtml) {
                        line[i + 2] = usage + " / " + limit;
                        int n = i + 2;
                        line[n] = line[n] + (classes.isEmpty() ? "" : "\n" + sb.toString());
                    } else {
                        line[i + 2] = "<a title='" + toolTip + "'>" + (limit == 0 ? "" : (usage > limit ? "<font color='red'>" : "") + usage + " / " + limit + (usage > limit ? "</font>" : "")) + "</a>";
                        int n = i + 2;
                        line[n] = line[n] + (classes.isEmpty() ? "" : "<br>" + sb.toString());
                    }
                    cmp[i + 2] = new Integer(usage * 1000 + limit);
                }
                line[1] = noHtml ? "" + penalty : (penalty == 0 ? "" : "<font color='red'>+" + penalty + "</font>");
                cmp[1] = new Integer(penalty);
                webTable.addLine(null, line, cmp);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    private String disp(long value, boolean noHtml) {
        if (value == 0L) {
            return "";
        }
        return noHtml ? ClassAssignmentDetails.dispNumberNoHtml(value) : ClassAssignmentDetails.dispNumber(value);
    }

    public PdfWebTable getPerturbationReportTable(HttpServletRequest request, PerturbationReport report, boolean noHtml) {
        WebTable.setOrder(this.sessionContext, "solutionReports.pert.ord", request.getParameter("pert_ord"), 1);
        PdfWebTable webTable = new PdfWebTable(24, "Perturbations", "solutionReport.do?pert_ord=%%", new String[]{"Class", "Time", "Room", "Dist", "St", "StT", "StR", "StB", "Ins", "InsT", "InsR", "InsB", "Rm", "Bld", "Tm", "Day", "Hr", "TFSt", "TFIns", "DStC", "NStC", "DTPr", "DRPr", "DInsB"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (PerturbationReport.PerturbationGroup g : report.getGroups()) {
                webTable.addLine(null, new String[]{noHtml ? g.getClazz().getClazz().getName() : g.getClazz().getClazz().toHtml(true, true), noHtml ? g.getClazz().getTimeNoHtml() : g.getClazz().getTimeHtml(), noHtml ? g.getClazz().getRoomNoHtml() : g.getClazz().getRoomHtml(), Math.round(g.distance) > 0L ? Math.round(g.distance) + "m" : "", this.disp(g.affectedStudents, noHtml), this.disp(g.affectedStudentsByTime, noHtml), this.disp(g.affectedStudentsByRoom, noHtml), this.disp(g.affectedStudentsByBldg, noHtml), this.disp(g.affectedInstructors, noHtml), this.disp(g.affectedInstructorsByTime, noHtml), this.disp(g.affectedInstructorsByRoom, noHtml), this.disp(g.affectedInstructorsByBldg, noHtml), this.disp(g.differentRoom, noHtml), this.disp(g.differentBuilding, noHtml), this.disp(g.differentTime, noHtml), this.disp(g.differentDay, noHtml), this.disp(g.differentHour, noHtml), this.disp(g.tooFarForStudents, noHtml), this.disp(g.tooFarForInstructors, noHtml), this.disp(g.deltaStudentConflicts, noHtml), this.disp(g.newStudentConflicts, noHtml), this.disp(Math.round(g.deltaTimePreferences), noHtml), this.disp(g.deltaRoomPreferences, noHtml), this.disp(g.deltaInstructorDistancePreferences, noHtml)}, new Comparable[]{g.getClazz(), g.getClazz().getTimeName(), g.getClazz().getRoomName(), new Double(g.distance), new Long(g.affectedStudents), new Long(g.affectedStudentsByTime), new Long(g.affectedStudentsByRoom), new Long(g.affectedStudentsByBldg), new Integer(g.affectedInstructors), new Integer(g.affectedInstructorsByTime), new Integer(g.affectedInstructorsByRoom), new Integer(g.affectedInstructorsByBldg), new Integer(g.differentRoom), new Integer(g.differentBuilding), new Integer(g.differentTime), new Integer(g.differentDay), new Integer(g.differentHour), new Integer(g.tooFarForStudents), new Integer(g.tooFarForInstructors), new Integer(g.deltaStudentConflicts), new Integer(g.newStudentConflicts), new Double(g.deltaTimePreferences), new Integer(g.deltaRoomPreferences), new Integer(g.deltaInstructorDistancePreferences)});
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable;
    }

    public static class MultiComparable
    implements Comparable {
        private Vector iX = new Vector();

        public void add(Comparable x) {
            this.iX.addElement(x);
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof MultiComparable)) {
                return -1;
            }
            MultiComparable m = (MultiComparable)o;
            Enumeration e1 = this.iX.elements();
            Enumeration e2 = m.iX.elements();
            while (e1.hasMoreElements() && e2.hasMoreElements()) {
                int cmp = ((Comparable)e1.nextElement()).compareTo((Comparable)e2.nextElement());
                if (cmp == 0) continue;
                return cmp;
            }
            return Double.compare(e1.hasMoreElements() ? 1.0 : 0.0, e2.hasMoreElements() ? 1.0 : 0.0);
        }
    }

    public static class DuoComparable
    implements Comparable {
        private Comparable iA = null;
        private Comparable iB = null;

        public DuoComparable(Comparable a, Comparable b) {
            this.iA = a;
            this.iB = b;
        }

        public int compareTo(Object o) {
            int cmp;
            if (o == null || !(o instanceof DuoComparable)) {
                return -1;
            }
            DuoComparable d = (DuoComparable)o;
            int n = this.iA == null ? (d.iA == null ? 0 : -1) : (cmp = d.iA == null ? 1 : this.iA.compareTo(d.iA));
            if (cmp != 0) {
                return cmp;
            }
            return this.iB == null ? (d.iB == null ? 0 : -1) : (d.iB == null ? 1 : this.iB.compareTo(d.iB));
        }
    }
}

