/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Service(value="/instructorDetail")
public class InstructorDetailAction
extends PreferencesAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static GwtConstants CONST = Localization.create(GwtConstants.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            List<DepartmentalInstructor> instructors;
            String instructorId;
            super.execute(mapping, form, request, response);
            InstructorEditForm frm = (InstructorEditForm)form;
            ActionMessages errors = new ActionMessages();
            Object object = request.getParameter("instructorId") == null ? (request.getAttribute("instructorId") == null ? null : request.getAttribute("instructorId").toString()) : (instructorId = request.getParameter("instructorId"));
            if (instructorId == null && (instructors = DepartmentalInstructor.getUserInstructors(this.sessionContext.getUser())) != null) {
                String deptId = (String)request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
                if (deptId != null) {
                    for (DepartmentalInstructor i : instructors) {
                        if (!i.getDepartment().getUniqueId().toString().equals(deptId) || !this.sessionContext.hasPermission(i, Right.InstructorDetail)) continue;
                        instructorId = i.getUniqueId().toString();
                        break;
                    }
                }
                if (instructorId == null) {
                    for (DepartmentalInstructor i : instructors) {
                        if (!this.sessionContext.hasPermission(i, Right.InstructorDetail)) continue;
                        instructorId = i.getUniqueId().toString();
                        break;
                    }
                }
            }
            this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorDetail);
            String op = frm.getOp();
            if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
                op = request.getParameter("op2");
            }
            if (op == null) {
                throw new Exception("Null Operation not supported.");
            }
            if (op.equals(MSG.actionEditInstructor()) || op.equals(MSG.actionEditInstructorPreferences()) || op.equals(MSG.actionEditInstructorAssignmentPreferences()) || op.equals(MSG.actionBackToInstructors()) || op.equals(MSG.actionDisplayInstructorPreferences()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) {
                instructorId = frm.getInstructorId();
            } else {
                frm.reset(mapping, request);
            }
            Debug.debug("op: " + op);
            Debug.debug("instructor: " + instructorId);
            if (instructorId == null || instructorId.trim() == "") {
                throw new Exception("Instructor Info not supplied.");
            }
            if (op.equals(MSG.actionBackToInstructors()) && instructorId != null && instructorId.trim() != "") {
                response.sendRedirect(response.encodeURL("instructorList.do"));
                return null;
            }
            DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(instructorId));
            LookupTables.setupInstructorDistribTypes(request, this.sessionContext, inst);
            if (op.equals(MSG.actionEditInstructor()) && instructorId != null && instructorId.trim() != "") {
                this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorEdit);
                response.sendRedirect(response.encodeURL("instructorInfoEdit.do?instructorId=" + instructorId));
                return null;
            }
            if (op.equals(MSG.actionEditInstructorPreferences()) && instructorId != null && instructorId.trim() != "") {
                this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorPreferences);
                response.sendRedirect(response.encodeURL("instructorPrefEdit.do?instructorId=" + instructorId));
                return null;
            }
            if (op.equals(MSG.actionEditInstructorAssignmentPreferences()) && instructorId != null && !instructorId.trim().isEmpty()) {
                this.sessionContext.checkPermission(inst.getDepartment(), Right.InstructorAssignmentPreferences);
                response.sendRedirect(response.encodeURL("instructorAssignmentPref.do?instructorId=" + instructorId));
                return null;
            }
            if (op.equals(MSG.actionNextInstructor())) {
                response.sendRedirect(response.encodeURL("instructorDetail.do?instructorId=" + frm.getNextId()));
                return null;
            }
            if (op.equals(MSG.actionPreviousInstructor())) {
                response.sendRedirect(response.encodeURL("instructorDetail.do?instructorId=" + frm.getPreviousId()));
                return null;
            }
            this.doLoad(request, frm, inst, instructorId);
            BackTracker.markForBack(request, "instructorDetail.do?instructorId=" + instructorId, MSG.backInstructor(frm.getName() == null ? "null" : frm.getName().trim()), true, !this.sessionContext.hasPermission(Right.HasRole));
            HashSet<ClassInstructor> allClasses = new HashSet<ClassInstructor>();
            for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(inst, inst.getDepartment().getSession().getUniqueId())) {
                allClasses.addAll(di.getClasses());
            }
            if (!allClasses.isEmpty()) {
                boolean hasTimetable = this.sessionContext.hasPermission(Right.ClassAssignments);
                WebTable classTable = hasTimetable ? new WebTable(10, null, new String[]{MSG.columnClass(), MSG.columnInstructorCheckConflicts(), MSG.columnInstructorShare(), MSG.columnTeachingResponsibility(), MSG.columnLimit(), MSG.columnEnrollment(), MSG.columnManager(), MSG.columnAssignedTime(), MSG.columnAssignedDatePattern(), MSG.columnAssignedRoom()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null) : new WebTable(6, null, new String[]{MSG.columnClass(), MSG.columnInstructorCheckConflicts(), MSG.columnInstructorShare(), MSG.columnTeachingResponsibility(), MSG.columnLimit(), MSG.columnManager()}, new String[]{"left", "left", "left", "left", "left", "left"}, null);
                String backType = request.getParameter("backType");
                String backId = request.getParameter("backId");
                TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
                classes.addAll(allClasses);
                Vector<Long> classIds = new Vector<Long>(classes.size());
                for (ClassInstructor ci : classes) {
                    Class_ c = ci.getClassInstructing();
                    classIds.add(c.getUniqueId());
                    String limitString = "";
                    if (!c.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
                        if (c.getExpectedCapacity() != null) {
                            limitString = c.getExpectedCapacity().toString();
                            if (c.getMaxExpectedCapacity() != null && !c.getMaxExpectedCapacity().equals(c.getExpectedCapacity())) {
                                limitString = limitString + "-" + c.getMaxExpectedCapacity().toString();
                            }
                        } else {
                            limitString = "0";
                            if (c.getMaxExpectedCapacity() != null && c.getMaxExpectedCapacity() != 0) {
                                limitString = limitString + "-" + c.getMaxExpectedCapacity().toString();
                            }
                        }
                    }
                    String enrollmentString = "";
                    enrollmentString = c.getEnrollment() != null ? c.getEnrollment().toString() : "0";
                    String managingDept = null;
                    if (c.getManagingDept() != null) {
                        Department d = c.getManagingDept();
                        managingDept = d.getManagingDeptAbbv();
                    }
                    String assignedTime = "";
                    String assignedDate = "";
                    String assignedRoom = "";
                    ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, this.courseTimetablingSolverService.getSolver(), c.getUniqueId(), false);
                    if (ca == null) {
                        try {
                            Assignment a = this.classAssignmentService.getAssignment().getAssignment(c);
                            if (a.getUniqueId() != null) {
                                ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(this.sessionContext, a.getUniqueId(), false);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (ca != null) {
                        if (ca.getAssignedTime() != null) {
                            assignedTime = ca.getAssignedTime().toHtml(false, false, true, true);
                            assignedDate = ca.getAssignedTime().getDatePatternHtml();
                        }
                        if (ca.getAssignedRoom() != null) {
                            for (int i = 0; i < ca.getAssignedRoom().length; ++i) {
                                if (i > 0) {
                                    assignedRoom = assignedRoom + ", ";
                                }
                                assignedRoom = assignedRoom + ca.getAssignedRoom()[i].toHtml(false, false, true);
                            }
                        }
                    }
                    String icon = null;
                    String bgColor = null;
                    String title = null;
                    if (!c.isCancelled().booleanValue() && ci.isLead().booleanValue()) {
                        Set<Assignment> conflicts = null;
                        try {
                            conflicts = this.classAssignmentService.getAssignment().getConflicts(c.getUniqueId());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (conflicts != null && !conflicts.isEmpty()) {
                            bgColor = "#fff0f0";
                            String s = "";
                            for (Assignment x : conflicts) {
                                if (!s.isEmpty()) {
                                    s = s + ", ";
                                }
                                s = s + (x.getClassName() + " " + x.getPlacement().getName(CONST.useAmPm())).trim();
                            }
                            title = MSG.classIsConflicting(c.getClassLabel(), s);
                            icon = "<IMG alt='" + MSG.classIsConflicting(c.getClassLabel(), s) + "' title='" + MSG.classIsConflicting(c.getClassLabel(), s) + "' src='images/warning.png' style='margin-left: 1px; margin-right: 3px; vertical-align: top;'>";
                        } else {
                            Set<RoomAvailabilityInterface.TimeBlock> ec = null;
                            try {
                                ec = this.classAssignmentService.getAssignment().getConflictingTimeBlocks(c.getUniqueId());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (ec != null && !ec.isEmpty()) {
                                String s = "";
                                String lastName = null;
                                String lastType = null;
                                for (RoomAvailabilityInterface.TimeBlock t : ec) {
                                    if (lastName != null && lastName.equals(t.getEventName()) && lastType.equals(t.getEventType())) continue;
                                    lastName = t.getEventName();
                                    lastType = t.getEventType();
                                    if (!s.isEmpty()) {
                                        s = s + ", ";
                                    }
                                    s = s + lastName + " (" + lastType + ")";
                                }
                                bgColor = "#fff0f0";
                                title = MSG.classIsConflicting(c.getClassLabel(), s);
                                icon = "<IMG alt='" + MSG.classIsConflicting(c.getClassLabel(), s) + "' title='" + MSG.classIsConflicting(c.getClassLabel(), s) + "' src='images/warning.png' style='margin-left: 1px; margin-right: 3px; vertical-align: top;'>";
                            }
                        }
                    }
                    String onClick = null;
                    if (this.sessionContext.hasPermission(c, Right.ClassDetail)) {
                        onClick = "onClick=\"document.location='classDetail.do?cid=" + c.getUniqueId() + "';\"";
                    }
                    boolean back = "PreferenceGroup".equals(backType) && c.getUniqueId().toString().equals(backId);
                    String responsibility = ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel();
                    WebTable.WebTableLine line = null;
                    line = hasTimetable ? classTable.addLine(onClick, new String[]{(back ? "<A name=\"back\"></A>" : "") + (icon == null ? "" : icon) + c.getClassLabel(), ci.isLead() != false ? "<IMG border='0' alt='true' align='absmiddle' src='images/accept.png'>" : "", ci.getPercentShare() + "%", responsibility, limitString, enrollmentString, managingDept, assignedTime, assignedDate, assignedRoom}, null, null) : classTable.addLine(onClick, new String[]{(back ? "<A name=\"back\"></A>" : "") + c.getClassLabel(), ci.isLead() != false ? "<IMG border='0' alt='true' align='absmiddle' src='images/accept.png'>" : "", ci.getPercentShare() + "%", responsibility, limitString, managingDept}, null, null);
                    if (bgColor != null) {
                        line.setBgColor(bgColor);
                    }
                    if (title != null) {
                        line.setTitle(title);
                    }
                    if (!c.isCancelled().booleanValue()) continue;
                    line.setStyle("color: gray; font-style: italic;");
                    line.setTitle(MSG.classNoteCancelled(c.getClassLabel()));
                }
                Navigation.set(this.sessionContext, Navigation.sClassLevel, classIds);
                String tblData = classTable.printTable();
                request.setAttribute("classTable", (Object)tblData);
            }
            if (ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue() && inst.getExternalUniqueId() != null && !inst.getExternalUniqueId().isEmpty() && RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
                WebTable.setOrder(this.sessionContext, "instructorUnavailability.ord", request.getParameter("iuord"), 1);
                WebTable eventTable = new WebTable(5, "Instructor Unavailability", "instructorDetail.do?instructorId=" + frm.getInstructorId() + "&iuord=%%", new String[]{"Event", "Type", "Date", "Time", "Room"}, new String[]{"left", "left", "left", "left", "left"}, null);
                Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);
                Session hibSession = EventDAO.getInstance().getSession();
                HashMap<Event, HashSet<Meeting>> unavailabilities = new HashMap<Event, HashSet<Meeting>>();
                for (Meeting meeting : hibSession.createQuery("select distinct m from Event e inner join e.meetings m left outer join e.additionalContacts c, Session s where e.class in (CourseEvent, SpecialEvent, UnavailableEvent) and m.meetingDate >= s.eventBeginDate and m.meetingDate <= s.eventEndDate and s.uniqueId = :sessionId and (e.mainContact.externalUniqueId = :user or c.externalUniqueId = :user) and m.approvalStatus = 1").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("user", inst.getExternalUniqueId()).setCacheable(true).list()) {
                    HashSet<Meeting> meetings = (HashSet<Meeting>)unavailabilities.get(meeting.getEvent());
                    if (meetings == null) {
                        meetings = new HashSet<Meeting>();
                        unavailabilities.put(meeting.getEvent(), meetings);
                    }
                    meetings.add(meeting);
                }
                for (Event event : new TreeSet(unavailabilities.keySet())) {
                    for (Event.MultiMeeting m : Event.getMultiMeetings((Collection)unavailabilities.get(event))) {
                        String date = m.getDays() + " " + (m.getMeetings().size() == 1 ? dfLong.format(m.getMeetings().first().getMeetingDate()) : dfShort.format(m.getMeetings().first().getMeetingDate()) + " - " + dfLong.format(m.getMeetings().last().getMeetingDate()));
                        String time = m.getMeetings().first().startTime() + " - " + m.getMeetings().first().stopTime();
                        String room = m.getMeetings().first().getLocation() == null ? "" : m.getMeetings().first().getLocation().getLabelWithHint();
                        eventTable.addLine(this.sessionContext.hasPermission(event, Right.EventDetail) ? "onClick=\"showGwtDialog('Event Detail', 'gwt.jsp?page=events&menu=hide#event=" + event.getUniqueId() + "','900','85%');\"" : null, new String[]{event.getEventName(), event.getEventTypeAbbv(), date, time, room}, new Comparable[]{event.getEventName(), Integer.valueOf(event.getEventType()), m.getMeetings().first().getMeetingDate(), m.getMeetings().first().getStartPeriod(), room});
                    }
                }
                if (!eventTable.getLines().isEmpty()) {
                    request.setAttribute("eventTable", (Object)eventTable.printTable(WebTable.getOrder(this.sessionContext, "instructorUnavailability.ord")));
                }
            }
            frm.setDisplayPrefs(CommonValues.Yes.eq(this.sessionContext.getUser().getProperty(UserProperty.DispInstructorPrefs)));
            if (op.equals(MSG.actionDisplayInstructorPreferences()) || "true".equals(request.getParameter("showPrefs"))) {
                frm.setDisplayPrefs(true);
                this.sessionContext.getUser().setProperty(UserProperty.DispInstructorPrefs, CommonValues.Yes.value());
            }
            if (op.equals(MSG.actionHideInstructorPreferences()) || "false".equals(request.getParameter("showPrefs"))) {
                frm.setDisplayPrefs(false);
                this.sessionContext.getUser().setProperty(UserProperty.DispInstructorPrefs, CommonValues.No.value());
            }
            if (frm.isDisplayPrefs()) {
                HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
                frm.setAvailableTimePatterns(null);
                this.initPrefs(frm, inst, null, false);
                timePatterns.add(new TimePattern(new Long(-1L)));
                this.processPrefAction(request, frm, errors);
                for (Preference pref : inst.getPreferences()) {
                    if (!(pref instanceof TimePref)) continue;
                    frm.setAvailability(((TimePref)pref).getPreference());
                    break;
                }
                LookupTables.setupRooms(request, inst);
                LookupTables.setupBldgs(request, inst);
                LookupTables.setupRoomFeatures(request, inst);
                LookupTables.setupRoomGroups(request, inst);
                LookupTables.setupCourses(request, inst);
            }
            frm.setMaxLoad(inst.getMaxLoad() == null ? null : Formats.getNumberFormat("0.##").format(inst.getMaxLoad()));
            frm.setTeachingPreference(inst.getTeachingPreference() == null ? PreferenceLevel.sProhibited : inst.getTeachingPreference().getPrefProlog());
            if (inst.getMaxLoad() == null && (inst.getTeachingPreference() == null || inst.getTeachingPreference().getPrefProlog().equals(PreferenceLevel.sProhibited))) {
                frm.setTeachingPreference(null);
            }
            frm.clearAttributes();
            for (InstructorAttribute attribute : inst.getAttributes()) {
                frm.setAttribute(attribute.getUniqueId(), (Boolean)true);
            }
            LookupTables.setupInstructorAttributeTypes(request, inst);
            LookupTables.setupInstructorAttributes(request, inst);
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorDetail);
            frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorDetail);
            frm.setNextId(next == null ? null : next.getUniqueId().toString());
            if (inst.getExternalUniqueId() != null && !inst.getExternalUniqueId().isEmpty()) {
                ArrayList<IdValue> departments = new ArrayList<IdValue>();
                for (DepartmentalInstructor di : DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId = :externalId order by i.department.deptCode").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("externalId", inst.getExternalUniqueId()).setCacheable(true).list()) {
                    if (!this.sessionContext.hasPermission(di, Right.InstructorDetail)) continue;
                    departments.add(new IdValue(di.getUniqueId(), di.getDepartment().getLabel()));
                }
                if (departments.size() > 1) {
                    frm.setDepartments(departments);
                }
            }
            return mapping.findForward("showInstructorDetail");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, InstructorEditForm frm, DepartmentalInstructor inst, String instructorId) {
        frm.setInstructorId(instructorId);
        NameFormat nameFormat = NameFormat.fromReference(this.sessionContext.getUser().getProperty(UserProperty.NameFormat));
        frm.setName(nameFormat.format(inst));
        frm.setEmail(inst.getEmail());
        frm.setDeptCode(inst.getDepartment().getDeptCode());
        frm.setDeptName(inst.getDepartment().getLabel());
        String puid = inst.getExternalUniqueId();
        if (puid != null) {
            frm.setPuId(puid);
        }
        if (inst.getPositionType() != null) {
            frm.setPosType(inst.getPositionType().getLabel().trim());
        }
        if (inst.getCareerAcct() != null) {
            frm.setCareerAcct(inst.getCareerAcct().trim());
        } else if (DepartmentalInstructor.canLookupInstructor()) {
            try {
                ExternalUidLookup.UserInfo user = DepartmentalInstructor.lookupInstructor(puid);
                if (user != null && user.getUserName() != null) {
                    frm.setCareerAcct(user.getUserName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inst.getNote() != null) {
            frm.setNote(inst.getNote().trim());
        }
        request.getSession().setAttribute(Constants.DEPT_ID_ATTR_NAME, (Object)inst.getDepartment().getUniqueId().toString());
        String orderStr = request.getParameter("order");
        int cols = 2;
        int order = 1;
        if (orderStr != null && orderStr.trim().length() != 0) {
            try {
                order = Integer.parseInt(orderStr);
                if (Math.abs(order) > cols) {
                    order = 1;
                }
            }
            catch (Exception e) {
                order = 1;
            }
        }
        frm.setIgnoreDist(inst.isIgnoreToFar() == null ? false : inst.isIgnoreToFar());
    }
}

