/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.Messages;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.unitime.localization.impl.PageNameGenerator;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.gwt.resources.Constants;
import org.unitime.timetable.gwt.resources.Messages;

public class ExportTranslations {
    private List<Bundle> iBundles = new ArrayList<Bundle>();
    private List<Locale> iLocales = new ArrayList<Locale>();
    private File iBaseDir;
    private String iTranslations = "Documentation/Translations";
    private File iSource;
    private Project iProject = null;
    private boolean iGeneratePageNames = false;
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setProject(Project project) {
        this.iProject = project;
        this.iBaseDir = project.getBaseDir();
    }

    public void setSource(String source) {
        this.iSource = new File(source);
    }

    public void setBaseDir(String baseDir) {
        this.iBaseDir = new File(baseDir);
    }

    public Bundle createBundle() {
        Bundle bundle = new Bundle();
        this.iBundles.add(bundle);
        return bundle;
    }

    public void addBundle(Bundle bundle) {
        this.iBundles.add(bundle);
    }

    public void setBundles(String bundles) {
        for (String name : bundles.split(",")) {
            this.addBundle(new Bundle(name));
        }
    }

    public Locale createLocale() {
        Locale locale = new Locale();
        this.iLocales.add(locale);
        return locale;
    }

    public void addLocale(Locale locale) {
        this.iLocales.add(locale);
    }

    public void setLocales(String locales) {
        for (String value : locales.split(",")) {
            this.addLocale(new Locale(value));
        }
    }

    public void setTranslations(String translations) {
        this.iTranslations = translations;
    }

    public void setGeneratePageNames(boolean generatePageNames) {
        this.iGeneratePageNames = generatePageNames;
    }

    private static String array2string(String[] value) {
        String ret = "";
        for (String s : value) {
            if (!ret.isEmpty()) {
                ret = ret + ",";
            }
            ret = ret + s.replace(",", "\\\\,");
        }
        return ret;
    }

    private static String unicodeEscape(String s, String locale) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >> 7 > 0) {
                sb.append("\\u");
                sb.append(hexChar[c >> 12 & 0xF]);
                sb.append(hexChar[c >> 8 & 0xF]);
                sb.append(hexChar[c >> 4 & 0xF]);
                sb.append(hexChar[c & 0xF]);
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\\\"");
                continue;
            }
            if (c == '\\') {
                if (locale != null) {
                    sb.append("\\\\\\\\");
                    continue;
                }
                sb.append("\\\\");
                continue;
            }
            if (c == ' ' && (i == 0 || i + 1 == s.length())) {
                sb.append("\\\\ ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void info(String message) {
        if (this.iProject != null) {
            this.iProject.log(message);
        } else {
            System.out.println("     [info] " + message);
        }
    }

    public void warn(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 1);
        } else {
            System.out.println("  [warning] " + message);
        }
    }

    public void debug(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 4);
        } else {
            System.out.println("    [debug] " + message);
        }
    }

    public void error(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 0);
        } else {
            System.out.println("    [error] " + message);
        }
    }

    public void execute() throws BuildException {
        try {
            File translations = new File(this.iBaseDir, this.iTranslations);
            this.info("Exporting translations to: " + translations);
            translations.mkdirs();
            for (Bundle bundle : this.iBundles) {
                this.info("Loading " + bundle);
                Class<?> clazz = null;
                File folder = null;
                if (bundle.hasPackage()) {
                    try {
                        clazz = Class.forName(bundle.getPackage() + "." + bundle.getName());
                        folder = new File(this.iSource, bundle.getPackage().replace('.', File.separatorChar));
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                try {
                    clazz = Class.forName("org.unitime.localization.messages." + bundle);
                    folder = new File(this.iSource, "org.unitime.localization.messages.".replace('.', File.separatorChar));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    if (clazz == null) {
                        clazz = Class.forName("org.unitime.timetable.gwt.resources." + bundle);
                        folder = new File(this.iSource, "org.unitime.timetable.gwt.resources.".replace('.', File.separatorChar));
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (clazz == null) {
                    this.error("Bundle " + bundle + " not found.");
                    continue;
                }
                PrintStream out = new PrintStream(new File(translations, bundle.getName() + ".properties"));
                ArrayList<String> names = new ArrayList<String>();
                if (PageNames.class.equals(clazz) && this.iGeneratePageNames) {
                    PageNameGenerator gen = new PageNameGenerator();
                    gen.setSource(this.iSource);
                    for (String name : gen.execute()) {
                        String prop = gen.name2property(name);
                        out.println("# " + prop);
                        out.println(prop + "=" + ExportTranslations.unicodeEscape(name, null));
                        names.add(prop);
                    }
                } else {
                    for (Method method : clazz.getMethods()) {
                        boolean doNotTranslate;
                        Constants.DefaultStringMapValue dsm;
                        Constants.DefaultStringArrayValue dsa;
                        Constants.DefaultStringValue ds;
                        Constants.DefaultIntValue di;
                        Constants.DefaultFloatValue df;
                        Constants.DefaultDoubleValue dd;
                        Constants.DefaultBooleanValue db;
                        names.add(method.getName());
                        String value = null;
                        Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
                        if (dm != null) {
                            value = dm.value();
                        }
                        if ((db = method.getAnnotation(Constants.DefaultBooleanValue.class)) != null) {
                            String string = value = db.value() ? "true" : "false";
                        }
                        if ((dd = method.getAnnotation(Constants.DefaultDoubleValue.class)) != null) {
                            value = String.valueOf(dd.value());
                        }
                        if ((df = method.getAnnotation(Constants.DefaultFloatValue.class)) != null) {
                            value = String.valueOf(df.value());
                        }
                        if ((di = method.getAnnotation(Constants.DefaultIntValue.class)) != null) {
                            value = String.valueOf(di.value());
                        }
                        if ((ds = method.getAnnotation(Constants.DefaultStringValue.class)) != null) {
                            value = ds.value();
                        }
                        if ((dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                            value = ExportTranslations.array2string(dsa.value());
                        }
                        if ((dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) != null) {
                            value = ExportTranslations.array2string(dsm.value());
                        }
                        if ("translateMessage".equals(method.getName())) continue;
                        boolean bl = doNotTranslate = method.getAnnotation(Messages.DoNotTranslate.class) != null || method.getAnnotation(Constants.DoNotTranslate.class) != null;
                        if (doNotTranslate) continue;
                        if (value == null) {
                            this.warn("Property " + method.getName() + " has no default value!");
                        }
                        out.println("# " + method.getName());
                        out.println(method.getName() + "=" + ExportTranslations.unicodeEscape(value != null ? value : "", null));
                    }
                }
                out.flush();
                out.close();
                for (Locale locale : this.iLocales) {
                    this.debug("Locale " + locale);
                    Properties properties = new Properties();
                    InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + "_" + locale + ".properties");
                    if (is != null) {
                        properties.load(is);
                    } else {
                        File file = new File(folder, bundle.getName() + "_" + locale.getValue() + ".properties");
                        if (file.exists()) {
                            FileReader r = new FileReader(file);
                            properties.load(r);
                            r.close();
                        }
                    }
                    out = new PrintStream(new File(translations, bundle.getName() + "_" + locale.getValue() + ".properties"));
                    for (String name : names) {
                        String text = properties.getProperty(name);
                        if (text == null) continue;
                        out.println(name + "=" + ExportTranslations.unicodeEscape(text, locale.getValue()));
                    }
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Export failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ExportTranslations task = new ExportTranslations();
            task.setBaseDir(System.getProperty("source", "/Users/muller/git/unitime"));
            task.setSource(System.getProperty("source", "/Users/muller/git/unitime") + File.separator + "JavaSource");
            task.setBundles(System.getProperty("bundle", "CourseMessages,ConstantsMessages,ExaminationMessages,SecurityMessages,GwtConstants,GwtAriaMessages,GwtMessages,StudentSectioningConstants,StudentSectioningMessages"));
            task.setLocales(System.getProperty("locale", "cs"));
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Locale {
        String iValue;

        public Locale(String value) {
            this.iValue = value;
        }

        public Locale() {
            this(null);
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getValue() {
            return this.iValue;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static class Bundle {
        String iPackage;
        String iName;

        public Bundle(String pck, String name) {
            this.iPackage = pck;
            this.iName = name;
        }

        public Bundle() {
            this(null, null);
        }

        public Bundle(String name) {
            this(null, name);
        }

        public void setPackage(String pck) {
            this.iPackage = pck;
        }

        public boolean hasPackage() {
            return this.iPackage != null && !this.iPackage.isEmpty();
        }

        public String getPackage() {
            return this.iPackage;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public String toString() {
            return (this.hasPackage() ? this.getPackage() + "." : "") + this.getName();
        }
    }
}

