/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.weights;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.SolutionComparator;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.weights.EqualStudentWeights;
import org.cpsolver.studentsct.weights.OriginalStudentWeights;
import org.cpsolver.studentsct.weights.PriorityStudentWeights;

public interface StudentWeights
extends SolutionComparator<Request, Enrollment> {
    public double getBound(Request var1);

    public double getWeight(Assignment<Request, Enrollment> var1, Enrollment var2);

    public double getWeight(Assignment<Request, Enrollment> var1, Enrollment var2, Set<DistanceConflict.Conflict> var3, Set<TimeOverlapsCounter.Conflict> var4);

    public double getDistanceConflictWeight(Assignment<Request, Enrollment> var1, DistanceConflict.Conflict var2);

    public double getTimeOverlapConflictWeight(Assignment<Request, Enrollment> var1, Enrollment var2, TimeOverlapsCounter.Conflict var3);

    public boolean isFreeTimeAllowOverlaps();

    public static enum Implementation {
        Priority(PriorityStudentWeights.class),
        Equal(EqualStudentWeights.class),
        Legacy(OriginalStudentWeights.class);

        private Class<? extends StudentWeights> iImplementation;

        private Implementation(Class<? extends StudentWeights> implementation) {
            this.iImplementation = implementation;
        }

        public Class<? extends StudentWeights> getImplementation() {
            return this.iImplementation;
        }
    }
}

