/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentConflict
extends Constraint<Request, Enrollment> {
    public StudentConflict(Student student) {
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
    }

    public static boolean canAssign(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        int alt = 0;
        boolean found = false;
        for (Request r : enrollment.getStudent().getRequests()) {
            boolean waitlist;
            if (r.equals(enrollment.getRequest())) {
                found = true;
            }
            boolean assigned = r.isAssigned(assignment) || r.equals(enrollment.getRequest());
            boolean course = r instanceof CourseRequest;
            boolean bl = waitlist = course && ((CourseRequest)r).isWaitlist();
            if (r.isAlternative()) {
                if (!assigned && (found || !waitlist)) continue;
                --alt;
                continue;
            }
            if (!course || waitlist || assigned) continue;
            ++alt;
        }
        return alt >= 0;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        for (Request request : this.variables()) {
            Enrollment e;
            if (request.equals(enrollment.getRequest()) || (e = assignment.getValue(request)) == null || !enrollment.isOverlapping(e)) continue;
            conflicts.add(e);
        }
        if (!enrollment.getAssignments().isEmpty() && !StudentConflict.canAssign(assignment, enrollment)) {
            Enrollment lowestPriorityEnrollment = null;
            int lowestPriority = -1;
            for (Request request : this.variables()) {
                Enrollment e;
                if (request.equals(enrollment.getRequest()) || !(request instanceof CourseRequest) || ((CourseRequest)request).isWaitlist() || (e = assignment.getValue(request)) == null || lowestPriority >= request.getPriority()) continue;
                lowestPriority = request.getPriority();
                lowestPriorityEnrollment = e;
            }
            if (lowestPriorityEnrollment != null) {
                conflicts.add(lowestPriorityEnrollment);
            } else {
                conflicts.add(enrollment);
            }
        }
    }

    @Override
    public boolean isConsistent(Enrollment e1, Enrollment e2) {
        return !e1.isOverlapping(e2);
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        for (Request request : this.variables()) {
            Enrollment e;
            if (request.equals(enrollment.getRequest()) || (e = assignment.getValue(request)) == null || !enrollment.isOverlapping(e)) continue;
            return true;
        }
        return !StudentConflict.canAssign(assignment, enrollment);
    }

    public String toString() {
        return "StudentConflicts";
    }
}

