/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultInheritedAssignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.assignment.EmptyAssignment;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ExtendedInfoProvider;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.ModelListener;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.ToolBox;

public class Model<V extends Variable<V, T>, T extends Value<V, T>> {
    private static Logger sLogger = Logger.getLogger(Model.class);
    protected static DecimalFormat sTimeFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sPercentageFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private List<V> iVariables = new ArrayList<V>();
    private List<Constraint<V, T>> iConstraints = new ArrayList<Constraint<V, T>>();
    private List<GlobalConstraint<V, T>> iGlobalConstraints = new ArrayList<GlobalConstraint<V, T>>();
    private Collection<V> iVariablesWithInitialValueCache = null;
    private final ReentrantReadWriteLock iVariablesWithInitialValueLock = new ReentrantReadWriteLock();
    private List<ModelListener<V, T>> iModelListeners = new ArrayList<ModelListener<V, T>>();
    private List<InfoProvider<V, T>> iInfoProviders = new ArrayList<InfoProvider<V, T>>();
    private HashMap<String, Criterion<V, T>> iCriteria = new HashMap();
    private int iBestUnassignedVariables = -1;
    private int iBestPerturbations = 0;
    private double iBestValue = 0.0;
    private int iNextReferenceId = 0;
    private int iNextVariableIndex = 0;
    @Deprecated
    private Assignment<V, T> iAssignment = null;
    private Assignment<V, T> iEmptyAssignment = null;
    private Map<Integer, AssignmentContextReference<V, T, ? extends AssignmentContext>> iAssignmentContextReferences = new HashMap<Integer, AssignmentContextReference<V, T, ? extends AssignmentContext>>();

    public List<V> variables() {
        return this.iVariables;
    }

    public int countVariables() {
        return this.iVariables.size();
    }

    public void addVariable(V variable) {
        ((Variable)variable).setModel(this);
        ((Variable)variable).setIndex(this.iNextVariableIndex++);
        this.iVariables.add(variable);
        if (variable instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)variable);
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.variableAdded(variable);
        }
        this.invalidateVariablesWithInitialValueCache();
    }

    public void removeVariable(V variable) {
        ((Variable)variable).setModel(null);
        this.iVariables.remove(variable);
        if (variable instanceof InfoProvider) {
            this.iInfoProviders.remove(variable);
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.variableRemoved(variable);
        }
        this.invalidateVariablesWithInitialValueCache();
        if (variable instanceof HasAssignmentContext) {
            this.removeReference((HasAssignmentContext)variable);
        }
    }

    public List<Constraint<V, T>> constraints() {
        return this.iConstraints;
    }

    public int countConstraints() {
        return this.iConstraints.size();
    }

    public void addConstraint(Constraint<V, T> constraint) {
        constraint.setModel(this);
        this.iConstraints.add(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)constraint));
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.constraintAdded(constraint);
        }
    }

    public void removeConstraint(Constraint<V, T> constraint) {
        constraint.setModel(null);
        this.iConstraints.remove(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.remove(constraint);
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.constraintRemoved(constraint);
        }
        if (constraint instanceof HasAssignmentContext) {
            this.removeReference((HasAssignmentContext)((Object)constraint));
        }
    }

    public List<GlobalConstraint<V, T>> globalConstraints() {
        return this.iGlobalConstraints;
    }

    public int countGlobalConstraints() {
        return this.iGlobalConstraints.size();
    }

    public void addGlobalConstraint(GlobalConstraint<V, T> constraint) {
        constraint.setModel(this);
        this.iGlobalConstraints.add(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)constraint));
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.constraintAdded(constraint);
        }
    }

    public void removeGlobalConstraint(GlobalConstraint<V, T> constraint) {
        constraint.setModel(null);
        this.iGlobalConstraints.remove(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.remove(constraint);
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.constraintRemoved(constraint);
        }
        if (constraint instanceof HasAssignmentContext) {
            this.removeReference((HasAssignmentContext)((Object)constraint));
        }
    }

    @Deprecated
    public Collection<V> unassignedVariables() {
        return this.unassignedVariables(this.getDefaultAssignment());
    }

    public Collection<V> unassignedVariables(Assignment<V, T> assignment) {
        return assignment.unassignedVariables(this);
    }

    @Deprecated
    public int nrUnassignedVariables() {
        return this.nrUnassignedVariables(this.getDefaultAssignment());
    }

    public int nrUnassignedVariables(Assignment<V, T> assignment) {
        return assignment.nrUnassignedVariables(this);
    }

    @Deprecated
    public Collection<V> assignedVariables() {
        return this.assignedVariables(this.getDefaultAssignment());
    }

    public Collection<V> assignedVariables(Assignment<V, T> assignment) {
        return assignment.assignedVariables();
    }

    @Deprecated
    public int nrAssignedVariables() {
        return this.nrAssignedVariables(this.getDefaultAssignment());
    }

    public int nrAssignedVariables(Assignment<V, T> assignment) {
        return assignment.nrAssignedVariables();
    }

    @Deprecated
    public Collection<V> perturbVariables() {
        return this.perturbVariables(this.getDefaultAssignment(), this.variablesWithInitialValue());
    }

    public Collection<V> perturbVariables(Assignment<V, T> assignment) {
        return this.perturbVariables(assignment, this.variablesWithInitialValue());
    }

    @Deprecated
    public List<V> perturbVariables(Collection<V> variables) {
        return this.perturbVariables(this.getDefaultAssignment(), variables);
    }

    public List<V> perturbVariables(Assignment<V, T> assignment, Collection<V> variables) {
        ArrayList<Variable> perturbances = new ArrayList<Variable>();
        for (Variable variable : variables) {
            if (variable.getInitialAssignment() == null) continue;
            T value = assignment.getValue(variable);
            if (value != null) {
                if (((Value)variable.getInitialAssignment()).equals(value)) continue;
                perturbances.add(variable);
                continue;
            }
            boolean hasPerturbance = false;
            for (Constraint<Variable, T> constraint : variable.hardConstraints()) {
                if (!constraint.inConflict(assignment, variable.getInitialAssignment())) continue;
                hasPerturbance = true;
                break;
            }
            if (!hasPerturbance) {
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    if (!globalConstraint.inConflict(assignment, variable.getInitialAssignment())) continue;
                    hasPerturbance = true;
                    break;
                }
            }
            if (!hasPerturbance) continue;
            perturbances.add(variable);
        }
        return perturbances;
    }

    @Deprecated
    public Set<T> conflictValues(T value) {
        return this.conflictValues(this.getDefaultAssignment(), value);
    }

    public Set<T> conflictValues(Assignment<V, T> assignment, T value) {
        HashSet conflictValues = new HashSet();
        for (Constraint<V, T> constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            constraint.computeConflicts(assignment, value, conflictValues);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            globalConstraint.computeConflicts(assignment, value, conflictValues);
        }
        return conflictValues;
    }

    @Deprecated
    public boolean inConflict(T value) {
        return this.inConflict(this.getDefaultAssignment(), value);
    }

    public boolean inConflict(Assignment<V, T> assignment, T value) {
        for (Constraint<V, T> constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            if (!constraint.inConflict(assignment, value)) continue;
            return true;
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            if (!globalConstraint.inConflict(assignment, value)) continue;
            return true;
        }
        return false;
    }

    public Collection<V> variablesWithInitialValue() {
        this.iVariablesWithInitialValueLock.readLock().lock();
        try {
            if (this.iVariablesWithInitialValueCache != null) {
                Collection<V> collection = this.iVariablesWithInitialValueCache;
                return collection;
            }
        }
        finally {
            this.iVariablesWithInitialValueLock.readLock().unlock();
        }
        this.iVariablesWithInitialValueLock.writeLock().lock();
        try {
            if (this.iVariablesWithInitialValueCache != null) {
                Collection<V> collection = this.iVariablesWithInitialValueCache;
                return collection;
            }
            this.iVariablesWithInitialValueCache = new ArrayList<V>();
            for (Variable variable : this.iVariables) {
                if (variable.getInitialAssignment() == null) continue;
                this.iVariablesWithInitialValueCache.add(variable);
            }
            Collection<V> collection = this.iVariablesWithInitialValueCache;
            return collection;
        }
        finally {
            this.iVariablesWithInitialValueLock.writeLock().unlock();
        }
    }

    protected void invalidateVariablesWithInitialValueCache() {
        this.iVariablesWithInitialValueLock.writeLock().lock();
        this.iVariablesWithInitialValueCache = null;
        this.iVariablesWithInitialValueLock.writeLock().unlock();
    }

    @Deprecated
    public void beforeAssigned(long iteration, T value) {
    }

    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        this.beforeAssigned(iteration, value);
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.beforeAssigned(assignment, iteration, value);
        }
    }

    @Deprecated
    public void beforeUnassigned(long iteration, T value) {
    }

    public void beforeUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        this.beforeUnassigned(iteration, value);
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.beforeUnassigned(assignment, iteration, value);
        }
    }

    @Deprecated
    public void afterAssigned(long iteration, T value) {
    }

    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        this.afterAssigned(iteration, value);
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.afterAssigned(assignment, iteration, value);
        }
    }

    @Deprecated
    public void afterUnassigned(long iteration, T value) {
    }

    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        this.afterUnassigned(iteration, value);
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.afterUnassigned(assignment, iteration, value);
        }
    }

    public String toString() {
        return "Model{\n    variables=" + ToolBox.col2string(this.variables(), 2) + ",\n    constraints=" + ToolBox.col2string(this.constraints(), 2) + ",\n  }";
    }

    public String toString(Assignment<V, T> assignment) {
        ArrayList<Criterion<V, T>> criteria = new ArrayList<Criterion<V, T>>(this.getCriteria());
        Collections.sort(criteria, new Comparator<Criterion<V, T>>(){

            @Override
            public int compare(Criterion<V, T> c1, Criterion<V, T> c2) {
                int cmp = -Double.compare(c1.getWeight(), c2.getWeight());
                if (cmp != 0) {
                    return cmp;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        String ret = "";
        for (Criterion criterion : criteria) {
            String val = criterion.toString(assignment);
            if (val == null || val.isEmpty()) continue;
            ret = ret + ", " + val;
        }
        return (this.nrUnassignedVariables(assignment) == 0 ? "" : "V:" + this.nrAssignedVariables(assignment) + "/" + this.variables().size() + ", ") + "T:" + sDoubleFormat.format(this.getTotalValue(assignment)) + ret;
    }

    protected String getPerc(double value, double min, double max) {
        if (max == min) {
            return sPercentageFormat.format(100.0);
        }
        return sPercentageFormat.format(100.0 - 100.0 * (value - min) / (max - min));
    }

    protected String getPercRev(double value, double min, double max) {
        if (max == min) {
            return sPercentageFormat.format(0.0);
        }
        return sPercentageFormat.format(100.0 * (value - min) / (max - min));
    }

    @Deprecated
    public Map<String, String> getInfo() {
        return this.getInfo(this.getDefaultAssignment());
    }

    public Map<String, String> getInfo(Assignment<V, T> assignment) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Assigned variables", this.getPercRev(assignment.nrAssignedVariables(), 0.0, this.variables().size()) + "% (" + assignment.nrAssignedVariables() + "/" + this.variables().size() + ")");
        int nrVarsWithInitialValue = this.variablesWithInitialValue().size();
        if (nrVarsWithInitialValue > 0) {
            Collection<V> pv = this.perturbVariables(assignment);
            ret.put("Perturbation variables", this.getPercRev(pv.size(), 0.0, nrVarsWithInitialValue) + "% (" + pv.size() + " + " + (this.variables().size() - nrVarsWithInitialValue) + ")");
        }
        ret.put("Overall solution value", sDoubleFormat.format(this.getTotalValue(assignment)));
        for (InfoProvider<V, T> provider : this.iInfoProviders) {
            provider.getInfo(assignment, ret);
        }
        return ret;
    }

    @Deprecated
    public Map<String, String> getExtendedInfo() {
        return this.getExtendedInfo(this.getDefaultAssignment());
    }

    public Map<String, String> getExtendedInfo(Assignment<V, T> assignment) {
        Map<String, String> ret = this.getInfo(assignment);
        for (InfoProvider<V, T> provider : this.iInfoProviders) {
            if (!(provider instanceof ExtendedInfoProvider)) continue;
            ((ExtendedInfoProvider)provider).getExtendedInfo(assignment, ret);
        }
        return ret;
    }

    @Deprecated
    public Map<String, String> getInfo(Collection<V> variables) {
        return this.getInfo(this.getDefaultAssignment(), variables);
    }

    public Map<String, String> getInfo(Assignment<V, T> assignment, Collection<V> variables) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int assigned = 0;
        int perturb = 0;
        int nrVarsWithInitialValue = 0;
        for (Variable variable : variables) {
            T value = assignment.getValue(variable);
            if (value != null) {
                ++assigned;
            }
            if (variable.getInitialAssignment() == null) continue;
            ++nrVarsWithInitialValue;
            if (value != null) {
                if (((Value)variable.getInitialAssignment()).equals(value)) continue;
                ++perturb;
                continue;
            }
            boolean hasPerturbance = false;
            for (Constraint<Variable, T> constraint : variable.hardConstraints()) {
                if (!constraint.inConflict(assignment, variable.getInitialAssignment())) continue;
                hasPerturbance = true;
                break;
            }
            if (!hasPerturbance) {
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    if (!globalConstraint.inConflict(assignment, variable.getInitialAssignment())) continue;
                    hasPerturbance = true;
                    break;
                }
            }
            if (!hasPerturbance) continue;
            ++perturb;
        }
        ret.put("Assigned variables", this.getPercRev(assigned, 0.0, variables.size()) + "% (" + assigned + "/" + variables.size() + ")");
        if (nrVarsWithInitialValue > 0) {
            ret.put("Perturbation variables", this.getPercRev(perturb, 0.0, nrVarsWithInitialValue) + "% (" + perturb + " + " + (variables.size() - nrVarsWithInitialValue) + ")");
        }
        ret.put("Overall solution value", sDoubleFormat.format(this.getTotalValue(assignment, variables)));
        for (InfoProvider infoProvider : this.iInfoProviders) {
            infoProvider.getInfo(assignment, ret, variables);
        }
        return ret;
    }

    public int getBestUnassignedVariables() {
        return this.iBestUnassignedVariables;
    }

    public int getBestPerturbations() {
        return this.iBestPerturbations;
    }

    public double getBestValue() {
        return this.iBestValue;
    }

    public void setBestValue(double bestValue) {
        this.iBestValue = bestValue;
    }

    @Deprecated
    public void saveBest() {
        this.saveBest(this.getDefaultAssignment());
    }

    public void saveBest(Assignment<V, T> assignment) {
        this.iBestUnassignedVariables = this.iVariables.size() - assignment.nrAssignedVariables();
        this.iBestPerturbations = this.perturbVariables(assignment).size();
        this.iBestValue = this.getTotalValue(assignment);
        for (Variable variable : this.iVariables) {
            variable.setBestAssignment(assignment.getValue(variable), assignment.getIteration(variable));
        }
        for (Criterion criterion : this.getCriteria()) {
            criterion.bestSaved(assignment);
        }
    }

    public void clearBest() {
        this.iBestUnassignedVariables = -1;
        this.iBestPerturbations = 0;
        this.iBestValue = 0.0;
        for (Variable variable : this.iVariables) {
            variable.setBestAssignment(null, 0L);
        }
    }

    @Deprecated
    protected void restoreBest() {
        this.restoreBest(this.getDefaultAssignment());
    }

    protected void restoreBest(Assignment<V, T> assignment, Comparator<V> assignmentOrder) {
        TreeSet<V> sortedVariables = new TreeSet<V>(assignmentOrder);
        for (Object variable : this.iVariables) {
            Value value = assignment.getValue((Variable)variable);
            if (value == null) {
                if (((Variable)variable).getBestAssignment() == null) continue;
                sortedVariables.add(variable);
                continue;
            }
            if (value.equals(((Variable)variable).getBestAssignment())) continue;
            assignment.unassign(0L, (Variable)variable);
            if (((Variable)variable).getBestAssignment() == null) continue;
            sortedVariables.add(variable);
        }
        HashSet<Object> problems = new HashSet<Object>();
        for (Variable variable : sortedVariables) {
            Set<Value> confs = this.conflictValues(assignment, variable.getBestAssignment());
            if (!confs.isEmpty()) {
                sLogger.error("restore best problem: assignment " + variable.getName() + " = " + ((Value)variable.getBestAssignment()).getName());
                boolean bl = false;
                for (Constraint<Variable, Value> constraint : variable.hardConstraints()) {
                    HashSet hashSet = new HashSet();
                    constraint.computeConflicts(assignment, (Value)variable.getBestAssignment(), hashSet);
                    if (hashSet.isEmpty()) continue;
                    if (constraint instanceof WeakeningConstraint) {
                        ((WeakeningConstraint)((Object)constraint)).weaken(assignment, variable.getBestAssignment());
                        sLogger.info("  constraint " + constraint.getClass().getSimpleName() + " " + constraint.getName() + " had to be weakened");
                        bl = true;
                        continue;
                    }
                    sLogger.error("  constraint " + constraint.getClass().getSimpleName() + " " + constraint.getName() + " causes the following conflicts " + hashSet);
                }
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    HashSet hashSet = new HashSet();
                    globalConstraint.computeConflicts(assignment, variable.getBestAssignment(), hashSet);
                    if (hashSet.isEmpty()) continue;
                    if (globalConstraint instanceof WeakeningConstraint) {
                        ((WeakeningConstraint)((Object)globalConstraint)).weaken(assignment, variable.getBestAssignment());
                        sLogger.info("  constraint " + globalConstraint.getClass().getSimpleName() + " " + globalConstraint.getName() + " had to be weakened");
                        bl = true;
                        continue;
                    }
                    sLogger.error("  global constraint " + globalConstraint.getClass().getSimpleName() + " " + globalConstraint.getName() + " causes the following conflicts " + hashSet);
                }
                if (bl && this.conflictValues(assignment, variable.getBestAssignment()).isEmpty()) {
                    assignment.assign(0L, (Value)variable.getBestAssignment());
                    continue;
                }
                problems.add(variable.getBestAssignment());
                continue;
            }
            assignment.assign(0L, (Value)variable.getBestAssignment());
        }
        int attempt = 0;
        int maxAttempts = 3 * problems.size();
        while (!problems.isEmpty() && attempt <= maxAttempts) {
            ++attempt;
            Value value = (Value)ToolBox.random(problems);
            problems.remove(value);
            Object v = value.variable();
            Set<Value> confs = this.conflictValues(assignment, value);
            if (!confs.isEmpty()) {
                HashSet x;
                sLogger.error("restore best problem (again, att=" + attempt + "): assignment " + ((Variable)v).getName() + " = " + value.getName());
                for (Constraint<Variable, Value> constraint : ((Variable)v).hardConstraints()) {
                    x = new HashSet();
                    constraint.computeConflicts(assignment, value, x);
                    if (x.isEmpty()) continue;
                    sLogger.error("  constraint " + constraint.getClass().getSimpleName() + " " + constraint.getName() + " causes the following conflicts " + x);
                }
                for (GlobalConstraint<Variable, Value> globalConstraint : this.globalConstraints()) {
                    x = new HashSet();
                    globalConstraint.computeConflicts(assignment, value, x);
                    if (x.isEmpty()) continue;
                    sLogger.error("  constraint " + globalConstraint.getClass().getSimpleName() + " " + globalConstraint.getName() + " causes the following conflicts " + x);
                }
                for (Value value2 : confs) {
                    assignment.unassign(0L, (Variable)value2.variable());
                }
                problems.addAll(confs);
            }
            assignment.assign(0L, value);
        }
        for (Criterion<Variable, Value> criterion : this.getCriteria()) {
            criterion.bestRestored(assignment);
        }
    }

    public void restoreBest(Assignment<V, T> assignment) {
        this.restoreBest(assignment, new Comparator<V>(){

            @Override
            public int compare(V v1, V v2) {
                if (((Variable)v1).getBestAssignmentIteration() < ((Variable)v2).getBestAssignmentIteration()) {
                    return -1;
                }
                if (((Variable)v1).getBestAssignmentIteration() > ((Variable)v2).getBestAssignmentIteration()) {
                    return 1;
                }
                return ((Variable)v1).compareTo(v2);
            }
        });
    }

    @Deprecated
    public Collection<V> bestUnassignedVariables() {
        return this.bestUnassignedVariables(this.getDefaultAssignment());
    }

    public Collection<V> bestUnassignedVariables(Assignment<V, T> assignment) {
        ArrayList<Variable> ret = new ArrayList<Variable>(this.variables().size());
        if (this.iBestUnassignedVariables < 0) {
            for (Variable variable : this.variables()) {
                if (assignment.getValue(variable) != null) continue;
                ret.add(variable);
            }
        } else {
            for (Variable variable : this.variables()) {
                if (variable.getBestAssignment() != null) continue;
                ret.add(variable);
            }
        }
        return ret;
    }

    @Deprecated
    public double getTotalValue() {
        return this.getTotalValue(this.getDefaultAssignment());
    }

    public double getTotalValue(Assignment<V, T> assignment) {
        double ret = 0.0;
        if (this.getCriteria().isEmpty()) {
            for (Value t : assignment.assignedValues()) {
                ret += t.toDouble(assignment);
            }
        } else {
            for (Criterion<V, T> c : this.getCriteria()) {
                ret += c.getWeightedValue(assignment);
            }
        }
        return ret;
    }

    @Deprecated
    public double getTotalValue(Collection<V> variables) {
        return this.getTotalValue(this.getDefaultAssignment(), variables);
    }

    public double getTotalValue(Assignment<V, T> assignment, Collection<V> variables) {
        double ret = 0.0;
        for (Variable v : variables) {
            T t = assignment.getValue(v);
            if (t == null) continue;
            ret += ((Value)t).toDouble(assignment);
        }
        return ret;
    }

    public void addModelListener(ModelListener<V, T> listener) {
        this.iModelListeners.add(listener);
        if (listener instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)listener));
        }
        for (Constraint<V, T> constraint : this.iConstraints) {
            listener.constraintAdded(constraint);
        }
        for (Variable variable : this.iVariables) {
            listener.variableAdded(variable);
        }
    }

    public void removeModelListener(ModelListener<V, T> listener) {
        if (listener instanceof InfoProvider) {
            this.iInfoProviders.remove(listener);
        }
        for (Variable variable : this.iVariables) {
            listener.variableRemoved(variable);
        }
        for (Constraint constraint : this.iConstraints) {
            listener.constraintRemoved(constraint);
        }
        this.iModelListeners.remove(listener);
    }

    public boolean init(Solver<V, T> solver) {
        for (ModelListener<V, T> listener : new ArrayList<ModelListener<V, T>>(this.iModelListeners)) {
            if (listener.init(solver)) continue;
            return false;
        }
        return true;
    }

    public List<ModelListener<V, T>> getModelListeners() {
        return this.iModelListeners;
    }

    public ModelListener<V, T> modelListenerOfType(Class<ModelListener<V, T>> type) {
        for (ModelListener<V, T> listener : this.iModelListeners) {
            if (listener.getClass() != type) continue;
            return listener;
        }
        return null;
    }

    public Map<Constraint<V, T>, Set<T>> conflictConstraints(Assignment<V, T> assignment, T value) {
        HashSet conflicts;
        HashMap conflictConstraints = new HashMap();
        for (Constraint<V, T> constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            conflicts = new HashSet();
            constraint.computeConflicts(assignment, value, conflicts);
            if (conflicts.isEmpty()) continue;
            conflictConstraints.put(constraint, conflicts);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            conflicts = new HashSet();
            globalConstraint.computeConflicts(assignment, value, conflicts);
            if (conflicts.isEmpty()) continue;
            conflictConstraints.put(globalConstraint, conflicts);
        }
        return conflictConstraints;
    }

    public List<Constraint<V, T>> unassignedHardConstraints(Assignment<V, T> assignment) {
        ArrayList<Constraint<V, T>> ret = new ArrayList<Constraint<V, T>>();
        block0: for (Constraint<V, T> constraint : this.constraints()) {
            if (!constraint.isHard()) continue;
            for (Variable v : constraint.variables()) {
                if (assignment.getValue(v) != null) continue;
                ret.add(constraint);
                continue block0;
            }
        }
        if (this.iVariables.size() > assignment.nrAssignedVariables()) {
            ret.addAll(this.globalConstraints());
        }
        return ret;
    }

    protected List<InfoProvider<V, T>> getInfoProviders() {
        return this.iInfoProviders;
    }

    public void addCriterion(Criterion<V, T> criterion) {
        this.iCriteria.put(criterion.getClass().getName(), criterion);
        criterion.setModel(this);
        this.addModelListener(criterion);
    }

    public void removeCriterion(Criterion<V, T> criterion) {
        this.iCriteria.remove(criterion.getClass().getName());
        criterion.setModel(null);
        this.removeModelListener(criterion);
    }

    public void removeCriterion(Class<? extends Criterion<V, T>> criterion) {
        Criterion<V, T> c = this.iCriteria.remove(criterion.getName());
        if (c != null) {
            this.removeModelListener(c);
        }
    }

    public Criterion<V, T> getCriterion(Class<? extends Criterion<V, T>> criterion) {
        return this.iCriteria.get(criterion.getName());
    }

    public Collection<Criterion<V, T>> getCriteria() {
        return this.iCriteria.values();
    }

    public void weaken(Assignment<V, T> assignment, T value) {
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            if (!(constraint instanceof WeakeningConstraint)) continue;
            ((WeakeningConstraint)((Object)constraint)).weaken(assignment, value);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            if (!(globalConstraint instanceof WeakeningConstraint)) continue;
            ((WeakeningConstraint)((Object)globalConstraint)).weaken(assignment, value);
        }
    }

    public synchronized <C extends AssignmentContext> AssignmentContextReference<V, T, C> createReference(HasAssignmentContext<V, T, C> parent) {
        AssignmentContextReference<V, T, C> ref = new AssignmentContextReference<V, T, C>(parent, this.iNextReferenceId);
        this.iAssignmentContextReferences.put(this.iNextReferenceId, ref);
        ++this.iNextReferenceId;
        return ref;
    }

    public synchronized void clearAssignmentContexts(Assignment<V, T> assignment) {
        for (AssignmentContextReference<V, T, ? extends AssignmentContext> assignmentContextReference : this.iAssignmentContextReferences.values()) {
            assignment.clearContext(assignmentContextReference);
        }
    }

    public synchronized <C extends AssignmentContext> AssignmentContextReference<V, T, C> removeReference(HasAssignmentContext<V, T, C> parent) {
        AssignmentContextReference<V, T, C> reference = parent.getAssignmentContextReference();
        if (reference != null) {
            return this.iAssignmentContextReferences.remove(reference.getIndex());
        }
        return null;
    }

    public synchronized void createAssignmentContexts(Assignment<V, T> assignment, boolean clear) {
        for (AssignmentContextReference<V, T, ? extends AssignmentContext> assignmentContextReference : this.iAssignmentContextReferences.values()) {
            if (clear) {
                assignment.clearContext(assignmentContextReference);
            }
            assignment.getAssignmentContext(assignmentContextReference);
        }
    }

    @Deprecated
    public Assignment<V, T> getDefaultAssignment() {
        if (this.iAssignment == null) {
            this.iAssignment = new DefaultSingleAssignment();
        }
        return this.iAssignment;
    }

    @Deprecated
    public void setDefaultAssignment(Assignment<V, T> assignment) {
        this.iAssignment = assignment;
    }

    public Assignment<V, T> getEmptyAssignment() {
        if (this.iEmptyAssignment == null) {
            this.iEmptyAssignment = new EmptyAssignment();
        }
        return this.iEmptyAssignment;
    }

    public InheritedAssignment<V, T> createInheritedAssignment(Solution<V, T> solution, int index) {
        return new DefaultInheritedAssignment<V, T>(solution, index);
    }
}

