/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.VCalAlarmPropertyScribe;
import biweekly.property.AudioAlarm;
import biweekly.util.org.apache.commons.codec.binary.Base64;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioAlarmScribe
extends VCalAlarmPropertyScribe<AudioAlarm> {
    public AudioAlarmScribe() {
        super(AudioAlarm.class, "AALARM");
    }

    @Override
    protected ICalDataType _dataType(AudioAlarm property, ICalVersion version) {
        if (property.getUri() != null) {
            return ICalDataType.URL;
        }
        if (property.getData() != null) {
            return ICalDataType.BINARY;
        }
        if (property.getContentId() != null) {
            return ICalDataType.CONTENT_ID;
        }
        return null;
    }

    @Override
    protected List<String> writeData(AudioAlarm property) {
        String uri = property.getUri();
        if (uri != null) {
            return Arrays.asList(uri);
        }
        byte[] data = property.getData();
        if (data != null) {
            String base64Str = Base64.encodeBase64String(data);
            return Arrays.asList(base64Str);
        }
        String contentId = property.getContentId();
        if (contentId != null) {
            return Arrays.asList(contentId);
        }
        return Arrays.asList(new Object[0]);
    }

    @Override
    protected AudioAlarm create(ICalDataType dataType, ICalPropertyScribe.SemiStructuredIterator it) {
        AudioAlarm aalarm = new AudioAlarm();
        String next = it.next();
        if (next == null) {
            return aalarm;
        }
        if (dataType == ICalDataType.BINARY) {
            byte[] data = Base64.decodeBase64(next);
            aalarm.setData(data);
        } else if (dataType == ICalDataType.URL) {
            aalarm.setUri(next);
        } else if (dataType == ICalDataType.CONTENT_ID) {
            aalarm.setContentId(next);
        } else {
            aalarm.setUri(next);
        }
        return aalarm;
    }
}

