/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.property.Attachment;
import biweekly.util.org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentScribe
extends ICalPropertyScribe<Attachment> {
    public AttachmentScribe() {
        super(Attachment.class, "ATTACH", ICalDataType.URI);
    }

    @Override
    protected ICalParameters _prepareParameters(Attachment property, WriteContext context) {
        ICalParameters copy = new ICalParameters(property.getParameters());
        if (property.getUri() != null) {
            copy.setEncoding(null);
        } else if (property.getData() != null) {
            copy.setEncoding(Encoding.BASE64);
        }
        return copy;
    }

    @Override
    protected ICalDataType _dataType(Attachment property, ICalVersion version) {
        if (property.getUri() != null) {
            return version == ICalVersion.V1_0 ? ICalDataType.URL : ICalDataType.URI;
        }
        if (property.getData() != null) {
            return ICalDataType.BINARY;
        }
        if (property.getContentId() != null) {
            return version == ICalVersion.V1_0 ? ICalDataType.CONTENT_ID : ICalDataType.URI;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected String _writeText(Attachment property, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        byte[] data = property.getData();
        if (data != null) {
            return Base64.encodeBase64String(data);
        }
        String contentId = property.getContentId();
        if (contentId != null) {
            return context.getVersion() == ICalVersion.V1_0 ? contentId : "CID:" + contentId;
        }
        return "";
    }

    @Override
    protected Attachment _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = AttachmentScribe.unescape(value);
        if (dataType == ICalDataType.BINARY || parameters.getEncoding() == Encoding.BASE64) {
            return new Attachment(null, Base64.decodeBase64(value));
        }
        return new Attachment(null, value);
    }

    @Override
    protected void _writeXml(Attachment property, XCalElement element, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            element.append(ICalDataType.URI, uri);
            return;
        }
        byte[] data = property.getData();
        if (data != null) {
            element.append(ICalDataType.BINARY, Base64.encodeBase64String(data));
            return;
        }
        element.append(this.defaultDataType(context.getVersion()), "");
    }

    @Override
    protected Attachment _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String uri = element.first(ICalDataType.URI);
        if (uri != null) {
            return new Attachment(null, uri);
        }
        String base64Data = element.first(ICalDataType.BINARY);
        if (base64Data != null) {
            return new Attachment(null, Base64.decodeBase64(base64Data));
        }
        throw AttachmentScribe.missingXmlElements(ICalDataType.URI, ICalDataType.BINARY);
    }

    @Override
    protected JCalValue _writeJson(Attachment property, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            return JCalValue.single(uri);
        }
        byte[] data = property.getData();
        if (data != null) {
            return JCalValue.single(Base64.encodeBase64String(data));
        }
        return JCalValue.single("");
    }

    @Override
    protected Attachment _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        if (dataType == ICalDataType.BINARY) {
            return new Attachment(null, Base64.decodeBase64(valueStr));
        }
        return new Attachment(null, valueStr);
    }
}

