/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.parameter.FreeBusyType;
import biweekly.property.Attendee;
import biweekly.property.Comment;
import biweekly.property.Contact;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.DateTimeStamp;
import biweekly.property.FreeBusy;
import biweekly.property.Organizer;
import biweekly.property.RequestStatus;
import biweekly.property.Uid;
import biweekly.property.Url;
import biweekly.property.ValuedProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFreeBusy
extends ICalComponent {
    public VFreeBusy() {
        this.setUid(Uid.random());
        this.setDateTimeStamp(new Date());
    }

    public Uid getUid() {
        return this.getProperty(Uid.class);
    }

    public void setUid(Uid uid) {
        this.setProperty(Uid.class, uid);
    }

    public Uid setUid(String uid) {
        Uid prop = uid == null ? null : new Uid(uid);
        this.setUid(prop);
        return prop;
    }

    public DateTimeStamp getDateTimeStamp() {
        return this.getProperty(DateTimeStamp.class);
    }

    public void setDateTimeStamp(DateTimeStamp dateTimeStamp) {
        this.setProperty(DateTimeStamp.class, dateTimeStamp);
    }

    public DateTimeStamp setDateTimeStamp(Date dateTimeStamp) {
        DateTimeStamp prop = dateTimeStamp == null ? null : new DateTimeStamp(dateTimeStamp);
        this.setDateTimeStamp(prop);
        return prop;
    }

    public Contact getContact() {
        return this.getProperty(Contact.class);
    }

    public void setContact(Contact contact) {
        this.setProperty(Contact.class, contact);
    }

    public Contact addContact(String contact) {
        Contact prop = new Contact(contact);
        this.setContact(prop);
        return prop;
    }

    public DateStart getDateStart() {
        return this.getProperty(DateStart.class);
    }

    public void setDateStart(DateStart dateStart) {
        this.setProperty(DateStart.class, dateStart);
    }

    public DateStart setDateStart(Date dateStart) {
        DateStart prop = dateStart == null ? null : new DateStart(dateStart);
        this.setDateStart(prop);
        return prop;
    }

    public DateEnd getDateEnd() {
        return this.getProperty(DateEnd.class);
    }

    public void setDateEnd(DateEnd dateEnd) {
        this.setProperty(DateEnd.class, dateEnd);
    }

    public DateEnd setDateEnd(Date dateEnd) {
        DateEnd prop = dateEnd == null ? null : new DateEnd(dateEnd);
        this.setDateEnd(prop);
        return prop;
    }

    public Organizer getOrganizer() {
        return this.getProperty(Organizer.class);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(Organizer.class, organizer);
    }

    public Organizer setOrganizer(String email) {
        Organizer prop = email == null ? null : new Organizer(null, email);
        this.setOrganizer(prop);
        return prop;
    }

    public Url getUrl() {
        return this.getProperty(Url.class);
    }

    public void setUrl(Url url) {
        this.setProperty(Url.class, url);
    }

    public Url setUrl(String url) {
        Url prop = url == null ? null : new Url(url);
        this.setUrl(prop);
        return prop;
    }

    public List<Attendee> getAttendees() {
        return this.getProperties(Attendee.class);
    }

    public void addAttendee(Attendee attendee) {
        this.addProperty(attendee);
    }

    public List<Comment> getComments() {
        return this.getProperties(Comment.class);
    }

    public void addComment(Comment comment) {
        this.addProperty(comment);
    }

    public Comment addComment(String comment) {
        Comment prop = new Comment(comment);
        this.addComment(prop);
        return prop;
    }

    public List<FreeBusy> getFreeBusy() {
        return this.getProperties(FreeBusy.class);
    }

    public void addFreeBusy(FreeBusy freeBusy) {
        this.addProperty(freeBusy);
    }

    public FreeBusy addFreeBusy(FreeBusyType type, Date start, Date end) {
        FreeBusy found = this.findByFbType(type);
        found.addValue(start, end);
        return found;
    }

    public FreeBusy addFreeBusy(FreeBusyType type, Date start, Duration duration) {
        FreeBusy found = this.findByFbType(type);
        found.addValue(start, duration);
        return found;
    }

    private FreeBusy findByFbType(FreeBusyType type) {
        FreeBusy found = null;
        for (FreeBusy fb : this.getFreeBusy()) {
            if (fb.getType() != type) continue;
            found = fb;
            break;
        }
        if (found == null) {
            found = new FreeBusy();
            found.setType(type);
            this.addFreeBusy(found);
        }
        return found;
    }

    public RequestStatus getRequestStatus() {
        return this.getProperty(RequestStatus.class);
    }

    public void setRequestStatus(RequestStatus requestStatus) {
        this.setProperty(RequestStatus.class, requestStatus);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        if (version == ICalVersion.V1_0) {
            warnings.add(Warning.validate(48, new Object[]{version}));
        }
        this.checkRequiredCardinality(warnings, Uid.class, DateTimeStamp.class);
        this.checkOptionalCardinality(warnings, Contact.class, DateStart.class, DateEnd.class, Organizer.class, Url.class);
        ICalDate dateStart = ValuedProperty.getValue(this.getDateStart());
        ICalDate dateEnd = ValuedProperty.getValue(this.getDateEnd());
        if (dateEnd != null && dateStart == null) {
            warnings.add(Warning.validate(15, new Object[0]));
        }
        if (dateStart != null && !dateStart.hasTime()) {
            warnings.add(Warning.validate(20, DateStart.class.getSimpleName()));
        }
        if (dateEnd != null && !dateEnd.hasTime()) {
            warnings.add(Warning.validate(20, DateEnd.class.getSimpleName()));
        }
        if (dateStart != null && dateEnd != null && dateStart.compareTo(dateEnd) >= 0) {
            warnings.add(Warning.validate(16, new Object[0]));
        }
    }
}

