/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.MoreSpaceThanExpected;
import org.cpsolver.studentsct.weights.EqualStudentWeights;
import org.cpsolver.studentsct.weights.PriorityStudentWeights;
import org.cpsolver.studentsct.weights.StudentWeights;

public class StudentSchedulingAssistantWeights
implements StudentWeights {
    private double iNoTimeFactor = 0.05;
    private double iSelectionFactor = 0.125;
    private double iOverExpectedFactor = 0.25;
    private double iAvailabilityFactor = 0.05;
    private double iPenaltyFactor = 0.001;
    private Hashtable<CourseRequest, double[]> iCache = new Hashtable();
    private boolean iPriorityWeighting = true;
    private StudentWeights iParent;

    public StudentSchedulingAssistantWeights(DataProperties properties) {
        this.iNoTimeFactor = properties.getPropertyDouble("StudentWeights.NoTimeFactor", this.iNoTimeFactor);
        this.iSelectionFactor = properties.getPropertyDouble("StudentWeights.SelectionFactor", this.iSelectionFactor);
        this.iOverExpectedFactor = properties.getPropertyDouble("StudentWeights.PenaltyFactor", this.iOverExpectedFactor);
        this.iPenaltyFactor = properties.getPropertyDouble("StudentWeights.AvgPenaltyFactor", this.iPenaltyFactor);
        this.iAvailabilityFactor = properties.getPropertyDouble("StudentWeights.AvailabilityFactor", this.iAvailabilityFactor);
        this.iPriorityWeighting = properties.getPropertyBoolean("StudentWeights.PriorityWeighting", this.iPriorityWeighting);
        this.iParent = this.iPriorityWeighting ? new PriorityStudentWeights(properties) : new EqualStudentWeights(properties);
    }

    public void clearBestCache() {
        this.iCache.clear();
    }

    private double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        if (request.getModel() == null || !(request.getModel() instanceof OnlineSectioningModel)) {
            return new MoreSpaceThanExpected().getOverExpected(assignment, section, request);
        }
        return ((OnlineSectioningModel)request.getModel()).getOverExpected(assignment, section, request);
    }

    private double[] best(Assignment<Request, Enrollment> assignment, CourseRequest cr) {
        double[] cached = this.iCache.get(cr);
        if (cached != null) {
            return cached;
        }
        double bestTime = 0.0;
        Double bestOverExpected = null;
        Double bestAvgPenalty = null;
        double bestSelected = 0.0;
        for (Course course : cr.getCourses()) {
            for (Config config : course.getOffering().getConfigs()) {
                int size = config.getSubparts().size();
                double sectionsWithTime = 0.0;
                double overExpected = 0.0;
                double penalty = 0.0;
                double selectedSections = 0.0;
                for (Subpart subpart : config.getSubparts()) {
                    boolean hasTime = false;
                    Double sectionPenalty = null;
                    Double sectionOverExpected = null;
                    boolean hasSelection = false;
                    for (Section section : subpart.getSections()) {
                        if (section.getLimit() == 0) continue;
                        if (section.getTime() != null) {
                            hasTime = true;
                        }
                        if (!cr.getSelectedChoices().isEmpty() && cr.isSelected(section)) {
                            hasSelection = true;
                        }
                        if (sectionPenalty == null || sectionPenalty > section.getPenalty()) {
                            sectionPenalty = section.getPenalty();
                        }
                        double oexp = this.getOverExpected(assignment, section, cr);
                        if (sectionOverExpected != null && !(sectionOverExpected > oexp)) continue;
                        sectionOverExpected = oexp;
                    }
                    if (hasTime) {
                        sectionsWithTime += 1.0;
                    }
                    if (sectionPenalty != null) {
                        penalty += sectionPenalty.doubleValue();
                    }
                    if (hasSelection) {
                        selectedSections += 1.0;
                    }
                    if (sectionOverExpected == null) continue;
                    overExpected += sectionOverExpected.doubleValue();
                }
                if (sectionsWithTime / (double)size > bestTime) {
                    bestTime = sectionsWithTime / (double)size;
                }
                if (bestOverExpected == null || overExpected < bestOverExpected) {
                    bestOverExpected = overExpected;
                }
                if (bestAvgPenalty == null || penalty / (double)size < bestAvgPenalty) {
                    bestAvgPenalty = penalty / (double)size;
                }
                if (!(selectedSections / (double)size > bestSelected)) continue;
                bestSelected = selectedSections / (double)size;
            }
        }
        cached = new double[]{bestTime, bestOverExpected == null ? 0.0 : bestOverExpected, bestAvgPenalty == null ? 0.0 : bestAvgPenalty, bestSelected};
        this.iCache.put(cr, cached);
        return cached;
    }

    public double getBaseWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        return this.iParent.getWeight(assignment, enrollment);
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        double base;
        if (!enrollment.isCourseRequest()) {
            return this.getBaseWeight(assignment, enrollment);
        }
        if (enrollment.getAssignments().isEmpty()) {
            return 0.0;
        }
        double weight = base = this.getBaseWeight(assignment, enrollment);
        int size = enrollment.getAssignments().size();
        CourseRequest cr = (CourseRequest)enrollment.getRequest();
        double[] best = this.best(assignment, cr);
        double hasTime = 0.0;
        double oexp = 0.0;
        double penalty = 0.0;
        for (Section section : enrollment.getSections()) {
            if (section.getTime() != null) {
                hasTime += 1.0;
            }
            oexp += this.getOverExpected(assignment, section, cr);
            penalty += section.getPenalty();
        }
        double noTime = best[0] - hasTime / (double)size;
        double overExpected = oexp - best[1];
        double avgPenalty = penalty / (double)size - best[2];
        double nrSelected = 0.0;
        if (!cr.getSelectedChoices().isEmpty()) {
            for (Section section : enrollment.getSections()) {
                if (!cr.isSelected(section)) continue;
                nrSelected += 1.0;
            }
        }
        double unselectedFraction = best[3] - nrSelected / (double)size;
        double unavailableSize = 0.0;
        double altSectionsWithLimit = 0.0;
        for (Section section : enrollment.getSections()) {
            Subpart subpart = section.getSubpart();
            if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
            double averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
            if ((double)section.getLimit() < averageSize) {
                unavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
            }
            altSectionsWithLimit += 1.0;
        }
        double unavailableSizeFraction = unavailableSize > 0.0 ? unavailableSize / altSectionsWithLimit : 0.0;
        weight -= overExpected * base * this.iOverExpectedFactor;
        weight -= unselectedFraction * base * this.iSelectionFactor;
        weight -= noTime * base * this.iNoTimeFactor;
        weight -= unavailableSizeFraction * base * this.iAvailabilityFactor;
        return this.round(weight -= avgPenalty * this.iPenaltyFactor);
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        if (enrollment.getAssignments().isEmpty()) {
            return 0.0;
        }
        double weight = this.getWeight(assignment, enrollment);
        if (distanceConflicts != null) {
            for (DistanceConflict.Conflict conflict : distanceConflicts) {
                Enrollment other = conflict.getE1().equals(enrollment) ? conflict.getE2() : conflict.getE1();
                if (other.getRequest().getPriority() > enrollment.getRequest().getPriority()) continue;
                weight -= this.getDistanceConflictWeight(assignment, conflict);
            }
        }
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict conflict : timeOverlappingConflicts) {
                weight -= this.getTimeOverlapConflictWeight(assignment, enrollment, conflict);
            }
        }
        return weight;
    }

    protected double round(double value) {
        return Math.ceil(10000.0 * value) / 10000.0;
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        return this.iParent.isBetterThanBestSolution(currentSolution);
    }

    @Override
    public double getBound(Request request) {
        return this.iParent.getBound(request);
    }

    @Override
    public double getDistanceConflictWeight(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict distanceConflict) {
        return this.iParent.getDistanceConflictWeight(assignment, distanceConflict);
    }

    @Override
    public double getTimeOverlapConflictWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, TimeOverlapsCounter.Conflict timeOverlap) {
        return this.iParent.getTimeOverlapConflictWeight(assignment, enrollment, timeOverlap);
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return this.iParent.isFreeTimeAllowOverlaps();
    }
}

