/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSolverInfo;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.timegrid.SolutionGridModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridCell;
import org.unitime.timetable.webutil.timegrid.TimetableGridContext;
import org.unitime.timetable.webutil.timegrid.TimetableGridModel;

public class TimetableGridTable {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
    protected static Formats.Format<Number> sUtF = Formats.getNumberFormat("0.00");
    public static final int sDaysAll = 0;
    public static final int sDaysAllExceptSat = 1;
    public static final int sDaysMon = 2;
    public static final int sDaysTue = 3;
    public static final int sDaysWed = 4;
    public static final int sDaysThu = 5;
    public static final int sDaysFri = 6;
    public static final int sDaysSat = 7;
    public static final int sDaysSun = 8;
    public static final int sDaysMonThu = 9;
    public static final int sDaysFriSat = 10;
    public static final int sDaysMWF = 11;
    public static final int sDaysTTh = 12;
    public static String[] sDays = new String[]{"All", "All except Weekend", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Monday - Thursday", "Friday & Saturday", "Monday, Wednesday, Friday", "Tuesday, Thursday"};
    public static final int sDispModeInRow = 0;
    public static final int sDispModePerWeekHorizontal = 1;
    public static final int sDispModePerWeekVertical = 2;
    public static final int sDispModeWeekByWeekHorizontal = 3;
    public static String[] sDispModes = new String[]{"In Row [horizontal]", "Per Week [horizontal]", "Per Week [vertical]", "Per Date [horizontal]"};
    public static final int sOrderByNameAsc = 0;
    public static final int sOrderByNameDesc = 1;
    public static final int sOrderBySizeAsc = 2;
    public static final int sOrderBySizeDesc = 3;
    public static final int sOrderByTypeAsc = 4;
    public static final int sOrderByTypeDesc = 5;
    public static final int sOrderByUtilizationAsc = 6;
    public static final int sOrderByUtilizationDesc = 7;
    public static String[] sOrderBy = new String[]{"Name [asc]", "Name [desc]", "Size [asc]", "Size [desc]", "Type [asc]", "Type [desc]", "Utilization [asc]", "Utilization [desc]"};
    private int iDays = 1;
    public static final int sDayModeDay = 0;
    public static final int sDayModeEvening = 1;
    public static final int sDayModeDayEvening = 2;
    public static final int sDayModeAll = 3;
    public static String[] sDayMode = new String[]{"Daytime", "Evening", "Daytime & Evening", "All"};
    private int iDayMode = 0;
    private int iDispMode = 1;
    private int iBgMode = 0;
    Vector iModels = new Vector();
    private int iResourceType = 0;
    private String iFindStr = null;
    private int iOrderBy = 0;
    private int iWeek = -100;
    private boolean iShowUselessTimes = false;
    private boolean iShowInstructors = false;
    private boolean iShowEvents = false;
    private boolean iShowComments = false;
    private boolean iShowTimes = false;
    private Query iQuery = null;
    private int iNrSlotsPerPeriod = -1;
    private String iDefaultDatePatternName = null;
    protected Date iFirstDate = null;
    protected int iFirstDay = 0;

    public Vector models() {
        return this.iModels;
    }

    public void setDays(int days) {
        this.iDays = days;
    }

    public int getDays() {
        return this.iDays;
    }

    public void setDayMode(int dayMode) {
        this.iDayMode = dayMode;
    }

    public int getDayMode() {
        return this.iDayMode;
    }

    public void setDispMode(int dispMode) {
        this.iDispMode = dispMode;
    }

    public int getDispMode() {
        return this.iDispMode;
    }

    public void setBgMode(int bgMode) {
        this.iBgMode = bgMode;
    }

    public int getBgMode() {
        return this.iBgMode;
    }

    public int getResourceType() {
        return this.iResourceType;
    }

    public boolean isDepartmentalResourceType() {
        return this.iResourceType == 2 || this.iResourceType == 4;
    }

    public void setResourceType(int resourceType) {
        this.iResourceType = resourceType;
    }

    public String getFindString() {
        return this.iFindStr;
    }

    public void setFindString(String findSrt) {
        this.iFindStr = findSrt;
        this.iQuery = findSrt == null ? null : new Query(findSrt);
    }

    public int getOrderBy() {
        return this.iOrderBy;
    }

    public void setOrderBy(int orderBy) {
        this.iOrderBy = orderBy;
    }

    public int getWeek() {
        return this.iWeek;
    }

    public void setWeek(int week) {
        this.iWeek = week;
    }

    public boolean getShowUselessTimes() {
        return this.iShowUselessTimes;
    }

    public void setShowUselessTimes(boolean showUselessTimes) {
        this.iShowUselessTimes = showUselessTimes;
    }

    public boolean getShowInstructors() {
        return this.iShowInstructors;
    }

    public void setShowInstructors(boolean showInstructors) {
        this.iShowInstructors = showInstructors;
    }

    public boolean getShowTimes() {
        return this.iShowTimes;
    }

    public void setShowTimes(boolean showTimes) {
        this.iShowTimes = showTimes;
    }

    public boolean getShowComments() {
        return this.iShowComments;
    }

    public void setShowComments(boolean showComments) {
        this.iShowComments = showComments;
    }

    public boolean getShowEvents() {
        return this.iShowEvents;
    }

    public void setShowEvents(boolean showEvents) {
        this.iShowEvents = showEvents;
    }

    public Vector getWeeks(SessionContext context) throws Exception {
        Vector<SolverPredefinedSetting.IdValue> weeks = new Vector<SolverPredefinedSetting.IdValue>();
        weeks.addElement(new SolverPredefinedSetting.IdValue(new Long(-100L), "All weeks"));
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        int startWeek = DateUtils.getWeek(session.getSessionBeginDateTime()) - ApplicationProperty.SessionNrExcessDays.intValue() / 7;
        Calendar endCal = Calendar.getInstance(Locale.US);
        endCal.setTime(session.getSessionEndDateTime());
        endCal.add(6, ApplicationProperty.SessionNrExcessDays.intValue());
        int week = startWeek;
        this.iFirstDate = DateUtils.getStartDate(session.getSessionStartYear(), startWeek);
        this.iFirstDay = DateUtils.getFirstDayOfWeek(session.getSessionStartYear(), startWeek) - session.getDayOfYear(1, session.getPatternStartMonth()) - 1;
        while (DateUtils.getStartDate(session.getSessionStartYear(), week).compareTo(endCal.getTime()) <= 0) {
            weeks.addElement(new SolverPredefinedSetting.IdValue(new Long(week), sDF.format(DateUtils.getStartDate(session.getSessionStartYear(), week)) + " - " + sDF.format(DateUtils.getEndDate(session.getSessionStartYear(), week))));
            ++week;
        }
        if (this.iWeek < startWeek || this.iWeek >= week) {
            this.iWeek = -100;
        }
        return weeks;
    }

    public void load(UserContext user) {
        this.setDays(Integer.parseInt(user.getProperty("TimetableGridTable.days", String.valueOf(this.getDays()))));
        this.setDayMode(Integer.parseInt(user.getProperty("TimetableGridTable.dayMode", String.valueOf(this.getDayMode()))));
        this.setBgMode(Integer.parseInt(user.getProperty("TimetableGridTable.bgMode", String.valueOf(this.getBgMode()))));
        this.setFindString(user.getProperty("TimetableGridTable.findString", this.getFindString()));
        this.setOrderBy(Integer.parseInt(user.getProperty("TimetableGridTable.orderBy", String.valueOf(this.getOrderBy()))));
        this.setDispMode(Integer.parseInt(user.getProperty("TimetableGridTable.dispMode", String.valueOf(this.getDispMode()))));
        this.setResourceType(Integer.parseInt(user.getProperty("TimetableGridTable.resourceType", String.valueOf(this.getResourceType()))));
        this.setShowUselessTimes("1".equals(user.getProperty("TimetableGridTable.showUselessTimes", this.getShowUselessTimes() ? "1" : "0")));
        this.setWeek(Integer.parseInt(user.getProperty("TimetableGridTable.week", String.valueOf(this.getWeek()))));
        this.setShowInstructors("1".equals(user.getProperty("TimetableGridTable.showInstructors", this.getShowInstructors() ? "1" : "0")));
        this.setShowComments("1".equals(user.getProperty("TimetableGridTable.showComments", this.getShowComments() ? "1" : "0")));
        this.setShowEvents("1".equals(user.getProperty("TimetableGridTable.showEvets", this.getShowEvents() ? "1" : "0")));
        this.setShowTimes("1".equals(user.getProperty("TimetableGridTable.showTimes", this.getShowTimes() ? "1" : "0")));
    }

    public void save(UserContext user) {
        user.setProperty("TimetableGridTable.days", String.valueOf(this.getDays()));
        user.setProperty("TimetableGridTable.dayMode", String.valueOf(this.getDayMode()));
        user.setProperty("TimetableGridTable.bgMode", String.valueOf(this.getBgMode()));
        user.setProperty("TimetableGridTable.findString", this.getFindString());
        user.setProperty("TimetableGridTable.orderBy", String.valueOf(this.getOrderBy()));
        user.setProperty("TimetableGridTable.dispMode", String.valueOf(this.getDispMode()));
        user.setProperty("TimetableGridTable.resourceType", String.valueOf(this.getResourceType()));
        user.setProperty("TimetableGridTable.showUselessTimes", this.getShowUselessTimes() ? "1" : "0");
        user.setProperty("TimetableGridTable.week", String.valueOf(this.getWeek()));
        user.setProperty("TimetableGridTable.showInstructors", this.getShowInstructors() ? "1" : "0");
        user.setProperty("TimetableGridTable.showComments", this.getShowComments() ? "1" : "0");
        user.setProperty("TimetableGridTable.showEvets", this.getShowEvents() ? "1" : "0");
        user.setProperty("TimetableGridTable.showTimes", this.getShowTimes() ? "1" : "0");
    }

    public void printToHtml(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printToHtml(out);
        out.flush();
    }

    public void printToHtml(PrintWriter out) {
        out.println("<table border='0' cellpadding='2' cellspacing='0'>");
        int rowNumber = 0;
        Enumeration e = this.models().elements();
        while (e.hasMoreElements()) {
            this.printToHtml(out, (TimetableGridModel)e.nextElement(), rowNumber);
            ++rowNumber;
        }
        out.println("</table>");
    }

    public boolean isDispModePerWeekVertical() {
        return this.iDispMode == 2;
    }

    public boolean isDispModePerWeekHorizontal() {
        return this.iDispMode == 1;
    }

    public boolean isDispModePerWeek() {
        return this.isDispModePerWeekHorizontal() || this.isDispModePerWeekVertical() || this.isDispModeWeekByWeekHorizontal();
    }

    public boolean isDispModeInRow() {
        return this.iDispMode == 0;
    }

    public boolean isDispModeWeekByWeekHorizontal() {
        return this.iDispMode == 3;
    }

    public int startDay() {
        switch (this.iDays) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 0;
            }
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    public int endDay() {
        switch (this.iDays) {
            case 0: {
                return 6;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 3;
            }
        }
        return 4;
    }

    public boolean skipDay(int day) {
        switch (this.iDays) {
            case 11: {
                return day == 1 || day == 3;
            }
            case 12: {
                return day == 2;
            }
        }
        return false;
    }

    public int nrDays() {
        switch (this.iDays) {
            case 11: {
                return 3;
            }
            case 12: {
                return 2;
            }
        }
        return this.endDay() - this.startDay() + 1;
    }

    public int nrSlotsPerPeriod() {
        if (this.iNrSlotsPerPeriod < 0) {
            this.iNrSlotsPerPeriod = ApplicationProperty.TimetableGridSlotsPerPeriod.intValue();
        }
        return this.iNrSlotsPerPeriod;
    }

    public int firstSlot() {
        switch (this.iDayMode) {
            case 0: 
            case 2: {
                return ApplicationProperty.TimetableGridFirstDaySlot.intValue();
            }
            case 1: {
                return ApplicationProperty.TimetableGridLastDaySlot.intValue() + 1;
            }
        }
        return 0;
    }

    public int lastSlot() {
        switch (this.iDayMode) {
            case 0: {
                return ApplicationProperty.TimetableGridLastDaySlot.intValue();
            }
            case 1: 
            case 2: {
                return ApplicationProperty.TimetableGridLastEveningSlot.intValue();
            }
        }
        return 287;
    }

    public void printHeader(PrintWriter out, TimetableGridModel model, int rowNumber) {
        String sfx2 = "";
        if (this.isDispModePerWeekVertical()) {
            sfx2 = sfx2 + "Vertical";
        }
        out.println("<tr valign='top'>");
        out.println("<th class='Timetable" + (rowNumber == 0 ? "Head" : "") + "Cell" + sfx2 + "' " + (this.getResourceType() == 0 ? "onmouseover=\"showGwtRoomHint(this, '" + model.getResourceId() + "');\" onmouseout=\"hideGwtRoomHint();\"" : "") + ">");
        if (this.isDispModePerWeek()) {
            out.println(model.getName());
            if (this.getResourceType() == 0) {
                out.println("<div style='white-space:nowrap;' title='capacity " + model.getSize() + " seats, utilization " + sUtF.format(model.getUtilization() / (double)this.nrSlotsPerPeriod()) + " periods'  >(" + model.getSize() + ", " + sUtF.format(model.getUtilization() / (double)this.nrSlotsPerPeriod()) + ")</div>");
            } else if (this.getResourceType() == 3) {
                out.println("<span style='white-space:nowrap;' title='" + model.getSize() + " students'  >(" + model.getSize() + ")</span>");
            } else if (model.getResourceType() == 5) {
                out.println("<div style='white-space:nowrap;' title='capacity " + model.getSize() + " seats, same class " + sUtF.format(100.0 * model.getUtilization()) + "%'  >(" + model.getSize() + ", " + sUtF.format(100.0 * model.getUtilization()) + "%)</div>");
            } else if (model.getSize() > 0) {
                out.println("<span style='white-space:nowrap;' title='" + model.getSize() + " classes'  >(" + model.getSize() + ")</span>");
            }
        }
        out.println("</th>");
        if (this.isDispModePerWeekVertical()) {
            for (int day = this.startDay(); day <= this.endDay(); ++day) {
                if (this.skipDay(day)) continue;
                boolean eol = day == this.endDay();
                out.println("<th colspan='" + (1 + model.getMaxIdxForDay(day, this.firstSlot(), this.lastSlot())) + "'class='TimetableHeadCellVertical" + (eol ? "EOL" : "") + "'>");
                out.println(CONSTANTS.days()[day]);
                out.println("</th>");
            }
        } else {
            for (int day = this.startDay(); this.isDispModeInRow() && day <= this.endDay() || this.isDispModePerWeek() && day == this.startDay(); ++day) {
                if (this.skipDay(day)) continue;
                for (int slot = this.firstSlot(); slot <= this.lastSlot(); slot += this.nrSlotsPerPeriod()) {
                    int time = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                    boolean eod = slot + this.nrSlotsPerPeriod() - 1 == this.lastSlot();
                    boolean eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                    out.println("<th colspan='" + this.nrSlotsPerPeriod() + "' class='Timetable" + (rowNumber == 0 ? "Head" : "") + "Cell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "'>");
                    if (this.isDispModeInRow()) {
                        out.println(CONSTANTS.days()[day] + "<br>");
                    }
                    out.println(Constants.toTime(time));
                    out.println("</th>");
                }
            }
        }
        out.println("</tr>");
    }

    private void getMouseOverAndMouseOut(StringBuffer onMouseOver, StringBuffer onMouseOut, StringBuffer onClick, TimetableGridCell cell, String bgColor) {
        if (cell == null) {
            return;
        }
        onMouseOver.append(" onmouseover=\"");
        onMouseOut.append(" onmouseout=\"");
        if (cell.getAssignmentId() >= 0L) {
            onMouseOver.append("mOvr(" + cell.getAssignmentId() + ");");
            onMouseOut.append("mOut(" + cell.getAssignmentId() + ",'" + (bgColor == null ? "transparent" : bgColor) + "');");
        }
        if (cell.getOnClick() != null && !cell.getOnClick().isEmpty()) {
            onMouseOver.append("mHnd(this);");
            onClick.append(" onclick=\"");
            if (cell.getTitle() != null && !cell.getTitle().isEmpty()) {
                onClick.append("hideGwtHint();");
            }
            if (cell.getAssignmentId() >= 0L) {
                onClick.append("mOut(" + cell.getAssignmentId() + ",'" + (bgColor == null ? "transparent" : bgColor) + "');");
            }
            onClick.append(cell.getOnClick() + "\"");
        }
        if (cell.getTitle() != null && !cell.getTitle().isEmpty()) {
            onMouseOver.append("showGwtHint(this,'" + cell.getTitle() + "');");
            onMouseOut.append("hideGwtHint();");
        }
        onMouseOver.append("\" ");
        onMouseOut.append("\" ");
    }

    public void printToHtml(PrintWriter out, TimetableGridModel model, int rowNumber) {
        int maxCellWidth = ApplicationProperty.TimetableGridMaxCellWidth.intValue();
        int maxCellWidthVertical = ApplicationProperty.TimetableGridMaxCellWidthVertical.intValue();
        model.clearRendered();
        if (this.isDispModePerWeek() || rowNumber % 10 == 0) {
            this.printHeader(out, model, rowNumber);
        }
        out.println("<tr valign='top'>");
        if (this.isDispModeInRow()) {
            int maxIdx = model.getMaxIdx(this.startDay(), this.endDay(), this.firstSlot(), this.lastSlot());
            out.println("<th rowspan='" + (1 + maxIdx) + "' class='Timetable" + (rowNumber % 10 == 0 ? "Head" : "") + "Cell' " + (this.getResourceType() == 0 ? "onmouseover=\"showGwtRoomHint(this, '" + model.getResourceId() + "');\" onmouseout=\"hideGwtRoomHint();\"" : "") + ">");
            out.println(model.getName());
            if (this.getResourceType() == 0) {
                out.println("<div style='white-space:nowrap;' title='capacity " + model.getSize() + " seats, utilization " + sUtF.format(model.getUtilization() / (double)this.nrSlotsPerPeriod()) + " periods'  >(" + model.getSize() + ", " + sUtF.format(model.getUtilization() / (double)this.nrSlotsPerPeriod()) + ")</div>");
            } else if (this.getResourceType() == 3) {
                out.println("<span style='white-space:nowrap;' title='" + model.getSize() + " students'  >(" + model.getSize() + ")</span>");
            }
            if (this.getResourceType() == 5) {
                out.println("<div style='white-space:nowrap;' title='capacity " + model.getSize() + " seats, same class " + sUtF.format(100.0 * model.getUtilization()) + "%'  >(" + model.getSize() + ", " + sUtF.format(100.0 * model.getUtilization()) + "%)</div>");
            } else if (model.getSize() > 0) {
                out.println("<span style='white-space:nowrap;' title='" + model.getSize() + " classes'  >(" + model.getSize() + ")</span>");
            }
            out.println("</th>");
            for (int idx = 0; idx <= maxIdx; ++idx) {
                if (idx > 0) {
                    out.println("</tr><tr valign='top'>");
                }
                for (int day = this.startDay(); day <= this.endDay(); ++day) {
                    if (this.skipDay(day)) continue;
                    for (int slot = this.firstSlot(); slot <= this.lastSlot(); ++slot) {
                        boolean eol;
                        boolean eod;
                        String bgColor;
                        int slotsToEnd = this.lastSlot() - slot + 1;
                        TimetableGridCell cell = model.getCell(day, slot, idx);
                        if (cell == null && model.isRendered(day, slot, idx)) continue;
                        int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                        int colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        int rowSpan = this.isDepartmentalResourceType() && cell != null ? 1 : model.getDepth(day, slot, idx, maxIdx, colSpan);
                        model.setRendered(day, slot, idx, rowSpan, colSpan);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            eod = slot == this.lastSlot();
                            eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                            boolean first = slot == this.firstSlot() || model.getCell(day, slot - 1, idx) != null;
                            boolean in = !first && !eod && !eol && (model.getCell(day, slot + 1, idx) == null || model.getCell(day, slot - 1, idx) == null) && (slot - this.firstSlot()) % this.nrSlotsPerPeriod() != 0;
                            boolean inEod = eod && model.getCell(day, slot - 1, idx) == null;
                            boolean inEol = eol && model.getCell(day, slot - 1, idx) == null;
                            out.println("<td class='TimetableCell" + (first ? "First" : (in ? "In" : (inEol ? "InEOL" : (inEod ? "InEOD" : (eol ? "EOL" : (eod ? "EOD" : "")))))) + "' rowSpan='" + rowSpan + "' colSpan='" + colSpan + "' " + (bgColor == null ? "" : "style='background-color:" + bgColor + "'") + ">&nbsp;</td>");
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.getBgMode() == 0 && !TimetableGridCell.sBgColorNotAvailable.equals(bgColor)) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        eod = slot + length > this.lastSlot();
                        eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        StringBuffer onClick = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, onClick, cell, bgColor);
                        out.println("<td nowrap style='" + (bgColor == null ? "" : "background-color:" + bgColor) + ";max-width:" + maxCellWidth * colSpan + "px;' " + " class='TimetableCell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "' " + "align='center' " + "colspan='" + colSpan + "' rowSpan='" + rowSpan + "' " + (cell.getAssignmentId() >= 0L ? "name='c" + cell.getAssignmentId() + "' " : "") + onClick + onMouseOver + onMouseOut + ">");
                        out.print(cell.getName());
                        if (this.iShowTimes) {
                            out.print("<BR>" + cell.getTime());
                        }
                        if (this.getResourceType() != 0 && cell.getRoomName() != null) {
                            out.print("<BR>" + cell.getRoomName());
                        }
                        if (this.getResourceType() != 1 && this.iShowInstructors && !cell.getInstructor().isEmpty()) {
                            out.print("<BR>" + cell.getInstructor());
                        }
                        if (this.iShowComments) {
                            out.print(cell.getShortComment() == null ? "" : "<BR>" + cell.getShortComment());
                        }
                        if (this.iWeek == -100 && cell.hasDays() && !cell.getDays().equals(this.iDefaultDatePatternName)) {
                            out.print("<BR>" + cell.getDays());
                        }
                        out.println("</td>");
                        slot += length - 1;
                    }
                }
            }
        } else if (this.isDispModePerWeekHorizontal()) {
            for (int day = this.startDay(); day <= this.endDay(); ++day) {
                if (this.skipDay(day)) continue;
                if (day > this.startDay()) {
                    out.println("</tr><tr valign='top'>");
                }
                int maxIdx = model.getMaxIdxForDay(day, this.firstSlot(), this.lastSlot());
                out.println("<th rowspan='" + (1 + maxIdx) + "' class='TimetableCell'>" + CONSTANTS.days()[day] + "</th>");
                for (int idx = 0; idx <= maxIdx; ++idx) {
                    if (idx > 0) {
                        out.println("</tr><tr valign='top'>");
                    }
                    for (int slot = this.firstSlot(); slot <= this.lastSlot(); ++slot) {
                        boolean eol;
                        boolean eod;
                        String bgColor;
                        int slotsToEnd = this.lastSlot() - slot + 1;
                        TimetableGridCell cell = model.getCell(day, slot, idx);
                        if (cell == null && model.isRendered(day, slot, idx)) continue;
                        int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                        int colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        int rowSpan = this.isDepartmentalResourceType() && cell != null ? 1 : model.getDepth(day, slot, idx, maxIdx, colSpan);
                        model.setRendered(day, slot, idx, rowSpan, colSpan);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            eod = slot == this.lastSlot();
                            eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                            boolean first = slot == this.firstSlot() || model.getCell(day, slot - 1, idx) != null;
                            boolean in = !first && !eod && !eol && (model.getCell(day, slot + 1, idx) == null || model.getCell(day, slot - 1, idx) == null) && (slot - this.firstSlot()) % this.nrSlotsPerPeriod() != 0;
                            boolean inEod = eod && model.getCell(day, slot - 1, idx) == null;
                            boolean inEol = eol && model.getCell(day, slot - 1, idx) == null;
                            out.println("<td class='TimetableCell" + (first ? "First" : (in ? "In" : (inEol ? "InEOL" : (inEod ? "InEOD" : (eol ? "EOL" : (eod ? "EOD" : "")))))) + "' rowSpan='" + rowSpan + "' colSpan='" + colSpan + "' " + (bgColor == null ? "" : "style='background-color:" + bgColor + "'") + ">&nbsp;</td>");
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.getBgMode() == 0 && !TimetableGridCell.sBgColorNotAvailable.equals(bgColor)) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        eod = slot + length > this.lastSlot();
                        eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        StringBuffer onClick = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, onClick, cell, bgColor);
                        out.println("<td nowrap style='" + (bgColor == null ? "" : "background-color:" + bgColor) + ";max-width:" + maxCellWidth * colSpan + "px;' " + " class='TimetableCell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "' " + "align='center' " + "colspan='" + colSpan + "' rowSpan='" + rowSpan + "' " + (cell.getAssignmentId() >= 0L ? "name='c" + cell.getAssignmentId() + "' " : "") + onClick + onMouseOver + onMouseOut + ">");
                        out.print(cell.getName());
                        if (this.iShowTimes) {
                            out.print("<BR>" + cell.getTime());
                        }
                        if (this.getResourceType() != 0 && cell.getRoomName() != null) {
                            out.print("<BR>" + cell.getRoomName());
                        }
                        if (this.getResourceType() != 1 && this.iShowInstructors && !cell.getInstructor().isEmpty()) {
                            out.print("<BR>" + cell.getInstructor());
                        }
                        if (this.iShowComments) {
                            out.print(cell.getShortComment() == null ? "" : "<BR>" + cell.getShortComment());
                        }
                        if (this.iWeek == -100 && cell.hasDays() && !cell.getDays().equals(this.iDefaultDatePatternName)) {
                            out.print("<BR>" + cell.getDays());
                        }
                        out.println("</td>");
                        slot += length - 1;
                    }
                }
            }
        } else if (this.isDispModeWeekByWeekHorizontal()) {
            boolean firstDay = true;
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(this.iFirstDate);
            for (int d = 0; d < 365; ++d) {
                int day;
                if (d > 0) {
                    c.add(6, 1);
                }
                int date = d + this.iFirstDay;
                if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || (day = d % 7) < this.startDay() || day > this.endDay() || this.skipDay(day)) continue;
                boolean hasClasses = false;
                for (int slot = this.firstSlot(); slot <= this.lastSlot(); ++slot) {
                    if (model.getCell(day, slot, 0, date) == null) continue;
                    hasClasses = true;
                    break;
                }
                if (!hasClasses) continue;
                if (firstDay) {
                    firstDay = false;
                } else {
                    out.println("</tr><tr valign='top'>");
                }
                int maxIdx = model.getMaxIdxForDay(day, this.firstSlot(), this.lastSlot(), date);
                out.println("<th rowspan='" + (1 + maxIdx) + "' class='TimetableCell'>" + CONSTANTS.days()[day] + " " + sDF.format(c.getTime()) + "</th>");
                for (int idx = 0; idx <= maxIdx; ++idx) {
                    if (idx > 0) {
                        out.println("</tr><tr valign='top'>");
                    }
                    for (int slot = this.firstSlot(); slot <= this.lastSlot(); ++slot) {
                        boolean eol;
                        boolean eod;
                        String bgColor;
                        int slotsToEnd = this.lastSlot() - slot + 1;
                        TimetableGridCell cell = model.getCell(day, slot, idx, date);
                        if (cell == null && model.isRendered(day, slot, idx, date)) continue;
                        int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                        int colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        int rowSpan = this.isDepartmentalResourceType() && cell != null ? 1 : model.getDepth(day, slot, idx, maxIdx, colSpan, date);
                        model.setRendered(day, slot, idx, rowSpan, colSpan, date);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            eod = slot == this.lastSlot();
                            eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                            boolean first = slot == this.firstSlot() || model.getCell(day, slot - 1, idx, date) != null;
                            boolean in = !first && !eod && !eol && (model.getCell(day, slot + 1, idx, date) == null || model.getCell(day, slot - 1, idx, date) == null) && (slot - this.firstSlot()) % this.nrSlotsPerPeriod() != 0;
                            boolean inEod = eod && model.getCell(day, slot - 1, idx, date) == null;
                            boolean inEol = eol && model.getCell(day, slot - 1, idx, date) == null;
                            out.println("<td class='TimetableCell" + (first ? "First" : (in ? "In" : (inEol ? "InEOL" : (inEod ? "InEOD" : (eol ? "EOL" : (eod ? "EOD" : "")))))) + "' rowSpan='" + rowSpan + "' colSpan='" + colSpan + "' " + (bgColor == null ? "" : "style='background-color:" + bgColor + "'") + ">&nbsp;</td>");
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.getBgMode() == 0 && !TimetableGridCell.sBgColorNotAvailable.equals(bgColor)) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        eod = slot + length > this.lastSlot();
                        eol = eod && (this.isDispModePerWeek() || day == this.endDay());
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        StringBuffer onClick = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, onClick, cell, bgColor);
                        out.println("<td nowrap style='" + (bgColor == null ? "" : "background-color:" + bgColor) + ";max-width:" + maxCellWidth * colSpan + "px;' " + " class='TimetableCell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "' " + "align='center' " + "colspan='" + colSpan + "' rowSpan='" + rowSpan + "' " + (cell.getAssignmentId() >= 0L ? "name='c" + cell.getAssignmentId() + "' " : "") + onClick + onMouseOver + onMouseOut + ">");
                        out.print(cell.getName());
                        if (this.iShowTimes) {
                            out.print("<BR>" + cell.getTime());
                        }
                        if (this.getResourceType() != 0) {
                            out.print("<BR>" + cell.getRoomName());
                        }
                        if (this.getResourceType() != 1 && this.iShowInstructors && !cell.getInstructor().isEmpty()) {
                            out.print("<BR>" + cell.getInstructor());
                        }
                        if (this.iShowComments) {
                            out.print(cell.getShortComment() == null ? "" : "<BR>" + cell.getShortComment());
                        }
                        out.println("</td>");
                        slot += length - 1;
                    }
                }
            }
        } else {
            int step = this.nrSlotsPerPeriod();
            for (int slot = this.firstSlot(); slot <= this.lastSlot(); slot += step) {
                int time = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                int slotsToEnd = this.lastSlot() - slot + 1;
                if ((slot - this.firstSlot()) % this.nrSlotsPerPeriod() == 0) {
                    out.println("<th class='TimetableHeadCell" + (slot == this.firstSlot() ? "" : "In") + "Vertical'>" + Constants.toTime(time) + "</th>");
                } else {
                    out.println("<th class='TimetableHeadCellInVertical'>&nbsp;</th>");
                }
                for (int day = this.startDay(); day <= this.endDay(); ++day) {
                    if (this.skipDay(day)) continue;
                    int maxIdx = model.getMaxIdxForDay(day, this.firstSlot(), this.lastSlot());
                    for (int idx = 0; idx <= maxIdx; ++idx) {
                        String bgColor;
                        TimetableGridCell cell = model.getCell(day, slot, idx);
                        if (model.isRendered(day, slot, idx)) continue;
                        int rowSpan = cell == null ? 1 : Math.min(cell.getLength() + cell.getSlot() - slot, slotsToEnd);
                        int colSpan = this.isDepartmentalResourceType() && cell != null ? 1 : model.getDepth(day, slot, idx, maxIdx, rowSpan);
                        model.setRendered(day, slot, idx, colSpan, rowSpan);
                        int rowSpanDivStep = (int)Math.ceil((double)rowSpan / (double)step);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            boolean eol = day == this.endDay() && idx + colSpan - 1 == maxIdx;
                            out.println("<td class='TimetableCell" + (slot == this.firstSlot() ? "" : "In") + "Vertical" + (eol ? "EOL" : "") + "' rowSpan='" + rowSpanDivStep + "' colSpan='" + colSpan + "' " + (bgColor == null ? "" : "style='background-color:" + bgColor + "'") + ">&nbsp;</td>");
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.getBgMode() == 0 && !TimetableGridCell.sBgColorNotAvailable.equals(bgColor)) {
                            for (int i = 0; i < cell.getLength() + cell.getSlot() - slot; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        StringBuffer onClick = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, onClick, cell, bgColor);
                        boolean eol = day == this.endDay();
                        out.println("<td nowrap style='" + (bgColor == null ? "" : "background-color:" + bgColor) + ";max-width:" + maxCellWidthVertical * colSpan + "px;' " + "class='TimetableCell" + (slot == this.firstSlot() ? "" : "In") + "Vertical" + (eol ? "EOL" : "") + "' align='center' " + "colspan='" + colSpan + "' rowSpan='" + rowSpanDivStep + "' " + (cell.getAssignmentId() >= 0L ? "name='c" + cell.getAssignmentId() + "' " : "") + onClick + onMouseOver + onMouseOut + ">");
                        out.print(cell.getName());
                        if (this.iShowTimes) {
                            out.print("<BR>" + cell.getTime());
                        }
                        if (this.getResourceType() != 0) {
                            out.print("<BR>" + cell.getRoomName());
                        }
                        if (this.getResourceType() != 1 && this.iShowInstructors && !cell.getInstructor().isEmpty()) {
                            out.print("<BR>" + cell.getInstructor());
                        }
                        if (this.iShowComments) {
                            out.print(cell.getShortComment() == null ? "" : "<BR>" + cell.getShortComment());
                        }
                        if (this.iWeek == -100 && cell.hasDays() && !cell.getDays().equals(this.iDefaultDatePatternName)) {
                            out.print("<BR>" + cell.getDays());
                        }
                        out.println("</td>");
                    }
                }
                out.println("</tr><tr valign='top'>");
                if (slot != this.lastSlot()) continue;
                out.println("<td>&nbsp;</td>");
            }
        }
    }

    private boolean match(final String name) {
        return this.iQuery == null || this.iQuery.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(term, " ,");
                    block0: while (s.hasMoreTokens()) {
                        String termToken = s.nextToken();
                        StringTokenizer t = new StringTokenizer(name, " ,");
                        while (t.hasMoreTokens()) {
                            String token = t.nextToken();
                            if (!token.toLowerCase().startsWith(termToken.toLowerCase())) continue;
                            continue block0;
                        }
                        return false;
                    }
                    return true;
                }
                if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                    return name.matches(term);
                }
                if ("find".equals(attr)) {
                    return name.toLowerCase().indexOf(term.toLowerCase()) >= 0;
                }
                return false;
            }
        });
    }

    private boolean match(final Location location) {
        return this.iQuery == null || this.iQuery.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(location.getLabel(), " ,");
                    while (s.hasMoreTokens()) {
                        String token = s.nextToken();
                        if (!term.equalsIgnoreCase(token)) continue;
                        return true;
                    }
                } else {
                    if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                        return location.getLabel().matches(term);
                    }
                    if ("find".equals(attr)) {
                        return location.getLabel().toLowerCase().indexOf(term.toLowerCase()) >= 0;
                    }
                    if ("type".equals(attr)) {
                        return term.equalsIgnoreCase(location.getRoomType().getReference()) || term.equalsIgnoreCase(location.getRoomType().getLabel());
                    }
                    if ("size".equals(attr)) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        Size prefix = Size.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = Size.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = Size.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = Size.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = Size.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = Size.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                max = Integer.parseInt(b);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        return min <= location.getCapacity() && location.getCapacity() <= max;
                    }
                }
                return false;
            }
        });
    }

    private void showUselessTimesIfDesired() {
        if (this.iShowUselessTimes && this.iModels != null) {
            Enumeration e = this.iModels.elements();
            while (e.hasMoreElements()) {
                ((TimetableGridModel)e.nextElement()).initBgModeUselessSlots();
            }
        }
    }

    public String getDefaultDatePatternName() {
        return this.iDefaultDatePatternName;
    }

    public boolean reload(HttpServletRequest request, SessionContext context, SolverProxy solver) throws Exception {
        Session acadSession;
        DatePattern defaultDatePattern;
        if (this.iModels != null) {
            this.iModels.clear();
        }
        this.iDefaultDatePatternName = (defaultDatePattern = (acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId())).getDefaultDatePatternNotNull()) == null ? null : defaultDatePattern.getName();
        TimetableGridContext cx = new TimetableGridContext(this, acadSession);
        if (solver != null) {
            this.iModels = solver.getTimetableGridTables(cx);
            Collections.sort(this.iModels, new TimetableGridModelComparator());
            this.showUselessTimesIfDesired();
            return true;
        }
        String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
        if (solutionIdsStr == null || solutionIdsStr.length() == 0) {
            return false;
        }
        Transaction tx = null;
        try {
            SolutionDAO dao = new SolutionDAO();
            org.hibernate.Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if (this.getResourceType() == 0) {
                if (RoomAvailability.getInstance() != null) {
                    Calendar startDateCal = Calendar.getInstance(Locale.US);
                    startDateCal.setTime(DateUtils.getDate(1, acadSession.getStartMonth(), acadSession.getSessionStartYear()));
                    startDateCal.set(11, 0);
                    startDateCal.set(12, 0);
                    startDateCal.set(13, 0);
                    Calendar endDateCal = Calendar.getInstance(Locale.US);
                    endDateCal.setTime(DateUtils.getDate(0, acadSession.getEndMonth() + 1, acadSession.getSessionStartYear()));
                    endDateCal.set(11, 23);
                    endDateCal.set(12, 59);
                    endDateCal.set(13, 59);
                    RoomAvailability.getInstance().activate(acadSession, startDateCal.getTime(), endDateCal.getTime(), RoomAvailabilityInterface.sClassType, false);
                    RoomAvailability.setAvailabilityWarning(request, acadSession, true, true);
                }
                org.hibernate.Query q = hibSession.createQuery("select distinct r from Location as r inner join r.assignments as a where a.solution.uniqueId in (" + solutionIdsStr + ")");
                q.setCacheable(true);
                for (Location room : q.list()) {
                    if (!this.match(room)) continue;
                    this.iModels.add(new SolutionGridModel(solutionIdsStr, room, hibSession, cx));
                }
            } else if (this.getResourceType() == 1) {
                if (RoomAvailability.getInstance() != null && this.getShowEvents()) {
                    Calendar startDateCal = Calendar.getInstance(Locale.US);
                    startDateCal.setTime(DateUtils.getDate(1, acadSession.getStartMonth(), acadSession.getSessionStartYear()));
                    startDateCal.set(11, 0);
                    startDateCal.set(12, 0);
                    startDateCal.set(13, 0);
                    Calendar endDateCal = Calendar.getInstance(Locale.US);
                    endDateCal.setTime(DateUtils.getDate(0, acadSession.getEndMonth() + 1, acadSession.getSessionStartYear()));
                    endDateCal.set(11, 23);
                    endDateCal.set(12, 59);
                    endDateCal.set(13, 59);
                    RoomAvailability.getInstance().activate(acadSession, startDateCal.getTime(), endDateCal.getTime(), RoomAvailabilityInterface.sClassType, false);
                    RoomAvailability.setAvailabilityWarning(request, acadSession, true, true);
                }
                String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
                org.hibernate.Query q = null;
                q = ApplicationProperty.TimetableGridUseClassInstructors.isTrue() ? hibSession.createQuery("select distinct i.instructor from ClassInstructor as i inner join i.classInstructing.assignments as a where a.solution.uniqueId in (" + solutionIdsStr + ")") : hibSession.createQuery("select distinct i from DepartmentalInstructor as i inner join i.assignments as a where a.solution.uniqueId in (" + solutionIdsStr + ")");
                q.setCacheable(true);
                HashSet<String> puids = new HashSet<String>();
                for (DepartmentalInstructor instructor : q.list()) {
                    String name = (instructor.getLastName() + ", " + instructor.getFirstName() + " " + instructor.getMiddleName()).trim();
                    if (!this.match(name) || instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0 && !puids.add(instructor.getExternalUniqueId())) continue;
                    SolutionGridModel m = new SolutionGridModel(solutionIdsStr, instructor, hibSession, cx);
                    m.setName(instructor.getName(instructorNameFormat));
                    this.iModels.add(m);
                }
            } else if (this.getResourceType() == 2) {
                org.hibernate.Query q = hibSession.createQuery("select distinct d from Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea.department as d where a.solution.uniqueId in (" + solutionIdsStr + ") and o.isControl=true");
                q.setCacheable(true);
                for (Department dept : q.list()) {
                    String name = dept.getAbbreviation();
                    if (!this.match(name)) continue;
                    this.iModels.add(new SolutionGridModel(solutionIdsStr, dept, hibSession, cx));
                }
            } else if (this.getResourceType() == 4) {
                org.hibernate.Query q = hibSession.createQuery("select distinct sa from Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea as sa where a.solution.uniqueId in (" + solutionIdsStr + ") and o.isControl=true");
                q.setCacheable(true);
                for (SubjectArea sa : q.list()) {
                    String name = sa.getSubjectAreaAbbreviation();
                    if (!this.match(name)) continue;
                    this.iModels.add(new SolutionGridModel(solutionIdsStr, sa, hibSession, cx));
                }
            } else if (this.getResourceType() == 3) {
                org.hibernate.Query q = hibSession.createQuery("select distinct cc.classification from CurriculumCourse cc, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where a.solution.uniqueId in (" + solutionIdsStr + ") and co = cc.course");
                q.setCacheable(true);
                for (CurriculumClassification cc : q.list()) {
                    String name = cc.getCurriculum().getAbbv() + " " + cc.getName();
                    if (!this.match(name)) continue;
                    this.iModels.add(new SolutionGridModel(solutionIdsStr, cc, hibSession, cx));
                }
            } else if (this.getResourceType() == 5) {
                org.hibernate.Query q = hibSession.createQuery("select distinct c from ConstraintInfo c inner join c.assignments a where a.solution.uniqueId in (" + solutionIdsStr + ") and c.definition.name = 'GroupInfo'");
                q.setCacheable(true);
                for (Serializable g : q.list()) {
                    TimetableInfo info;
                    if (!this.match(((BaseSolverInfo)g).getOpt()) && !this.match(((BaseSolverInfo)g).getOpt()) || (info = ((SolverInfo)g).getInfo()) == null || !(info instanceof StudentGroupInfo)) continue;
                    this.iModels.add(new SolutionGridModel(solutionIdsStr, (StudentGroupInfo)info, hibSession, cx));
                }
                if (this.iModels.isEmpty()) {
                    q = hibSession.createQuery("select distinct r.group from StudentGroupReservation r, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering as io where a.solution.uniqueId in (" + solutionIdsStr + ") and io = r.instructionalOffering");
                    q.setCacheable(true);
                    for (Serializable g : q.list()) {
                        if (!this.match(((BaseStudentGroup)g).getGroupName()) && !this.match(((BaseStudentGroup)g).getGroupAbbreviation())) continue;
                        this.iModels.add(new SolutionGridModel(solutionIdsStr, (StudentGroup)g, hibSession, cx));
                    }
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            Debug.error(e);
            throw e;
        }
        Collections.sort(this.iModels, new TimetableGridModelComparator());
        this.showUselessTimesIfDesired();
        return true;
    }

    public void printLegend(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printLegend(out);
        out.flush();
    }

    public void printLegend(PrintWriter out) {
        if (this.iBgMode != 0) {
            out.println("<tr><td colspan='2'>Assigned classes:</td></tr>");
        }
        if (this.iBgMode == 1) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required time</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly preferred time</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Preferred time</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No time preference</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged time</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged time</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited time</td><td></td></tr>");
        } else if (this.iBgMode == 2) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly preferred room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Preferred room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No room preference</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited room</td><td></td></tr>");
        } else if (this.iBgMode == 3) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2color(nrConflicts);
                out.println("<tr><td width='40' style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "student conflicts</td><td></td></tr>");
            }
        } else if (this.iBgMode == 4) {
            out.println("<tr><td idth=40 style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No instructor back-to-back preference <i>(distance=0)</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged back-to-back <i>(0&lt;distance&lt;=5)</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged back-to-back <i>(5&lt;distance&lt;=20)</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited back-to-back <i>(20&lt;distance)</i></td><td></td></tr>");
        } else if (this.iBgMode == 5) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No violated constraint<i>(distance=0)</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged/preferred constraint violated</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged/preferred constraint violated</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required/prohibited constraint violated</i></td><td></td></tr>");
        } else if (this.iBgMode == 6) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No change</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No initial assignment</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Room changed</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Time changed</i></td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Both time and room changed</i></td><td></td></tr>");
        } else if (this.iBgMode == 7) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2color(nrConflicts);
                out.println("<tr><td width='40' style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + (nrConflicts == 0 ? "Zero perturbation penalty" : (nrConflicts == 15 ? "Perturbation penalty above 15" : "Perturbation penalty below or equal to " + nrConflicts)) + "</td><td></td></tr>");
            }
        } else if (this.iBgMode == 8) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required time and room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Can be moved in room with no hard conflict</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Can be moved in room (but there is a hard conflict), can be moved in time with no conflict</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Can be moved in room (but there is a hard conflict)</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Can be moved in time with no hard conflict, cannot be moved in room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Can be moved in time (but there is a hard conflict), cannot be moved in room</td><td></td></tr>");
        } else if (this.iBgMode == 9) {
            for (int nrConflicts = 0; nrConflicts <= 3; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2colorFast(nrConflicts);
                out.println("<tr><td width='40' style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + (nrConflicts == 0 ? "Zero penalty" : (nrConflicts == 3 ? "Penalty equal or above 3" : "Penalty equal to " + nrConflicts)) + "</td><td></td></tr>");
            }
        } else if (this.iBgMode == 10) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Assigned room is smaller than room limit of a class</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Assigned room is not more than 25% bigger than the smallest avaialable room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Assigned room is not more than 50% bigger than the smallest avaialable room</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Assigned room is more than 50% bigger than the smallest avaialable room</td><td></td></tr>");
        }
        out.println("<tr><td colspan='2'>Free times:</td></tr>");
        out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.sBgColorNotAvailable + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Time not available</td><td></td></tr>");
        out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No preference</td><td></td></tr>");
        if (this.iShowUselessTimes) {
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Standard (MWF or TTh) time pattern is broken (time cannot be used for MW, WF, MF or TTh class)</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Useless half-hour</td><td></td></tr>");
            out.println("<tr><td width='40' style='background-color:" + TimetableGridCell.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Useless half-hour and broken standard time pattern</td><td></td></tr>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TimetableGridModelComparator
    implements Comparator<TimetableGridModel> {
        public int compareModels(TimetableGridModel m1, TimetableGridModel m2) {
            switch (TimetableGridTable.this.getOrderBy()) {
                case 0: {
                    return m1.getName().compareTo(m2.getName());
                }
                case 1: {
                    return m2.getName().compareTo(m1.getName());
                }
                case 2: {
                    return Double.compare(m1.getSize(), m2.getSize());
                }
                case 3: {
                    return Double.compare(m2.getSize(), m1.getSize());
                }
                case 4: {
                    int cmp;
                    if (m1.getType() != null && m2.getType() != null && (cmp = m1.getType().compareTo(m2.getType())) != 0) {
                        return cmp;
                    }
                    return m1.getName().compareTo(m2.getName());
                }
                case 5: {
                    int cmp;
                    if (m1.getType() != null && m2.getType() != null && (cmp = m2.getType().compareTo(m1.getType())) != 0) {
                        return cmp;
                    }
                    return m2.getName().compareTo(m1.getName());
                }
                case 6: {
                    return Double.compare(m1.getUtilization(), m2.getUtilization());
                }
                case 7: {
                    return Double.compare(m2.getUtilization(), m1.getUtilization());
                }
            }
            return 0;
        }

        @Override
        public int compare(TimetableGridModel m1, TimetableGridModel m2) {
            int cmp = this.compareModels(m1, m2);
            if (cmp != 0) {
                return cmp;
            }
            return m1.getName().compareTo(m2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

