/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.util.duration.DurationModel;

public class CsvClassAssignmentExport {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    public static CSVFile exportCsv(UserContext user, Collection classes, ClassAssignmentProxy proxy) {
        CSVFile file = new CSVFile();
        String instructorFormat = user.getProperty(UserProperty.NameFormat);
        file.setSeparator(",");
        file.setQuotationMark("\"");
        file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"ITYPE"), new CSVFile.CSVField((Object)"SECTION"), new CSVFile.CSVField((Object)"SUFFIX"), new CSVFile.CSVField((Object)"EXTERNAL_ID"), new CSVFile.CSVField((Object)"ENROLLMENT"), new CSVFile.CSVField((Object)"LIMIT"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAY"), new CSVFile.CSVField((Object)"START_TIME"), new CSVFile.CSVField((Object)"END_TIME"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"INSTRUCTOR"), new CSVFile.CSVField((Object)"SCHEDULE_NOTE")});
        for (Object[] o : classes) {
            Class_ clazz = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            StringBuffer leadsSb = new StringBuffer();
            if (clazz.isDisplayInstructor().booleanValue()) {
                for (ClassInstructor ci : clazz.getClassInstructors()) {
                    if (!leadsSb.toString().isEmpty()) {
                        leadsSb.append("\n");
                    }
                    DepartmentalInstructor instructor = ci.getInstructor();
                    leadsSb.append(instructor.getName(instructorFormat));
                }
            }
            String divSec = clazz.getClassSuffix(co);
            Assignment assignment = null;
            try {
                assignment = proxy.getAssignment(clazz);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (assignment != null) {
                Placement placement = assignment.getPlacement();
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)co.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)divSec), new CSVFile.CSVField((Object)clazz.getEnrollment()), new CSVFile.CSVField(clazz.getClassLimit(proxy)), new CSVFile.CSVField((Object)assignment.getDatePattern().getName()), new CSVFile.CSVField((Object)placement.getTimeLocation().getDayHeader()), new CSVFile.CSVField((Object)placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getRoomName(",")), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
                continue;
            }
            DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer arrHrs = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
            file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)co.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)divSec), new CSVFile.CSVField((Object)clazz.getEnrollment()), new CSVFile.CSVField(clazz.getClassLimit(proxy)), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)("Arr " + (arrHrs == null ? "" : arrHrs + " ") + "Hrs")), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
        }
        return file;
    }

    public static CSVFile exportCsv2(UserContext user, Collection classes, ClassAssignmentProxy proxy) {
        CSVFile file = new CSVFile();
        file.setSeparator(",");
        file.setQuotationMark("\"");
        file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"ID"), new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"DIVSEC"), new CSVFile.CSVField((Object)"TITLEOFFHR"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAYS"), new CSVFile.CSVField((Object)"TIME"), new CSVFile.CSVField((Object)"BUILDING"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"LASTNAME"), new CSVFile.CSVField((Object)"FIRSTNAME"), new CSVFile.CSVField((Object)"MIDINITIAL"), new CSVFile.CSVField((Object)"INITIALS"), new CSVFile.CSVField((Object)"RANK"), new CSVFile.CSVField((Object)"NOTES"), new CSVFile.CSVField((Object)"SUBJECT"), new CSVFile.CSVField((Object)"INSTR_TYPE"), new CSVFile.CSVField((Object)"CROSS_LIST")});
        int idx = 1;
        for (Object[] o : classes) {
            Class_ clazz = (Class_)o[0];
            CourseOffering course = (CourseOffering)o[1];
            if (!course.isIsControl().booleanValue()) continue;
            List<DepartmentalInstructor> leads = clazz.getLeadInstructors();
            StringBuffer lastNameSb = new StringBuffer();
            StringBuffer firstNameSb = new StringBuffer();
            StringBuffer midNameSb = new StringBuffer();
            StringBuffer iniSb = new StringBuffer();
            StringBuffer rankSb = new StringBuffer();
            Iterator<DepartmentalInstructor> e = leads.iterator();
            while (e.hasNext()) {
                DepartmentalInstructor instructor = e.next();
                lastNameSb.append(instructor.getLastName() == null ? "" : instructor.getLastName().trim().substring(0, 1) + instructor.getLastName().trim().substring(1).toLowerCase());
                firstNameSb.append(instructor.getFirstName() == null ? "" : instructor.getFirstName().trim().substring(0, 1) + instructor.getFirstName().trim().substring(1).toLowerCase());
                midNameSb.append(instructor.getMiddleName() == null ? "" : instructor.getMiddleName().trim());
                iniSb.append(instructor.getFirstName() == null || instructor.getFirstName().length() == 0 ? "" : instructor.getFirstName().substring(0, 1));
                iniSb.append(instructor.getMiddleName() == null || instructor.getMiddleName().length() == 0 ? "" : " " + instructor.getMiddleName().substring(0, 1));
                rankSb.append(instructor.getPositionType().getLabel());
                if (!e.hasNext()) continue;
                lastNameSb.append("\n");
                firstNameSb.append("\n");
                midNameSb.append("\n");
                iniSb.append("\n");
                rankSb.append("\n");
            }
            StringBuffer noteSb = new StringBuffer();
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getScheduleBookNote() != null) {
                noteSb.append(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getScheduleBookNote());
            }
            if (clazz.getSchedulePrintNote() != null) {
                if (noteSb.length() > 0) {
                    noteSb.append("\n");
                }
                noteSb.append(clazz.getSchedulePrintNote());
            }
            if (clazz.getNotes() != null) {
                if (noteSb.length() > 0) {
                    noteSb.append("\n");
                }
                noteSb.append(clazz.getNotes());
            }
            StringBuffer titleSb = new StringBuffer();
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getTitle() != null) {
                titleSb.append(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getTitle());
            }
            StringBuffer crossListSb = new StringBuffer();
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings().size() > 1) {
                for (CourseOffering co : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                    crossListSb.append(co.getCourseName());
                }
            }
            String divSec = clazz.getClassSuffix(course);
            Assignment assignment = null;
            try {
                assignment = proxy.getAssignment(clazz);
            }
            catch (Exception e2) {
                Debug.error(e2);
            }
            if (assignment != null) {
                Placement placement = assignment.getPlacement();
                StringBuffer roomSb = new StringBuffer();
                StringBuffer bldgSb = new StringBuffer();
                if (placement.isMultiRoom()) {
                    Iterator e3 = placement.getRoomLocations().iterator();
                    while (e3.hasNext()) {
                        RoomLocation r = (RoomLocation)e3.next();
                        String room = r.getName();
                        bldgSb.append(room.substring(0, room.lastIndexOf(32)));
                        roomSb.append(room.substring(room.lastIndexOf(32) + 1));
                        if (!e3.hasNext()) continue;
                        roomSb.append('\n');
                        bldgSb.append('\n');
                    }
                } else {
                    String room = placement.getRoomLocation() == null ? "" : placement.getRoomLocation().getName();
                    bldgSb.append(room.substring(0, room.lastIndexOf(32)));
                    roomSb.append(room.substring(room.lastIndexOf(32) + 1));
                }
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(idx++), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getCourseNbr()), new CSVFile.CSVField((Object)divSec), new CSVFile.CSVField((Object)titleSb), new CSVFile.CSVField((Object)assignment.getDatePattern().getName()), new CSVFile.CSVField((Object)placement.getTimeLocation().getDayHeader()), new CSVFile.CSVField((Object)(placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()))), new CSVFile.CSVField((Object)bldgSb), new CSVFile.CSVField((Object)roomSb), new CSVFile.CSVField((Object)lastNameSb), new CSVFile.CSVField((Object)firstNameSb), new CSVFile.CSVField((Object)midNameSb), new CSVFile.CSVField((Object)iniSb), new CSVFile.CSVField((Object)rankSb), new CSVFile.CSVField((Object)noteSb), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectAreaAbbv()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getItypeDesc().trim().toUpperCase()), new CSVFile.CSVField((Object)crossListSb)});
                continue;
            }
            DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer arrHrs = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
            file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(idx++), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getCourseNbr()), new CSVFile.CSVField((Object)divSec), new CSVFile.CSVField((Object)titleSb), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)("Arr " + (arrHrs == null ? "" : arrHrs + " ") + "Hrs")), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)lastNameSb), new CSVFile.CSVField((Object)firstNameSb), new CSVFile.CSVField((Object)midNameSb), new CSVFile.CSVField((Object)iniSb), new CSVFile.CSVField((Object)rankSb), new CSVFile.CSVField((Object)noteSb), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectAreaAbbv()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getItypeDesc().trim().toUpperCase()), new CSVFile.CSVField((Object)crossListSb)});
        }
        return file;
    }
}

