/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.util.duration.MeetingCountingDuration;

public class MeetingMinutes
extends MeetingCountingDuration {
    protected double iLowerBound = 0.95;
    protected double iUpperBound = 1.1;

    public MeetingMinutes(String parameter) {
        Matcher matcher;
        if (parameter != null && (matcher = Pattern.compile(this.getParamterFormat()).matcher(parameter)).find()) {
            this.iLowerBound = Double.parseDouble(matcher.group(1));
            this.iUpperBound = Double.parseDouble(matcher.group(2));
        }
    }

    public boolean check(int minutes, int semesterMinutes) {
        return this.iLowerBound * (double)minutes <= (double)semesterMinutes && (double)semesterMinutes <= this.iUpperBound * (double)minutes;
    }

    public Integer getMaxMeetings(int minutes, int minutesPerMeeting) {
        return (int)Math.ceil(minutes / minutesPerMeeting);
    }

    public String getParamterFormat() {
        return "([0-9]*\\.?[0-9]+),([0-9]*\\.?[0-9]+)";
    }

    public int getExactTimeMinutesPerMeeting(int minutes, DatePattern datePattern, int dayCode) {
        int meetings = this.nbrMeetings(datePattern, dayCode);
        return meetings <= 0 ? 0 : minutes / meetings;
    }

    public Integer getArrangedHours(int minutes, DatePattern datePattern) {
        Iterator<DatePattern> iterator;
        if (minutes <= 0 || datePattern == null) {
            return null;
        }
        if (datePattern.getType() != null && datePattern.getType() == 4 && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return new Integer(Math.round((float)minutes / (50.0f * child.getEffectiveNumberOfWeeks())));
        }
        return new Integer(Math.round((float)minutes / (50.0f * datePattern.getEffectiveNumberOfWeeks())));
    }
}

