/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.engine.spi.SessionImplementor;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.RoomAvailabilityService;

public class BlobRoomAvailabilityService
extends RoomAvailabilityService {
    private static Log sLog = LogFactory.getLog(RoomAvailabilityInterface.class);
    private String iRequestSql = ApplicationProperty.BlobRoomAvailabilityRequestSQL.value();
    private String iResponseSql = ApplicationProperty.BlobRoomAvailabilityResponseSQL.value();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendRequest(Document request) throws IOException {
        try {
            try {
                StringWriter writer = new StringWriter();
                new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint()).write(request);
                writer.flush();
                writer.close();
                SessionImplementor session = (SessionImplementor)new _RootDAO().getSession();
                Connection connection = session.getJdbcConnectionAccess().obtainConnection();
                try {
                    CallableStatement call = connection.prepareCall(this.iRequestSql);
                    call.setString(1, writer.getBuffer().toString());
                    call.execute();
                    call.close();
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    session.getJdbcConnectionAccess().releaseConnection(connection);
                    throw throwable;
                }
                session.getJdbcConnectionAccess().releaseConnection(connection);
                Object var9_10 = null;
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to send request: " + e.getMessage()), (Throwable)e);
                Object var9_11 = null;
                _RootDAO.closeCurrentThreadSessions();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document receiveResponse() throws IOException, DocumentException {
        Document document;
        String response;
        block7: {
            CallableStatement call;
            SessionImplementor session = (SessionImplementor)new _RootDAO().getSession();
            Connection connection = session.getJdbcConnectionAccess().obtainConnection();
            response = null;
            try {
                call = connection.prepareCall(this.iResponseSql);
                call.registerOutParameter(1, 2005);
                call.execute();
                response = call.getString(1);
                call.close();
                document = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                session.getJdbcConnectionAccess().releaseConnection(connection);
                throw throwable;
            }
            session.getJdbcConnectionAccess().releaseConnection(connection);
            if (response != null && response.length() != 0) break block7;
            call = null;
            Object var8_10 = null;
            _RootDAO.closeCurrentThreadSessions();
            return call;
        }
        try {
            StringReader reader = new StringReader(response);
            Document document2 = new SAXReader().read((Reader)reader);
            reader.close();
            document = document2;
            Object var8_11 = null;
        }
        catch (Exception e) {
            Document document3;
            try {
                sLog.error((Object)("Unable to receive response: " + e.getMessage()), (Throwable)e);
                document3 = null;
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                _RootDAO.closeCurrentThreadSessions();
                throw throwable;
            }
            _RootDAO.closeCurrentThreadSessions();
            return document3;
        }
        _RootDAO.closeCurrentThreadSessions();
        return document;
    }
}

