/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao._RootDAO;

public class ExamResetRoomPrefs {
    private static Log sLog = LogFactory.getLog(ExamResetRoomPrefs.class);

    public static void doUpdate(Long sessionId, Long examType, boolean override, org.hibernate.Session hibSession) {
        for (Exam exam : new TreeSet(Exam.findAll(sessionId, examType))) {
            sLog.info((Object)("Updating " + exam.getLabel()));
            exam.generateDefaultPreferences(override);
            hibSession.saveOrUpdate((Object)exam);
            hibSession.flush();
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2008"), ApplicationProperties.getProperty("term", "Fall"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            ExamType examType = ExamType.findByReference(ApplicationProperties.getProperty("type", "final"));
            boolean override = "true".equals(ApplicationProperties.getProperty("override", "false"));
            ExamResetRoomPrefs.doUpdate(session.getUniqueId(), examType.getUniqueId(), override, new _RootDAO().getSession());
            HibernateUtil.closeHibernate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

