/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring;

import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class CustomBeanNameGenerator
extends AnnotationBeanNameGenerator {
    protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
        AnnotationMetadata amd = annotatedDef.getMetadata();
        Set types = amd.getAnnotationTypes();
        String beanName = null;
        for (String type : types) {
            Map attributes = amd.getAnnotationAttributes(type);
            if (!this.isStereotypeWithNameValue(type, amd.getMetaAnnotationTypes(type), attributes)) continue;
            String value = null;
            if (PermissionForRight.class.getName().equals(type)) {
                Right right = (Right)((Object)attributes.get("value"));
                value = "permission" + right.name();
            } else if (GwtRpcImplements.class.getName().equals(type)) {
                Class requestClass = (Class)attributes.get("value");
                value = requestClass.getName();
            } else {
                if (GwtRpcLogging.class.getName().equals(type)) continue;
                value = (String)attributes.get("value");
            }
            if (!StringUtils.hasLength((String)value)) continue;
            if (beanName != null && !value.equals(beanName)) {
                throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: '" + beanName + "' versus '" + value + "'");
            }
            beanName = value;
        }
        return beanName;
    }
}

