/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import org.apache.log4j.Logger;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.GeneralTerminationCondition;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurTermination
implements TerminationCondition<CurVariable, CurValue> {
    protected static Logger sLogger = Logger.getLogger(GeneralTerminationCondition.class);
    private int iMaxIter;
    private double iTimeOut;
    private boolean iStopWhenComplete;
    private long iMaxIdle;

    public CurTermination(DataProperties properties) {
        this.iMaxIter = properties.getPropertyInt("Termination.MaxIters", -1);
        this.iTimeOut = properties.getPropertyDouble("Termination.TimeOut", -1.0);
        this.iStopWhenComplete = properties.getPropertyBoolean("Termination.StopWhenComplete", false);
        this.iMaxIdle = properties.getPropertyLong("Termination.MaxIdle", 10000L);
    }

    public boolean canContinue(Solution<CurVariable, CurValue> currentSolution) {
        if (this.iMaxIter >= 0 && currentSolution.getIteration() >= (long)this.iMaxIter) {
            sLogger.info((Object)"Maximum number of iteration reached.");
            return false;
        }
        if (this.iTimeOut >= 0.0 && currentSolution.getTime() > this.iTimeOut) {
            sLogger.info((Object)"Timeout reached.");
            return false;
        }
        if (this.iStopWhenComplete || this.iMaxIter < 0 && this.iTimeOut < 0.0) {
            boolean ret;
            boolean bl = ret = currentSolution.getModel().nrUnassignedVariables(currentSolution.getAssignment()) != 0;
            if (!ret) {
                sLogger.info((Object)"Complete solution found.");
            }
            return ret;
        }
        if (currentSolution.getIteration() - currentSolution.getBestIteration() > this.iMaxIdle) {
            sLogger.info((Object)"Maximum idle iterations reached.");
            return false;
        }
        return true;
    }
}

