/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurSimpleAssignment;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurHillClimber
implements NeighbourSelection<CurVariable, CurValue> {
    protected CurHillClimber(DataProperties config) {
    }

    public void init(Solver<CurVariable, CurValue> solver) {
    }

    public Neighbour<CurVariable, CurValue> selectNeighbour(Solution<CurVariable, CurValue> solution) {
        CurModel model = (CurModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        int ix = ToolBox.random((int)model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            CurVariable course = (CurVariable)((Object)model.variables().get((ix + i) % model.variables().size()));
            CurValue current = (CurValue)assignment.getValue((Variable)course);
            if (!course.getCourse().isComplete((Assignment<CurVariable, CurValue>)assignment) && current != null) continue;
            int jx = ToolBox.random((int)course.values(solution.getAssignment()).size());
            if (current != null && current.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() <= model.getStudentLimit().getMinLimit()) continue;
            for (int j = 0; j < course.values(solution.getAssignment()).size(); ++j) {
                CurValue student = (CurValue)((Object)course.values(solution.getAssignment()).get((j + jx) % course.values(solution.getAssignment()).size()));
                if (course.getCourse().getStudents((Assignment<CurVariable, CurValue>)assignment).contains((Object)student.getStudent()) || student.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() >= model.getStudentLimit().getMaxLimit()) continue;
                if (course.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - (current == null ? 0.0 : current.getStudent().getWeight()) > course.getCourse().getMaxSize() || current != null && course.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - current.getStudent().getWeight() < course.getCourse().getMaxSize() - model.getMinStudentWidth()) continue;
                return new CurSimpleAssignment(student);
            }
        }
        return null;
    }
}

