/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastLikeStudentCourseDemands
implements StudentCourseDemands,
StudentCourseDemands.ProjectionsProvider {
    protected org.hibernate.Session iHibSession;
    protected Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> iDemandsForPemId = new Hashtable();
    protected Hashtable<Long, Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>>> iDemandsForSubjectCourseNbr = new Hashtable();
    protected Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = null;
    protected Long iSessionId = null;
    protected double iBasePriorityWeight = 0.9;
    protected boolean iUsePriorities = false;
    private Hashtable<Long, Hashtable<String, Double>> iEnrollmentPriorities = new Hashtable();

    public LastLikeStudentCourseDemands(DataProperties properties) {
        this.iUsePriorities = properties.getPropertyBoolean("LastLikeStudentCourseDemands.UsePriorities", this.iUsePriorities);
        this.iBasePriorityWeight = properties.getPropertyDouble("LastLikeStudentCourseDemands.BasePriorityWeight", this.iBasePriorityWeight);
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iHibSession = hibSession;
        this.iSessionId = session.getUniqueId();
    }

    @Override
    public float getProjection(String areaAbbv, String clasfCode, String majorCode) {
        return 1.0f;
    }

    protected Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> loadSubject(SubjectArea subject) {
        Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> demandsForCourseNbr = new Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>>();
        this.iDemandsForSubjectCourseNbr.put(subject.getUniqueId(), demandsForCourseNbr);
        for (Object[] d : this.iHibSession.createQuery("select distinct d.courseNbr, d.coursePermId, s, d.priority from LastLikeCourseDemand d inner join d.student s left join fetch s.areaClasfMajors where d.subjectArea.uniqueId = :subjectAreaId").setLong("subjectAreaId", subject.getUniqueId().longValue()).setCacheable(true).list()) {
            Hashtable<String, Double> priorities;
            String courseNbr = (String)d[0];
            String coursePermId = (String)d[1];
            Student student = (Student)d[2];
            Integer priority = (Integer)d[3];
            StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId(student, this);
            Set<StudentCourseDemands.WeightedStudentId> studentIds = demandsForCourseNbr.get(courseNbr);
            if (studentIds == null) {
                studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
                demandsForCourseNbr.put(courseNbr, studentIds);
            }
            studentIds.add(studentId);
            if (coursePermId != null) {
                studentIds = this.iDemandsForPemId.get(coursePermId);
                if (studentIds == null) {
                    studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
                    this.iDemandsForPemId.put(coursePermId, studentIds);
                }
                studentIds.add(studentId);
            }
            if (priority != null) {
                priorities = this.iEnrollmentPriorities.get(student.getUniqueId());
                if (priorities == null) {
                    priorities = new Hashtable();
                    this.iEnrollmentPriorities.put(student.getUniqueId(), priorities);
                }
                priorities.put(subject.getUniqueId() + "|" + courseNbr, Math.pow(this.iBasePriorityWeight, priority.intValue()));
            }
            if (priority == null || coursePermId == null) continue;
            priorities = this.iEnrollmentPriorities.get(student.getUniqueId());
            if (priorities == null) {
                priorities = new Hashtable();
                this.iEnrollmentPriorities.put(student.getUniqueId(), priorities);
            }
            priorities.put(coursePermId, Math.pow(this.iBasePriorityWeight, priority.intValue()));
        }
        return demandsForCourseNbr;
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> demandsForCourseNbr = this.iDemandsForSubjectCourseNbr.get(course.getSubjectArea().getUniqueId());
        if (demandsForCourseNbr == null) {
            demandsForCourseNbr = this.loadSubject(course.getSubjectArea());
        }
        Set<StudentCourseDemands.WeightedStudentId> studentIds = null;
        if (course.getPermId() != null) {
            studentIds = this.iDemandsForPemId.get(course.getPermId());
        }
        if (studentIds == null) {
            studentIds = demandsForCourseNbr.get(course.getCourseNbr());
        }
        if (course.getDemandOffering() != null && !course.getDemandOffering().equals(course)) {
            if (studentIds == null) {
                studentIds = this.getDemands(course.getDemandOffering());
            } else {
                studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>(studentIds);
                studentIds.addAll(this.getDemands(course.getDemandOffering()));
            }
        }
        if (studentIds == null) {
            studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
        }
        return studentIds;
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        if (this.iStudentRequests == null) {
            String[] checks;
            this.iStudentRequests = new Hashtable();
            for (String where : checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"}) {
                for (Object[] o : this.iHibSession.createQuery("select distinct s, co from LastLikeCourseDemand x inner join x.student s left join fetch s.areaClasfMajors, CourseOffering co left outer join co.demandOffering do where " + where).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list()) {
                    Student student = (Student)o[0];
                    CourseOffering co = (CourseOffering)o[1];
                    Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(student.getUniqueId());
                    if (courses == null) {
                        courses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                        this.iStudentRequests.put(student.getUniqueId(), courses);
                    }
                    courses.add(new StudentCourseDemands.WeightedCourseOffering(co, new StudentCourseDemands.WeightedStudentId(student, this).getWeight()));
                }
            }
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Double priority;
        Hashtable<String, Double> priorities;
        if (!this.iUsePriorities) {
            return null;
        }
        CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(courseId);
        if (course == null) {
            return null;
        }
        if (this.iDemandsForSubjectCourseNbr.get(course.getSubjectArea().getUniqueId()) == null) {
            this.loadSubject(course.getSubjectArea());
        }
        if ((priorities = this.iEnrollmentPriorities.get(studentId)) == null) {
            return null;
        }
        if (course.getPermId() != null && (priority = priorities.get(course.getPermId())) != null) {
            return priority;
        }
        return priorities.get(course.getSubjectArea().getUniqueId() + "|" + course.getCourseNbr());
    }
}

