/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.AttachmentTypeDAO;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.EventServiceProviderDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationPictureDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.RoomPictureDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomSharingBackend;
import org.unitime.timetable.util.LocationPermIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.RoomUpdateRpcRequest.class)
public class RoomUpdateBackend
implements GwtRpcImplementation<RoomInterface.RoomUpdateRpcRequest, RoomInterface.RoomDetailInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Logger sLog = Logger.getLogger(RoomUpdateBackend.class);

    @Override
    public RoomInterface.RoomDetailInterface execute(RoomInterface.RoomUpdateRpcRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        Location location = null;
        RoomInterface.RoomException exception = null;
        try {
            switch (request.getOperation()) {
                case DELETE: {
                    List<Location> futureLocations = request.hasFutureFlags() ? Location.getFutureLocations(request.getLocationId()) : null;
                    this.delete(request.getLocationId(), context, false);
                    if (futureLocations == null) break;
                    for (Location location2 : futureLocations) {
                        if (request.getFutureFlag(location2.getUniqueId()) == null) continue;
                        this.delete(location2.getUniqueId(), new EventAction.EventContext(context, context.getUser(), location2.getSession().getUniqueId()), true);
                    }
                    break;
                }
                case UPDATE: {
                    List<Location> futureLocations = request.hasFutureFlags() ? Location.getFutureLocations(request.getRoom().getUniqueId()) : null;
                    List<ExamType> examTypes = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
                    location = this.update(request.getRoom(), context, false, request.getFutureFlag(0L, RoomInterface.FutureOperation.getFlagAllEnabled()), examTypes);
                    if (futureLocations == null) break;
                    for (Location location3 : futureLocations) {
                        Integer flags = request.getFutureFlag(location3.getUniqueId());
                        if (flags == null) continue;
                        request.getRoom().setUniqueId(location3.getUniqueId());
                        this.update(request.getRoom(), new EventAction.EventContext(context, context.getUser(), location3.getSession().getUniqueId()), true, flags, examTypes);
                    }
                    break;
                }
                case CREATE: {
                    location = this.create(request.getRoom(), context, null, null, request.getFutureFlag(0L, RoomInterface.FutureOperation.getFlagAllEnabled()));
                    if (location == null || !request.hasFutureFlags()) break;
                    List list = LocationDAO.getInstance().getSession().createQuery("select f.uniqueId from Session f, Session s where s.uniqueId = :sessionId and s.sessionBeginDateTime < f.sessionBeginDateTime and s.academicInitiative = f.academicInitiative order by f.sessionBeginDateTime").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).list();
                    for (Long id : list) {
                        Integer flags = request.getFutureFlag(-id.longValue());
                        if (flags == null) continue;
                        this.create(request.getRoom(), new EventAction.EventContext(context, context.getUser(), id), id, location.getPermanentId(), flags);
                    }
                    break;
                }
            }
        }
        catch (RoomInterface.RoomException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            exception = e;
        }
        if (location != null) {
            List<ExamType> types = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
            RoomInterface.RoomDetailInterface detail = new RoomDetailsBackend().load(location, null, true, context, !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent), types, context.hasPermission(Right.InstructionalOfferings) || context.hasPermission(Right.Classes), context.hasPermission(Right.Examinations), context.hasPermission(Right.Events) || context.hasPermission(location, Right.RoomEditChangeEventProperties), true);
            RoomSharingBackend roomSharingBackend = new RoomSharingBackend();
            if (detail.isCanSeeEventAvailability()) {
                detail.setEventAvailabilityModel(roomSharingBackend.loadEventAvailability(location, context));
            }
            if (detail.isCanSeeAvailability()) {
                detail.setRoomSharingModel(roomSharingBackend.loadRoomSharing(location, true, context));
            }
            if (detail.isCanSeePeriodPreferences()) {
                PeriodPreferencesBackend periodPreferencesBackend = new PeriodPreferencesBackend();
                for (ExamType type : types) {
                    detail.setPeriodPreferenceModel(periodPreferencesBackend.loadPeriodPreferences(location, type, context));
                }
            }
            context.setAttribute("ROOM_PICTURES", null);
            if (exception != null) {
                throw exception.withRoom(detail);
            }
            return detail;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long delete(Long locationId, SessionContext context, boolean future) {
        Long l;
        Transaction tx;
        block23: {
            Long l2;
            block22: {
                Long l3;
                block21: {
                    Long l4;
                    block20: {
                        if (locationId == null) {
                            return null;
                        }
                        tx = null;
                        Long permId = null;
                        String roomName = null;
                        String sessionLabel = null;
                        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
                        try {
                            try {
                                Event event;
                                Location location;
                                block25: {
                                    block24: {
                                        tx = hibSession.beginTransaction();
                                        location = (Location)LocationDAO.getInstance().get(locationId, hibSession);
                                        if (location == null) {
                                            l4 = null;
                                            Object var17_15 = null;
                                            if (tx == null) return l4;
                                            break block20;
                                        }
                                        roomName = location.getLabel();
                                        sessionLabel = location.getSession().getLabel();
                                        if (!future) break block24;
                                        if (location instanceof Room) {
                                            if (!context.hasPermission((Room)location, Right.RoomDelete)) {
                                                l3 = null;
                                                break block21;
                                            }
                                            break block25;
                                        } else if (!context.hasPermission((NonUniversityLocation)location, Right.NonUniversityLocationDelete)) {
                                            l2 = null;
                                            break block22;
                                        }
                                        break block25;
                                    }
                                    if (location instanceof Room) {
                                        context.checkPermission((Room)location, Right.RoomDelete);
                                    } else {
                                        context.checkPermission((NonUniversityLocation)location, Right.NonUniversityLocationDelete);
                                    }
                                }
                                permId = location.getPermanentId();
                                ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.DELETE, null, location.getControllingDepartment());
                                HashMap<Event, ArrayList<Meeting>> deletedMeetings = new HashMap<Event, ArrayList<Meeting>>();
                                for (Meeting meeting : hibSession.createQuery("select m from Meeting m, Location l where l.uniqueId = :locId and m.locationPermanentId = l.permanentId and m.meetingDate >= l.session.eventBeginDate and m.meetingDate <= l.session.eventEndDate").setLong("locId", location.getUniqueId().longValue()).list()) {
                                    event = meeting.getEvent();
                                    event.getMeetings().remove(meeting);
                                    ArrayList<Meeting> deleted = (ArrayList<Meeting>)deletedMeetings.get(event);
                                    if (deleted == null) {
                                        deleted = new ArrayList<Meeting>();
                                        deletedMeetings.put(event, deleted);
                                    }
                                    deleted.add(meeting);
                                }
                                for (Map.Entry entry : deletedMeetings.entrySet()) {
                                    event = (Event)entry.getKey();
                                    List meetings = (List)entry.getValue();
                                    if (event.getMeetings().isEmpty()) {
                                        hibSession.delete((Object)event);
                                        continue;
                                    }
                                    EventNote note = new EventNote();
                                    note.setEvent(event);
                                    note.setNoteType(4);
                                    note.setTimeStamp(new Date());
                                    note.setUser(context.getUser().getTrueName());
                                    note.setUserId(context.getUser().getTrueExternalUserId());
                                    note.setTextNote(MESSAGES.eventNoteRoomDeleted(location.getLabel()));
                                    note.setMeetingCollection(meetings);
                                    event.getNotes().add(note);
                                    hibSession.saveOrUpdate((Object)event);
                                }
                                List roomPrefs = hibSession.createCriteria(RoomPref.class).add((Criterion)Restrictions.eq((String)"room.uniqueId", (Object)location.getUniqueId())).list();
                                for (RoomDept rd : location.getRoomDepts()) {
                                    Department d = rd.getDepartment();
                                    d.getRoomDepts().remove(rd);
                                    hibSession.delete((Object)rd);
                                    hibSession.saveOrUpdate((Object)d);
                                }
                                for (RoomPref rp : roomPrefs) {
                                    rp.getOwner().getPreferences().remove(rp);
                                    hibSession.delete((Object)rp);
                                    hibSession.saveOrUpdate((Object)rp.getOwner());
                                }
                                Iterator<Assignment> iterator = location.getAssignments().iterator();
                                while (iterator.hasNext()) {
                                    Assignment a = iterator.next();
                                    a.getRooms().remove(location);
                                    hibSession.saveOrUpdate((Object)a);
                                    iterator.remove();
                                }
                                hibSession.delete((Object)location);
                                tx.commit();
                                tx = null;
                                l = permId;
                                break block23;
                            }
                            catch (Throwable t) {
                                if (!future) throw new GwtRpcException(t.getMessage(), t);
                                throw new RoomInterface.RoomException(MESSAGES.failedDeleteLocation(roomName, sessionLabel, t.getMessage()), t);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_19 = null;
                            if (tx == null) throw throwable;
                            if (!tx.isActive()) throw throwable;
                            tx.rollback();
                            throw throwable;
                        }
                    }
                    if (!tx.isActive()) return l4;
                    tx.rollback();
                    return l4;
                }
                Object var17_16 = null;
                if (tx == null) return l3;
                if (!tx.isActive()) return l3;
                tx.rollback();
                return l3;
            }
            Object var17_17 = null;
            if (tx == null) return l2;
            if (!tx.isActive()) return l2;
            tx.rollback();
            return l2;
        }
        Object var17_18 = null;
        if (tx == null) return l;
        if (!tx.isActive()) return l;
        tx.rollback();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    protected Location update(RoomInterface.RoomDetailInterface room, SessionContext context, boolean future, int flags, List<ExamType> examTypes) {
        Location location;
        Location location2;
        org.hibernate.Session hibSession;
        String sessionLabel;
        String roomName;
        Transaction tx;
        block103: {
            tx = null;
            roomName = null;
            sessionLabel = null;
            hibSession = LocationDAO.getInstance().getSession();
            tx = hibSession.beginTransaction();
            location2 = (Location)LocationDAO.getInstance().get(room.getUniqueId(), hibSession);
            if (location2 != null) break block103;
            Location location3 = null;
            Object var23_14 = null;
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            return location3;
        }
        try {
            RoomType type;
            sessionLabel = location2.getSession().getLabel();
            boolean canEdit = context.hasPermission(location2, location2 instanceof Room ? Right.RoomEdit : Right.NonUniversityLocationEdit);
            if (canEdit && context.hasPermission(location2, Right.RoomEditChangeRoomProperties) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                if (location2 instanceof Room) {
                    Building building = this.lookupBuilding(hibSession, room.getBuilding(), future, location2.getSession().getUniqueId());
                    if (future && room.getBuilding() != null && building == null) {
                        throw new RoomInterface.RoomException(MESSAGES.errorBuildingNotExist(room.getBuilding().getAbbreviation()));
                    }
                    Room other = Room.findByBldgIdRoomNbr(building != null ? building.getUniqueId() : ((Room)location2).getBuilding().getUniqueId(), room.getName(), location2.getSession().getUniqueId());
                    if (other != null && !location2.getUniqueId().equals(other.getUniqueId())) {
                        throw new RoomInterface.RoomException(MESSAGES.errorRoomAlreadyExists(roomName));
                    }
                    if (building != null) {
                        ((Room)location2).setBuilding(building);
                        ((Room)location2).setBuildingAbbv(building.getAbbreviation());
                    }
                    ((Room)location2).setRoomNumber(room.getName());
                } else {
                    if (!room.getName().equals(location2.getLabel())) {
                        String nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
                        String nonUniversityLocationInfo = ApplicationProperty.NonUniversityLocationPatternInfo.value();
                        if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                            try {
                                Pattern pattern = Pattern.compile(nonUniversityLocationRegex);
                                Iterator<EventInterface.EventServiceProviderInterface> matcher = pattern.matcher(room.getName());
                                if (!((Matcher)((Object)matcher)).find()) {
                                    throw new RoomInterface.RoomException(nonUniversityLocationInfo == null || nonUniversityLocationInfo.isEmpty() ? MESSAGES.errorLocationNameDoesNotMeetRequiredPattern(room.getName(), nonUniversityLocationRegex) : nonUniversityLocationInfo);
                                }
                            }
                            catch (RoomInterface.RoomException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RoomInterface.RoomException(MESSAGES.errorLocationNameDoesNotMeetRequiredPatternWithReason(room.getName(), nonUniversityLocationRegex, e.getMessage()), e);
                            }
                        }
                    }
                    ((NonUniversityLocation)location2).setName(room.getName());
                }
                location2.setIgnoreTooFar(room.isIgnoreTooFar());
                location2.setIgnoreRoomCheck(room.isIgnoreRoomCheck());
                location2.setCoordinateX(room.getX());
                location2.setCoordinateY(room.getY());
                location2.setArea(room.getArea());
                location2.setDisplayName(room.getDisplayName());
            }
            if (canEdit && context.hasPermission(location2, Right.RoomEditChangeCapacity) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location2.setCapacity(room.getCapacity());
            }
            if (canEdit && context.hasPermission(location2, Right.RoomEditChangeExternalId) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location2.setExternalUniqueId(room.getExternalId());
            }
            if (canEdit && context.hasPermission(location2, Right.RoomEditChangeType) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags) && (type = this.lookupRoomType(hibSession, room.getRoomType())) != null && (type.isRoom().booleanValue() && location2 instanceof Room || !type.isRoom().booleanValue() || !(location2 instanceof NonUniversityLocation))) {
                location2.setRoomType(type);
            }
            String oldNote = location2.getNote();
            if (context.hasPermission(location2, Right.RoomEditChangeEventProperties) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                Department eventDepartment = this.lookuDepartment(hibSession, room.getEventDepartment(), future, location2.getSession().getUniqueId());
                if (!future || room.getEventDepartment() == null || eventDepartment != null) {
                    location2.setEventDepartment(eventDepartment);
                }
                location2.setBreakTime(room.getBreakTime());
                if (!future) {
                    location2.setEventStatus(room.getEventStatus());
                }
                location2.setNote(room.getEventNote() == null ? "" : (room.getEventNote().length() > 2048 ? room.getEventNote().substring(0, 2048) : room.getEventNote()));
                HashSet<EventServiceProvider> services = new HashSet<EventServiceProvider>(location2.getAllowedServices());
                if (room.hasServices()) {
                    for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : room.getServices()) {
                        EventServiceProvider eventServiceProvider = this.lookupService(hibSession, eventServiceProviderInterface, future, location2.getSession().getUniqueId());
                        if (eventServiceProvider == null || services.remove(eventServiceProvider)) continue;
                        location2.getAllowedServices().add(eventServiceProvider);
                    }
                }
                for (EventServiceProvider eventServiceProvider : services) {
                    EventServiceProvider eventServiceProvider2;
                    if (future && ((eventServiceProvider2 = eventServiceProvider.findInSession(hibSession, room.getSessionId())) == null || eventServiceProvider2.isAllRooms().booleanValue() || !eventServiceProvider2.isVisible().booleanValue())) continue;
                    location2.getAllowedServices().remove(eventServiceProvider);
                }
            }
            if (canEdit && context.hasPermission(location2, Right.RoomEditChangeExaminationStatus) && RoomInterface.FutureOperation.EXAM_PROPERTIES.in(flags)) {
                location2.setExamCapacity(room.getExamCapacity());
                boolean examTypesChanged = false;
                List<ExamType> types = null;
                if (future) {
                    types = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
                    Iterator<ExamType> i = types.iterator();
                    while (i.hasNext()) {
                        if (examTypes.contains(i.next())) continue;
                        i.remove();
                    }
                } else {
                    types = examTypes;
                }
                for (ExamType examType : types) {
                    if (room.getExamType(examType.getUniqueId(), examType.getReference()) != null == location2.getExamTypes().contains(examType)) continue;
                    examTypesChanged = true;
                    break;
                }
                if (examTypesChanged) {
                    ArrayList<ExamType> readOnlyTypes = new ArrayList<ExamType>();
                    for (ExamType examType : location2.getExamTypes()) {
                        if (types.contains(examType)) continue;
                        readOnlyTypes.add(examType);
                    }
                    if (!location2.getExamTypes().isEmpty()) {
                        location2.getExamTypes().clear();
                        hibSession.update((Object)location2);
                        hibSession.flush();
                    }
                    for (ExamType examType : types) {
                        if (room.getExamType(examType.getUniqueId(), examType.getReference()) == null) continue;
                        location2.getExamTypes().add(examType);
                    }
                    for (ExamType examType : readOnlyTypes) {
                        location2.getExamTypes().add(examType);
                    }
                }
            }
            if (context.hasPermission(Right.EditRoomDepartmentsExams) && RoomInterface.FutureOperation.EXAM_PREFS.in(flags)) {
                for (ExamType type4 : location2.getExamTypes()) {
                    RoomInterface.PeriodPreferenceModel model = room.getPeriodPreferenceModel(type4.getUniqueId());
                    if (model == null || !examTypes.contains(type4)) continue;
                    location2.clearExamPreferences(type4.getUniqueId());
                    for (ExamPeriod examPeriod : hibSession.createQuery("from ExamPeriod ep where ep.session.uniqueId=:sessionId and ep.examType.uniqueId=:typeId").setLong("sessionId", location2.getSession().getUniqueId().longValue()).setLong("typeId", type4.getUniqueId().longValue()).setCacheable(true).list()) {
                        RoomInterface.PreferenceInterface pref = model.getPreference(examPeriod.getDateOffset(), examPeriod.getStartSlot());
                        if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
                        location2.addExamPreference(examPeriod, PreferenceLevel.getPreferenceLevel(pref.getCode()));
                    }
                }
            }
            if (context.hasPermission(location2, Right.RoomEditAvailability) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                if (room.hasRoomSharingModel()) {
                    HashMap<Long, Character> dept2char = new HashMap<Long, Character>();
                    dept2char.put(-1L, Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                    dept2char.put(-2L, Character.valueOf(RoomSharingModel.sNotAvailablePrefChar));
                    Object managerIds = "";
                    char pref = '0';
                    HashSet<Department> hashSet = new HashSet<Department>();
                    HashMap<Long, Department> hashMap = new HashMap<Long, Department>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        if (option.getId() < 0L) continue;
                        Department d2 = this.lookuDepartment(hibSession, option.getId(), future, location2.getSession().getUniqueId());
                        if (d2 != null) {
                            hashMap.put(option.getId(), d2);
                            managerIds = managerIds + (((String)managerIds).isEmpty() ? "" : ",") + d2.getUniqueId();
                            char c = pref;
                            pref = (char)(pref + 1);
                            dept2char.put(option.getId(), new Character(c));
                            hashSet.add(d2);
                            continue;
                        }
                        dept2char.put(option.getId(), Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                    }
                    Object pattern = "";
                    for (int d3 = 0; d3 < 7; ++d3) {
                        for (int s = 0; s < 288; ++s) {
                            RoomInterface.RoomSharingOption option = room.getRoomSharingModel().getOption(d3, s);
                            pattern = (String)pattern + dept2char.get(option.getId());
                        }
                    }
                    location2.setManagerIds((String)managerIds);
                    location2.setPattern((String)pattern);
                    Iterator<RoomDept> i = location2.getRoomDepts().iterator();
                    while (i.hasNext()) {
                        RoomDept rd = i.next();
                        if (hashSet.remove(rd.getDepartment())) continue;
                        rd.getDepartment().getRoomDepts().remove(rd);
                        i.remove();
                        hibSession.delete((Object)rd);
                    }
                    for (Department d4 : hashSet) {
                        RoomDept rd = new RoomDept();
                        rd.setControl(false);
                        rd.setDepartment(d4);
                        rd.getDepartment().getRoomDepts().add(rd);
                        rd.setRoom(location2);
                        location2.getRoomDepts().add(rd);
                        hibSession.saveOrUpdate((Object)rd);
                    }
                    if (room.getRoomSharingModel().isNoteEditable()) {
                        if (room.getRoomSharingModel().hasNote()) {
                            location2.setShareNote(room.getRoomSharingModel().getNote().length() > 2048 ? room.getRoomSharingModel().getNote().substring(0, 2048) : room.getRoomSharingModel().getNote());
                        } else {
                            location2.setShareNote(null);
                        }
                    }
                } else if (room.hasDepartments()) {
                    HashMap<Long, RoomDept> rds = new HashMap<Long, RoomDept>();
                    for (RoomDept rd : location2.getRoomDepts()) {
                        rds.put(rd.getDepartment().getUniqueId(), rd);
                    }
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        Department department2 = this.lookuDepartment(hibSession, department, future, location2.getSession().getUniqueId());
                        if (department2 == null || rds.remove(department2.getUniqueId()) != null) continue;
                        RoomDept roomDept = new RoomDept();
                        roomDept.setControl(false);
                        roomDept.setDepartment(department2);
                        roomDept.getDepartment().getRoomDepts().add(roomDept);
                        roomDept.setRoom(location2);
                        location2.getRoomDepts().add(roomDept);
                        hibSession.saveOrUpdate((Object)roomDept);
                    }
                    for (RoomDept rd : rds.values()) {
                        rd.getDepartment().getRoomDepts().remove(rd);
                        location2.getRoomDepts().remove(rd);
                        hibSession.delete((Object)rd);
                    }
                    location2.setShareNote(room.getRoomSharingNote());
                }
            }
            if (context.hasPermission(location2, Right.RoomEditPreference) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                HashMap<Long, Object> dept2pref = null;
                if (room.hasRoomSharingModel()) {
                    dept2pref = new HashMap<Long, Object>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        Department department;
                        if (option.getId() < 0L || !option.isEditable() || !option.hasPreference() || (department = this.lookuDepartment(hibSession, option.getId(), future, location2.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department.getUniqueId(), PreferenceLevelDAO.getInstance().get(option.getPreference()));
                    }
                } else if (room.hasDepartments()) {
                    dept2pref = new HashMap();
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        Department department3;
                        if (department.getPreference() == null || (department3 = this.lookuDepartment(hibSession, department, future, location2.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department3.getUniqueId(), this.lookupPreferenceLevel(hibSession, department.getPreference()));
                    }
                }
                if (dept2pref != null) {
                    for (RoomDept rd : location2.getRoomDepts()) {
                        void var17_105;
                        PreferenceLevel preferenceLevel = (PreferenceLevel)dept2pref.get(rd.getDepartment().getUniqueId());
                        Object var17_103 = null;
                        for (RoomPref x : rd.getDepartment().getRoomPreferences()) {
                            if (!x.getRoom().equals(location2)) continue;
                            RoomPref roomPref = x;
                            break;
                        }
                        if (var17_105 == null && preferenceLevel != null && !preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                            RoomPref roomPref = new RoomPref();
                            roomPref.setRoom(location2);
                            roomPref.setPrefLevel(preferenceLevel);
                            roomPref.setOwner(rd.getDepartment());
                            rd.getDepartment().getPreferences().add(roomPref);
                            rd.setPreference(preferenceLevel);
                            hibSession.saveOrUpdate((Object)roomPref);
                            hibSession.saveOrUpdate((Object)rd.getDepartment());
                            continue;
                        }
                        if (var17_105 != null && (preferenceLevel == null || preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral))) {
                            rd.getDepartment().getPreferences().remove(var17_105);
                            rd.setPreference(null);
                            hibSession.delete((Object)var17_105);
                            hibSession.saveOrUpdate((Object)rd.getDepartment());
                            continue;
                        }
                        if (var17_105 == null || var17_105.getPrefLevel().equals(preferenceLevel)) continue;
                        var17_105.setPrefLevel(preferenceLevel);
                        rd.setPreference(preferenceLevel);
                        hibSession.saveOrUpdate((Object)var17_105);
                    }
                }
            }
            if (context.hasPermission(location2, Right.RoomEditFeatures) && RoomInterface.FutureOperation.FEATURES.in(flags)) {
                boolean editGlobalFeatures = context.hasPermission(location2, Right.RoomEditGlobalFeatures);
                boolean deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomFeature> features = new HashSet<RoomFeature>(location2.getFeatures());
                for (RoomInterface.FeatureInterface featureInterface : room.getFeatures()) {
                    RoomFeature feature = this.lookupFeature(hibSession, featureInterface, future, location2.getSession().getUniqueId());
                    if (feature == null || features.remove(feature) || feature instanceof GlobalRoomFeature && !editGlobalFeatures || feature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)feature).getDepartment())) continue;
                    location2.getFeatures().add(feature);
                    feature.getRooms().add(location2);
                    hibSession.saveOrUpdate((Object)feature);
                }
                for (RoomFeature roomFeature : features) {
                    if (roomFeature instanceof GlobalRoomFeature && !editGlobalFeatures || roomFeature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)roomFeature).getDepartment())) continue;
                    if (future) {
                        RoomInterface.FeatureInterface f = new RoomInterface.FeatureInterface(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel());
                        if (roomFeature instanceof DepartmentRoomFeature) {
                            f.setDepartment(new RoomInterface.DepartmentInterface());
                        }
                        if (this.lookupFeature(hibSession, f, future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    }
                    location2.getFeatures().remove(roomFeature);
                    roomFeature.getRooms().remove(location2);
                    hibSession.saveOrUpdate((Object)roomFeature);
                }
            }
            if (context.hasPermission(location2, Right.RoomEditGroups) && RoomInterface.FutureOperation.GROUPS.in(flags)) {
                boolean editGlobalGroups = context.hasPermission(location2, Right.RoomEditGlobalGroups);
                boolean deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomGroup> groups = new HashSet<RoomGroup>(location2.getRoomGroups());
                for (RoomInterface.GroupInterface groupInterface : room.getGroups()) {
                    RoomGroup group = this.lookupGroup(hibSession, groupInterface, future, location2.getSession().getUniqueId());
                    if (group == null || groups.remove(group) || group.isGlobal().booleanValue() && !editGlobalGroups || !group.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(group.getDepartment())) continue;
                    location2.getRoomGroups().add(group);
                    group.getRooms().add(location2);
                    hibSession.saveOrUpdate((Object)group);
                }
                for (RoomGroup roomGroup : groups) {
                    if (roomGroup.isGlobal().booleanValue() && !editGlobalGroups || !roomGroup.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(roomGroup.getDepartment())) continue;
                    if (future) {
                        RoomInterface.GroupInterface g = new RoomInterface.GroupInterface(roomGroup.getUniqueId(), roomGroup.getAbbv(), roomGroup.getName());
                        if (!roomGroup.isGlobal().booleanValue()) {
                            g.setDepartment(new RoomInterface.DepartmentInterface());
                        }
                        if (this.lookupGroup(hibSession, g, future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    }
                    location2.getRoomGroups().remove(roomGroup);
                    roomGroup.getRooms().remove(location2);
                    hibSession.saveOrUpdate((Object)roomGroup);
                }
            }
            if (context.hasPermission(location2, Right.RoomEditChangeControll) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                Department d5 = this.lookuDepartment(hibSession, room.getControlDepartment(), future, location2.getSession().getUniqueId());
                if (!future || room.getControlDepartment() == null || d5 != null) {
                    for (RoomDept rd : location2.getRoomDepts()) {
                        rd.setControl(rd.getDepartment().equals(d5));
                    }
                }
            }
            if (context.hasPermission(location2, Right.RoomEditEventAvailability) && room.hasEventAvailabilityModel() && RoomInterface.FutureOperation.EVENT_AVAILABILITY.in(flags)) {
                String availability = "";
                for (int d6 = 0; d6 < 7; ++d6) {
                    for (int s = 0; s < 288; ++s) {
                        RoomInterface.RoomSharingOption roomSharingOption = room.getEventAvailabilityModel().getOption(d6, s);
                        availability = availability + (roomSharingOption.getId() == -1L ? (char)'0' : '1');
                    }
                }
                location2.setEventAvailability(availability);
            }
            hibSession.saveOrUpdate((Object)location2);
            for (RoomDept rd : location2.getRoomDepts()) {
                hibSession.saveOrUpdate((Object)rd);
            }
            if (context.hasPermission(location2, Right.RoomEditChangeEventProperties) && !(oldNote == null ? "" : oldNote).equals(location2.getNote() == null ? "" : location2.getNote()) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                ChangeLog.addChange(hibSession, context, location2, location2.getNote() == null || location2.getNote().isEmpty() ? "-" : location2.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location2.getControllingDepartment());
            }
            ChangeLog.addChange(hibSession, context, location2, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.UPDATE, null, location2.getControllingDepartment());
            if (context.hasPermission(location2, Right.RoomEditChangePicture) && RoomInterface.FutureOperation.PICTURES.in(flags)) {
                Map temp = (Map)context.getAttribute("ROOM_PICTURES");
                HashMap<Long, LocationPicture> pictures = new HashMap<Long, LocationPicture>();
                if (future) {
                    HashSet<? extends LocationPicture> otherPictures = new HashSet<LocationPicture>(location2.getPictures());
                    block37: for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture original;
                        LocationPicture p2;
                        Iterator i = otherPictures.iterator();
                        while (i.hasNext()) {
                            p2 = (LocationPicture)i.next();
                            if (!this.samePicture(roomPictureInterface, p2)) continue;
                            if (!this.sameType(roomPictureInterface, p2)) {
                                p2.setType(roomPictureInterface.getPictureType() == null ? null : (AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                                hibSession.saveOrUpdate((Object)p2);
                            }
                            i.remove();
                            continue block37;
                        }
                        if (location2 instanceof Room) {
                            original = (RoomPicture)RoomPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                            if (original == null) continue;
                            p2 = ((RoomPicture)original).clonePicture();
                            p2.setLocation(location2);
                            ((Room)location2).getPictures().add((RoomPicture)p2);
                            hibSession.saveOrUpdate((Object)p2);
                            continue;
                        }
                        original = (NonUniversityLocationPicture)NonUniversityLocationPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                        if (original == null) continue;
                        p2 = ((NonUniversityLocationPicture)original).clonePicture();
                        p2.setLocation(location2);
                        ((NonUniversityLocation)location2).getPictures().add((NonUniversityLocationPicture)p2);
                        hibSession.saveOrUpdate((Object)p2);
                    }
                    for (LocationPicture locationPicture : otherPictures) {
                        location2.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                } else {
                    for (LocationPicture locationPicture : location2.getPictures()) {
                        pictures.put(locationPicture.getUniqueId(), locationPicture);
                    }
                    for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture locationPicture = (LocationPicture)pictures.remove(roomPictureInterface.getUniqueId());
                        if (locationPicture == null && temp != null) {
                            LocationPicture locationPicture2 = (LocationPicture)temp.get(roomPictureInterface.getUniqueId());
                            if (locationPicture2 == null) continue;
                            if (location2 instanceof Room) {
                                ((RoomPicture)locationPicture2).setLocation((Room)location2);
                                ((Room)location2).getPictures().add((RoomPicture)locationPicture2);
                            } else {
                                ((NonUniversityLocationPicture)locationPicture2).setLocation((NonUniversityLocation)location2);
                                ((NonUniversityLocation)location2).getPictures().add((NonUniversityLocationPicture)locationPicture2);
                            }
                            if (roomPictureInterface.getPictureType() != null) {
                                locationPicture2.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                            }
                            hibSession.saveOrUpdate((Object)locationPicture2);
                            roomPictureInterface.setUniqueId(locationPicture2.getUniqueId());
                            continue;
                        }
                        if (locationPicture == null) continue;
                        if (roomPictureInterface.getPictureType() != null) {
                            locationPicture.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                        }
                        hibSession.saveOrUpdate((Object)locationPicture);
                    }
                    for (LocationPicture locationPicture : pictures.values()) {
                        location2.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                }
            }
            hibSession.flush();
            tx.commit();
            tx = null;
            location = location2;
            Object var23_15 = null;
        }
        catch (Throwable t) {
            try {
                if (future) {
                    throw new RoomInterface.RoomException(MESSAGES.failedUpdateLocation(roomName, sessionLabel, t.getMessage()), t);
                }
                throw new GwtRpcException(t.getMessage(), t);
            }
            catch (Throwable throwable) {
                block104: {
                    Object var23_16 = null;
                    if (tx == null || !tx.isActive()) break block104;
                    tx.rollback();
                }
                throw throwable;
            }
        }
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
        return location;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected Location create(RoomInterface.RoomDetailInterface room, SessionContext context, Long sessionId, Long permId, int flags) {
        block87: {
            block88: {
                block86: {
                    tx = null;
                    roomName = room.getLabel();
                    sessionLabel = null;
                    future = sessionId != null;
                    hibSession = LocationDAO.getInstance().getSession();
                    tx = hibSession.beginTransaction();
                    session = (Session)SessionDAO.getInstance().get(sessionId == null ? context.getUser().getCurrentAcademicSessionId() : sessionId, hibSession);
                    if (session != null) break block86;
                    var12_13 = null;
                    var24_17 = null;
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return var12_13;
                }
                sessionLabel = session.getLabel();
                if (!future) break block87;
                if (!room.getRoomType().isRoom()) break block88;
                if (context.hasPermission(Right.AddRoom)) ** GOTO lbl43
                var12_14 = null;
                var24_18 = null;
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                return var12_14;
            }
            if (context.hasPermission(Right.AddNonUnivLocation)) ** GOTO lbl43
            var12_15 = null;
            var24_19 = null;
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            return var12_15;
        }
        try {
            if (room.getRoomType().isRoom()) {
                context.checkPermission(Right.AddRoom);
            } else {
                context.checkPermission(Right.AddNonUnivLocation);
            }
lbl43:
            // 4 sources

            if (room.getRoomType().isRoom()) {
                // empty if block
            }
            location = null;
            if (room.getRoomType().isRoom()) {
                r = new Room();
                b = this.lookupBuilding(hibSession, room.getBuilding(), future, session.getUniqueId());
                if (b == null) {
                    throw new RoomInterface.RoomException(RoomUpdateBackend.MESSAGES.errorBuildingNotExist(room.getBuilding().getAbbreviation()));
                }
                other = Room.findByBldgIdRoomNbr(b.getUniqueId(), room.getName(), session.getUniqueId());
                if (other != null) {
                    throw new RoomInterface.RoomException(RoomUpdateBackend.MESSAGES.errorRoomAlreadyExists(roomName));
                }
                r.setBuilding(b);
                r.setBuildingAbbv(b.getAbbreviation());
                r.setRoomNumber(room.getName());
                r.setPictures(new HashSet<RoomPicture>());
                location = r;
            } else {
                nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
                nonUniversityLocationInfo = ApplicationProperty.NonUniversityLocationPatternInfo.value();
                if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                    try {
                        pattern = Pattern.compile(nonUniversityLocationRegex);
                        matcher = pattern.matcher(room.getName());
                        if (!matcher.find()) {
                            throw new RoomInterface.RoomException(nonUniversityLocationInfo == null || nonUniversityLocationInfo.isEmpty() != false ? RoomUpdateBackend.MESSAGES.errorLocationNameDoesNotMeetRequiredPattern(room.getName(), nonUniversityLocationRegex) : nonUniversityLocationInfo);
                        }
                    }
                    catch (RoomInterface.RoomException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RoomInterface.RoomException(RoomUpdateBackend.MESSAGES.errorLocationNameDoesNotMeetRequiredPatternWithReason(room.getName(), nonUniversityLocationRegex, e.getMessage()), e);
                    }
                }
                r = new NonUniversityLocation();
                r.setPictures(new HashSet<NonUniversityLocationPicture>());
                r.setName(room.getName());
                location = r;
            }
            location.setSession(session);
            location.setIgnoreTooFar(room.isIgnoreTooFar());
            location.setIgnoreRoomCheck(room.isIgnoreRoomCheck());
            location.setCoordinateX(room.getX());
            location.setCoordinateY(room.getY());
            location.setArea(room.getArea());
            location.setDisplayName(room.getDisplayName());
            location.setCapacity(room.getCapacity());
            location.setRoomDepts(new HashSet<RoomDept>());
            location.setExamPreferences(new HashSet<ExamLocationPref>());
            location.setExamTypes(new HashSet<ExamType>());
            location.setRoomDepts(new HashSet<RoomDept>());
            location.setRoomGroups(new HashSet<RoomGroup>());
            location.setFeatures(new HashSet<RoomFeature>());
            location.setRoomType(this.lookupRoomType(hibSession, room.getRoomType()));
            if (permId == null) {
                LocationPermIdGenerator.setPermanentId(location);
            } else {
                location.setPermanentId(permId);
            }
            if (room.hasRoomSharingModel() && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                dept2char = new HashMap<Long, Character>();
                dept2char.put(-1L, Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                dept2char.put(-2L, Character.valueOf(RoomSharingModel.sNotAvailablePrefChar));
                managerIds = "";
                pref = '0';
                add = new HashSet<Department>();
                id2dept = new HashMap<Long, Department>();
                for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                    if (option.getId() < 0L) continue;
                    d = this.lookuDepartment(hibSession, option.getId(), future, session.getUniqueId());
                    if (d != null) {
                        id2dept.put(option.getId(), d);
                        managerIds = (String)managerIds + (managerIds.isEmpty() != false ? "" : ",") + d.getUniqueId();
                        v0 = pref;
                        pref = (char)(pref + 1);
                        dept2char.put(option.getId(), new Character(v0));
                        add.add(d);
                        continue;
                    }
                    dept2char.put(option.getId(), Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                }
                pattern = "";
                for (d = 0; d < 7; ++d) {
                    for (s = 0; s < 288; ++s) {
                        option = room.getRoomSharingModel().getOption(d, s);
                        pattern = pattern + dept2char.get(option.getId());
                    }
                }
                location.setManagerIds((String)managerIds);
                location.setPattern(pattern);
                control = this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId());
                for (Department d : add) {
                    rd = new RoomDept();
                    rd.setControl(d.equals(control));
                    rd.setDepartment(d);
                    rd.getDepartment().getRoomDepts().add(rd);
                    rd.setRoom(location);
                    location.getRoomDepts().add(rd);
                }
                if (room.getRoomSharingModel().isNoteEditable()) {
                    if (room.getRoomSharingModel().hasNote()) {
                        location.setShareNote(room.getRoomSharingModel().getNote().length() > 2048 ? room.getRoomSharingModel().getNote().substring(0, 2048) : room.getRoomSharingModel().getNote());
                    } else {
                        location.setShareNote(null);
                    }
                }
            } else if (room.hasDepartments()) {
                control = room.getControlDepartment() == null ? null : this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId());
                for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                    d = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId());
                    if (d == null) continue;
                    rd = new RoomDept();
                    rd.setControl(d.equals(control));
                    rd.setDepartment(d);
                    rd.getDepartment().getRoomDepts().add(rd);
                    rd.setRoom(location);
                    location.getRoomDepts().add(rd);
                }
                location.setShareNote(room.getRoomSharingNote());
            } else if (room.getControlDepartment() != null && (dept = this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId())) != null) {
                rd = new RoomDept();
                rd.setControl(true);
                rd.setDepartment(dept);
                rd.getDepartment().getRoomDepts().add((RoomDept)rd);
                rd.setRoom(location);
                location.getRoomDepts().add((RoomDept)rd);
            }
            hibSession.save((Object)location);
            if (context.hasPermission(location, Right.RoomEditChangeExternalId) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location.setExternalUniqueId(room.getExternalId());
            }
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                eventDepartment = this.lookuDepartment(hibSession, room.getEventDepartment(), future, session.getUniqueId());
                if (!future || room.getEventDepartment() == null || eventDepartment != null) {
                    location.setEventDepartment(eventDepartment);
                }
                location.setBreakTime(room.getBreakTime());
                if (!future) {
                    location.setEventStatus(room.getEventStatus());
                }
                location.setNote(room.getEventNote() == null ? "" : (room.getEventNote().length() > 2048 ? room.getEventNote().substring(0, 2048) : room.getEventNote()));
                location.setAllowedServices(new HashSet<EventServiceProvider>());
                if (room.hasServices()) {
                    for (EventInterface.EventServiceProviderInterface service : room.getServices()) {
                        provider = this.lookupService(hibSession, service, future, location.getSession().getUniqueId());
                        if (provider == null) continue;
                        location.getAllowedServices().add(provider);
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditChangeExaminationStatus) && RoomInterface.FutureOperation.EXAM_PROPERTIES.in(flags)) {
                location.setExamCapacity(room.getExamCapacity());
                types = ExamType.findAll(hibSession);
                rd = types.iterator();
                while (rd.hasNext()) {
                    type = (ExamType)rd.next();
                    if (room.getExamType(type.getUniqueId(), type.getReference()) == null) continue;
                    location.getExamTypes().add(type);
                }
            }
            if (context.hasPermission(Right.EditRoomDepartmentsExams) && RoomInterface.FutureOperation.EXAM_PREFS.in(flags)) {
                for (Object type : location.getExamTypes()) {
                    model = room.getPeriodPreferenceModel(type.getUniqueId());
                    if (model == null) continue;
                    location.clearExamPreferences(type.getUniqueId());
                    for (ExamPeriod period : hibSession.createQuery("from ExamPeriod ep where ep.session.uniqueId=:sessionId and ep.examType.uniqueId=:typeId").setLong("sessionId", session.getUniqueId().longValue()).setLong("typeId", type.getUniqueId().longValue()).setCacheable(true).list()) {
                        pref = model.getPreference(period.getDateOffset(), period.getStartSlot());
                        if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
                        location.addExamPreference(period, PreferenceLevel.getPreferenceLevel(pref.getCode()));
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditPreference) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                dept2pref = null;
                if (room.hasRoomSharingModel()) {
                    dept2pref = new HashMap<Long, Object>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        if (option.getId() < 0L || !option.isEditable() || !option.hasPreference() || (d = this.lookuDepartment(hibSession, option.getId(), future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(d.getUniqueId(), PreferenceLevelDAO.getInstance().get(option.getPreference()));
                    }
                } else if (room.hasDepartments()) {
                    dept2pref = new HashMap<K, V>();
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        if (department.getPreference() == null || (d = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(d.getUniqueId(), this.lookupPreferenceLevel(hibSession, department.getPreference()));
                    }
                }
                if (dept2pref != null) {
                    for (RoomDept rd : location.getRoomDepts()) {
                        pref = (PreferenceLevel)dept2pref.get(rd.getDepartment().getUniqueId());
                        if (pref == null || pref.getPrefProlog().equals(PreferenceLevel.sNeutral)) continue;
                        rp = new RoomPref();
                        rp.setRoom(location);
                        rp.setPrefLevel(pref);
                        rp.setOwner(rd.getDepartment());
                        rd.getDepartment().getPreferences().add(rp);
                        rd.setPreference(pref);
                        hibSession.saveOrUpdate((Object)rp);
                        hibSession.saveOrUpdate((Object)rd.getDepartment());
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditFeatures) && RoomInterface.FutureOperation.FEATURES.in(flags)) {
                editGlobalFeatures = context.hasPermission(location, Right.RoomEditGlobalFeatures);
                deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                features = new HashSet<RoomFeature>(location.getFeatures());
                for (RoomInterface.FeatureInterface f : room.getFeatures()) {
                    feature = this.lookupFeature(hibSession, f, future, location.getSession().getUniqueId());
                    if (feature == null || features.remove(feature.getUniqueId()) || feature instanceof GlobalRoomFeature && !editGlobalFeatures || feature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)feature).getDepartment())) continue;
                    location.getFeatures().add(feature);
                    feature.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)feature);
                }
                for (RoomFeature feature : features) {
                    if (feature instanceof GlobalRoomFeature && !editGlobalFeatures || feature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)feature).getDepartment()) || future && this.lookupFeature(hibSession, new RoomInterface.FeatureInterface(feature.getUniqueId(), feature.getAbbv(), feature.getLabel()), future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    location.getFeatures().remove(feature);
                    feature.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)feature);
                }
            }
            if (context.hasPermission(location, Right.RoomEditGroups) && RoomInterface.FutureOperation.GROUPS.in(flags)) {
                editGlobalGroups = context.hasPermission(location, Right.RoomEditGlobalGroups);
                deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                groups = new HashSet<RoomGroup>(location.getRoomGroups());
                for (RoomInterface.GroupInterface g : room.getGroups()) {
                    group = this.lookupGroup(hibSession, g, future, location.getSession().getUniqueId());
                    if (group == null || groups.remove(group) || group.isGlobal().booleanValue() && !editGlobalGroups || !group.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(group.getDepartment())) continue;
                    location.getRoomGroups().add(group);
                    group.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)group);
                }
                for (RoomGroup group : groups) {
                    if (group.isGlobal().booleanValue() && !editGlobalGroups || !group.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(group.getDepartment()) || future && this.lookupGroup(hibSession, new RoomInterface.GroupInterface(group.getUniqueId(), group.getAbbv(), group.getName()), future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    location.getRoomGroups().remove(group);
                    group.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)group);
                }
            }
            if (context.hasPermission(location, Right.RoomEditEventAvailability) && room.hasEventAvailabilityModel() && RoomInterface.FutureOperation.EVENT_AVAILABILITY.in(flags)) {
                availability = "";
                for (d = 0; d < 7; ++d) {
                    for (s = 0; s < 288; ++s) {
                        option = room.getEventAvailabilityModel().getOption(d, s);
                        availability = availability + (option.getId() == -1L ? '0' : '1');
                    }
                }
                location.setEventAvailability(availability);
            }
            hibSession.saveOrUpdate((Object)location);
            for (RoomDept rd : location.getRoomDepts()) {
                hibSession.saveOrUpdate((Object)rd);
            }
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && location.getNote() != null && !location.getNote().isEmpty() && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                ChangeLog.addChange(hibSession, context, location, location.getNote() == null || location.getNote().isEmpty() != false ? "-" : location.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location.getControllingDepartment());
            }
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.CREATE, null, location.getControllingDepartment());
            if (context.hasPermission(location, Right.RoomEditChangePicture) && RoomInterface.FutureOperation.PICTURES.in(flags)) {
                temp = (Map)context.getAttribute("ROOM_PICTURES");
                pictures = new HashMap<Long, LocationPicture>();
                if (future) {
                    otherPictures = new HashSet<LocationPicture>(location.getPictures());
                    block29: for (RoomInterface.RoomPictureInterface p1 : room.getPictures()) {
                        i = otherPictures.iterator();
                        while (i.hasNext()) {
                            p2 = (LocationPicture)i.next();
                            if (!this.samePicture(p1, p2)) continue;
                            if (!this.sameType(p1, p2)) {
                                p2.setType(p1.getPictureType() == null ? null : (AttachmentType)AttachmentTypeDAO.getInstance().get(p1.getPictureType().getId(), hibSession));
                                hibSession.saveOrUpdate((Object)p2);
                            }
                            i.remove();
                            continue block29;
                        }
                        if (location instanceof Room) {
                            original = (RoomPicture)RoomPictureDAO.getInstance().get(p1.getUniqueId());
                            if (original == null) continue;
                            p2 = original.clonePicture();
                            p2.setLocation(location);
                            ((Room)location).getPictures().add((RoomPicture)p2);
                            hibSession.saveOrUpdate((Object)p2);
                            continue;
                        }
                        original = (NonUniversityLocationPicture)NonUniversityLocationPictureDAO.getInstance().get(p1.getUniqueId());
                        if (original == null) continue;
                        p2 = original.clonePicture();
                        p2.setLocation(location);
                        ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)p2);
                        hibSession.saveOrUpdate((Object)p2);
                    }
                    for (LocationPicture picture : otherPictures) {
                        location.getPictures().remove(picture);
                        hibSession.delete((Object)picture);
                    }
                } else {
                    for (Object p : location.getPictures()) {
                        pictures.put(p.getUniqueId(), (LocationPicture)p);
                    }
                    for (Object p : room.getPictures()) {
                        picture = (LocationPicture)pictures.remove(p.getUniqueId());
                        if (picture == null && temp != null) {
                            picture = (LocationPicture)temp.get(p.getUniqueId());
                            if (picture == null) continue;
                            if (location instanceof Room) {
                                ((RoomPicture)picture).setLocation((Room)location);
                                ((Room)location).getPictures().add((RoomPicture)picture);
                                if (p.getPictureType() != null) {
                                    picture.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(p.getPictureType().getId(), hibSession));
                                }
                                hibSession.saveOrUpdate((Object)picture);
                                p.setUniqueId(picture.getUniqueId());
                                continue;
                            }
                            np = new NonUniversityLocationPicture();
                            np.setDataFile(picture.getDataFile());
                            np.setFileName(picture.getFileName());
                            np.setContentType(picture.getContentType());
                            np.setTimeStamp(picture.getTimeStamp());
                            np.setLocation((NonUniversityLocation)location);
                            ((NonUniversityLocation)location).getPictures().add(np);
                            if (p.getPictureType() != null) {
                                np.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(p.getPictureType().getId(), hibSession));
                            }
                            hibSession.saveOrUpdate((Object)np);
                            p.setUniqueId(np.getUniqueId());
                            continue;
                        }
                        if (picture == null) continue;
                        if (p.getPictureType() != null) {
                            picture.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(p.getPictureType().getId(), hibSession));
                        }
                        hibSession.saveOrUpdate((Object)picture);
                    }
                    for (LocationPicture picture : pictures.values()) {
                        location.getPictures().remove(picture);
                        hibSession.delete((Object)picture);
                    }
                }
            }
            hibSession.flush();
            tx.commit();
            tx = null;
            var13_26 = location;
            var24_20 = null;
        }
        catch (Throwable t) {
            try {
                if (future) {
                    throw new RoomInterface.RoomException(RoomUpdateBackend.MESSAGES.failedCreateLocation(roomName, sessionLabel, t.getMessage()), t);
                }
                throw new GwtRpcException(t.getMessage(), t);
            }
            catch (Throwable var23_59) {
                block89: {
                    var24_21 = null;
                    if (tx == null || !tx.isActive()) break block89;
                    tx.rollback();
                }
                throw var23_59;
            }
        }
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
        return var13_26;
    }

    protected boolean samePicture(RoomInterface.RoomPictureInterface p1, LocationPicture p2) {
        return p1.getName().equals(p2.getFileName()) && Math.abs(p1.getTimeStamp() - p2.getTimeStamp().getTime()) < 1000L && p1.getType().equals(p2.getContentType());
    }

    protected boolean sameType(RoomInterface.RoomPictureInterface p1, LocationPicture p2) {
        if (p1.getPictureType() == null) {
            return p2.getType() == null;
        }
        return p2.getType() != null && p1.getPictureType().getId().equals(p2.getType().getUniqueId());
    }

    protected RoomType lookupRoomType(org.hibernate.Session hibSession, RoomInterface.RoomTypeInterface original) {
        if (original == null) {
            return null;
        }
        if (original.getId() != null) {
            return (RoomType)RoomTypeDAO.getInstance().get(original.getId(), hibSession);
        }
        return (RoomType)hibSession.createQuery("select t from RoomType t where t.reference = :reference").setString("reference", original.getReference()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    protected PreferenceLevel lookupPreferenceLevel(org.hibernate.Session hibSession, RoomInterface.PreferenceInterface original) {
        if (original == null) {
            return null;
        }
        if (original.getId() != null) {
            return (PreferenceLevel)PreferenceLevelDAO.getInstance().get(original.getId(), hibSession);
        }
        return PreferenceLevel.getPreferenceLevel(original.getCode());
    }

    protected Building lookupBuilding(org.hibernate.Session hibSession, RoomInterface.BuildingInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future || original.getId() == null) {
            return (Building)hibSession.createQuery("select b from Building b where b.abbreviation = :abbreviation and b.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("abbreviation", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (Building)BuildingDAO.getInstance().get(original.getId(), hibSession);
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, RoomInterface.DepartmentInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future || original.getId() == null) {
            return Department.findByDeptCode(original.getDeptCode(), sessionId, hibSession);
        }
        return (Department)DepartmentDAO.getInstance().get(original.getId(), hibSession);
    }

    protected EventServiceProvider lookupService(org.hibernate.Session hibSession, EventInterface.EventServiceProviderInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        EventServiceProvider service = (EventServiceProvider)EventServiceProviderDAO.getInstance().get(original.getId());
        if (future && service != null) {
            return service.findInSession(sessionId);
        }
        return service;
    }

    protected RoomFeature lookupFeature(org.hibernate.Session hibSession, RoomInterface.FeatureInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (original.getId() == null) {
            if (original.isDepartmental()) {
                return (DepartmentRoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f where f.department.session.uniqueId = :sessionId and f.abbv = :abbv and f.department.deptCode = :deptCode").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setString("deptCode", original.getDepartment().getDeptCode()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (GlobalRoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f where f.session.uniqueId = :sessionId and f.abbv = :abbv").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        if (future) {
            if (original.isDepartmental()) {
                return (DepartmentRoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f, DepartmentRoomFeature o where o.uniqueId = :originalId and f.department.session.uniqueId = :sessionId and f.abbv = o.abbv and f.department.deptCode = o.department.deptCode").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (GlobalRoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f, GlobalRoomFeature o where o.uniqueId = :originalId and f.session.uniqueId = :sessionId and f.abbv = o.abbv").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomFeature)RoomFeatureDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomGroup lookupGroup(org.hibernate.Session hibSession, RoomInterface.GroupInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (original.getId() == null) {
            if (original.isDepartmental()) {
                return (RoomGroup)hibSession.createQuery("select g from RoomGroup g where g.department.session.uniqueId = :sessionId and g.abbv = :abbv and g.department.deptCode = :deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setString("deptCode", original.getDepartment().getDeptCode()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomGroup)hibSession.createQuery("select g from RoomGroup g where g.session.uniqueId = :sessionId and g.abbv = :abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        if (future) {
            if (original.isDepartmental()) {
                return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.department.session.uniqueId = :sessionId and g.abbv = o.abbv and g.department.deptCode = o.department.deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.session.uniqueId = :sessionId and g.abbv = o.abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomGroup)RoomGroupDAO.getInstance().get(original.getId(), hibSession);
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, Department original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            return (Department)hibSession.createQuery("select d from Department d, Department o where d.deptCode = o.deptCode and d.session.uniqueId = :sessionId and o.uniqueId = :originalId").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getUniqueId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return original;
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, Long originalId, boolean future, Long sessionId) {
        if (originalId == null) {
            return null;
        }
        if (future) {
            return (Department)hibSession.createQuery("select distinct d from Department d, Department o where d.deptCode = o.deptCode and d.session.uniqueId = :sessionId and o.uniqueId = :originalId").setLong("sessionId", sessionId.longValue()).setLong("originalId", originalId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (Department)DepartmentDAO.getInstance().get(originalId, hibSession);
    }
}

