/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseLong;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLStoreRpcRequest.class)
public class HQLStoreBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLStoreRpcRequest, GwtRpcResponseLong> {
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="(#query.id != null and checkPermission(#query.id, 'SavedHQL', 'HQLReportEdit')) or (#query.id == null and checkPermission('HQLReportAdd'))")
    public GwtRpcResponseLong execute(SavedHQLInterface.HQLStoreRpcRequest query, SessionContext context) {
        if (SavedHQL.Flag.ADMIN_ONLY.isSet(query.getFlags())) {
            this.sessionContext.checkPermission(Right.HQLReportsAdminOnly);
        }
        Session hibSession = SavedHQLDAO.getInstance().getSession();
        SavedHQL hql = null;
        if (query.getId() != null) {
            hql = (SavedHQL)SavedHQLDAO.getInstance().get(query.getId(), hibSession);
        }
        if (hql == null) {
            hql = new SavedHQL();
        }
        hql.setName(query.getName());
        hql.setDescription(query.getDescription());
        hql.setType(query.getFlags());
        hql.setQuery(query.getQuery());
        hibSession.saveOrUpdate((Object)hql);
        hibSession.flush();
        hibSession.refresh((Object)hql);
        return new GwtRpcResponseLong(hql.getUniqueId());
    }
}

