/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="gwtAdminTable[type=group]")
public class StudentGroups
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentGroup(), MESSAGES.pageStudentGroups());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroups')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 200, 30, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 500, 90, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldExpectedSize(), SimpleEditInterface.FieldType.number, 80, 10, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldStudents(), SimpleEditInterface.FieldType.students, 200, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1, 2);
        for (StudentGroup group : StudentGroupDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(group.getUniqueId());
            r.setField(0, group.getExternalUniqueId());
            r.setField(1, group.getGroupAbbreviation());
            r.setField(2, group.getGroupName());
            r.setField(3, group.getExpectedSize() == null ? "" : group.getExpectedSize().toString());
            String students = "";
            for (Student student : new TreeSet<Student>(group.getStudents())) {
                if (!students.isEmpty()) {
                    students = students + "\n";
                }
                students = students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
            }
            r.setField(4, students, group.getExternalUniqueId() == null);
            r.setDeletable(group.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.StudentGroupEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (StudentGroup group : StudentGroupDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(group.getUniqueId());
            if (r == null) {
                this.delete(group, context, hibSession, studentIds);
                continue;
            }
            this.update(group, r, context, hibSession, studentIds);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession, studentIds);
        }
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        StudentGroup group = new StudentGroup();
        group.setExternalUniqueId(record.getField(0));
        group.setGroupAbbreviation(record.getField(1));
        group.setGroupName(record.getField(2));
        try {
            group.setExpectedSize(record.getField(3) == null || record.getField(3).isEmpty() ? null : Integer.valueOf(record.getField(3)));
        }
        catch (NumberFormatException e) {
            group.setExpectedSize(null);
        }
        group.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        group.setStudents(new HashSet<Student>());
        if (record.getField(4) != null) {
            String students = "";
            for (String s : record.getField(4).split("\\n")) {
                Student student;
                if (s.indexOf(32) >= 0) {
                    s = s.substring(0, s.indexOf(32));
                }
                if (s.trim().isEmpty() || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), s.trim())) == null) continue;
                group.getStudents().add(student);
                student.getGroups().add(group);
                if (!students.isEmpty()) {
                    students = students + "\n";
                }
                students = students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
                studentIds.add(student.getUniqueId());
            }
            record.setField(4, students, true);
        }
        record.setUniqueId((Long)hibSession.save((Object)group));
        ChangeLog.addChange(hibSession, context, group, group.getGroupAbbreviation() + " " + group.getGroupName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.save(record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void update(StudentGroup group, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (group == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)group.getExternalUniqueId(), (Object)record.getField(0)) || !ToolBox.equals((Object)group.getGroupAbbreviation(), (Object)record.getField(1)) || !ToolBox.equals((Object)group.getGroupName(), (Object)record.getField(2)) || !ToolBox.equals((Object)(group.getExpectedSize() == null ? "" : group.getExpectedSize().toString()), (Object)record.getField(3));
        group.setExternalUniqueId(record.getField(0));
        group.setGroupAbbreviation(record.getField(1));
        group.setGroupName(record.getField(2));
        try {
            group.setExpectedSize(record.getField(3) == null || record.getField(3).isEmpty() ? null : Integer.valueOf(record.getField(3)));
        }
        catch (NumberFormatException e) {
            group.setExpectedSize(null);
        }
        if (group.getExternalUniqueId() == null && record.getField(4) != null) {
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Student s : group.getStudents()) {
                students.put(s.getExternalUniqueId(), s);
            }
            for (String line : record.getField(4).split("\\n")) {
                Student student;
                String extId = (line.indexOf(32) >= 0 ? line.substring(0, line.indexOf(32)) : line).trim();
                if (extId.isEmpty() || students.remove(extId) != null || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), extId)) == null) continue;
                group.getStudents().add(student);
                student.getGroups().add(group);
                changed = true;
                studentIds.add(student.getUniqueId());
            }
            if (!students.isEmpty()) {
                for (Student student : students.values()) {
                    studentIds.add(student.getUniqueId());
                    student.getGroups().remove(group);
                }
                group.getStudents().removeAll(students.values());
                changed = true;
            }
            String newStudents = "";
            for (Student student : new TreeSet<Student>(group.getStudents())) {
                if (!newStudents.isEmpty()) {
                    newStudents = newStudents + "\n";
                }
                newStudents = newStudents + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
            }
            record.setField(4, newStudents, group.getExternalUniqueId() == null);
        }
        hibSession.saveOrUpdate((Object)group);
        if (changed) {
            ChangeLog.addChange(hibSession, context, group, group.getGroupAbbreviation() + " " + group.getGroupName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.update((StudentGroup)StudentGroupDAO.getInstance().get(record.getUniqueId()), record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void delete(StudentGroup group, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (group == null) {
            return;
        }
        if (group.getStudents() != null) {
            for (Student student : group.getStudents()) {
                studentIds.add(student.getUniqueId());
                student.getGroups().remove(group);
            }
        }
        ChangeLog.addChange(hibSession, context, group, group.getGroupAbbreviation() + " " + group.getGroupName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)group);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.delete((StudentGroup)StudentGroupDAO.getInstance().get(record.getUniqueId()), context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }
}

