/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.MessageDigestPasswordEncoder;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.admin.PasswordPage;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.UserData;
import org.unitime.timetable.model.dao.UserDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=PasswordPage.PasswordChangeRequest.class)
public class PasswordChangeBackend
implements GwtRpcImplementation<PasswordPage.PasswordChangeRequest, PasswordPage.PasswordChangeResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private static final String sGenCharset = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @Autowired
    HttpServletRequest iRequest;

    @Override
    public PasswordPage.PasswordChangeResponse execute(PasswordPage.PasswordChangeRequest request, SessionContext context) {
        block19: {
            Session hibSession = UserDAO.getInstance().getSession();
            if (request.isReset()) {
                try {
                    HashSet userIds = new HashSet();
                    userIds.addAll(hibSession.createQuery("select distinct externalUniqueId from TimetableManager where lower(emailAddress) = :email and externalUniqueId is not null").setString("email", request.getEmail().toLowerCase()).list());
                    userIds.addAll(hibSession.createQuery("select distinct externalUniqueId from Staff where lower(email) = :email and externalUniqueId is not null").setString("email", request.getEmail().toLowerCase()).list());
                    userIds.addAll(hibSession.createQuery("select distinct externalUniqueId from DepartmentalInstructor where lower(email) = :email and externalUniqueId is not null").setString("email", request.getEmail().toLowerCase()).list());
                    userIds.addAll(hibSession.createQuery("select distinct externalUniqueId from Student where lower(email) = :email and externalUniqueId is not null").setString("email", request.getEmail().toLowerCase()).list());
                    if (userIds.isEmpty()) {
                        throw new GwtRpcException(MESSAGES.errorEmailNotValid());
                    }
                    boolean matched = false;
                    for (String userId : userIds) {
                        User user = User.findByExternalId(userId);
                        if (user == null) continue;
                        matched = true;
                        String key = "";
                        Random rnd = new Random();
                        for (int i = 0; i < 32; ++i) {
                            key = key + sGenCharset.charAt(rnd.nextInt(sGenCharset.length()));
                        }
                        UserData.setProperty(userId, "Password.TempKey", PasswordChangeBackend.encode(key));
                        UserData.setProperty(userId, "Password.TempKeyStamp", Long.toString(System.currentTimeMillis() + 172800000L, 16));
                        Email email = Email.createEmail();
                        email.setSubject(MESSAGES.emailPasswordChange());
                        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
                        cfg.setClassForTemplateLoading(PasswordChangeBackend.class, "");
                        cfg.setLocale(Localization.getJavaLocale());
                        cfg.setOutputEncoding("utf-8");
                        cfg.setEncoding(Localization.getJavaLocale(), "utf-8");
                        Template template = cfg.getTemplate("PasswordResetEmail.ftl");
                        HashMap<String, Object> input = new HashMap<String, Object>();
                        input.put("msg", MESSAGES);
                        input.put("const", CONSTANTS);
                        String url = this.iRequest.getScheme() + "://" + this.iRequest.getServerName() + ":" + this.iRequest.getServerPort() + this.iRequest.getContextPath();
                        if (!url.endsWith("/")) {
                            url = url + "/";
                        }
                        url = url + "gwt.jsp?page=password&user=" + user.getUsername() + "&key=" + key;
                        input.put("username", user.getUsername());
                        input.put("url", url);
                        input.put("version", MESSAGES.pageVersion(Constants.getVersion(), Constants.getReleaseDate()));
                        input.put("ts", new Date());
                        input.put("sender", ApplicationProperty.EmailSenderName.value());
                        StringWriter s = new StringWriter();
                        template.process(input, (Writer)new PrintWriter(s));
                        s.flush();
                        s.close();
                        email.setHTML(s.toString());
                        email.addRecipient(request.getEmail(), null);
                        email.send();
                    }
                    if (!matched) {
                        throw new GwtRpcException(MESSAGES.errorNoMatchingUser());
                    }
                    break block19;
                }
                catch (GwtRpcException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new GwtRpcException(MESSAGES.failedToResetPassword(e.getMessage()), e);
                }
            }
            try {
                if (request.hasUsername()) {
                    User user = User.findByUserName(request.getUsername());
                    if (user == null) {
                        throw new GwtRpcException(MESSAGES.errorBadCredentials());
                    }
                    if (PasswordChangeBackend.encode(request.getOldPassword()).equals(UserData.getProperty(user.getExternalUniqueId(), "Password.TempKey"))) {
                        long ts = Long.valueOf(UserData.getProperty(user.getExternalUniqueId(), "Password.TempKeyStamp", "0"), 16);
                        if (ts < System.currentTimeMillis()) {
                            throw new GwtRpcException(MESSAGES.errorPasswordResetExpired());
                        }
                        user.setPassword(PasswordChangeBackend.encode(request.getNewPassword()));
                        hibSession.update((Object)user);
                        hibSession.flush();
                        UserData.removeProperty(user.getExternalUniqueId(), "Password.TempKey");
                        UserData.removeProperty(user.getExternalUniqueId(), "Password.TempKeyStamp");
                        return new PasswordPage.PasswordChangeResponse();
                    }
                } else {
                    context.checkPermissionAnyAuthority(Right.ChangePassword, new Qualifiable[0]);
                }
                String username = request.hasUsername() ? request.getUsername() : context.getUser().getUsername();
                User user = (User)hibSession.createQuery("from User where username = :username and password = :password").setString("username", username).setString("password", PasswordChangeBackend.encode(request.getOldPassword())).setMaxResults(1).uniqueResult();
                if (user == null) {
                    if (request.hasUsername()) {
                        throw new GwtRpcException(MESSAGES.errorBadCredentials());
                    }
                    throw new GwtRpcException(MESSAGES.errorOldPasswordNotValid());
                }
                if (request.getNewPassword() == null || request.getNewPassword().isEmpty()) {
                    throw new GwtRpcException(MESSAGES.errorEnterNewPassword());
                }
                user.setPassword(PasswordChangeBackend.encode(request.getNewPassword()));
                hibSession.update((Object)user);
                hibSession.flush();
            }
            catch (IllegalArgumentException e) {
                throw new GwtRpcException(MESSAGES.failedToChangePassword(e.getMessage()), e);
            }
        }
        return new PasswordPage.PasswordChangeResponse();
    }

    private static String encode(String password) {
        return new MessageDigestPasswordEncoder("MD5", true).encodePassword(password, null);
    }
}

