/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class ReservationPermissions {

    @PermissionForRight(value=Right.ReservationDelete)
    public static class ReservationDelete
    extends ReservationEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ReservationEdit)
    public static class ReservationEdit
    implements Permission<Reservation> {
        @Autowired
        Permission<InstructionalOffering> permissionReservationOffering;

        @Override
        public boolean check(UserContext user, Reservation source) {
            return this.permissionReservationOffering.check(user, source.getInstructionalOffering());
        }

        @Override
        public Class<Reservation> type() {
            return Reservation.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ReservationOffering)
    public static class ReservationOffering
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            return !this.permissionOfferingLockNeeded.check(user, source) && source.isNotOffered() == false && this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit, DepartmentStatusType.Status.ManagerLimitedEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ReservationAdd)
    public static class ReservationAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit, DepartmentStatusType.Status.ManagerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.Reservations)
    public static class Reservations
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerView, DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }
}

